/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.analytics.implementation;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.datalake.analytics.Catalogs;
import com.microsoft.azure.management.datalake.analytics.implementation.DataLakeAnalyticsCatalogManagementClientImpl;
import com.microsoft.azure.management.datalake.analytics.models.Acl;
import com.microsoft.azure.management.datalake.analytics.models.AclCreateOrUpdateParameters;
import com.microsoft.azure.management.datalake.analytics.models.AclDeleteParameters;
import com.microsoft.azure.management.datalake.analytics.models.DataLakeAnalyticsCatalogCredentialCreateParameters;
import com.microsoft.azure.management.datalake.analytics.models.DataLakeAnalyticsCatalogCredentialDeleteParameters;
import com.microsoft.azure.management.datalake.analytics.models.DataLakeAnalyticsCatalogCredentialUpdateParameters;
import com.microsoft.azure.management.datalake.analytics.models.DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters;
import com.microsoft.azure.management.datalake.analytics.models.PageImpl;
import com.microsoft.azure.management.datalake.analytics.models.USqlAssembly;
import com.microsoft.azure.management.datalake.analytics.models.USqlAssemblyClr;
import com.microsoft.azure.management.datalake.analytics.models.USqlCredential;
import com.microsoft.azure.management.datalake.analytics.models.USqlDatabase;
import com.microsoft.azure.management.datalake.analytics.models.USqlExternalDataSource;
import com.microsoft.azure.management.datalake.analytics.models.USqlPackage;
import com.microsoft.azure.management.datalake.analytics.models.USqlProcedure;
import com.microsoft.azure.management.datalake.analytics.models.USqlSchema;
import com.microsoft.azure.management.datalake.analytics.models.USqlSecret;
import com.microsoft.azure.management.datalake.analytics.models.USqlTable;
import com.microsoft.azure.management.datalake.analytics.models.USqlTableFragment;
import com.microsoft.azure.management.datalake.analytics.models.USqlTablePartition;
import com.microsoft.azure.management.datalake.analytics.models.USqlTablePreview;
import com.microsoft.azure.management.datalake.analytics.models.USqlTableStatistics;
import com.microsoft.azure.management.datalake.analytics.models.USqlTableType;
import com.microsoft.azure.management.datalake.analytics.models.USqlTableValuedFunction;
import com.microsoft.azure.management.datalake.analytics.models.USqlType;
import com.microsoft.azure.management.datalake.analytics.models.USqlView;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class CatalogsImpl
implements Catalogs {
    private CatalogsService service;
    private DataLakeAnalyticsCatalogManagementClientImpl client;

    public CatalogsImpl(Retrofit retrofit, DataLakeAnalyticsCatalogManagementClientImpl client) {
        this.service = (CatalogsService)retrofit.create(CatalogsService.class);
        this.client = client;
    }

    @Override
    public void createSecret(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters) {
        ((ServiceResponse)this.createSecretWithServiceResponseAsync(accountName, databaseName, secretName, parameters).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> createSecretAsync(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.createSecretWithServiceResponseAsync(accountName, databaseName, secretName, parameters), serviceCallback);
    }

    @Override
    public Observable<Void> createSecretAsync(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters) {
        return this.createSecretWithServiceResponseAsync(accountName, databaseName, secretName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> createSecretWithServiceResponseAsync(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.createSecret(databaseName, secretName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.createSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> createSecretDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public USqlSecret getSecret(String accountName, String databaseName, String secretName) {
        return (USqlSecret)((ServiceResponse)this.getSecretWithServiceResponseAsync(accountName, databaseName, secretName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<USqlSecret> getSecretAsync(String accountName, String databaseName, String secretName, ServiceCallback<USqlSecret> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSecretWithServiceResponseAsync(accountName, databaseName, secretName), serviceCallback);
    }

    @Override
    public Observable<USqlSecret> getSecretAsync(String accountName, String databaseName, String secretName) {
        return this.getSecretWithServiceResponseAsync(accountName, databaseName, secretName).map((Func1)new Func1<ServiceResponse<USqlSecret>, USqlSecret>(){

            public USqlSecret call(ServiceResponse<USqlSecret> response) {
                return (USqlSecret)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<USqlSecret>> getSecretWithServiceResponseAsync(String accountName, String databaseName, String secretName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.getSecret(databaseName, secretName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlSecret>>>(){

            public Observable<ServiceResponse<USqlSecret>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.getSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<USqlSecret> getSecretDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<USqlSecret>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void updateSecret(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters) {
        ((ServiceResponse)this.updateSecretWithServiceResponseAsync(accountName, databaseName, secretName, parameters).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> updateSecretAsync(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateSecretWithServiceResponseAsync(accountName, databaseName, secretName, parameters), serviceCallback);
    }

    @Override
    public Observable<Void> updateSecretAsync(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters) {
        return this.updateSecretWithServiceResponseAsync(accountName, databaseName, secretName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> updateSecretWithServiceResponseAsync(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.updateSecret(databaseName, secretName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.updateSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> updateSecretDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void deleteSecret(String accountName, String databaseName, String secretName) {
        ((ServiceResponse)this.deleteSecretWithServiceResponseAsync(accountName, databaseName, secretName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteSecretAsync(String accountName, String databaseName, String secretName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteSecretWithServiceResponseAsync(accountName, databaseName, secretName), serviceCallback);
    }

    @Override
    public Observable<Void> deleteSecretAsync(String accountName, String databaseName, String secretName) {
        return this.deleteSecretWithServiceResponseAsync(accountName, databaseName, secretName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> deleteSecretWithServiceResponseAsync(String accountName, String databaseName, String secretName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.deleteSecret(databaseName, secretName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.deleteSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteSecretDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void deleteAllSecrets(String accountName, String databaseName) {
        ((ServiceResponse)this.deleteAllSecretsWithServiceResponseAsync(accountName, databaseName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteAllSecretsAsync(String accountName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteAllSecretsWithServiceResponseAsync(accountName, databaseName), serviceCallback);
    }

    @Override
    public Observable<Void> deleteAllSecretsAsync(String accountName, String databaseName) {
        return this.deleteAllSecretsWithServiceResponseAsync(accountName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> deleteAllSecretsWithServiceResponseAsync(String accountName, String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.deleteAllSecrets(databaseName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.deleteAllSecretsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteAllSecretsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void createCredential(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialCreateParameters parameters) {
        ((ServiceResponse)this.createCredentialWithServiceResponseAsync(accountName, databaseName, credentialName, parameters).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> createCredentialAsync(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialCreateParameters parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.createCredentialWithServiceResponseAsync(accountName, databaseName, credentialName, parameters), serviceCallback);
    }

    @Override
    public Observable<Void> createCredentialAsync(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialCreateParameters parameters) {
        return this.createCredentialWithServiceResponseAsync(accountName, databaseName, credentialName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> createCredentialWithServiceResponseAsync(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialCreateParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (credentialName == null) {
            throw new IllegalArgumentException("Parameter credentialName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.createCredential(databaseName, credentialName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.createCredentialDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> createCredentialDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public USqlCredential getCredential(String accountName, String databaseName, String credentialName) {
        return (USqlCredential)((ServiceResponse)this.getCredentialWithServiceResponseAsync(accountName, databaseName, credentialName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<USqlCredential> getCredentialAsync(String accountName, String databaseName, String credentialName, ServiceCallback<USqlCredential> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCredentialWithServiceResponseAsync(accountName, databaseName, credentialName), serviceCallback);
    }

    @Override
    public Observable<USqlCredential> getCredentialAsync(String accountName, String databaseName, String credentialName) {
        return this.getCredentialWithServiceResponseAsync(accountName, databaseName, credentialName).map((Func1)new Func1<ServiceResponse<USqlCredential>, USqlCredential>(){

            public USqlCredential call(ServiceResponse<USqlCredential> response) {
                return (USqlCredential)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<USqlCredential>> getCredentialWithServiceResponseAsync(String accountName, String databaseName, String credentialName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (credentialName == null) {
            throw new IllegalArgumentException("Parameter credentialName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.getCredential(databaseName, credentialName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlCredential>>>(){

            public Observable<ServiceResponse<USqlCredential>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.getCredentialDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<USqlCredential> getCredentialDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<USqlCredential>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void updateCredential(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialUpdateParameters parameters) {
        ((ServiceResponse)this.updateCredentialWithServiceResponseAsync(accountName, databaseName, credentialName, parameters).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> updateCredentialAsync(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialUpdateParameters parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateCredentialWithServiceResponseAsync(accountName, databaseName, credentialName, parameters), serviceCallback);
    }

    @Override
    public Observable<Void> updateCredentialAsync(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialUpdateParameters parameters) {
        return this.updateCredentialWithServiceResponseAsync(accountName, databaseName, credentialName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> updateCredentialWithServiceResponseAsync(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialUpdateParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (credentialName == null) {
            throw new IllegalArgumentException("Parameter credentialName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.updateCredential(databaseName, credentialName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.updateCredentialDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> updateCredentialDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void deleteCredential(String accountName, String databaseName, String credentialName) {
        ((ServiceResponse)this.deleteCredentialWithServiceResponseAsync(accountName, databaseName, credentialName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteCredentialAsync(String accountName, String databaseName, String credentialName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteCredentialWithServiceResponseAsync(accountName, databaseName, credentialName), serviceCallback);
    }

    @Override
    public Observable<Void> deleteCredentialAsync(String accountName, String databaseName, String credentialName) {
        return this.deleteCredentialWithServiceResponseAsync(accountName, databaseName, credentialName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> deleteCredentialWithServiceResponseAsync(String accountName, String databaseName, String credentialName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (credentialName == null) {
            throw new IllegalArgumentException("Parameter credentialName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Boolean cascade = null;
        Object password = null;
        DataLakeAnalyticsCatalogCredentialDeleteParameters parameters = new DataLakeAnalyticsCatalogCredentialDeleteParameters();
        parameters.withPassword(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.deleteCredential(databaseName, credentialName, cascade, this.client.apiVersion(), this.client.acceptLanguage(), parameters, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.deleteCredentialDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void deleteCredential(String accountName, String databaseName, String credentialName, Boolean cascade, String password) {
        ((ServiceResponse)this.deleteCredentialWithServiceResponseAsync(accountName, databaseName, credentialName, cascade, password).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteCredentialAsync(String accountName, String databaseName, String credentialName, Boolean cascade, String password, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteCredentialWithServiceResponseAsync(accountName, databaseName, credentialName, cascade, password), serviceCallback);
    }

    @Override
    public Observable<Void> deleteCredentialAsync(String accountName, String databaseName, String credentialName, Boolean cascade, String password) {
        return this.deleteCredentialWithServiceResponseAsync(accountName, databaseName, credentialName, cascade, password).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> deleteCredentialWithServiceResponseAsync(String accountName, String databaseName, String credentialName, Boolean cascade, String password) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (credentialName == null) {
            throw new IllegalArgumentException("Parameter credentialName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        DataLakeAnalyticsCatalogCredentialDeleteParameters parameters = null;
        if (password != null) {
            parameters = new DataLakeAnalyticsCatalogCredentialDeleteParameters();
            parameters.withPassword(password);
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.deleteCredential(databaseName, credentialName, cascade, this.client.apiVersion(), this.client.acceptLanguage(), parameters, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.deleteCredentialDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteCredentialDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlCredential> listCredentials(String accountName, String databaseName) {
        ServiceResponse response = (ServiceResponse)this.listCredentialsSinglePageAsync(accountName, databaseName).toBlocking().single();
        return new PagedList<USqlCredential>((Page)response.body()){

            public Page<USqlCredential> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listCredentialsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlCredential>> listCredentialsAsync(String accountName, String databaseName, ListOperationCallback<USqlCredential> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listCredentialsSinglePageAsync(accountName, databaseName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlCredential>>>>(){

            public Observable<ServiceResponse<Page<USqlCredential>>> call(String nextPageLink) {
                return CatalogsImpl.this.listCredentialsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlCredential>> listCredentialsAsync(String accountName, String databaseName) {
        return this.listCredentialsWithServiceResponseAsync(accountName, databaseName).map((Func1)new Func1<ServiceResponse<Page<USqlCredential>>, Page<USqlCredential>>(){

            public Page<USqlCredential> call(ServiceResponse<Page<USqlCredential>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlCredential>>> listCredentialsWithServiceResponseAsync(String accountName, String databaseName) {
        return this.listCredentialsSinglePageAsync(accountName, databaseName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlCredential>>, Observable<ServiceResponse<Page<USqlCredential>>>>(){

            public Observable<ServiceResponse<Page<USqlCredential>>> call(ServiceResponse<Page<USqlCredential>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listCredentialsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlCredential>>> listCredentialsSinglePageAsync(String accountName, String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listCredentials(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlCredential>>>>(){

            public Observable<ServiceResponse<Page<USqlCredential>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listCredentialsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlCredential> listCredentials(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listCredentialsSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlCredential>((Page)response.body()){

            public Page<USqlCredential> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listCredentialsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlCredential>> listCredentialsAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<USqlCredential> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listCredentialsSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlCredential>>>>(){

            public Observable<ServiceResponse<Page<USqlCredential>>> call(String nextPageLink) {
                return CatalogsImpl.this.listCredentialsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlCredential>> listCredentialsAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listCredentialsWithServiceResponseAsync(accountName, databaseName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<USqlCredential>>, Page<USqlCredential>>(){

            public Page<USqlCredential> call(ServiceResponse<Page<USqlCredential>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlCredential>>> listCredentialsWithServiceResponseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listCredentialsSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<USqlCredential>>, Observable<ServiceResponse<Page<USqlCredential>>>>(){

            public Observable<ServiceResponse<Page<USqlCredential>>> call(ServiceResponse<Page<USqlCredential>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listCredentialsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlCredential>>> listCredentialsSinglePageAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listCredentials(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlCredential>>>>(){

            public Observable<ServiceResponse<Page<USqlCredential>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listCredentialsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlCredential>> listCredentialsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlCredential>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public USqlExternalDataSource getExternalDataSource(String accountName, String databaseName, String externalDataSourceName) {
        return (USqlExternalDataSource)((ServiceResponse)this.getExternalDataSourceWithServiceResponseAsync(accountName, databaseName, externalDataSourceName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<USqlExternalDataSource> getExternalDataSourceAsync(String accountName, String databaseName, String externalDataSourceName, ServiceCallback<USqlExternalDataSource> serviceCallback) {
        return ServiceFuture.fromResponse(this.getExternalDataSourceWithServiceResponseAsync(accountName, databaseName, externalDataSourceName), serviceCallback);
    }

    @Override
    public Observable<USqlExternalDataSource> getExternalDataSourceAsync(String accountName, String databaseName, String externalDataSourceName) {
        return this.getExternalDataSourceWithServiceResponseAsync(accountName, databaseName, externalDataSourceName).map((Func1)new Func1<ServiceResponse<USqlExternalDataSource>, USqlExternalDataSource>(){

            public USqlExternalDataSource call(ServiceResponse<USqlExternalDataSource> response) {
                return (USqlExternalDataSource)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<USqlExternalDataSource>> getExternalDataSourceWithServiceResponseAsync(String accountName, String databaseName, String externalDataSourceName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (externalDataSourceName == null) {
            throw new IllegalArgumentException("Parameter externalDataSourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.getExternalDataSource(databaseName, externalDataSourceName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlExternalDataSource>>>(){

            public Observable<ServiceResponse<USqlExternalDataSource>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.getExternalDataSourceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<USqlExternalDataSource> getExternalDataSourceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<USqlExternalDataSource>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlExternalDataSource> listExternalDataSources(String accountName, String databaseName) {
        ServiceResponse response = (ServiceResponse)this.listExternalDataSourcesSinglePageAsync(accountName, databaseName).toBlocking().single();
        return new PagedList<USqlExternalDataSource>((Page)response.body()){

            public Page<USqlExternalDataSource> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listExternalDataSourcesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlExternalDataSource>> listExternalDataSourcesAsync(String accountName, String databaseName, ListOperationCallback<USqlExternalDataSource> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listExternalDataSourcesSinglePageAsync(accountName, databaseName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlExternalDataSource>>>>(){

            public Observable<ServiceResponse<Page<USqlExternalDataSource>>> call(String nextPageLink) {
                return CatalogsImpl.this.listExternalDataSourcesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlExternalDataSource>> listExternalDataSourcesAsync(String accountName, String databaseName) {
        return this.listExternalDataSourcesWithServiceResponseAsync(accountName, databaseName).map((Func1)new Func1<ServiceResponse<Page<USqlExternalDataSource>>, Page<USqlExternalDataSource>>(){

            public Page<USqlExternalDataSource> call(ServiceResponse<Page<USqlExternalDataSource>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlExternalDataSource>>> listExternalDataSourcesWithServiceResponseAsync(String accountName, String databaseName) {
        return this.listExternalDataSourcesSinglePageAsync(accountName, databaseName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlExternalDataSource>>, Observable<ServiceResponse<Page<USqlExternalDataSource>>>>(){

            public Observable<ServiceResponse<Page<USqlExternalDataSource>>> call(ServiceResponse<Page<USqlExternalDataSource>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listExternalDataSourcesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlExternalDataSource>>> listExternalDataSourcesSinglePageAsync(String accountName, String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listExternalDataSources(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlExternalDataSource>>>>(){

            public Observable<ServiceResponse<Page<USqlExternalDataSource>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listExternalDataSourcesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlExternalDataSource> listExternalDataSources(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listExternalDataSourcesSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlExternalDataSource>((Page)response.body()){

            public Page<USqlExternalDataSource> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listExternalDataSourcesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlExternalDataSource>> listExternalDataSourcesAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<USqlExternalDataSource> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listExternalDataSourcesSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlExternalDataSource>>>>(){

            public Observable<ServiceResponse<Page<USqlExternalDataSource>>> call(String nextPageLink) {
                return CatalogsImpl.this.listExternalDataSourcesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlExternalDataSource>> listExternalDataSourcesAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listExternalDataSourcesWithServiceResponseAsync(accountName, databaseName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<USqlExternalDataSource>>, Page<USqlExternalDataSource>>(){

            public Page<USqlExternalDataSource> call(ServiceResponse<Page<USqlExternalDataSource>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlExternalDataSource>>> listExternalDataSourcesWithServiceResponseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listExternalDataSourcesSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<USqlExternalDataSource>>, Observable<ServiceResponse<Page<USqlExternalDataSource>>>>(){

            public Observable<ServiceResponse<Page<USqlExternalDataSource>>> call(ServiceResponse<Page<USqlExternalDataSource>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listExternalDataSourcesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlExternalDataSource>>> listExternalDataSourcesSinglePageAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listExternalDataSources(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlExternalDataSource>>>>(){

            public Observable<ServiceResponse<Page<USqlExternalDataSource>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listExternalDataSourcesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlExternalDataSource>> listExternalDataSourcesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlExternalDataSource>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public USqlProcedure getProcedure(String accountName, String databaseName, String schemaName, String procedureName) {
        return (USqlProcedure)((ServiceResponse)this.getProcedureWithServiceResponseAsync(accountName, databaseName, schemaName, procedureName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<USqlProcedure> getProcedureAsync(String accountName, String databaseName, String schemaName, String procedureName, ServiceCallback<USqlProcedure> serviceCallback) {
        return ServiceFuture.fromResponse(this.getProcedureWithServiceResponseAsync(accountName, databaseName, schemaName, procedureName), serviceCallback);
    }

    @Override
    public Observable<USqlProcedure> getProcedureAsync(String accountName, String databaseName, String schemaName, String procedureName) {
        return this.getProcedureWithServiceResponseAsync(accountName, databaseName, schemaName, procedureName).map((Func1)new Func1<ServiceResponse<USqlProcedure>, USqlProcedure>(){

            public USqlProcedure call(ServiceResponse<USqlProcedure> response) {
                return (USqlProcedure)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<USqlProcedure>> getProcedureWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String procedureName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (procedureName == null) {
            throw new IllegalArgumentException("Parameter procedureName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.getProcedure(databaseName, schemaName, procedureName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlProcedure>>>(){

            public Observable<ServiceResponse<USqlProcedure>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.getProcedureDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<USqlProcedure> getProcedureDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<USqlProcedure>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlProcedure> listProcedures(String accountName, String databaseName, String schemaName) {
        ServiceResponse response = (ServiceResponse)this.listProceduresSinglePageAsync(accountName, databaseName, schemaName).toBlocking().single();
        return new PagedList<USqlProcedure>((Page)response.body()){

            public Page<USqlProcedure> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listProceduresNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlProcedure>> listProceduresAsync(String accountName, String databaseName, String schemaName, ListOperationCallback<USqlProcedure> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listProceduresSinglePageAsync(accountName, databaseName, schemaName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlProcedure>>>>(){

            public Observable<ServiceResponse<Page<USqlProcedure>>> call(String nextPageLink) {
                return CatalogsImpl.this.listProceduresNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlProcedure>> listProceduresAsync(String accountName, String databaseName, String schemaName) {
        return this.listProceduresWithServiceResponseAsync(accountName, databaseName, schemaName).map((Func1)new Func1<ServiceResponse<Page<USqlProcedure>>, Page<USqlProcedure>>(){

            public Page<USqlProcedure> call(ServiceResponse<Page<USqlProcedure>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlProcedure>>> listProceduresWithServiceResponseAsync(String accountName, String databaseName, String schemaName) {
        return this.listProceduresSinglePageAsync(accountName, databaseName, schemaName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlProcedure>>, Observable<ServiceResponse<Page<USqlProcedure>>>>(){

            public Observable<ServiceResponse<Page<USqlProcedure>>> call(ServiceResponse<Page<USqlProcedure>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listProceduresNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlProcedure>>> listProceduresSinglePageAsync(String accountName, String databaseName, String schemaName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listProcedures(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlProcedure>>>>(){

            public Observable<ServiceResponse<Page<USqlProcedure>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listProceduresDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlProcedure> listProcedures(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listProceduresSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlProcedure>((Page)response.body()){

            public Page<USqlProcedure> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listProceduresNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlProcedure>> listProceduresAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<USqlProcedure> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listProceduresSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlProcedure>>>>(){

            public Observable<ServiceResponse<Page<USqlProcedure>>> call(String nextPageLink) {
                return CatalogsImpl.this.listProceduresNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlProcedure>> listProceduresAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listProceduresWithServiceResponseAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<USqlProcedure>>, Page<USqlProcedure>>(){

            public Page<USqlProcedure> call(ServiceResponse<Page<USqlProcedure>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlProcedure>>> listProceduresWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listProceduresSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<USqlProcedure>>, Observable<ServiceResponse<Page<USqlProcedure>>>>(){

            public Observable<ServiceResponse<Page<USqlProcedure>>> call(ServiceResponse<Page<USqlProcedure>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listProceduresNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlProcedure>>> listProceduresSinglePageAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listProcedures(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlProcedure>>>>(){

            public Observable<ServiceResponse<Page<USqlProcedure>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listProceduresDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlProcedure>> listProceduresDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlProcedure>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public USqlTable getTable(String accountName, String databaseName, String schemaName, String tableName) {
        return (USqlTable)((ServiceResponse)this.getTableWithServiceResponseAsync(accountName, databaseName, schemaName, tableName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<USqlTable> getTableAsync(String accountName, String databaseName, String schemaName, String tableName, ServiceCallback<USqlTable> serviceCallback) {
        return ServiceFuture.fromResponse(this.getTableWithServiceResponseAsync(accountName, databaseName, schemaName, tableName), serviceCallback);
    }

    @Override
    public Observable<USqlTable> getTableAsync(String accountName, String databaseName, String schemaName, String tableName) {
        return this.getTableWithServiceResponseAsync(accountName, databaseName, schemaName, tableName).map((Func1)new Func1<ServiceResponse<USqlTable>, USqlTable>(){

            public USqlTable call(ServiceResponse<USqlTable> response) {
                return (USqlTable)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<USqlTable>> getTableWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.getTable(databaseName, schemaName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlTable>>>(){

            public Observable<ServiceResponse<USqlTable>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.getTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<USqlTable> getTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<USqlTable>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTableFragment> listTableFragments(String accountName, String databaseName, String schemaName, String tableName) {
        ServiceResponse response = (ServiceResponse)this.listTableFragmentsSinglePageAsync(accountName, databaseName, schemaName, tableName).toBlocking().single();
        return new PagedList<USqlTableFragment>((Page)response.body()){

            public Page<USqlTableFragment> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableFragmentsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableFragment>> listTableFragmentsAsync(String accountName, String databaseName, String schemaName, String tableName, ListOperationCallback<USqlTableFragment> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableFragmentsSinglePageAsync(accountName, databaseName, schemaName, tableName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableFragment>>>>(){

            public Observable<ServiceResponse<Page<USqlTableFragment>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableFragmentsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableFragment>> listTableFragmentsAsync(String accountName, String databaseName, String schemaName, String tableName) {
        return this.listTableFragmentsWithServiceResponseAsync(accountName, databaseName, schemaName, tableName).map((Func1)new Func1<ServiceResponse<Page<USqlTableFragment>>, Page<USqlTableFragment>>(){

            public Page<USqlTableFragment> call(ServiceResponse<Page<USqlTableFragment>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableFragment>>> listTableFragmentsWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName) {
        return this.listTableFragmentsSinglePageAsync(accountName, databaseName, schemaName, tableName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableFragment>>, Observable<ServiceResponse<Page<USqlTableFragment>>>>(){

            public Observable<ServiceResponse<Page<USqlTableFragment>>> call(ServiceResponse<Page<USqlTableFragment>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableFragmentsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableFragment>>> listTableFragmentsSinglePageAsync(String accountName, String databaseName, String schemaName, String tableName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTableFragments(databaseName, schemaName, tableName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableFragment>>>>(){

            public Observable<ServiceResponse<Page<USqlTableFragment>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableFragmentsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlTableFragment> listTableFragments(String accountName, String databaseName, String schemaName, String tableName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listTableFragmentsSinglePageAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlTableFragment>((Page)response.body()){

            public Page<USqlTableFragment> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableFragmentsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableFragment>> listTableFragmentsAsync(String accountName, String databaseName, String schemaName, String tableName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<USqlTableFragment> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableFragmentsSinglePageAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableFragment>>>>(){

            public Observable<ServiceResponse<Page<USqlTableFragment>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableFragmentsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableFragment>> listTableFragmentsAsync(String accountName, String databaseName, String schemaName, String tableName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listTableFragmentsWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<USqlTableFragment>>, Page<USqlTableFragment>>(){

            public Page<USqlTableFragment> call(ServiceResponse<Page<USqlTableFragment>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableFragment>>> listTableFragmentsWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listTableFragmentsSinglePageAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableFragment>>, Observable<ServiceResponse<Page<USqlTableFragment>>>>(){

            public Observable<ServiceResponse<Page<USqlTableFragment>>> call(ServiceResponse<Page<USqlTableFragment>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableFragmentsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableFragment>>> listTableFragmentsSinglePageAsync(String accountName, String databaseName, String schemaName, String tableName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTableFragments(databaseName, schemaName, tableName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableFragment>>>>(){

            public Observable<ServiceResponse<Page<USqlTableFragment>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableFragmentsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTableFragment>> listTableFragmentsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTableFragment>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTable> listTables(String accountName, String databaseName, String schemaName) {
        ServiceResponse response = (ServiceResponse)this.listTablesSinglePageAsync(accountName, databaseName, schemaName).toBlocking().single();
        return new PagedList<USqlTable>((Page)response.body()){

            public Page<USqlTable> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTablesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTable>> listTablesAsync(String accountName, String databaseName, String schemaName, ListOperationCallback<USqlTable> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTablesSinglePageAsync(accountName, databaseName, schemaName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTable>>>>(){

            public Observable<ServiceResponse<Page<USqlTable>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTablesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTable>> listTablesAsync(String accountName, String databaseName, String schemaName) {
        return this.listTablesWithServiceResponseAsync(accountName, databaseName, schemaName).map((Func1)new Func1<ServiceResponse<Page<USqlTable>>, Page<USqlTable>>(){

            public Page<USqlTable> call(ServiceResponse<Page<USqlTable>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTable>>> listTablesWithServiceResponseAsync(String accountName, String databaseName, String schemaName) {
        return this.listTablesSinglePageAsync(accountName, databaseName, schemaName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTable>>, Observable<ServiceResponse<Page<USqlTable>>>>(){

            public Observable<ServiceResponse<Page<USqlTable>>> call(ServiceResponse<Page<USqlTable>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTablesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTable>>> listTablesSinglePageAsync(String accountName, String databaseName, String schemaName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        Boolean basic = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTables(databaseName, schemaName, filter, top, skip, select, orderby, count, basic, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTable>>>>(){

            public Observable<ServiceResponse<Page<USqlTable>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTablesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlTable> listTables(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, Boolean basic) {
        ServiceResponse response = (ServiceResponse)this.listTablesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count, basic).toBlocking().single();
        return new PagedList<USqlTable>((Page)response.body()){

            public Page<USqlTable> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTablesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTable>> listTablesAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, Boolean basic, ListOperationCallback<USqlTable> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTablesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count, basic), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTable>>>>(){

            public Observable<ServiceResponse<Page<USqlTable>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTablesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTable>> listTablesAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, Boolean basic) {
        return this.listTablesWithServiceResponseAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count, basic).map((Func1)new Func1<ServiceResponse<Page<USqlTable>>, Page<USqlTable>>(){

            public Page<USqlTable> call(ServiceResponse<Page<USqlTable>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTable>>> listTablesWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, Boolean basic) {
        return this.listTablesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count, basic).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTable>>, Observable<ServiceResponse<Page<USqlTable>>>>(){

            public Observable<ServiceResponse<Page<USqlTable>>> call(ServiceResponse<Page<USqlTable>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTablesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTable>>> listTablesSinglePageAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, Boolean basic) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTables(databaseName, schemaName, filter, top, skip, select, orderby, count, basic, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTable>>>>(){

            public Observable<ServiceResponse<Page<USqlTable>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTablesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTable>> listTablesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTable>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTableStatistics> listTableStatisticsByDatabaseAndSchema(String accountName, String databaseName, String schemaName) {
        ServiceResponse response = (ServiceResponse)this.listTableStatisticsByDatabaseAndSchemaSinglePageAsync(accountName, databaseName, schemaName).toBlocking().single();
        return new PagedList<USqlTableStatistics>((Page)response.body()){

            public Page<USqlTableStatistics> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaAsync(String accountName, String databaseName, String schemaName, ListOperationCallback<USqlTableStatistics> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableStatisticsByDatabaseAndSchemaSinglePageAsync(accountName, databaseName, schemaName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaAsync(String accountName, String databaseName, String schemaName) {
        return this.listTableStatisticsByDatabaseAndSchemaWithServiceResponseAsync(accountName, databaseName, schemaName).map((Func1)new Func1<ServiceResponse<Page<USqlTableStatistics>>, Page<USqlTableStatistics>>(){

            public Page<USqlTableStatistics> call(ServiceResponse<Page<USqlTableStatistics>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseAndSchemaWithServiceResponseAsync(String accountName, String databaseName, String schemaName) {
        return this.listTableStatisticsByDatabaseAndSchemaSinglePageAsync(accountName, databaseName, schemaName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableStatistics>>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(ServiceResponse<Page<USqlTableStatistics>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableStatisticsByDatabaseAndSchemaNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseAndSchemaSinglePageAsync(String accountName, String databaseName, String schemaName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTableStatisticsByDatabaseAndSchema(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableStatisticsByDatabaseAndSchemaDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlTableStatistics> listTableStatisticsByDatabaseAndSchema(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listTableStatisticsByDatabaseAndSchemaSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlTableStatistics>((Page)response.body()){

            public Page<USqlTableStatistics> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<USqlTableStatistics> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableStatisticsByDatabaseAndSchemaSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listTableStatisticsByDatabaseAndSchemaWithServiceResponseAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<USqlTableStatistics>>, Page<USqlTableStatistics>>(){

            public Page<USqlTableStatistics> call(ServiceResponse<Page<USqlTableStatistics>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseAndSchemaWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listTableStatisticsByDatabaseAndSchemaSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableStatistics>>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(ServiceResponse<Page<USqlTableStatistics>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableStatisticsByDatabaseAndSchemaNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseAndSchemaSinglePageAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTableStatisticsByDatabaseAndSchema(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableStatisticsByDatabaseAndSchemaDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTableStatistics>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public USqlTableType getTableType(String accountName, String databaseName, String schemaName, String tableTypeName) {
        return (USqlTableType)((ServiceResponse)this.getTableTypeWithServiceResponseAsync(accountName, databaseName, schemaName, tableTypeName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<USqlTableType> getTableTypeAsync(String accountName, String databaseName, String schemaName, String tableTypeName, ServiceCallback<USqlTableType> serviceCallback) {
        return ServiceFuture.fromResponse(this.getTableTypeWithServiceResponseAsync(accountName, databaseName, schemaName, tableTypeName), serviceCallback);
    }

    @Override
    public Observable<USqlTableType> getTableTypeAsync(String accountName, String databaseName, String schemaName, String tableTypeName) {
        return this.getTableTypeWithServiceResponseAsync(accountName, databaseName, schemaName, tableTypeName).map((Func1)new Func1<ServiceResponse<USqlTableType>, USqlTableType>(){

            public USqlTableType call(ServiceResponse<USqlTableType> response) {
                return (USqlTableType)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<USqlTableType>> getTableTypeWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableTypeName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableTypeName == null) {
            throw new IllegalArgumentException("Parameter tableTypeName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.getTableType(databaseName, schemaName, tableTypeName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlTableType>>>(){

            public Observable<ServiceResponse<USqlTableType>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.getTableTypeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<USqlTableType> getTableTypeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<USqlTableType>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTableType> listTableTypes(String accountName, String databaseName, String schemaName) {
        ServiceResponse response = (ServiceResponse)this.listTableTypesSinglePageAsync(accountName, databaseName, schemaName).toBlocking().single();
        return new PagedList<USqlTableType>((Page)response.body()){

            public Page<USqlTableType> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableTypesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableType>> listTableTypesAsync(String accountName, String databaseName, String schemaName, ListOperationCallback<USqlTableType> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableTypesSinglePageAsync(accountName, databaseName, schemaName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableType>>>>(){

            public Observable<ServiceResponse<Page<USqlTableType>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableTypesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableType>> listTableTypesAsync(String accountName, String databaseName, String schemaName) {
        return this.listTableTypesWithServiceResponseAsync(accountName, databaseName, schemaName).map((Func1)new Func1<ServiceResponse<Page<USqlTableType>>, Page<USqlTableType>>(){

            public Page<USqlTableType> call(ServiceResponse<Page<USqlTableType>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableType>>> listTableTypesWithServiceResponseAsync(String accountName, String databaseName, String schemaName) {
        return this.listTableTypesSinglePageAsync(accountName, databaseName, schemaName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableType>>, Observable<ServiceResponse<Page<USqlTableType>>>>(){

            public Observable<ServiceResponse<Page<USqlTableType>>> call(ServiceResponse<Page<USqlTableType>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableTypesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableType>>> listTableTypesSinglePageAsync(String accountName, String databaseName, String schemaName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTableTypes(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableType>>>>(){

            public Observable<ServiceResponse<Page<USqlTableType>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableTypesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlTableType> listTableTypes(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listTableTypesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlTableType>((Page)response.body()){

            public Page<USqlTableType> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableTypesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableType>> listTableTypesAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<USqlTableType> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableTypesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableType>>>>(){

            public Observable<ServiceResponse<Page<USqlTableType>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableTypesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableType>> listTableTypesAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listTableTypesWithServiceResponseAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<USqlTableType>>, Page<USqlTableType>>(){

            public Page<USqlTableType> call(ServiceResponse<Page<USqlTableType>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableType>>> listTableTypesWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listTableTypesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableType>>, Observable<ServiceResponse<Page<USqlTableType>>>>(){

            public Observable<ServiceResponse<Page<USqlTableType>>> call(ServiceResponse<Page<USqlTableType>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableTypesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableType>>> listTableTypesSinglePageAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTableTypes(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableType>>>>(){

            public Observable<ServiceResponse<Page<USqlTableType>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableTypesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTableType>> listTableTypesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTableType>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public USqlPackage getPackage(String accountName, String databaseName, String schemaName, String packageName) {
        return (USqlPackage)((ServiceResponse)this.getPackageWithServiceResponseAsync(accountName, databaseName, schemaName, packageName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<USqlPackage> getPackageAsync(String accountName, String databaseName, String schemaName, String packageName, ServiceCallback<USqlPackage> serviceCallback) {
        return ServiceFuture.fromResponse(this.getPackageWithServiceResponseAsync(accountName, databaseName, schemaName, packageName), serviceCallback);
    }

    @Override
    public Observable<USqlPackage> getPackageAsync(String accountName, String databaseName, String schemaName, String packageName) {
        return this.getPackageWithServiceResponseAsync(accountName, databaseName, schemaName, packageName).map((Func1)new Func1<ServiceResponse<USqlPackage>, USqlPackage>(){

            public USqlPackage call(ServiceResponse<USqlPackage> response) {
                return (USqlPackage)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<USqlPackage>> getPackageWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String packageName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("Parameter packageName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.getPackage(databaseName, schemaName, packageName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlPackage>>>(){

            public Observable<ServiceResponse<USqlPackage>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.getPackageDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<USqlPackage> getPackageDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<USqlPackage>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlPackage> listPackages(String accountName, String databaseName, String schemaName) {
        ServiceResponse response = (ServiceResponse)this.listPackagesSinglePageAsync(accountName, databaseName, schemaName).toBlocking().single();
        return new PagedList<USqlPackage>((Page)response.body()){

            public Page<USqlPackage> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listPackagesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlPackage>> listPackagesAsync(String accountName, String databaseName, String schemaName, ListOperationCallback<USqlPackage> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listPackagesSinglePageAsync(accountName, databaseName, schemaName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlPackage>>>>(){

            public Observable<ServiceResponse<Page<USqlPackage>>> call(String nextPageLink) {
                return CatalogsImpl.this.listPackagesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlPackage>> listPackagesAsync(String accountName, String databaseName, String schemaName) {
        return this.listPackagesWithServiceResponseAsync(accountName, databaseName, schemaName).map((Func1)new Func1<ServiceResponse<Page<USqlPackage>>, Page<USqlPackage>>(){

            public Page<USqlPackage> call(ServiceResponse<Page<USqlPackage>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlPackage>>> listPackagesWithServiceResponseAsync(String accountName, String databaseName, String schemaName) {
        return this.listPackagesSinglePageAsync(accountName, databaseName, schemaName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlPackage>>, Observable<ServiceResponse<Page<USqlPackage>>>>(){

            public Observable<ServiceResponse<Page<USqlPackage>>> call(ServiceResponse<Page<USqlPackage>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listPackagesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlPackage>>> listPackagesSinglePageAsync(String accountName, String databaseName, String schemaName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listPackages(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlPackage>>>>(){

            public Observable<ServiceResponse<Page<USqlPackage>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listPackagesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlPackage> listPackages(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listPackagesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlPackage>((Page)response.body()){

            public Page<USqlPackage> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listPackagesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlPackage>> listPackagesAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<USqlPackage> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listPackagesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlPackage>>>>(){

            public Observable<ServiceResponse<Page<USqlPackage>>> call(String nextPageLink) {
                return CatalogsImpl.this.listPackagesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlPackage>> listPackagesAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listPackagesWithServiceResponseAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<USqlPackage>>, Page<USqlPackage>>(){

            public Page<USqlPackage> call(ServiceResponse<Page<USqlPackage>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlPackage>>> listPackagesWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listPackagesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<USqlPackage>>, Observable<ServiceResponse<Page<USqlPackage>>>>(){

            public Observable<ServiceResponse<Page<USqlPackage>>> call(ServiceResponse<Page<USqlPackage>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listPackagesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlPackage>>> listPackagesSinglePageAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listPackages(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlPackage>>>>(){

            public Observable<ServiceResponse<Page<USqlPackage>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listPackagesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlPackage>> listPackagesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlPackage>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public USqlView getView(String accountName, String databaseName, String schemaName, String viewName) {
        return (USqlView)((ServiceResponse)this.getViewWithServiceResponseAsync(accountName, databaseName, schemaName, viewName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<USqlView> getViewAsync(String accountName, String databaseName, String schemaName, String viewName, ServiceCallback<USqlView> serviceCallback) {
        return ServiceFuture.fromResponse(this.getViewWithServiceResponseAsync(accountName, databaseName, schemaName, viewName), serviceCallback);
    }

    @Override
    public Observable<USqlView> getViewAsync(String accountName, String databaseName, String schemaName, String viewName) {
        return this.getViewWithServiceResponseAsync(accountName, databaseName, schemaName, viewName).map((Func1)new Func1<ServiceResponse<USqlView>, USqlView>(){

            public USqlView call(ServiceResponse<USqlView> response) {
                return (USqlView)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<USqlView>> getViewWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String viewName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (viewName == null) {
            throw new IllegalArgumentException("Parameter viewName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.getView(databaseName, schemaName, viewName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlView>>>(){

            public Observable<ServiceResponse<USqlView>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.getViewDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<USqlView> getViewDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<USqlView>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlView> listViews(String accountName, String databaseName, String schemaName) {
        ServiceResponse response = (ServiceResponse)this.listViewsSinglePageAsync(accountName, databaseName, schemaName).toBlocking().single();
        return new PagedList<USqlView>((Page)response.body()){

            public Page<USqlView> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listViewsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlView>> listViewsAsync(String accountName, String databaseName, String schemaName, ListOperationCallback<USqlView> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listViewsSinglePageAsync(accountName, databaseName, schemaName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlView>>>>(){

            public Observable<ServiceResponse<Page<USqlView>>> call(String nextPageLink) {
                return CatalogsImpl.this.listViewsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlView>> listViewsAsync(String accountName, String databaseName, String schemaName) {
        return this.listViewsWithServiceResponseAsync(accountName, databaseName, schemaName).map((Func1)new Func1<ServiceResponse<Page<USqlView>>, Page<USqlView>>(){

            public Page<USqlView> call(ServiceResponse<Page<USqlView>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlView>>> listViewsWithServiceResponseAsync(String accountName, String databaseName, String schemaName) {
        return this.listViewsSinglePageAsync(accountName, databaseName, schemaName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlView>>, Observable<ServiceResponse<Page<USqlView>>>>(){

            public Observable<ServiceResponse<Page<USqlView>>> call(ServiceResponse<Page<USqlView>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listViewsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlView>>> listViewsSinglePageAsync(String accountName, String databaseName, String schemaName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listViews(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlView>>>>(){

            public Observable<ServiceResponse<Page<USqlView>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listViewsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlView> listViews(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listViewsSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlView>((Page)response.body()){

            public Page<USqlView> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listViewsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlView>> listViewsAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<USqlView> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listViewsSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlView>>>>(){

            public Observable<ServiceResponse<Page<USqlView>>> call(String nextPageLink) {
                return CatalogsImpl.this.listViewsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlView>> listViewsAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listViewsWithServiceResponseAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<USqlView>>, Page<USqlView>>(){

            public Page<USqlView> call(ServiceResponse<Page<USqlView>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlView>>> listViewsWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listViewsSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<USqlView>>, Observable<ServiceResponse<Page<USqlView>>>>(){

            public Observable<ServiceResponse<Page<USqlView>>> call(ServiceResponse<Page<USqlView>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listViewsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlView>>> listViewsSinglePageAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listViews(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlView>>>>(){

            public Observable<ServiceResponse<Page<USqlView>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listViewsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlView>> listViewsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlView>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public USqlTableStatistics getTableStatistic(String accountName, String databaseName, String schemaName, String tableName, String statisticsName) {
        return (USqlTableStatistics)((ServiceResponse)this.getTableStatisticWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, statisticsName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<USqlTableStatistics> getTableStatisticAsync(String accountName, String databaseName, String schemaName, String tableName, String statisticsName, ServiceCallback<USqlTableStatistics> serviceCallback) {
        return ServiceFuture.fromResponse(this.getTableStatisticWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, statisticsName), serviceCallback);
    }

    @Override
    public Observable<USqlTableStatistics> getTableStatisticAsync(String accountName, String databaseName, String schemaName, String tableName, String statisticsName) {
        return this.getTableStatisticWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, statisticsName).map((Func1)new Func1<ServiceResponse<USqlTableStatistics>, USqlTableStatistics>(){

            public USqlTableStatistics call(ServiceResponse<USqlTableStatistics> response) {
                return (USqlTableStatistics)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<USqlTableStatistics>> getTableStatisticWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName, String statisticsName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (statisticsName == null) {
            throw new IllegalArgumentException("Parameter statisticsName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.getTableStatistic(databaseName, schemaName, tableName, statisticsName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlTableStatistics>>>(){

            public Observable<ServiceResponse<USqlTableStatistics>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.getTableStatisticDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<USqlTableStatistics> getTableStatisticDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<USqlTableStatistics>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTableStatistics> listTableStatistics(String accountName, String databaseName, String schemaName, String tableName) {
        ServiceResponse response = (ServiceResponse)this.listTableStatisticsSinglePageAsync(accountName, databaseName, schemaName, tableName).toBlocking().single();
        return new PagedList<USqlTableStatistics>((Page)response.body()){

            public Page<USqlTableStatistics> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableStatisticsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableStatistics>> listTableStatisticsAsync(String accountName, String databaseName, String schemaName, String tableName, ListOperationCallback<USqlTableStatistics> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableStatisticsSinglePageAsync(accountName, databaseName, schemaName, tableName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableStatisticsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableStatistics>> listTableStatisticsAsync(String accountName, String databaseName, String schemaName, String tableName) {
        return this.listTableStatisticsWithServiceResponseAsync(accountName, databaseName, schemaName, tableName).map((Func1)new Func1<ServiceResponse<Page<USqlTableStatistics>>, Page<USqlTableStatistics>>(){

            public Page<USqlTableStatistics> call(ServiceResponse<Page<USqlTableStatistics>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName) {
        return this.listTableStatisticsSinglePageAsync(accountName, databaseName, schemaName, tableName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableStatistics>>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(ServiceResponse<Page<USqlTableStatistics>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableStatisticsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsSinglePageAsync(String accountName, String databaseName, String schemaName, String tableName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTableStatistics(databaseName, schemaName, tableName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableStatisticsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlTableStatistics> listTableStatistics(String accountName, String databaseName, String schemaName, String tableName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listTableStatisticsSinglePageAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlTableStatistics>((Page)response.body()){

            public Page<USqlTableStatistics> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableStatisticsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableStatistics>> listTableStatisticsAsync(String accountName, String databaseName, String schemaName, String tableName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<USqlTableStatistics> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableStatisticsSinglePageAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableStatisticsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableStatistics>> listTableStatisticsAsync(String accountName, String databaseName, String schemaName, String tableName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listTableStatisticsWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<USqlTableStatistics>>, Page<USqlTableStatistics>>(){

            public Page<USqlTableStatistics> call(ServiceResponse<Page<USqlTableStatistics>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listTableStatisticsSinglePageAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableStatistics>>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(ServiceResponse<Page<USqlTableStatistics>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableStatisticsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsSinglePageAsync(String accountName, String databaseName, String schemaName, String tableName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTableStatistics(databaseName, schemaName, tableName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableStatisticsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTableStatistics>> listTableStatisticsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTableStatistics>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public USqlTablePreview previewTablePartition(String accountName, String databaseName, String schemaName, String tableName, String partitionName) {
        return (USqlTablePreview)((ServiceResponse)this.previewTablePartitionWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, partitionName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<USqlTablePreview> previewTablePartitionAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName, ServiceCallback<USqlTablePreview> serviceCallback) {
        return ServiceFuture.fromResponse(this.previewTablePartitionWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, partitionName), serviceCallback);
    }

    @Override
    public Observable<USqlTablePreview> previewTablePartitionAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName) {
        return this.previewTablePartitionWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, partitionName).map((Func1)new Func1<ServiceResponse<USqlTablePreview>, USqlTablePreview>(){

            public USqlTablePreview call(ServiceResponse<USqlTablePreview> response) {
                return (USqlTablePreview)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<USqlTablePreview>> previewTablePartitionWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (partitionName == null) {
            throw new IllegalArgumentException("Parameter partitionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Long maxRows = null;
        Long maxColumns = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.previewTablePartition(databaseName, schemaName, tableName, partitionName, maxRows, maxColumns, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlTablePreview>>>(){

            public Observable<ServiceResponse<USqlTablePreview>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.previewTablePartitionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public USqlTablePreview previewTablePartition(String accountName, String databaseName, String schemaName, String tableName, String partitionName, Long maxRows, Long maxColumns) {
        return (USqlTablePreview)((ServiceResponse)this.previewTablePartitionWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, partitionName, maxRows, maxColumns).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<USqlTablePreview> previewTablePartitionAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName, Long maxRows, Long maxColumns, ServiceCallback<USqlTablePreview> serviceCallback) {
        return ServiceFuture.fromResponse(this.previewTablePartitionWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, partitionName, maxRows, maxColumns), serviceCallback);
    }

    @Override
    public Observable<USqlTablePreview> previewTablePartitionAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName, Long maxRows, Long maxColumns) {
        return this.previewTablePartitionWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, partitionName, maxRows, maxColumns).map((Func1)new Func1<ServiceResponse<USqlTablePreview>, USqlTablePreview>(){

            public USqlTablePreview call(ServiceResponse<USqlTablePreview> response) {
                return (USqlTablePreview)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<USqlTablePreview>> previewTablePartitionWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName, Long maxRows, Long maxColumns) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (partitionName == null) {
            throw new IllegalArgumentException("Parameter partitionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.previewTablePartition(databaseName, schemaName, tableName, partitionName, maxRows, maxColumns, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlTablePreview>>>(){

            public Observable<ServiceResponse<USqlTablePreview>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.previewTablePartitionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<USqlTablePreview> previewTablePartitionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<USqlTablePreview>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public USqlTablePartition getTablePartition(String accountName, String databaseName, String schemaName, String tableName, String partitionName) {
        return (USqlTablePartition)((ServiceResponse)this.getTablePartitionWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, partitionName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<USqlTablePartition> getTablePartitionAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName, ServiceCallback<USqlTablePartition> serviceCallback) {
        return ServiceFuture.fromResponse(this.getTablePartitionWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, partitionName), serviceCallback);
    }

    @Override
    public Observable<USqlTablePartition> getTablePartitionAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName) {
        return this.getTablePartitionWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, partitionName).map((Func1)new Func1<ServiceResponse<USqlTablePartition>, USqlTablePartition>(){

            public USqlTablePartition call(ServiceResponse<USqlTablePartition> response) {
                return (USqlTablePartition)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<USqlTablePartition>> getTablePartitionWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (partitionName == null) {
            throw new IllegalArgumentException("Parameter partitionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.getTablePartition(databaseName, schemaName, tableName, partitionName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlTablePartition>>>(){

            public Observable<ServiceResponse<USqlTablePartition>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.getTablePartitionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<USqlTablePartition> getTablePartitionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<USqlTablePartition>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public USqlTablePreview previewTable(String accountName, String databaseName, String schemaName, String tableName) {
        return (USqlTablePreview)((ServiceResponse)this.previewTableWithServiceResponseAsync(accountName, databaseName, schemaName, tableName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<USqlTablePreview> previewTableAsync(String accountName, String databaseName, String schemaName, String tableName, ServiceCallback<USqlTablePreview> serviceCallback) {
        return ServiceFuture.fromResponse(this.previewTableWithServiceResponseAsync(accountName, databaseName, schemaName, tableName), serviceCallback);
    }

    @Override
    public Observable<USqlTablePreview> previewTableAsync(String accountName, String databaseName, String schemaName, String tableName) {
        return this.previewTableWithServiceResponseAsync(accountName, databaseName, schemaName, tableName).map((Func1)new Func1<ServiceResponse<USqlTablePreview>, USqlTablePreview>(){

            public USqlTablePreview call(ServiceResponse<USqlTablePreview> response) {
                return (USqlTablePreview)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<USqlTablePreview>> previewTableWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Long maxRows = null;
        Long maxColumns = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.previewTable(databaseName, schemaName, tableName, maxRows, maxColumns, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlTablePreview>>>(){

            public Observable<ServiceResponse<USqlTablePreview>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.previewTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public USqlTablePreview previewTable(String accountName, String databaseName, String schemaName, String tableName, Long maxRows, Long maxColumns) {
        return (USqlTablePreview)((ServiceResponse)this.previewTableWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, maxRows, maxColumns).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<USqlTablePreview> previewTableAsync(String accountName, String databaseName, String schemaName, String tableName, Long maxRows, Long maxColumns, ServiceCallback<USqlTablePreview> serviceCallback) {
        return ServiceFuture.fromResponse(this.previewTableWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, maxRows, maxColumns), serviceCallback);
    }

    @Override
    public Observable<USqlTablePreview> previewTableAsync(String accountName, String databaseName, String schemaName, String tableName, Long maxRows, Long maxColumns) {
        return this.previewTableWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, maxRows, maxColumns).map((Func1)new Func1<ServiceResponse<USqlTablePreview>, USqlTablePreview>(){

            public USqlTablePreview call(ServiceResponse<USqlTablePreview> response) {
                return (USqlTablePreview)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<USqlTablePreview>> previewTableWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName, Long maxRows, Long maxColumns) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.previewTable(databaseName, schemaName, tableName, maxRows, maxColumns, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlTablePreview>>>(){

            public Observable<ServiceResponse<USqlTablePreview>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.previewTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<USqlTablePreview> previewTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<USqlTablePreview>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTablePartition> listTablePartitions(String accountName, String databaseName, String schemaName, String tableName) {
        ServiceResponse response = (ServiceResponse)this.listTablePartitionsSinglePageAsync(accountName, databaseName, schemaName, tableName).toBlocking().single();
        return new PagedList<USqlTablePartition>((Page)response.body()){

            public Page<USqlTablePartition> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTablePartitionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTablePartition>> listTablePartitionsAsync(String accountName, String databaseName, String schemaName, String tableName, ListOperationCallback<USqlTablePartition> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTablePartitionsSinglePageAsync(accountName, databaseName, schemaName, tableName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTablePartition>>>>(){

            public Observable<ServiceResponse<Page<USqlTablePartition>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTablePartitionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTablePartition>> listTablePartitionsAsync(String accountName, String databaseName, String schemaName, String tableName) {
        return this.listTablePartitionsWithServiceResponseAsync(accountName, databaseName, schemaName, tableName).map((Func1)new Func1<ServiceResponse<Page<USqlTablePartition>>, Page<USqlTablePartition>>(){

            public Page<USqlTablePartition> call(ServiceResponse<Page<USqlTablePartition>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTablePartition>>> listTablePartitionsWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName) {
        return this.listTablePartitionsSinglePageAsync(accountName, databaseName, schemaName, tableName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTablePartition>>, Observable<ServiceResponse<Page<USqlTablePartition>>>>(){

            public Observable<ServiceResponse<Page<USqlTablePartition>>> call(ServiceResponse<Page<USqlTablePartition>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTablePartitionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTablePartition>>> listTablePartitionsSinglePageAsync(String accountName, String databaseName, String schemaName, String tableName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTablePartitions(databaseName, schemaName, tableName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTablePartition>>>>(){

            public Observable<ServiceResponse<Page<USqlTablePartition>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTablePartitionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlTablePartition> listTablePartitions(String accountName, String databaseName, String schemaName, String tableName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listTablePartitionsSinglePageAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlTablePartition>((Page)response.body()){

            public Page<USqlTablePartition> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTablePartitionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTablePartition>> listTablePartitionsAsync(String accountName, String databaseName, String schemaName, String tableName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<USqlTablePartition> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTablePartitionsSinglePageAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTablePartition>>>>(){

            public Observable<ServiceResponse<Page<USqlTablePartition>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTablePartitionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTablePartition>> listTablePartitionsAsync(String accountName, String databaseName, String schemaName, String tableName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listTablePartitionsWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<USqlTablePartition>>, Page<USqlTablePartition>>(){

            public Page<USqlTablePartition> call(ServiceResponse<Page<USqlTablePartition>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTablePartition>>> listTablePartitionsWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listTablePartitionsSinglePageAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTablePartition>>, Observable<ServiceResponse<Page<USqlTablePartition>>>>(){

            public Observable<ServiceResponse<Page<USqlTablePartition>>> call(ServiceResponse<Page<USqlTablePartition>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTablePartitionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTablePartition>>> listTablePartitionsSinglePageAsync(String accountName, String databaseName, String schemaName, String tableName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTablePartitions(databaseName, schemaName, tableName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTablePartition>>>>(){

            public Observable<ServiceResponse<Page<USqlTablePartition>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTablePartitionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTablePartition>> listTablePartitionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTablePartition>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlType> listTypes(String accountName, String databaseName, String schemaName) {
        ServiceResponse response = (ServiceResponse)this.listTypesSinglePageAsync(accountName, databaseName, schemaName).toBlocking().single();
        return new PagedList<USqlType>((Page)response.body()){

            public Page<USqlType> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTypesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlType>> listTypesAsync(String accountName, String databaseName, String schemaName, ListOperationCallback<USqlType> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTypesSinglePageAsync(accountName, databaseName, schemaName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlType>>>>(){

            public Observable<ServiceResponse<Page<USqlType>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTypesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlType>> listTypesAsync(String accountName, String databaseName, String schemaName) {
        return this.listTypesWithServiceResponseAsync(accountName, databaseName, schemaName).map((Func1)new Func1<ServiceResponse<Page<USqlType>>, Page<USqlType>>(){

            public Page<USqlType> call(ServiceResponse<Page<USqlType>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlType>>> listTypesWithServiceResponseAsync(String accountName, String databaseName, String schemaName) {
        return this.listTypesSinglePageAsync(accountName, databaseName, schemaName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlType>>, Observable<ServiceResponse<Page<USqlType>>>>(){

            public Observable<ServiceResponse<Page<USqlType>>> call(ServiceResponse<Page<USqlType>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTypesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlType>>> listTypesSinglePageAsync(String accountName, String databaseName, String schemaName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTypes(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlType>>>>(){

            public Observable<ServiceResponse<Page<USqlType>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTypesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlType> listTypes(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listTypesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlType>((Page)response.body()){

            public Page<USqlType> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTypesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlType>> listTypesAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<USqlType> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTypesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlType>>>>(){

            public Observable<ServiceResponse<Page<USqlType>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTypesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlType>> listTypesAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listTypesWithServiceResponseAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<USqlType>>, Page<USqlType>>(){

            public Page<USqlType> call(ServiceResponse<Page<USqlType>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlType>>> listTypesWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listTypesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<USqlType>>, Observable<ServiceResponse<Page<USqlType>>>>(){

            public Observable<ServiceResponse<Page<USqlType>>> call(ServiceResponse<Page<USqlType>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTypesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlType>>> listTypesSinglePageAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTypes(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlType>>>>(){

            public Observable<ServiceResponse<Page<USqlType>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTypesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlType>> listTypesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlType>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public USqlTableValuedFunction getTableValuedFunction(String accountName, String databaseName, String schemaName, String tableValuedFunctionName) {
        return (USqlTableValuedFunction)((ServiceResponse)this.getTableValuedFunctionWithServiceResponseAsync(accountName, databaseName, schemaName, tableValuedFunctionName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<USqlTableValuedFunction> getTableValuedFunctionAsync(String accountName, String databaseName, String schemaName, String tableValuedFunctionName, ServiceCallback<USqlTableValuedFunction> serviceCallback) {
        return ServiceFuture.fromResponse(this.getTableValuedFunctionWithServiceResponseAsync(accountName, databaseName, schemaName, tableValuedFunctionName), serviceCallback);
    }

    @Override
    public Observable<USqlTableValuedFunction> getTableValuedFunctionAsync(String accountName, String databaseName, String schemaName, String tableValuedFunctionName) {
        return this.getTableValuedFunctionWithServiceResponseAsync(accountName, databaseName, schemaName, tableValuedFunctionName).map((Func1)new Func1<ServiceResponse<USqlTableValuedFunction>, USqlTableValuedFunction>(){

            public USqlTableValuedFunction call(ServiceResponse<USqlTableValuedFunction> response) {
                return (USqlTableValuedFunction)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<USqlTableValuedFunction>> getTableValuedFunctionWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableValuedFunctionName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableValuedFunctionName == null) {
            throw new IllegalArgumentException("Parameter tableValuedFunctionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.getTableValuedFunction(databaseName, schemaName, tableValuedFunctionName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlTableValuedFunction>>>(){

            public Observable<ServiceResponse<USqlTableValuedFunction>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.getTableValuedFunctionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<USqlTableValuedFunction> getTableValuedFunctionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<USqlTableValuedFunction>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTableValuedFunction> listTableValuedFunctions(String accountName, String databaseName, String schemaName) {
        ServiceResponse response = (ServiceResponse)this.listTableValuedFunctionsSinglePageAsync(accountName, databaseName, schemaName).toBlocking().single();
        return new PagedList<USqlTableValuedFunction>((Page)response.body()){

            public Page<USqlTableValuedFunction> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableValuedFunctionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableValuedFunction>> listTableValuedFunctionsAsync(String accountName, String databaseName, String schemaName, ListOperationCallback<USqlTableValuedFunction> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableValuedFunctionsSinglePageAsync(accountName, databaseName, schemaName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>(){

            public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableValuedFunctionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableValuedFunction>> listTableValuedFunctionsAsync(String accountName, String databaseName, String schemaName) {
        return this.listTableValuedFunctionsWithServiceResponseAsync(accountName, databaseName, schemaName).map((Func1)new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Page<USqlTableValuedFunction>>(){

            public Page<USqlTableValuedFunction> call(ServiceResponse<Page<USqlTableValuedFunction>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsWithServiceResponseAsync(String accountName, String databaseName, String schemaName) {
        return this.listTableValuedFunctionsSinglePageAsync(accountName, databaseName, schemaName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>(){

            public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(ServiceResponse<Page<USqlTableValuedFunction>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableValuedFunctionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsSinglePageAsync(String accountName, String databaseName, String schemaName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTableValuedFunctions(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>(){

            public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableValuedFunctionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlTableValuedFunction> listTableValuedFunctions(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listTableValuedFunctionsSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlTableValuedFunction>((Page)response.body()){

            public Page<USqlTableValuedFunction> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableValuedFunctionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableValuedFunction>> listTableValuedFunctionsAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<USqlTableValuedFunction> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableValuedFunctionsSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>(){

            public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableValuedFunctionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableValuedFunction>> listTableValuedFunctionsAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listTableValuedFunctionsWithServiceResponseAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Page<USqlTableValuedFunction>>(){

            public Page<USqlTableValuedFunction> call(ServiceResponse<Page<USqlTableValuedFunction>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listTableValuedFunctionsSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>(){

            public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(ServiceResponse<Page<USqlTableValuedFunction>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableValuedFunctionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsSinglePageAsync(String accountName, String databaseName, String schemaName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTableValuedFunctions(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>(){

            public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableValuedFunctionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTableValuedFunction>> listTableValuedFunctionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTableValuedFunction>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public USqlAssembly getAssembly(String accountName, String databaseName, String assemblyName) {
        return (USqlAssembly)((ServiceResponse)this.getAssemblyWithServiceResponseAsync(accountName, databaseName, assemblyName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<USqlAssembly> getAssemblyAsync(String accountName, String databaseName, String assemblyName, ServiceCallback<USqlAssembly> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAssemblyWithServiceResponseAsync(accountName, databaseName, assemblyName), serviceCallback);
    }

    @Override
    public Observable<USqlAssembly> getAssemblyAsync(String accountName, String databaseName, String assemblyName) {
        return this.getAssemblyWithServiceResponseAsync(accountName, databaseName, assemblyName).map((Func1)new Func1<ServiceResponse<USqlAssembly>, USqlAssembly>(){

            public USqlAssembly call(ServiceResponse<USqlAssembly> response) {
                return (USqlAssembly)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<USqlAssembly>> getAssemblyWithServiceResponseAsync(String accountName, String databaseName, String assemblyName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (assemblyName == null) {
            throw new IllegalArgumentException("Parameter assemblyName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.getAssembly(databaseName, assemblyName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlAssembly>>>(){

            public Observable<ServiceResponse<USqlAssembly>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.getAssemblyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<USqlAssembly> getAssemblyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<USqlAssembly>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlAssemblyClr> listAssemblies(String accountName, String databaseName) {
        ServiceResponse response = (ServiceResponse)this.listAssembliesSinglePageAsync(accountName, databaseName).toBlocking().single();
        return new PagedList<USqlAssemblyClr>((Page)response.body()){

            public Page<USqlAssemblyClr> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listAssembliesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlAssemblyClr>> listAssembliesAsync(String accountName, String databaseName, ListOperationCallback<USqlAssemblyClr> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAssembliesSinglePageAsync(accountName, databaseName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlAssemblyClr>>>>(){

            public Observable<ServiceResponse<Page<USqlAssemblyClr>>> call(String nextPageLink) {
                return CatalogsImpl.this.listAssembliesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlAssemblyClr>> listAssembliesAsync(String accountName, String databaseName) {
        return this.listAssembliesWithServiceResponseAsync(accountName, databaseName).map((Func1)new Func1<ServiceResponse<Page<USqlAssemblyClr>>, Page<USqlAssemblyClr>>(){

            public Page<USqlAssemblyClr> call(ServiceResponse<Page<USqlAssemblyClr>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlAssemblyClr>>> listAssembliesWithServiceResponseAsync(String accountName, String databaseName) {
        return this.listAssembliesSinglePageAsync(accountName, databaseName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlAssemblyClr>>, Observable<ServiceResponse<Page<USqlAssemblyClr>>>>(){

            public Observable<ServiceResponse<Page<USqlAssemblyClr>>> call(ServiceResponse<Page<USqlAssemblyClr>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listAssembliesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlAssemblyClr>>> listAssembliesSinglePageAsync(String accountName, String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listAssemblies(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlAssemblyClr>>>>(){

            public Observable<ServiceResponse<Page<USqlAssemblyClr>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listAssembliesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlAssemblyClr> listAssemblies(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listAssembliesSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlAssemblyClr>((Page)response.body()){

            public Page<USqlAssemblyClr> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listAssembliesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlAssemblyClr>> listAssembliesAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<USqlAssemblyClr> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAssembliesSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlAssemblyClr>>>>(){

            public Observable<ServiceResponse<Page<USqlAssemblyClr>>> call(String nextPageLink) {
                return CatalogsImpl.this.listAssembliesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlAssemblyClr>> listAssembliesAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listAssembliesWithServiceResponseAsync(accountName, databaseName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<USqlAssemblyClr>>, Page<USqlAssemblyClr>>(){

            public Page<USqlAssemblyClr> call(ServiceResponse<Page<USqlAssemblyClr>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlAssemblyClr>>> listAssembliesWithServiceResponseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listAssembliesSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<USqlAssemblyClr>>, Observable<ServiceResponse<Page<USqlAssemblyClr>>>>(){

            public Observable<ServiceResponse<Page<USqlAssemblyClr>>> call(ServiceResponse<Page<USqlAssemblyClr>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listAssembliesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlAssemblyClr>>> listAssembliesSinglePageAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listAssemblies(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlAssemblyClr>>>>(){

            public Observable<ServiceResponse<Page<USqlAssemblyClr>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listAssembliesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlAssemblyClr>> listAssembliesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlAssemblyClr>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public USqlSchema getSchema(String accountName, String databaseName, String schemaName) {
        return (USqlSchema)((ServiceResponse)this.getSchemaWithServiceResponseAsync(accountName, databaseName, schemaName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<USqlSchema> getSchemaAsync(String accountName, String databaseName, String schemaName, ServiceCallback<USqlSchema> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSchemaWithServiceResponseAsync(accountName, databaseName, schemaName), serviceCallback);
    }

    @Override
    public Observable<USqlSchema> getSchemaAsync(String accountName, String databaseName, String schemaName) {
        return this.getSchemaWithServiceResponseAsync(accountName, databaseName, schemaName).map((Func1)new Func1<ServiceResponse<USqlSchema>, USqlSchema>(){

            public USqlSchema call(ServiceResponse<USqlSchema> response) {
                return (USqlSchema)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<USqlSchema>> getSchemaWithServiceResponseAsync(String accountName, String databaseName, String schemaName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.getSchema(databaseName, schemaName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlSchema>>>(){

            public Observable<ServiceResponse<USqlSchema>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.getSchemaDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<USqlSchema> getSchemaDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<USqlSchema>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlSchema> listSchemas(String accountName, String databaseName) {
        ServiceResponse response = (ServiceResponse)this.listSchemasSinglePageAsync(accountName, databaseName).toBlocking().single();
        return new PagedList<USqlSchema>((Page)response.body()){

            public Page<USqlSchema> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listSchemasNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlSchema>> listSchemasAsync(String accountName, String databaseName, ListOperationCallback<USqlSchema> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSchemasSinglePageAsync(accountName, databaseName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlSchema>>>>(){

            public Observable<ServiceResponse<Page<USqlSchema>>> call(String nextPageLink) {
                return CatalogsImpl.this.listSchemasNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlSchema>> listSchemasAsync(String accountName, String databaseName) {
        return this.listSchemasWithServiceResponseAsync(accountName, databaseName).map((Func1)new Func1<ServiceResponse<Page<USqlSchema>>, Page<USqlSchema>>(){

            public Page<USqlSchema> call(ServiceResponse<Page<USqlSchema>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlSchema>>> listSchemasWithServiceResponseAsync(String accountName, String databaseName) {
        return this.listSchemasSinglePageAsync(accountName, databaseName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlSchema>>, Observable<ServiceResponse<Page<USqlSchema>>>>(){

            public Observable<ServiceResponse<Page<USqlSchema>>> call(ServiceResponse<Page<USqlSchema>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listSchemasNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlSchema>>> listSchemasSinglePageAsync(String accountName, String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listSchemas(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlSchema>>>>(){

            public Observable<ServiceResponse<Page<USqlSchema>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listSchemasDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlSchema> listSchemas(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listSchemasSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlSchema>((Page)response.body()){

            public Page<USqlSchema> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listSchemasNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlSchema>> listSchemasAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<USqlSchema> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSchemasSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlSchema>>>>(){

            public Observable<ServiceResponse<Page<USqlSchema>>> call(String nextPageLink) {
                return CatalogsImpl.this.listSchemasNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlSchema>> listSchemasAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listSchemasWithServiceResponseAsync(accountName, databaseName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<USqlSchema>>, Page<USqlSchema>>(){

            public Page<USqlSchema> call(ServiceResponse<Page<USqlSchema>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlSchema>>> listSchemasWithServiceResponseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listSchemasSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<USqlSchema>>, Observable<ServiceResponse<Page<USqlSchema>>>>(){

            public Observable<ServiceResponse<Page<USqlSchema>>> call(ServiceResponse<Page<USqlSchema>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listSchemasNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlSchema>>> listSchemasSinglePageAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listSchemas(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlSchema>>>>(){

            public Observable<ServiceResponse<Page<USqlSchema>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listSchemasDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlSchema>> listSchemasDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlSchema>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTableStatistics> listTableStatisticsByDatabase(String accountName, String databaseName) {
        ServiceResponse response = (ServiceResponse)this.listTableStatisticsByDatabaseSinglePageAsync(accountName, databaseName).toBlocking().single();
        return new PagedList<USqlTableStatistics>((Page)response.body()){

            public Page<USqlTableStatistics> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableStatisticsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableStatistics>> listTableStatisticsByDatabaseAsync(String accountName, String databaseName, ListOperationCallback<USqlTableStatistics> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableStatisticsByDatabaseSinglePageAsync(accountName, databaseName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableStatisticsByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableStatistics>> listTableStatisticsByDatabaseAsync(String accountName, String databaseName) {
        return this.listTableStatisticsByDatabaseWithServiceResponseAsync(accountName, databaseName).map((Func1)new Func1<ServiceResponse<Page<USqlTableStatistics>>, Page<USqlTableStatistics>>(){

            public Page<USqlTableStatistics> call(ServiceResponse<Page<USqlTableStatistics>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseWithServiceResponseAsync(String accountName, String databaseName) {
        return this.listTableStatisticsByDatabaseSinglePageAsync(accountName, databaseName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableStatistics>>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(ServiceResponse<Page<USqlTableStatistics>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableStatisticsByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseSinglePageAsync(String accountName, String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTableStatisticsByDatabase(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableStatisticsByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlTableStatistics> listTableStatisticsByDatabase(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listTableStatisticsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlTableStatistics>((Page)response.body()){

            public Page<USqlTableStatistics> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableStatisticsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableStatistics>> listTableStatisticsByDatabaseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<USqlTableStatistics> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableStatisticsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableStatisticsByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableStatistics>> listTableStatisticsByDatabaseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listTableStatisticsByDatabaseWithServiceResponseAsync(accountName, databaseName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<USqlTableStatistics>>, Page<USqlTableStatistics>>(){

            public Page<USqlTableStatistics> call(ServiceResponse<Page<USqlTableStatistics>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseWithServiceResponseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listTableStatisticsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableStatistics>>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(ServiceResponse<Page<USqlTableStatistics>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableStatisticsByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseSinglePageAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTableStatisticsByDatabase(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableStatisticsByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTableStatistics>> listTableStatisticsByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTableStatistics>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTable> listTablesByDatabase(String accountName, String databaseName) {
        ServiceResponse response = (ServiceResponse)this.listTablesByDatabaseSinglePageAsync(accountName, databaseName).toBlocking().single();
        return new PagedList<USqlTable>((Page)response.body()){

            public Page<USqlTable> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTablesByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTable>> listTablesByDatabaseAsync(String accountName, String databaseName, ListOperationCallback<USqlTable> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTablesByDatabaseSinglePageAsync(accountName, databaseName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTable>>>>(){

            public Observable<ServiceResponse<Page<USqlTable>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTablesByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTable>> listTablesByDatabaseAsync(String accountName, String databaseName) {
        return this.listTablesByDatabaseWithServiceResponseAsync(accountName, databaseName).map((Func1)new Func1<ServiceResponse<Page<USqlTable>>, Page<USqlTable>>(){

            public Page<USqlTable> call(ServiceResponse<Page<USqlTable>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTable>>> listTablesByDatabaseWithServiceResponseAsync(String accountName, String databaseName) {
        return this.listTablesByDatabaseSinglePageAsync(accountName, databaseName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTable>>, Observable<ServiceResponse<Page<USqlTable>>>>(){

            public Observable<ServiceResponse<Page<USqlTable>>> call(ServiceResponse<Page<USqlTable>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTablesByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTable>>> listTablesByDatabaseSinglePageAsync(String accountName, String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        Boolean basic = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTablesByDatabase(databaseName, filter, top, skip, select, orderby, count, basic, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTable>>>>(){

            public Observable<ServiceResponse<Page<USqlTable>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTablesByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlTable> listTablesByDatabase(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, Boolean basic) {
        ServiceResponse response = (ServiceResponse)this.listTablesByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count, basic).toBlocking().single();
        return new PagedList<USqlTable>((Page)response.body()){

            public Page<USqlTable> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTablesByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTable>> listTablesByDatabaseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, Boolean basic, ListOperationCallback<USqlTable> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTablesByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count, basic), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTable>>>>(){

            public Observable<ServiceResponse<Page<USqlTable>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTablesByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTable>> listTablesByDatabaseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, Boolean basic) {
        return this.listTablesByDatabaseWithServiceResponseAsync(accountName, databaseName, filter, top, skip, select, orderby, count, basic).map((Func1)new Func1<ServiceResponse<Page<USqlTable>>, Page<USqlTable>>(){

            public Page<USqlTable> call(ServiceResponse<Page<USqlTable>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTable>>> listTablesByDatabaseWithServiceResponseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, Boolean basic) {
        return this.listTablesByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count, basic).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTable>>, Observable<ServiceResponse<Page<USqlTable>>>>(){

            public Observable<ServiceResponse<Page<USqlTable>>> call(ServiceResponse<Page<USqlTable>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTablesByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTable>>> listTablesByDatabaseSinglePageAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, Boolean basic) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTablesByDatabase(databaseName, filter, top, skip, select, orderby, count, basic, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTable>>>>(){

            public Observable<ServiceResponse<Page<USqlTable>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTablesByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTable>> listTablesByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTable>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTableValuedFunction> listTableValuedFunctionsByDatabase(String accountName, String databaseName) {
        ServiceResponse response = (ServiceResponse)this.listTableValuedFunctionsByDatabaseSinglePageAsync(accountName, databaseName).toBlocking().single();
        return new PagedList<USqlTableValuedFunction>((Page)response.body()){

            public Page<USqlTableValuedFunction> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableValuedFunctionsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseAsync(String accountName, String databaseName, ListOperationCallback<USqlTableValuedFunction> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableValuedFunctionsByDatabaseSinglePageAsync(accountName, databaseName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>(){

            public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableValuedFunctionsByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseAsync(String accountName, String databaseName) {
        return this.listTableValuedFunctionsByDatabaseWithServiceResponseAsync(accountName, databaseName).map((Func1)new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Page<USqlTableValuedFunction>>(){

            public Page<USqlTableValuedFunction> call(ServiceResponse<Page<USqlTableValuedFunction>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsByDatabaseWithServiceResponseAsync(String accountName, String databaseName) {
        return this.listTableValuedFunctionsByDatabaseSinglePageAsync(accountName, databaseName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>(){

            public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(ServiceResponse<Page<USqlTableValuedFunction>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableValuedFunctionsByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsByDatabaseSinglePageAsync(String accountName, String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTableValuedFunctionsByDatabase(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>(){

            public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableValuedFunctionsByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlTableValuedFunction> listTableValuedFunctionsByDatabase(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listTableValuedFunctionsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlTableValuedFunction>((Page)response.body()){

            public Page<USqlTableValuedFunction> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableValuedFunctionsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<USqlTableValuedFunction> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableValuedFunctionsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>(){

            public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableValuedFunctionsByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listTableValuedFunctionsByDatabaseWithServiceResponseAsync(accountName, databaseName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Page<USqlTableValuedFunction>>(){

            public Page<USqlTableValuedFunction> call(ServiceResponse<Page<USqlTableValuedFunction>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsByDatabaseWithServiceResponseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listTableValuedFunctionsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>(){

            public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(ServiceResponse<Page<USqlTableValuedFunction>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableValuedFunctionsByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsByDatabaseSinglePageAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listTableValuedFunctionsByDatabase(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>(){

            public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableValuedFunctionsByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTableValuedFunction>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlView> listViewsByDatabase(String accountName, String databaseName) {
        ServiceResponse response = (ServiceResponse)this.listViewsByDatabaseSinglePageAsync(accountName, databaseName).toBlocking().single();
        return new PagedList<USqlView>((Page)response.body()){

            public Page<USqlView> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listViewsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlView>> listViewsByDatabaseAsync(String accountName, String databaseName, ListOperationCallback<USqlView> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listViewsByDatabaseSinglePageAsync(accountName, databaseName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlView>>>>(){

            public Observable<ServiceResponse<Page<USqlView>>> call(String nextPageLink) {
                return CatalogsImpl.this.listViewsByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlView>> listViewsByDatabaseAsync(String accountName, String databaseName) {
        return this.listViewsByDatabaseWithServiceResponseAsync(accountName, databaseName).map((Func1)new Func1<ServiceResponse<Page<USqlView>>, Page<USqlView>>(){

            public Page<USqlView> call(ServiceResponse<Page<USqlView>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlView>>> listViewsByDatabaseWithServiceResponseAsync(String accountName, String databaseName) {
        return this.listViewsByDatabaseSinglePageAsync(accountName, databaseName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlView>>, Observable<ServiceResponse<Page<USqlView>>>>(){

            public Observable<ServiceResponse<Page<USqlView>>> call(ServiceResponse<Page<USqlView>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listViewsByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlView>>> listViewsByDatabaseSinglePageAsync(String accountName, String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listViewsByDatabase(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlView>>>>(){

            public Observable<ServiceResponse<Page<USqlView>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listViewsByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlView> listViewsByDatabase(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listViewsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlView>((Page)response.body()){

            public Page<USqlView> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listViewsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlView>> listViewsByDatabaseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<USqlView> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listViewsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlView>>>>(){

            public Observable<ServiceResponse<Page<USqlView>>> call(String nextPageLink) {
                return CatalogsImpl.this.listViewsByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlView>> listViewsByDatabaseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listViewsByDatabaseWithServiceResponseAsync(accountName, databaseName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<USqlView>>, Page<USqlView>>(){

            public Page<USqlView> call(ServiceResponse<Page<USqlView>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlView>>> listViewsByDatabaseWithServiceResponseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listViewsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<USqlView>>, Observable<ServiceResponse<Page<USqlView>>>>(){

            public Observable<ServiceResponse<Page<USqlView>>> call(ServiceResponse<Page<USqlView>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listViewsByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlView>>> listViewsByDatabaseSinglePageAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listViewsByDatabase(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlView>>>>(){

            public Observable<ServiceResponse<Page<USqlView>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listViewsByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlView>> listViewsByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlView>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<Acl> listAclsByDatabase(String accountName, String databaseName) {
        ServiceResponse response = (ServiceResponse)this.listAclsByDatabaseSinglePageAsync(accountName, databaseName).toBlocking().single();
        return new PagedList<Acl>((Page)response.body()){

            public Page<Acl> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listAclsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<Acl>> listAclsByDatabaseAsync(String accountName, String databaseName, ListOperationCallback<Acl> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAclsByDatabaseSinglePageAsync(accountName, databaseName), (Func1)new Func1<String, Observable<ServiceResponse<Page<Acl>>>>(){

            public Observable<ServiceResponse<Page<Acl>>> call(String nextPageLink) {
                return CatalogsImpl.this.listAclsByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<Acl>> listAclsByDatabaseAsync(String accountName, String databaseName) {
        return this.listAclsByDatabaseWithServiceResponseAsync(accountName, databaseName).map((Func1)new Func1<ServiceResponse<Page<Acl>>, Page<Acl>>(){

            public Page<Acl> call(ServiceResponse<Page<Acl>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<Acl>>> listAclsByDatabaseWithServiceResponseAsync(String accountName, String databaseName) {
        return this.listAclsByDatabaseSinglePageAsync(accountName, databaseName).concatMap((Func1)new Func1<ServiceResponse<Page<Acl>>, Observable<ServiceResponse<Page<Acl>>>>(){

            public Observable<ServiceResponse<Page<Acl>>> call(ServiceResponse<Page<Acl>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listAclsByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<Acl>>> listAclsByDatabaseSinglePageAsync(String accountName, String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listAclsByDatabase(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Acl>>>>(){

            public Observable<ServiceResponse<Page<Acl>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listAclsByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<Acl> listAclsByDatabase(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listAclsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<Acl>((Page)response.body()){

            public Page<Acl> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listAclsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<Acl>> listAclsByDatabaseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<Acl> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAclsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<Acl>>>>(){

            public Observable<ServiceResponse<Page<Acl>>> call(String nextPageLink) {
                return CatalogsImpl.this.listAclsByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<Acl>> listAclsByDatabaseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listAclsByDatabaseWithServiceResponseAsync(accountName, databaseName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<Acl>>, Page<Acl>>(){

            public Page<Acl> call(ServiceResponse<Page<Acl>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<Acl>>> listAclsByDatabaseWithServiceResponseAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listAclsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<Acl>>, Observable<ServiceResponse<Page<Acl>>>>(){

            public Observable<ServiceResponse<Page<Acl>>> call(ServiceResponse<Page<Acl>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listAclsByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<Acl>>> listAclsByDatabaseSinglePageAsync(String accountName, String databaseName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listAclsByDatabase(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Acl>>>>(){

            public Observable<ServiceResponse<Page<Acl>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listAclsByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<Acl>> listAclsByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<Acl>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<Acl> listAcls(String accountName) {
        ServiceResponse response = (ServiceResponse)this.listAclsSinglePageAsync(accountName).toBlocking().single();
        return new PagedList<Acl>((Page)response.body()){

            public Page<Acl> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listAclsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<Acl>> listAclsAsync(String accountName, ListOperationCallback<Acl> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAclsSinglePageAsync(accountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<Acl>>>>(){

            public Observable<ServiceResponse<Page<Acl>>> call(String nextPageLink) {
                return CatalogsImpl.this.listAclsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<Acl>> listAclsAsync(String accountName) {
        return this.listAclsWithServiceResponseAsync(accountName).map((Func1)new Func1<ServiceResponse<Page<Acl>>, Page<Acl>>(){

            public Page<Acl> call(ServiceResponse<Page<Acl>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<Acl>>> listAclsWithServiceResponseAsync(String accountName) {
        return this.listAclsSinglePageAsync(accountName).concatMap((Func1)new Func1<ServiceResponse<Page<Acl>>, Observable<ServiceResponse<Page<Acl>>>>(){

            public Observable<ServiceResponse<Page<Acl>>> call(ServiceResponse<Page<Acl>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listAclsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<Acl>>> listAclsSinglePageAsync(String accountName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listAcls(filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Acl>>>>(){

            public Observable<ServiceResponse<Page<Acl>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listAclsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<Acl> listAcls(String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listAclsSinglePageAsync(accountName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<Acl>((Page)response.body()){

            public Page<Acl> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listAclsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<Acl>> listAclsAsync(String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<Acl> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAclsSinglePageAsync(accountName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<Acl>>>>(){

            public Observable<ServiceResponse<Page<Acl>>> call(String nextPageLink) {
                return CatalogsImpl.this.listAclsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<Acl>> listAclsAsync(String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listAclsWithServiceResponseAsync(accountName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<Acl>>, Page<Acl>>(){

            public Page<Acl> call(ServiceResponse<Page<Acl>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<Acl>>> listAclsWithServiceResponseAsync(String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listAclsSinglePageAsync(accountName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<Acl>>, Observable<ServiceResponse<Page<Acl>>>>(){

            public Observable<ServiceResponse<Page<Acl>>> call(ServiceResponse<Page<Acl>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listAclsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<Acl>>> listAclsSinglePageAsync(String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listAcls(filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Acl>>>>(){

            public Observable<ServiceResponse<Page<Acl>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listAclsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<Acl>> listAclsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<Acl>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public USqlDatabase getDatabase(String accountName, String databaseName) {
        return (USqlDatabase)((ServiceResponse)this.getDatabaseWithServiceResponseAsync(accountName, databaseName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<USqlDatabase> getDatabaseAsync(String accountName, String databaseName, ServiceCallback<USqlDatabase> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDatabaseWithServiceResponseAsync(accountName, databaseName), serviceCallback);
    }

    @Override
    public Observable<USqlDatabase> getDatabaseAsync(String accountName, String databaseName) {
        return this.getDatabaseWithServiceResponseAsync(accountName, databaseName).map((Func1)new Func1<ServiceResponse<USqlDatabase>, USqlDatabase>(){

            public USqlDatabase call(ServiceResponse<USqlDatabase> response) {
                return (USqlDatabase)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<USqlDatabase>> getDatabaseWithServiceResponseAsync(String accountName, String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.getDatabase(databaseName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlDatabase>>>(){

            public Observable<ServiceResponse<USqlDatabase>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.getDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<USqlDatabase> getDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<USqlDatabase>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlDatabase> listDatabases(String accountName) {
        ServiceResponse response = (ServiceResponse)this.listDatabasesSinglePageAsync(accountName).toBlocking().single();
        return new PagedList<USqlDatabase>((Page)response.body()){

            public Page<USqlDatabase> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listDatabasesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlDatabase>> listDatabasesAsync(String accountName, ListOperationCallback<USqlDatabase> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listDatabasesSinglePageAsync(accountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlDatabase>>>>(){

            public Observable<ServiceResponse<Page<USqlDatabase>>> call(String nextPageLink) {
                return CatalogsImpl.this.listDatabasesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlDatabase>> listDatabasesAsync(String accountName) {
        return this.listDatabasesWithServiceResponseAsync(accountName).map((Func1)new Func1<ServiceResponse<Page<USqlDatabase>>, Page<USqlDatabase>>(){

            public Page<USqlDatabase> call(ServiceResponse<Page<USqlDatabase>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlDatabase>>> listDatabasesWithServiceResponseAsync(String accountName) {
        return this.listDatabasesSinglePageAsync(accountName).concatMap((Func1)new Func1<ServiceResponse<Page<USqlDatabase>>, Observable<ServiceResponse<Page<USqlDatabase>>>>(){

            public Observable<ServiceResponse<Page<USqlDatabase>>> call(ServiceResponse<Page<USqlDatabase>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listDatabasesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlDatabase>>> listDatabasesSinglePageAsync(String accountName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listDatabases(filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlDatabase>>>>(){

            public Observable<ServiceResponse<Page<USqlDatabase>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listDatabasesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<USqlDatabase> listDatabases(String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listDatabasesSinglePageAsync(accountName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlDatabase>((Page)response.body()){

            public Page<USqlDatabase> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listDatabasesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlDatabase>> listDatabasesAsync(String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<USqlDatabase> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listDatabasesSinglePageAsync(accountName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlDatabase>>>>(){

            public Observable<ServiceResponse<Page<USqlDatabase>>> call(String nextPageLink) {
                return CatalogsImpl.this.listDatabasesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlDatabase>> listDatabasesAsync(String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listDatabasesWithServiceResponseAsync(accountName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<USqlDatabase>>, Page<USqlDatabase>>(){

            public Page<USqlDatabase> call(ServiceResponse<Page<USqlDatabase>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlDatabase>>> listDatabasesWithServiceResponseAsync(String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listDatabasesSinglePageAsync(accountName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<USqlDatabase>>, Observable<ServiceResponse<Page<USqlDatabase>>>>(){

            public Observable<ServiceResponse<Page<USqlDatabase>>> call(ServiceResponse<Page<USqlDatabase>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listDatabasesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlDatabase>>> listDatabasesSinglePageAsync(String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.listDatabases(filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlDatabase>>>>(){

            public Observable<ServiceResponse<Page<USqlDatabase>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listDatabasesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlDatabase>> listDatabasesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlDatabase>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void grantAcl(String accountName, AclCreateOrUpdateParameters parameters) {
        ((ServiceResponse)this.grantAclWithServiceResponseAsync(accountName, parameters).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> grantAclAsync(String accountName, AclCreateOrUpdateParameters parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.grantAclWithServiceResponseAsync(accountName, parameters), serviceCallback);
    }

    @Override
    public Observable<Void> grantAclAsync(String accountName, AclCreateOrUpdateParameters parameters) {
        return this.grantAclWithServiceResponseAsync(accountName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> grantAclWithServiceResponseAsync(String accountName, AclCreateOrUpdateParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String op = "GRANTACE";
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.grantAcl(parameters, "GRANTACE", this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.grantAclDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> grantAclDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void grantAclToDatabase(String accountName, String databaseName, AclCreateOrUpdateParameters parameters) {
        ((ServiceResponse)this.grantAclToDatabaseWithServiceResponseAsync(accountName, databaseName, parameters).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> grantAclToDatabaseAsync(String accountName, String databaseName, AclCreateOrUpdateParameters parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.grantAclToDatabaseWithServiceResponseAsync(accountName, databaseName, parameters), serviceCallback);
    }

    @Override
    public Observable<Void> grantAclToDatabaseAsync(String accountName, String databaseName, AclCreateOrUpdateParameters parameters) {
        return this.grantAclToDatabaseWithServiceResponseAsync(accountName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> grantAclToDatabaseWithServiceResponseAsync(String accountName, String databaseName, AclCreateOrUpdateParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String op = "GRANTACE";
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.grantAclToDatabase(databaseName, parameters, "GRANTACE", this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.grantAclToDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> grantAclToDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void revokeAcl(String accountName, AclDeleteParameters parameters) {
        ((ServiceResponse)this.revokeAclWithServiceResponseAsync(accountName, parameters).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> revokeAclAsync(String accountName, AclDeleteParameters parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.revokeAclWithServiceResponseAsync(accountName, parameters), serviceCallback);
    }

    @Override
    public Observable<Void> revokeAclAsync(String accountName, AclDeleteParameters parameters) {
        return this.revokeAclWithServiceResponseAsync(accountName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> revokeAclWithServiceResponseAsync(String accountName, AclDeleteParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String op = "REVOKEACE";
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.revokeAcl(parameters, "REVOKEACE", this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.revokeAclDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> revokeAclDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void revokeAclFromDatabase(String accountName, String databaseName, AclDeleteParameters parameters) {
        ((ServiceResponse)this.revokeAclFromDatabaseWithServiceResponseAsync(accountName, databaseName, parameters).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> revokeAclFromDatabaseAsync(String accountName, String databaseName, AclDeleteParameters parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.revokeAclFromDatabaseWithServiceResponseAsync(accountName, databaseName, parameters), serviceCallback);
    }

    @Override
    public Observable<Void> revokeAclFromDatabaseAsync(String accountName, String databaseName, AclDeleteParameters parameters) {
        return this.revokeAclFromDatabaseWithServiceResponseAsync(accountName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> revokeAclFromDatabaseWithServiceResponseAsync(String accountName, String databaseName, AclDeleteParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String op = "REVOKEACE";
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix()});
        return this.service.revokeAclFromDatabase(databaseName, parameters, "REVOKEACE", this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CatalogsImpl.this.revokeAclFromDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> revokeAclFromDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlCredential> listCredentialsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listCredentialsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlCredential>((Page)response.body()){

            public Page<USqlCredential> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listCredentialsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlCredential>> listCredentialsNextAsync(String nextPageLink, ServiceFuture<List<USqlCredential>> serviceFuture, ListOperationCallback<USqlCredential> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listCredentialsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlCredential>>>>(){

            public Observable<ServiceResponse<Page<USqlCredential>>> call(String nextPageLink) {
                return CatalogsImpl.this.listCredentialsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlCredential>> listCredentialsNextAsync(String nextPageLink) {
        return this.listCredentialsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlCredential>>, Page<USqlCredential>>(){

            public Page<USqlCredential> call(ServiceResponse<Page<USqlCredential>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlCredential>>> listCredentialsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listCredentialsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlCredential>>, Observable<ServiceResponse<Page<USqlCredential>>>>(){

            public Observable<ServiceResponse<Page<USqlCredential>>> call(ServiceResponse<Page<USqlCredential>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listCredentialsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlCredential>>> listCredentialsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listCredentialsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlCredential>>>>(){

            public Observable<ServiceResponse<Page<USqlCredential>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listCredentialsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlCredential>> listCredentialsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlCredential>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlExternalDataSource> listExternalDataSourcesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listExternalDataSourcesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlExternalDataSource>((Page)response.body()){

            public Page<USqlExternalDataSource> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listExternalDataSourcesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlExternalDataSource>> listExternalDataSourcesNextAsync(String nextPageLink, ServiceFuture<List<USqlExternalDataSource>> serviceFuture, ListOperationCallback<USqlExternalDataSource> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listExternalDataSourcesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlExternalDataSource>>>>(){

            public Observable<ServiceResponse<Page<USqlExternalDataSource>>> call(String nextPageLink) {
                return CatalogsImpl.this.listExternalDataSourcesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlExternalDataSource>> listExternalDataSourcesNextAsync(String nextPageLink) {
        return this.listExternalDataSourcesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlExternalDataSource>>, Page<USqlExternalDataSource>>(){

            public Page<USqlExternalDataSource> call(ServiceResponse<Page<USqlExternalDataSource>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlExternalDataSource>>> listExternalDataSourcesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listExternalDataSourcesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlExternalDataSource>>, Observable<ServiceResponse<Page<USqlExternalDataSource>>>>(){

            public Observable<ServiceResponse<Page<USqlExternalDataSource>>> call(ServiceResponse<Page<USqlExternalDataSource>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listExternalDataSourcesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlExternalDataSource>>> listExternalDataSourcesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listExternalDataSourcesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlExternalDataSource>>>>(){

            public Observable<ServiceResponse<Page<USqlExternalDataSource>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listExternalDataSourcesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlExternalDataSource>> listExternalDataSourcesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlExternalDataSource>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlProcedure> listProceduresNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listProceduresNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlProcedure>((Page)response.body()){

            public Page<USqlProcedure> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listProceduresNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlProcedure>> listProceduresNextAsync(String nextPageLink, ServiceFuture<List<USqlProcedure>> serviceFuture, ListOperationCallback<USqlProcedure> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listProceduresNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlProcedure>>>>(){

            public Observable<ServiceResponse<Page<USqlProcedure>>> call(String nextPageLink) {
                return CatalogsImpl.this.listProceduresNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlProcedure>> listProceduresNextAsync(String nextPageLink) {
        return this.listProceduresNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlProcedure>>, Page<USqlProcedure>>(){

            public Page<USqlProcedure> call(ServiceResponse<Page<USqlProcedure>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlProcedure>>> listProceduresNextWithServiceResponseAsync(String nextPageLink) {
        return this.listProceduresNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlProcedure>>, Observable<ServiceResponse<Page<USqlProcedure>>>>(){

            public Observable<ServiceResponse<Page<USqlProcedure>>> call(ServiceResponse<Page<USqlProcedure>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listProceduresNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlProcedure>>> listProceduresNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listProceduresNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlProcedure>>>>(){

            public Observable<ServiceResponse<Page<USqlProcedure>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listProceduresNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlProcedure>> listProceduresNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlProcedure>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTableFragment> listTableFragmentsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listTableFragmentsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTableFragment>((Page)response.body()){

            public Page<USqlTableFragment> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableFragmentsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableFragment>> listTableFragmentsNextAsync(String nextPageLink, ServiceFuture<List<USqlTableFragment>> serviceFuture, ListOperationCallback<USqlTableFragment> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableFragmentsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableFragment>>>>(){

            public Observable<ServiceResponse<Page<USqlTableFragment>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableFragmentsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableFragment>> listTableFragmentsNextAsync(String nextPageLink) {
        return this.listTableFragmentsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlTableFragment>>, Page<USqlTableFragment>>(){

            public Page<USqlTableFragment> call(ServiceResponse<Page<USqlTableFragment>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableFragment>>> listTableFragmentsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listTableFragmentsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableFragment>>, Observable<ServiceResponse<Page<USqlTableFragment>>>>(){

            public Observable<ServiceResponse<Page<USqlTableFragment>>> call(ServiceResponse<Page<USqlTableFragment>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableFragmentsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableFragment>>> listTableFragmentsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listTableFragmentsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableFragment>>>>(){

            public Observable<ServiceResponse<Page<USqlTableFragment>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableFragmentsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTableFragment>> listTableFragmentsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTableFragment>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTable> listTablesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listTablesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTable>((Page)response.body()){

            public Page<USqlTable> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTablesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTable>> listTablesNextAsync(String nextPageLink, ServiceFuture<List<USqlTable>> serviceFuture, ListOperationCallback<USqlTable> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTablesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTable>>>>(){

            public Observable<ServiceResponse<Page<USqlTable>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTablesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTable>> listTablesNextAsync(String nextPageLink) {
        return this.listTablesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlTable>>, Page<USqlTable>>(){

            public Page<USqlTable> call(ServiceResponse<Page<USqlTable>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTable>>> listTablesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listTablesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTable>>, Observable<ServiceResponse<Page<USqlTable>>>>(){

            public Observable<ServiceResponse<Page<USqlTable>>> call(ServiceResponse<Page<USqlTable>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTablesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTable>>> listTablesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listTablesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTable>>>>(){

            public Observable<ServiceResponse<Page<USqlTable>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTablesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTable>> listTablesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTable>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTableStatistics> listTableStatisticsByDatabaseAndSchemaNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTableStatistics>((Page)response.body()){

            public Page<USqlTableStatistics> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaNextAsync(String nextPageLink, ServiceFuture<List<USqlTableStatistics>> serviceFuture, ListOperationCallback<USqlTableStatistics> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaNextAsync(String nextPageLink) {
        return this.listTableStatisticsByDatabaseAndSchemaNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlTableStatistics>>, Page<USqlTableStatistics>>(){

            public Page<USqlTableStatistics> call(ServiceResponse<Page<USqlTableStatistics>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseAndSchemaNextWithServiceResponseAsync(String nextPageLink) {
        return this.listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableStatistics>>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(ServiceResponse<Page<USqlTableStatistics>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableStatisticsByDatabaseAndSchemaNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listTableStatisticsByDatabaseAndSchemaNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableStatisticsByDatabaseAndSchemaNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTableStatistics>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTableType> listTableTypesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listTableTypesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTableType>((Page)response.body()){

            public Page<USqlTableType> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableTypesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableType>> listTableTypesNextAsync(String nextPageLink, ServiceFuture<List<USqlTableType>> serviceFuture, ListOperationCallback<USqlTableType> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableTypesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableType>>>>(){

            public Observable<ServiceResponse<Page<USqlTableType>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableTypesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableType>> listTableTypesNextAsync(String nextPageLink) {
        return this.listTableTypesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlTableType>>, Page<USqlTableType>>(){

            public Page<USqlTableType> call(ServiceResponse<Page<USqlTableType>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableType>>> listTableTypesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listTableTypesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableType>>, Observable<ServiceResponse<Page<USqlTableType>>>>(){

            public Observable<ServiceResponse<Page<USqlTableType>>> call(ServiceResponse<Page<USqlTableType>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableTypesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableType>>> listTableTypesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listTableTypesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableType>>>>(){

            public Observable<ServiceResponse<Page<USqlTableType>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableTypesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTableType>> listTableTypesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTableType>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlPackage> listPackagesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listPackagesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlPackage>((Page)response.body()){

            public Page<USqlPackage> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listPackagesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlPackage>> listPackagesNextAsync(String nextPageLink, ServiceFuture<List<USqlPackage>> serviceFuture, ListOperationCallback<USqlPackage> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listPackagesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlPackage>>>>(){

            public Observable<ServiceResponse<Page<USqlPackage>>> call(String nextPageLink) {
                return CatalogsImpl.this.listPackagesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlPackage>> listPackagesNextAsync(String nextPageLink) {
        return this.listPackagesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlPackage>>, Page<USqlPackage>>(){

            public Page<USqlPackage> call(ServiceResponse<Page<USqlPackage>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlPackage>>> listPackagesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listPackagesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlPackage>>, Observable<ServiceResponse<Page<USqlPackage>>>>(){

            public Observable<ServiceResponse<Page<USqlPackage>>> call(ServiceResponse<Page<USqlPackage>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listPackagesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlPackage>>> listPackagesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listPackagesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlPackage>>>>(){

            public Observable<ServiceResponse<Page<USqlPackage>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listPackagesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlPackage>> listPackagesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlPackage>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlView> listViewsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listViewsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlView>((Page)response.body()){

            public Page<USqlView> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listViewsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlView>> listViewsNextAsync(String nextPageLink, ServiceFuture<List<USqlView>> serviceFuture, ListOperationCallback<USqlView> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listViewsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlView>>>>(){

            public Observable<ServiceResponse<Page<USqlView>>> call(String nextPageLink) {
                return CatalogsImpl.this.listViewsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlView>> listViewsNextAsync(String nextPageLink) {
        return this.listViewsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlView>>, Page<USqlView>>(){

            public Page<USqlView> call(ServiceResponse<Page<USqlView>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlView>>> listViewsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listViewsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlView>>, Observable<ServiceResponse<Page<USqlView>>>>(){

            public Observable<ServiceResponse<Page<USqlView>>> call(ServiceResponse<Page<USqlView>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listViewsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlView>>> listViewsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listViewsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlView>>>>(){

            public Observable<ServiceResponse<Page<USqlView>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listViewsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlView>> listViewsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlView>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTableStatistics> listTableStatisticsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listTableStatisticsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTableStatistics>((Page)response.body()){

            public Page<USqlTableStatistics> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableStatisticsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableStatistics>> listTableStatisticsNextAsync(String nextPageLink, ServiceFuture<List<USqlTableStatistics>> serviceFuture, ListOperationCallback<USqlTableStatistics> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableStatisticsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableStatisticsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableStatistics>> listTableStatisticsNextAsync(String nextPageLink) {
        return this.listTableStatisticsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlTableStatistics>>, Page<USqlTableStatistics>>(){

            public Page<USqlTableStatistics> call(ServiceResponse<Page<USqlTableStatistics>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listTableStatisticsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableStatistics>>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(ServiceResponse<Page<USqlTableStatistics>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableStatisticsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listTableStatisticsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableStatisticsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTableStatistics>> listTableStatisticsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTableStatistics>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTablePartition> listTablePartitionsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listTablePartitionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTablePartition>((Page)response.body()){

            public Page<USqlTablePartition> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTablePartitionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTablePartition>> listTablePartitionsNextAsync(String nextPageLink, ServiceFuture<List<USqlTablePartition>> serviceFuture, ListOperationCallback<USqlTablePartition> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTablePartitionsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTablePartition>>>>(){

            public Observable<ServiceResponse<Page<USqlTablePartition>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTablePartitionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTablePartition>> listTablePartitionsNextAsync(String nextPageLink) {
        return this.listTablePartitionsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlTablePartition>>, Page<USqlTablePartition>>(){

            public Page<USqlTablePartition> call(ServiceResponse<Page<USqlTablePartition>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTablePartition>>> listTablePartitionsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listTablePartitionsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTablePartition>>, Observable<ServiceResponse<Page<USqlTablePartition>>>>(){

            public Observable<ServiceResponse<Page<USqlTablePartition>>> call(ServiceResponse<Page<USqlTablePartition>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTablePartitionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTablePartition>>> listTablePartitionsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listTablePartitionsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTablePartition>>>>(){

            public Observable<ServiceResponse<Page<USqlTablePartition>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTablePartitionsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTablePartition>> listTablePartitionsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTablePartition>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlType> listTypesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listTypesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlType>((Page)response.body()){

            public Page<USqlType> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTypesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlType>> listTypesNextAsync(String nextPageLink, ServiceFuture<List<USqlType>> serviceFuture, ListOperationCallback<USqlType> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTypesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlType>>>>(){

            public Observable<ServiceResponse<Page<USqlType>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTypesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlType>> listTypesNextAsync(String nextPageLink) {
        return this.listTypesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlType>>, Page<USqlType>>(){

            public Page<USqlType> call(ServiceResponse<Page<USqlType>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlType>>> listTypesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listTypesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlType>>, Observable<ServiceResponse<Page<USqlType>>>>(){

            public Observable<ServiceResponse<Page<USqlType>>> call(ServiceResponse<Page<USqlType>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTypesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlType>>> listTypesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listTypesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlType>>>>(){

            public Observable<ServiceResponse<Page<USqlType>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTypesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlType>> listTypesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlType>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTableValuedFunction> listTableValuedFunctionsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listTableValuedFunctionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTableValuedFunction>((Page)response.body()){

            public Page<USqlTableValuedFunction> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableValuedFunctionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableValuedFunction>> listTableValuedFunctionsNextAsync(String nextPageLink, ServiceFuture<List<USqlTableValuedFunction>> serviceFuture, ListOperationCallback<USqlTableValuedFunction> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableValuedFunctionsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>(){

            public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableValuedFunctionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableValuedFunction>> listTableValuedFunctionsNextAsync(String nextPageLink) {
        return this.listTableValuedFunctionsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Page<USqlTableValuedFunction>>(){

            public Page<USqlTableValuedFunction> call(ServiceResponse<Page<USqlTableValuedFunction>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listTableValuedFunctionsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>(){

            public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(ServiceResponse<Page<USqlTableValuedFunction>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableValuedFunctionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listTableValuedFunctionsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>(){

            public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableValuedFunctionsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTableValuedFunction>> listTableValuedFunctionsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTableValuedFunction>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlAssemblyClr> listAssembliesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAssembliesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlAssemblyClr>((Page)response.body()){

            public Page<USqlAssemblyClr> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listAssembliesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlAssemblyClr>> listAssembliesNextAsync(String nextPageLink, ServiceFuture<List<USqlAssemblyClr>> serviceFuture, ListOperationCallback<USqlAssemblyClr> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAssembliesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlAssemblyClr>>>>(){

            public Observable<ServiceResponse<Page<USqlAssemblyClr>>> call(String nextPageLink) {
                return CatalogsImpl.this.listAssembliesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlAssemblyClr>> listAssembliesNextAsync(String nextPageLink) {
        return this.listAssembliesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlAssemblyClr>>, Page<USqlAssemblyClr>>(){

            public Page<USqlAssemblyClr> call(ServiceResponse<Page<USqlAssemblyClr>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlAssemblyClr>>> listAssembliesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAssembliesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlAssemblyClr>>, Observable<ServiceResponse<Page<USqlAssemblyClr>>>>(){

            public Observable<ServiceResponse<Page<USqlAssemblyClr>>> call(ServiceResponse<Page<USqlAssemblyClr>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listAssembliesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlAssemblyClr>>> listAssembliesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAssembliesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlAssemblyClr>>>>(){

            public Observable<ServiceResponse<Page<USqlAssemblyClr>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listAssembliesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlAssemblyClr>> listAssembliesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlAssemblyClr>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlSchema> listSchemasNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listSchemasNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlSchema>((Page)response.body()){

            public Page<USqlSchema> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listSchemasNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlSchema>> listSchemasNextAsync(String nextPageLink, ServiceFuture<List<USqlSchema>> serviceFuture, ListOperationCallback<USqlSchema> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSchemasNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlSchema>>>>(){

            public Observable<ServiceResponse<Page<USqlSchema>>> call(String nextPageLink) {
                return CatalogsImpl.this.listSchemasNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlSchema>> listSchemasNextAsync(String nextPageLink) {
        return this.listSchemasNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlSchema>>, Page<USqlSchema>>(){

            public Page<USqlSchema> call(ServiceResponse<Page<USqlSchema>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlSchema>>> listSchemasNextWithServiceResponseAsync(String nextPageLink) {
        return this.listSchemasNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlSchema>>, Observable<ServiceResponse<Page<USqlSchema>>>>(){

            public Observable<ServiceResponse<Page<USqlSchema>>> call(ServiceResponse<Page<USqlSchema>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listSchemasNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlSchema>>> listSchemasNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listSchemasNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlSchema>>>>(){

            public Observable<ServiceResponse<Page<USqlSchema>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listSchemasNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlSchema>> listSchemasNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlSchema>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTableStatistics> listTableStatisticsByDatabaseNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listTableStatisticsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTableStatistics>((Page)response.body()){

            public Page<USqlTableStatistics> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableStatisticsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableStatistics>> listTableStatisticsByDatabaseNextAsync(String nextPageLink, ServiceFuture<List<USqlTableStatistics>> serviceFuture, ListOperationCallback<USqlTableStatistics> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableStatisticsByDatabaseNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableStatisticsByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableStatistics>> listTableStatisticsByDatabaseNextAsync(String nextPageLink) {
        return this.listTableStatisticsByDatabaseNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlTableStatistics>>, Page<USqlTableStatistics>>(){

            public Page<USqlTableStatistics> call(ServiceResponse<Page<USqlTableStatistics>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseNextWithServiceResponseAsync(String nextPageLink) {
        return this.listTableStatisticsByDatabaseNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableStatistics>>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(ServiceResponse<Page<USqlTableStatistics>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableStatisticsByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listTableStatisticsByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>(){

            public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableStatisticsByDatabaseNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTableStatistics>> listTableStatisticsByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTableStatistics>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTable> listTablesByDatabaseNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listTablesByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTable>((Page)response.body()){

            public Page<USqlTable> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTablesByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTable>> listTablesByDatabaseNextAsync(String nextPageLink, ServiceFuture<List<USqlTable>> serviceFuture, ListOperationCallback<USqlTable> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTablesByDatabaseNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTable>>>>(){

            public Observable<ServiceResponse<Page<USqlTable>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTablesByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTable>> listTablesByDatabaseNextAsync(String nextPageLink) {
        return this.listTablesByDatabaseNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlTable>>, Page<USqlTable>>(){

            public Page<USqlTable> call(ServiceResponse<Page<USqlTable>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTable>>> listTablesByDatabaseNextWithServiceResponseAsync(String nextPageLink) {
        return this.listTablesByDatabaseNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTable>>, Observable<ServiceResponse<Page<USqlTable>>>>(){

            public Observable<ServiceResponse<Page<USqlTable>>> call(ServiceResponse<Page<USqlTable>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTablesByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTable>>> listTablesByDatabaseNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listTablesByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTable>>>>(){

            public Observable<ServiceResponse<Page<USqlTable>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTablesByDatabaseNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTable>> listTablesByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTable>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlTableValuedFunction> listTableValuedFunctionsByDatabaseNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listTableValuedFunctionsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTableValuedFunction>((Page)response.body()){

            public Page<USqlTableValuedFunction> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listTableValuedFunctionsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseNextAsync(String nextPageLink, ServiceFuture<List<USqlTableValuedFunction>> serviceFuture, ListOperationCallback<USqlTableValuedFunction> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listTableValuedFunctionsByDatabaseNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>(){

            public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(String nextPageLink) {
                return CatalogsImpl.this.listTableValuedFunctionsByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseNextAsync(String nextPageLink) {
        return this.listTableValuedFunctionsByDatabaseNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Page<USqlTableValuedFunction>>(){

            public Page<USqlTableValuedFunction> call(ServiceResponse<Page<USqlTableValuedFunction>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsByDatabaseNextWithServiceResponseAsync(String nextPageLink) {
        return this.listTableValuedFunctionsByDatabaseNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>(){

            public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(ServiceResponse<Page<USqlTableValuedFunction>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listTableValuedFunctionsByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsByDatabaseNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listTableValuedFunctionsByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>(){

            public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listTableValuedFunctionsByDatabaseNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlTableValuedFunction>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlView> listViewsByDatabaseNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listViewsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlView>((Page)response.body()){

            public Page<USqlView> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listViewsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlView>> listViewsByDatabaseNextAsync(String nextPageLink, ServiceFuture<List<USqlView>> serviceFuture, ListOperationCallback<USqlView> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listViewsByDatabaseNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlView>>>>(){

            public Observable<ServiceResponse<Page<USqlView>>> call(String nextPageLink) {
                return CatalogsImpl.this.listViewsByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlView>> listViewsByDatabaseNextAsync(String nextPageLink) {
        return this.listViewsByDatabaseNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlView>>, Page<USqlView>>(){

            public Page<USqlView> call(ServiceResponse<Page<USqlView>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlView>>> listViewsByDatabaseNextWithServiceResponseAsync(String nextPageLink) {
        return this.listViewsByDatabaseNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlView>>, Observable<ServiceResponse<Page<USqlView>>>>(){

            public Observable<ServiceResponse<Page<USqlView>>> call(ServiceResponse<Page<USqlView>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listViewsByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlView>>> listViewsByDatabaseNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listViewsByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlView>>>>(){

            public Observable<ServiceResponse<Page<USqlView>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listViewsByDatabaseNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlView>> listViewsByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlView>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<Acl> listAclsByDatabaseNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAclsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<Acl>((Page)response.body()){

            public Page<Acl> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listAclsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<Acl>> listAclsByDatabaseNextAsync(String nextPageLink, ServiceFuture<List<Acl>> serviceFuture, ListOperationCallback<Acl> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAclsByDatabaseNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<Acl>>>>(){

            public Observable<ServiceResponse<Page<Acl>>> call(String nextPageLink) {
                return CatalogsImpl.this.listAclsByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<Acl>> listAclsByDatabaseNextAsync(String nextPageLink) {
        return this.listAclsByDatabaseNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<Acl>>, Page<Acl>>(){

            public Page<Acl> call(ServiceResponse<Page<Acl>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<Acl>>> listAclsByDatabaseNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAclsByDatabaseNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<Acl>>, Observable<ServiceResponse<Page<Acl>>>>(){

            public Observable<ServiceResponse<Page<Acl>>> call(ServiceResponse<Page<Acl>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listAclsByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<Acl>>> listAclsByDatabaseNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAclsByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Acl>>>>(){

            public Observable<ServiceResponse<Page<Acl>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listAclsByDatabaseNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<Acl>> listAclsByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<Acl>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<Acl> listAclsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAclsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<Acl>((Page)response.body()){

            public Page<Acl> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listAclsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<Acl>> listAclsNextAsync(String nextPageLink, ServiceFuture<List<Acl>> serviceFuture, ListOperationCallback<Acl> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAclsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<Acl>>>>(){

            public Observable<ServiceResponse<Page<Acl>>> call(String nextPageLink) {
                return CatalogsImpl.this.listAclsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<Acl>> listAclsNextAsync(String nextPageLink) {
        return this.listAclsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<Acl>>, Page<Acl>>(){

            public Page<Acl> call(ServiceResponse<Page<Acl>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<Acl>>> listAclsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAclsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<Acl>>, Observable<ServiceResponse<Page<Acl>>>>(){

            public Observable<ServiceResponse<Page<Acl>>> call(ServiceResponse<Page<Acl>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listAclsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<Acl>>> listAclsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAclsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Acl>>>>(){

            public Observable<ServiceResponse<Page<Acl>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listAclsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<Acl>> listAclsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<Acl>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<USqlDatabase> listDatabasesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listDatabasesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlDatabase>((Page)response.body()){

            public Page<USqlDatabase> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CatalogsImpl.this.listDatabasesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<USqlDatabase>> listDatabasesNextAsync(String nextPageLink, ServiceFuture<List<USqlDatabase>> serviceFuture, ListOperationCallback<USqlDatabase> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listDatabasesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<USqlDatabase>>>>(){

            public Observable<ServiceResponse<Page<USqlDatabase>>> call(String nextPageLink) {
                return CatalogsImpl.this.listDatabasesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<USqlDatabase>> listDatabasesNextAsync(String nextPageLink) {
        return this.listDatabasesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<USqlDatabase>>, Page<USqlDatabase>>(){

            public Page<USqlDatabase> call(ServiceResponse<Page<USqlDatabase>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<USqlDatabase>>> listDatabasesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listDatabasesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<USqlDatabase>>, Observable<ServiceResponse<Page<USqlDatabase>>>>(){

            public Observable<ServiceResponse<Page<USqlDatabase>>> call(ServiceResponse<Page<USqlDatabase>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CatalogsImpl.this.listDatabasesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<USqlDatabase>>> listDatabasesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listDatabasesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlDatabase>>>>(){

            public Observable<ServiceResponse<Page<USqlDatabase>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CatalogsImpl.this.listDatabasesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<USqlDatabase>> listDatabasesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<USqlDatabase>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface CatalogsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs createSecret"})
        @PUT(value="catalog/usql/databases/{databaseName}/secrets/{secretName}")
        public Observable<Response<ResponseBody>> createSecret(@Path(value="databaseName") String var1, @Path(value="secretName") String var2, @Body DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getSecret"})
        @GET(value="catalog/usql/databases/{databaseName}/secrets/{secretName}")
        public Observable<Response<ResponseBody>> getSecret(@Path(value="databaseName") String var1, @Path(value="secretName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs updateSecret"})
        @PATCH(value="catalog/usql/databases/{databaseName}/secrets/{secretName}")
        public Observable<Response<ResponseBody>> updateSecret(@Path(value="databaseName") String var1, @Path(value="secretName") String var2, @Body DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs deleteSecret"})
        @HTTP(path="catalog/usql/databases/{databaseName}/secrets/{secretName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteSecret(@Path(value="databaseName") String var1, @Path(value="secretName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs deleteAllSecrets"})
        @HTTP(path="catalog/usql/databases/{databaseName}/secrets", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteAllSecrets(@Path(value="databaseName") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs createCredential"})
        @PUT(value="catalog/usql/databases/{databaseName}/credentials/{credentialName}")
        public Observable<Response<ResponseBody>> createCredential(@Path(value="databaseName") String var1, @Path(value="credentialName") String var2, @Body DataLakeAnalyticsCatalogCredentialCreateParameters var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getCredential"})
        @GET(value="catalog/usql/databases/{databaseName}/credentials/{credentialName}")
        public Observable<Response<ResponseBody>> getCredential(@Path(value="databaseName") String var1, @Path(value="credentialName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs updateCredential"})
        @PATCH(value="catalog/usql/databases/{databaseName}/credentials/{credentialName}")
        public Observable<Response<ResponseBody>> updateCredential(@Path(value="databaseName") String var1, @Path(value="credentialName") String var2, @Body DataLakeAnalyticsCatalogCredentialUpdateParameters var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs deleteCredential"})
        @POST(value="catalog/usql/databases/{databaseName}/credentials/{credentialName}")
        public Observable<Response<ResponseBody>> deleteCredential(@Path(value="databaseName") String var1, @Path(value="credentialName") String var2, @Query(value="cascade") Boolean var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body DataLakeAnalyticsCatalogCredentialDeleteParameters var6, @Header(value="x-ms-parameterized-host") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listCredentials"})
        @GET(value="catalog/usql/databases/{databaseName}/credentials")
        public Observable<Response<ResponseBody>> listCredentials(@Path(value="databaseName") String var1, @Query(value="$filter") String var2, @Query(value="$top") Integer var3, @Query(value="$skip") Integer var4, @Query(value="$select") String var5, @Query(value="$orderby") String var6, @Query(value="$count") Boolean var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="x-ms-parameterized-host") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getExternalDataSource"})
        @GET(value="catalog/usql/databases/{databaseName}/externaldatasources/{externalDataSourceName}")
        public Observable<Response<ResponseBody>> getExternalDataSource(@Path(value="databaseName") String var1, @Path(value="externalDataSourceName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listExternalDataSources"})
        @GET(value="catalog/usql/databases/{databaseName}/externaldatasources")
        public Observable<Response<ResponseBody>> listExternalDataSources(@Path(value="databaseName") String var1, @Query(value="$filter") String var2, @Query(value="$top") Integer var3, @Query(value="$skip") Integer var4, @Query(value="$select") String var5, @Query(value="$orderby") String var6, @Query(value="$count") Boolean var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="x-ms-parameterized-host") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getProcedure"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/procedures/{procedureName}")
        public Observable<Response<ResponseBody>> getProcedure(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Path(value="procedureName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listProcedures"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/procedures")
        public Observable<Response<ResponseBody>> listProcedures(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Query(value="$filter") String var3, @Query(value="$top") Integer var4, @Query(value="$skip") Integer var5, @Query(value="$select") String var6, @Query(value="$orderby") String var7, @Query(value="$count") Boolean var8, @Query(value="api-version") String var9, @Header(value="accept-language") String var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getTable"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}")
        public Observable<Response<ResponseBody>> getTable(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Path(value="tableName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableFragments"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/tablefragments")
        public Observable<Response<ResponseBody>> listTableFragments(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Path(value="tableName") String var3, @Query(value="$filter") String var4, @Query(value="$top") Integer var5, @Query(value="$skip") Integer var6, @Query(value="$select") String var7, @Query(value="$orderby") String var8, @Query(value="$count") Boolean var9, @Query(value="api-version") String var10, @Header(value="accept-language") String var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTables"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables")
        public Observable<Response<ResponseBody>> listTables(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Query(value="$filter") String var3, @Query(value="$top") Integer var4, @Query(value="$skip") Integer var5, @Query(value="$select") String var6, @Query(value="$orderby") String var7, @Query(value="$count") Boolean var8, @Query(value="basic") Boolean var9, @Query(value="api-version") String var10, @Header(value="accept-language") String var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableStatisticsByDatabaseAndSchema"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/statistics")
        public Observable<Response<ResponseBody>> listTableStatisticsByDatabaseAndSchema(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Query(value="$filter") String var3, @Query(value="$top") Integer var4, @Query(value="$skip") Integer var5, @Query(value="$select") String var6, @Query(value="$orderby") String var7, @Query(value="$count") Boolean var8, @Query(value="api-version") String var9, @Header(value="accept-language") String var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getTableType"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/tabletypes/{tableTypeName}")
        public Observable<Response<ResponseBody>> getTableType(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Path(value="tableTypeName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableTypes"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/tabletypes")
        public Observable<Response<ResponseBody>> listTableTypes(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Query(value="$filter") String var3, @Query(value="$top") Integer var4, @Query(value="$skip") Integer var5, @Query(value="$select") String var6, @Query(value="$orderby") String var7, @Query(value="$count") Boolean var8, @Query(value="api-version") String var9, @Header(value="accept-language") String var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getPackage"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/packages/{packageName}")
        public Observable<Response<ResponseBody>> getPackage(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Path(value="packageName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listPackages"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/packages")
        public Observable<Response<ResponseBody>> listPackages(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Query(value="$filter") String var3, @Query(value="$top") Integer var4, @Query(value="$skip") Integer var5, @Query(value="$select") String var6, @Query(value="$orderby") String var7, @Query(value="$count") Boolean var8, @Query(value="api-version") String var9, @Header(value="accept-language") String var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getView"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/views/{viewName}")
        public Observable<Response<ResponseBody>> getView(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Path(value="viewName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listViews"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/views")
        public Observable<Response<ResponseBody>> listViews(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Query(value="$filter") String var3, @Query(value="$top") Integer var4, @Query(value="$skip") Integer var5, @Query(value="$select") String var6, @Query(value="$orderby") String var7, @Query(value="$count") Boolean var8, @Query(value="api-version") String var9, @Header(value="accept-language") String var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getTableStatistic"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/statistics/{statisticsName}")
        public Observable<Response<ResponseBody>> getTableStatistic(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Path(value="tableName") String var3, @Path(value="statisticsName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="x-ms-parameterized-host") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableStatistics"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/statistics")
        public Observable<Response<ResponseBody>> listTableStatistics(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Path(value="tableName") String var3, @Query(value="$filter") String var4, @Query(value="$top") Integer var5, @Query(value="$skip") Integer var6, @Query(value="$select") String var7, @Query(value="$orderby") String var8, @Query(value="$count") Boolean var9, @Query(value="api-version") String var10, @Header(value="accept-language") String var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs previewTablePartition"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/partitions/{partitionName}/previewrows")
        public Observable<Response<ResponseBody>> previewTablePartition(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Path(value="tableName") String var3, @Path(value="partitionName") String var4, @Query(value="maxRows") Long var5, @Query(value="maxColumns") Long var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="x-ms-parameterized-host") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getTablePartition"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/partitions/{partitionName}")
        public Observable<Response<ResponseBody>> getTablePartition(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Path(value="tableName") String var3, @Path(value="partitionName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="x-ms-parameterized-host") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs previewTable"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/previewrows")
        public Observable<Response<ResponseBody>> previewTable(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Path(value="tableName") String var3, @Query(value="maxRows") Long var4, @Query(value="maxColumns") Long var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="x-ms-parameterized-host") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTablePartitions"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/partitions")
        public Observable<Response<ResponseBody>> listTablePartitions(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Path(value="tableName") String var3, @Query(value="$filter") String var4, @Query(value="$top") Integer var5, @Query(value="$skip") Integer var6, @Query(value="$select") String var7, @Query(value="$orderby") String var8, @Query(value="$count") Boolean var9, @Query(value="api-version") String var10, @Header(value="accept-language") String var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTypes"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/types")
        public Observable<Response<ResponseBody>> listTypes(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Query(value="$filter") String var3, @Query(value="$top") Integer var4, @Query(value="$skip") Integer var5, @Query(value="$select") String var6, @Query(value="$orderby") String var7, @Query(value="$count") Boolean var8, @Query(value="api-version") String var9, @Header(value="accept-language") String var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getTableValuedFunction"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/tablevaluedfunctions/{tableValuedFunctionName}")
        public Observable<Response<ResponseBody>> getTableValuedFunction(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Path(value="tableValuedFunctionName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableValuedFunctions"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}/tablevaluedfunctions")
        public Observable<Response<ResponseBody>> listTableValuedFunctions(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Query(value="$filter") String var3, @Query(value="$top") Integer var4, @Query(value="$skip") Integer var5, @Query(value="$select") String var6, @Query(value="$orderby") String var7, @Query(value="$count") Boolean var8, @Query(value="api-version") String var9, @Header(value="accept-language") String var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getAssembly"})
        @GET(value="catalog/usql/databases/{databaseName}/assemblies/{assemblyName}")
        public Observable<Response<ResponseBody>> getAssembly(@Path(value="databaseName") String var1, @Path(value="assemblyName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listAssemblies"})
        @GET(value="catalog/usql/databases/{databaseName}/assemblies")
        public Observable<Response<ResponseBody>> listAssemblies(@Path(value="databaseName") String var1, @Query(value="$filter") String var2, @Query(value="$top") Integer var3, @Query(value="$skip") Integer var4, @Query(value="$select") String var5, @Query(value="$orderby") String var6, @Query(value="$count") Boolean var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="x-ms-parameterized-host") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getSchema"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas/{schemaName}")
        public Observable<Response<ResponseBody>> getSchema(@Path(value="databaseName") String var1, @Path(value="schemaName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listSchemas"})
        @GET(value="catalog/usql/databases/{databaseName}/schemas")
        public Observable<Response<ResponseBody>> listSchemas(@Path(value="databaseName") String var1, @Query(value="$filter") String var2, @Query(value="$top") Integer var3, @Query(value="$skip") Integer var4, @Query(value="$select") String var5, @Query(value="$orderby") String var6, @Query(value="$count") Boolean var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="x-ms-parameterized-host") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableStatisticsByDatabase"})
        @GET(value="catalog/usql/databases/{databaseName}/statistics")
        public Observable<Response<ResponseBody>> listTableStatisticsByDatabase(@Path(value="databaseName") String var1, @Query(value="$filter") String var2, @Query(value="$top") Integer var3, @Query(value="$skip") Integer var4, @Query(value="$select") String var5, @Query(value="$orderby") String var6, @Query(value="$count") Boolean var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="x-ms-parameterized-host") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTablesByDatabase"})
        @GET(value="catalog/usql/databases/{databaseName}/tables")
        public Observable<Response<ResponseBody>> listTablesByDatabase(@Path(value="databaseName") String var1, @Query(value="$filter") String var2, @Query(value="$top") Integer var3, @Query(value="$skip") Integer var4, @Query(value="$select") String var5, @Query(value="$orderby") String var6, @Query(value="$count") Boolean var7, @Query(value="basic") Boolean var8, @Query(value="api-version") String var9, @Header(value="accept-language") String var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableValuedFunctionsByDatabase"})
        @GET(value="catalog/usql/databases/{databaseName}/tablevaluedfunctions")
        public Observable<Response<ResponseBody>> listTableValuedFunctionsByDatabase(@Path(value="databaseName") String var1, @Query(value="$filter") String var2, @Query(value="$top") Integer var3, @Query(value="$skip") Integer var4, @Query(value="$select") String var5, @Query(value="$orderby") String var6, @Query(value="$count") Boolean var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="x-ms-parameterized-host") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listViewsByDatabase"})
        @GET(value="catalog/usql/databases/{databaseName}/views")
        public Observable<Response<ResponseBody>> listViewsByDatabase(@Path(value="databaseName") String var1, @Query(value="$filter") String var2, @Query(value="$top") Integer var3, @Query(value="$skip") Integer var4, @Query(value="$select") String var5, @Query(value="$orderby") String var6, @Query(value="$count") Boolean var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="x-ms-parameterized-host") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listAclsByDatabase"})
        @GET(value="catalog/usql/databases/{databaseName}/acl")
        public Observable<Response<ResponseBody>> listAclsByDatabase(@Path(value="databaseName") String var1, @Query(value="$filter") String var2, @Query(value="$top") Integer var3, @Query(value="$skip") Integer var4, @Query(value="$select") String var5, @Query(value="$orderby") String var6, @Query(value="$count") Boolean var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="x-ms-parameterized-host") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listAcls"})
        @GET(value="catalog/usql/acl")
        public Observable<Response<ResponseBody>> listAcls(@Query(value="$filter") String var1, @Query(value="$top") Integer var2, @Query(value="$skip") Integer var3, @Query(value="$select") String var4, @Query(value="$orderby") String var5, @Query(value="$count") Boolean var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="x-ms-parameterized-host") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getDatabase"})
        @GET(value="catalog/usql/databases/{databaseName}")
        public Observable<Response<ResponseBody>> getDatabase(@Path(value="databaseName") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listDatabases"})
        @GET(value="catalog/usql/databases")
        public Observable<Response<ResponseBody>> listDatabases(@Query(value="$filter") String var1, @Query(value="$top") Integer var2, @Query(value="$skip") Integer var3, @Query(value="$select") String var4, @Query(value="$orderby") String var5, @Query(value="$count") Boolean var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="x-ms-parameterized-host") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs grantAcl"})
        @POST(value="catalog/usql/acl")
        public Observable<Response<ResponseBody>> grantAcl(@Body AclCreateOrUpdateParameters var1, @Query(value="op") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs grantAclToDatabase"})
        @POST(value="catalog/usql/databases/{databaseName}/acl")
        public Observable<Response<ResponseBody>> grantAclToDatabase(@Path(value="databaseName") String var1, @Body AclCreateOrUpdateParameters var2, @Query(value="op") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs revokeAcl"})
        @POST(value="catalog/usql/acl")
        public Observable<Response<ResponseBody>> revokeAcl(@Body AclDeleteParameters var1, @Query(value="op") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs revokeAclFromDatabase"})
        @POST(value="catalog/usql/databases/{databaseName}/acl")
        public Observable<Response<ResponseBody>> revokeAclFromDatabase(@Path(value="databaseName") String var1, @Body AclDeleteParameters var2, @Query(value="op") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listCredentialsNext"})
        @GET
        public Observable<Response<ResponseBody>> listCredentialsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listExternalDataSourcesNext"})
        @GET
        public Observable<Response<ResponseBody>> listExternalDataSourcesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listProceduresNext"})
        @GET
        public Observable<Response<ResponseBody>> listProceduresNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableFragmentsNext"})
        @GET
        public Observable<Response<ResponseBody>> listTableFragmentsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTablesNext"})
        @GET
        public Observable<Response<ResponseBody>> listTablesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableStatisticsByDatabaseAndSchemaNext"})
        @GET
        public Observable<Response<ResponseBody>> listTableStatisticsByDatabaseAndSchemaNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableTypesNext"})
        @GET
        public Observable<Response<ResponseBody>> listTableTypesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listPackagesNext"})
        @GET
        public Observable<Response<ResponseBody>> listPackagesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listViewsNext"})
        @GET
        public Observable<Response<ResponseBody>> listViewsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableStatisticsNext"})
        @GET
        public Observable<Response<ResponseBody>> listTableStatisticsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTablePartitionsNext"})
        @GET
        public Observable<Response<ResponseBody>> listTablePartitionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTypesNext"})
        @GET
        public Observable<Response<ResponseBody>> listTypesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableValuedFunctionsNext"})
        @GET
        public Observable<Response<ResponseBody>> listTableValuedFunctionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listAssembliesNext"})
        @GET
        public Observable<Response<ResponseBody>> listAssembliesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listSchemasNext"})
        @GET
        public Observable<Response<ResponseBody>> listSchemasNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableStatisticsByDatabaseNext"})
        @GET
        public Observable<Response<ResponseBody>> listTableStatisticsByDatabaseNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTablesByDatabaseNext"})
        @GET
        public Observable<Response<ResponseBody>> listTablesByDatabaseNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableValuedFunctionsByDatabaseNext"})
        @GET
        public Observable<Response<ResponseBody>> listTableValuedFunctionsByDatabaseNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listViewsByDatabaseNext"})
        @GET
        public Observable<Response<ResponseBody>> listViewsByDatabaseNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listAclsByDatabaseNext"})
        @GET
        public Observable<Response<ResponseBody>> listAclsByDatabaseNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listAclsNext"})
        @GET
        public Observable<Response<ResponseBody>> listAclsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listDatabasesNext"})
        @GET
        public Observable<Response<ResponseBody>> listDatabasesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

