/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.analytics.models;

import org.joda.time.DateTime;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A Data Lake Analytics catalog U-SQL table statistics item.
 */
public class USqlTableStatistics extends CatalogItem {
    /**
     * the name of the database.
     */
    @JsonProperty(value = "databaseName")
    private String databaseName;

    /**
     * the name of the schema associated with this table and database.
     */
    @JsonProperty(value = "schemaName")
    private String schemaName;

    /**
     * the name of the table.
     */
    @JsonProperty(value = "tableName")
    private String tableName;

    /**
     * the name of the table statistics.
     */
    @JsonProperty(value = "statisticsName")
    private String name;

    /**
     * the name of the user statistics.
     */
    @JsonProperty(value = "userStatName")
    private String userStatName;

    /**
     * the path to the statistics data.
     */
    @JsonProperty(value = "statDataPath")
    private String statDataPath;

    /**
     * the creation time of the statistics.
     */
    @JsonProperty(value = "createTime")
    private DateTime createTime;

    /**
     * the last time the statistics were updated.
     */
    @JsonProperty(value = "updateTime")
    private DateTime updateTime;

    /**
     * the switch indicating if these statistics are user created.
     */
    @JsonProperty(value = "isUserCreated")
    private Boolean isUserCreated;

    /**
     * the switch indicating if these statistics are automatically created.
     */
    @JsonProperty(value = "isAutoCreated")
    private Boolean isAutoCreated;

    /**
     * the switch indicating if these statistics have a filter.
     */
    @JsonProperty(value = "hasFilter")
    private Boolean hasFilter;

    /**
     * the filter definition for the statistics.
     */
    @JsonProperty(value = "filterDefinition")
    private String filterDefinition;

    /**
     * the list of column names associated with these statistics.
     */
    @JsonProperty(value = "colNames")
    private List<String> colNames;

    /**
     * Get the name of the database.
     *
     * @return the databaseName value
     */
    public String databaseName() {
        return this.databaseName;
    }

    /**
     * Set the name of the database.
     *
     * @param databaseName the databaseName value to set
     * @return the USqlTableStatistics object itself.
     */
    public USqlTableStatistics withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    /**
     * Get the name of the schema associated with this table and database.
     *
     * @return the schemaName value
     */
    public String schemaName() {
        return this.schemaName;
    }

    /**
     * Set the name of the schema associated with this table and database.
     *
     * @param schemaName the schemaName value to set
     * @return the USqlTableStatistics object itself.
     */
    public USqlTableStatistics withSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    /**
     * Get the name of the table.
     *
     * @return the tableName value
     */
    public String tableName() {
        return this.tableName;
    }

    /**
     * Set the name of the table.
     *
     * @param tableName the tableName value to set
     * @return the USqlTableStatistics object itself.
     */
    public USqlTableStatistics withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    /**
     * Get the name of the table statistics.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name of the table statistics.
     *
     * @param name the name value to set
     * @return the USqlTableStatistics object itself.
     */
    public USqlTableStatistics withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the name of the user statistics.
     *
     * @return the userStatName value
     */
    public String userStatName() {
        return this.userStatName;
    }

    /**
     * Set the name of the user statistics.
     *
     * @param userStatName the userStatName value to set
     * @return the USqlTableStatistics object itself.
     */
    public USqlTableStatistics withUserStatName(String userStatName) {
        this.userStatName = userStatName;
        return this;
    }

    /**
     * Get the path to the statistics data.
     *
     * @return the statDataPath value
     */
    public String statDataPath() {
        return this.statDataPath;
    }

    /**
     * Set the path to the statistics data.
     *
     * @param statDataPath the statDataPath value to set
     * @return the USqlTableStatistics object itself.
     */
    public USqlTableStatistics withStatDataPath(String statDataPath) {
        this.statDataPath = statDataPath;
        return this;
    }

    /**
     * Get the creation time of the statistics.
     *
     * @return the createTime value
     */
    public DateTime createTime() {
        return this.createTime;
    }

    /**
     * Set the creation time of the statistics.
     *
     * @param createTime the createTime value to set
     * @return the USqlTableStatistics object itself.
     */
    public USqlTableStatistics withCreateTime(DateTime createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
     * Get the last time the statistics were updated.
     *
     * @return the updateTime value
     */
    public DateTime updateTime() {
        return this.updateTime;
    }

    /**
     * Set the last time the statistics were updated.
     *
     * @param updateTime the updateTime value to set
     * @return the USqlTableStatistics object itself.
     */
    public USqlTableStatistics withUpdateTime(DateTime updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    /**
     * Get the switch indicating if these statistics are user created.
     *
     * @return the isUserCreated value
     */
    public Boolean isUserCreated() {
        return this.isUserCreated;
    }

    /**
     * Set the switch indicating if these statistics are user created.
     *
     * @param isUserCreated the isUserCreated value to set
     * @return the USqlTableStatistics object itself.
     */
    public USqlTableStatistics withIsUserCreated(Boolean isUserCreated) {
        this.isUserCreated = isUserCreated;
        return this;
    }

    /**
     * Get the switch indicating if these statistics are automatically created.
     *
     * @return the isAutoCreated value
     */
    public Boolean isAutoCreated() {
        return this.isAutoCreated;
    }

    /**
     * Set the switch indicating if these statistics are automatically created.
     *
     * @param isAutoCreated the isAutoCreated value to set
     * @return the USqlTableStatistics object itself.
     */
    public USqlTableStatistics withIsAutoCreated(Boolean isAutoCreated) {
        this.isAutoCreated = isAutoCreated;
        return this;
    }

    /**
     * Get the switch indicating if these statistics have a filter.
     *
     * @return the hasFilter value
     */
    public Boolean hasFilter() {
        return this.hasFilter;
    }

    /**
     * Set the switch indicating if these statistics have a filter.
     *
     * @param hasFilter the hasFilter value to set
     * @return the USqlTableStatistics object itself.
     */
    public USqlTableStatistics withHasFilter(Boolean hasFilter) {
        this.hasFilter = hasFilter;
        return this;
    }

    /**
     * Get the filter definition for the statistics.
     *
     * @return the filterDefinition value
     */
    public String filterDefinition() {
        return this.filterDefinition;
    }

    /**
     * Set the filter definition for the statistics.
     *
     * @param filterDefinition the filterDefinition value to set
     * @return the USqlTableStatistics object itself.
     */
    public USqlTableStatistics withFilterDefinition(String filterDefinition) {
        this.filterDefinition = filterDefinition;
        return this;
    }

    /**
     * Get the list of column names associated with these statistics.
     *
     * @return the colNames value
     */
    public List<String> colNames() {
        return this.colNames;
    }

    /**
     * Set the list of column names associated with these statistics.
     *
     * @param colNames the colNames value to set
     * @return the USqlTableStatistics object itself.
     */
    public USqlTableStatistics withColNames(List<String> colNames) {
        this.colNames = colNames;
        return this;
    }

}
