/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.analytics.models;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A Data Lake Analytics catalog table or partition preview rows item.
 */
public class USqlTablePreview {
    /**
     * the total number of rows in the table or partition.
     */
    @JsonProperty(value = "totalRowCount")
    private Long totalRowCount;

    /**
     * the total number of columns in the table or partition.
     */
    @JsonProperty(value = "totalColumnCount")
    private Long totalColumnCount;

    /**
     * the rows of the table or partition preview, where each row is an array
     * of string representations the row's values. Note: Byte arrays will
     * appear as base-64 encoded values, SqlMap and SqlArray objects will
     * appear as escaped JSON objects, and DateTime objects will appear as ISO
     * formatted UTC date-times.
     */
    @JsonProperty(value = "rows")
    private List<List<String>> rows;

    /**
     * true if the amount of data in the response is less than expected due to
     * the preview operation's size limitations. This can occur if the
     * requested rows or row counts are too large.
     */
    @JsonProperty(value = "truncated")
    private Boolean truncated;

    /**
     * the schema of the table or partition.
     */
    @JsonProperty(value = "schema")
    private List<USqlTableColumn> schema;

    /**
     * Get the total number of rows in the table or partition.
     *
     * @return the totalRowCount value
     */
    public Long totalRowCount() {
        return this.totalRowCount;
    }

    /**
     * Set the total number of rows in the table or partition.
     *
     * @param totalRowCount the totalRowCount value to set
     * @return the USqlTablePreview object itself.
     */
    public USqlTablePreview withTotalRowCount(Long totalRowCount) {
        this.totalRowCount = totalRowCount;
        return this;
    }

    /**
     * Get the total number of columns in the table or partition.
     *
     * @return the totalColumnCount value
     */
    public Long totalColumnCount() {
        return this.totalColumnCount;
    }

    /**
     * Set the total number of columns in the table or partition.
     *
     * @param totalColumnCount the totalColumnCount value to set
     * @return the USqlTablePreview object itself.
     */
    public USqlTablePreview withTotalColumnCount(Long totalColumnCount) {
        this.totalColumnCount = totalColumnCount;
        return this;
    }

    /**
     * Get the rows of the table or partition preview, where each row is an array of string representations the row's values. Note: Byte arrays will appear as base-64 encoded values, SqlMap and SqlArray objects will appear as escaped JSON objects, and DateTime objects will appear as ISO formatted UTC date-times.
     *
     * @return the rows value
     */
    public List<List<String>> rows() {
        return this.rows;
    }

    /**
     * Set the rows of the table or partition preview, where each row is an array of string representations the row's values. Note: Byte arrays will appear as base-64 encoded values, SqlMap and SqlArray objects will appear as escaped JSON objects, and DateTime objects will appear as ISO formatted UTC date-times.
     *
     * @param rows the rows value to set
     * @return the USqlTablePreview object itself.
     */
    public USqlTablePreview withRows(List<List<String>> rows) {
        this.rows = rows;
        return this;
    }

    /**
     * Get true if the amount of data in the response is less than expected due to the preview operation's size limitations. This can occur if the requested rows or row counts are too large.
     *
     * @return the truncated value
     */
    public Boolean truncated() {
        return this.truncated;
    }

    /**
     * Set true if the amount of data in the response is less than expected due to the preview operation's size limitations. This can occur if the requested rows or row counts are too large.
     *
     * @param truncated the truncated value to set
     * @return the USqlTablePreview object itself.
     */
    public USqlTablePreview withTruncated(Boolean truncated) {
        this.truncated = truncated;
        return this;
    }

    /**
     * Get the schema of the table or partition.
     *
     * @return the schema value
     */
    public List<USqlTableColumn> schema() {
        return this.schema;
    }

    /**
     * Set the schema of the table or partition.
     *
     * @param schema the schema value to set
     * @return the USqlTablePreview object itself.
     */
    public USqlTablePreview withSchema(List<USqlTableColumn> schema) {
        this.schema = schema;
        return this;
    }

}
