/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.analytics.models;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A Data Lake Analytics catalog U-SQL procedure item.
 */
public class USqlProcedure extends CatalogItem {
    /**
     * the name of the database.
     */
    @JsonProperty(value = "databaseName")
    private String databaseName;

    /**
     * the name of the schema associated with this procedure and database.
     */
    @JsonProperty(value = "schemaName")
    private String schemaName;

    /**
     * the name of the procedure.
     */
    @JsonProperty(value = "procName")
    private String name;

    /**
     * the defined query of the procedure.
     */
    @JsonProperty(value = "definition")
    private String definition;

    /**
     * Get the name of the database.
     *
     * @return the databaseName value
     */
    public String databaseName() {
        return this.databaseName;
    }

    /**
     * Set the name of the database.
     *
     * @param databaseName the databaseName value to set
     * @return the USqlProcedure object itself.
     */
    public USqlProcedure withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    /**
     * Get the name of the schema associated with this procedure and database.
     *
     * @return the schemaName value
     */
    public String schemaName() {
        return this.schemaName;
    }

    /**
     * Set the name of the schema associated with this procedure and database.
     *
     * @param schemaName the schemaName value to set
     * @return the USqlProcedure object itself.
     */
    public USqlProcedure withSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    /**
     * Get the name of the procedure.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name of the procedure.
     *
     * @param name the name value to set
     * @return the USqlProcedure object itself.
     */
    public USqlProcedure withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the defined query of the procedure.
     *
     * @return the definition value
     */
    public String definition() {
        return this.definition;
    }

    /**
     * Set the defined query of the procedure.
     *
     * @param definition the definition value to set
     * @return the USqlProcedure object itself.
     */
    public USqlProcedure withDefinition(String definition) {
        this.definition = definition;
        return this;
    }

}
