/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.analytics.models;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for FileType.
 */
public final class FileType extends ExpandableStringEnum<FileType> {
    /** Static value Assembly for FileType. */
    public static final FileType ASSEMBLY = fromString("Assembly");

    /** Static value Resource for FileType. */
    public static final FileType RESOURCE = fromString("Resource");

    /** Static value Nodeploy for FileType. */
    public static final FileType NODEPLOY = fromString("Nodeploy");

    /**
     * Creates or finds a FileType from its string representation.
     * @param name a name to look for
     * @return the corresponding FileType
     */
    @JsonCreator
    public static FileType fromString(String name) {
        return fromString(name, FileType.class);
    }

    /**
     * @return known FileType values
     */
    public static Collection<FileType> values() {
        return values(FileType.class);
    }
}
