/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.analytics.models;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for AclType.
 */
public final class AclType extends ExpandableStringEnum<AclType> {
    /** Static value UserObj for AclType. */
    public static final AclType USER_OBJ = fromString("UserObj");

    /** Static value GroupObj for AclType. */
    public static final AclType GROUP_OBJ = fromString("GroupObj");

    /** Static value Other for AclType. */
    public static final AclType OTHER = fromString("Other");

    /** Static value User for AclType. */
    public static final AclType USER = fromString("User");

    /** Static value Group for AclType. */
    public static final AclType GROUP = fromString("Group");

    /**
     * Creates or finds a AclType from its string representation.
     * @param name a name to look for
     * @return the corresponding AclType
     */
    @JsonCreator
    public static AclType fromString(String name) {
        return fromString(name, AclType.class);
    }

    /**
     * @return known AclType values
     */
    public static Collection<AclType> values() {
        return values(AclType.class);
    }
}
