/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.analytics.implementation;

import retrofit2.Retrofit;
import com.microsoft.azure.management.datalake.analytics.Pipelines;
import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.datalake.analytics.models.JobPipelineInformation;
import com.microsoft.azure.management.datalake.analytics.models.PageImpl;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Pipelines.
 */
public class PipelinesImpl implements Pipelines {
    /** The Retrofit service to perform REST calls. */
    private PipelinesService service;
    /** The service client containing this operation class. */
    private DataLakeAnalyticsJobManagementClientImpl client;

    /**
     * Initializes an instance of PipelinesImpl.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public PipelinesImpl(Retrofit retrofit, DataLakeAnalyticsJobManagementClientImpl client) {
        this.service = retrofit.create(PipelinesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Pipelines to be
     * used by Retrofit to perform actually REST calls.
     */
    interface PipelinesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Pipelines list" })
        @GET("pipelines")
        Observable<Response<ResponseBody>> list(@Query("startDateTime") DateTime startDateTime, @Query("endDateTime") DateTime endDateTime, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Pipelines get" })
        @GET("pipelines/{pipelineIdentity}")
        Observable<Response<ResponseBody>> get(@Path("pipelineIdentity") UUID pipelineIdentity, @Query("startDateTime") DateTime startDateTime, @Query("endDateTime") DateTime endDateTime, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Pipelines listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists all pipelines.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobPipelineInformation&gt; object if successful.
     */
    public PagedList<JobPipelineInformation> list(final String accountName) {
        ServiceResponse<Page<JobPipelineInformation>> response = listSinglePageAsync(accountName).toBlocking().single();
        return new PagedList<JobPipelineInformation>(response.body()) {
            @Override
            public Page<JobPipelineInformation> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all pipelines.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobPipelineInformation>> listAsync(final String accountName, final ListOperationCallback<JobPipelineInformation> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(accountName),
            new Func1<String, Observable<ServiceResponse<Page<JobPipelineInformation>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobPipelineInformation>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all pipelines.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobPipelineInformation&gt; object
     */
    public Observable<Page<JobPipelineInformation>> listAsync(final String accountName) {
        return listWithServiceResponseAsync(accountName)
            .map(new Func1<ServiceResponse<Page<JobPipelineInformation>>, Page<JobPipelineInformation>>() {
                @Override
                public Page<JobPipelineInformation> call(ServiceResponse<Page<JobPipelineInformation>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all pipelines.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobPipelineInformation&gt; object
     */
    public Observable<ServiceResponse<Page<JobPipelineInformation>>> listWithServiceResponseAsync(final String accountName) {
        return listSinglePageAsync(accountName)
            .concatMap(new Func1<ServiceResponse<Page<JobPipelineInformation>>, Observable<ServiceResponse<Page<JobPipelineInformation>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobPipelineInformation>>> call(ServiceResponse<Page<JobPipelineInformation>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all pipelines.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobPipelineInformation&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobPipelineInformation>>> listSinglePageAsync(final String accountName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final DateTime startDateTime = null;
        final DateTime endDateTime = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        return service.list(startDateTime, endDateTime, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobPipelineInformation>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobPipelineInformation>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<JobPipelineInformation>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobPipelineInformation>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Lists all pipelines.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param startDateTime The start date for when to get the list of pipelines. The startDateTime and endDateTime can be no more than 30 days apart.
     * @param endDateTime The end date for when to get the list of pipelines. The startDateTime and endDateTime can be no more than 30 days apart.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobPipelineInformation&gt; object if successful.
     */
    public PagedList<JobPipelineInformation> list(final String accountName, final DateTime startDateTime, final DateTime endDateTime) {
        ServiceResponse<Page<JobPipelineInformation>> response = listSinglePageAsync(accountName, startDateTime, endDateTime).toBlocking().single();
        return new PagedList<JobPipelineInformation>(response.body()) {
            @Override
            public Page<JobPipelineInformation> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all pipelines.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param startDateTime The start date for when to get the list of pipelines. The startDateTime and endDateTime can be no more than 30 days apart.
     * @param endDateTime The end date for when to get the list of pipelines. The startDateTime and endDateTime can be no more than 30 days apart.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobPipelineInformation>> listAsync(final String accountName, final DateTime startDateTime, final DateTime endDateTime, final ListOperationCallback<JobPipelineInformation> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(accountName, startDateTime, endDateTime),
            new Func1<String, Observable<ServiceResponse<Page<JobPipelineInformation>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobPipelineInformation>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all pipelines.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param startDateTime The start date for when to get the list of pipelines. The startDateTime and endDateTime can be no more than 30 days apart.
     * @param endDateTime The end date for when to get the list of pipelines. The startDateTime and endDateTime can be no more than 30 days apart.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobPipelineInformation&gt; object
     */
    public Observable<Page<JobPipelineInformation>> listAsync(final String accountName, final DateTime startDateTime, final DateTime endDateTime) {
        return listWithServiceResponseAsync(accountName, startDateTime, endDateTime)
            .map(new Func1<ServiceResponse<Page<JobPipelineInformation>>, Page<JobPipelineInformation>>() {
                @Override
                public Page<JobPipelineInformation> call(ServiceResponse<Page<JobPipelineInformation>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all pipelines.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param startDateTime The start date for when to get the list of pipelines. The startDateTime and endDateTime can be no more than 30 days apart.
     * @param endDateTime The end date for when to get the list of pipelines. The startDateTime and endDateTime can be no more than 30 days apart.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobPipelineInformation&gt; object
     */
    public Observable<ServiceResponse<Page<JobPipelineInformation>>> listWithServiceResponseAsync(final String accountName, final DateTime startDateTime, final DateTime endDateTime) {
        return listSinglePageAsync(accountName, startDateTime, endDateTime)
            .concatMap(new Func1<ServiceResponse<Page<JobPipelineInformation>>, Observable<ServiceResponse<Page<JobPipelineInformation>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobPipelineInformation>>> call(ServiceResponse<Page<JobPipelineInformation>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all pipelines.
     *
    ServiceResponse<PageImpl<JobPipelineInformation>> * @param accountName The Azure Data Lake Analytics account to execute job operations on.
    ServiceResponse<PageImpl<JobPipelineInformation>> * @param startDateTime The start date for when to get the list of pipelines. The startDateTime and endDateTime can be no more than 30 days apart.
    ServiceResponse<PageImpl<JobPipelineInformation>> * @param endDateTime The end date for when to get the list of pipelines. The startDateTime and endDateTime can be no more than 30 days apart.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobPipelineInformation&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobPipelineInformation>>> listSinglePageAsync(final String accountName, final DateTime startDateTime, final DateTime endDateTime) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        return service.list(startDateTime, endDateTime, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobPipelineInformation>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobPipelineInformation>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<JobPipelineInformation>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobPipelineInformation>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<JobPipelineInformation>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<JobPipelineInformation>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<JobPipelineInformation>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the Pipeline information for the specified pipeline ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param pipelineIdentity Pipeline ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobPipelineInformation object if successful.
     */
    public JobPipelineInformation get(String accountName, UUID pipelineIdentity) {
        return getWithServiceResponseAsync(accountName, pipelineIdentity).toBlocking().single().body();
    }

    /**
     * Gets the Pipeline information for the specified pipeline ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param pipelineIdentity Pipeline ID.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobPipelineInformation> getAsync(String accountName, UUID pipelineIdentity, final ServiceCallback<JobPipelineInformation> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(accountName, pipelineIdentity), serviceCallback);
    }

    /**
     * Gets the Pipeline information for the specified pipeline ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param pipelineIdentity Pipeline ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobPipelineInformation object
     */
    public Observable<JobPipelineInformation> getAsync(String accountName, UUID pipelineIdentity) {
        return getWithServiceResponseAsync(accountName, pipelineIdentity).map(new Func1<ServiceResponse<JobPipelineInformation>, JobPipelineInformation>() {
            @Override
            public JobPipelineInformation call(ServiceResponse<JobPipelineInformation> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the Pipeline information for the specified pipeline ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param pipelineIdentity Pipeline ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobPipelineInformation object
     */
    public Observable<ServiceResponse<JobPipelineInformation>> getWithServiceResponseAsync(String accountName, UUID pipelineIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (pipelineIdentity == null) {
            throw new IllegalArgumentException("Parameter pipelineIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final DateTime startDateTime = null;
        final DateTime endDateTime = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        return service.get(pipelineIdentity, startDateTime, endDateTime, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobPipelineInformation>>>() {
                @Override
                public Observable<ServiceResponse<JobPipelineInformation>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobPipelineInformation> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets the Pipeline information for the specified pipeline ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param pipelineIdentity Pipeline ID.
     * @param startDateTime The start date for when to get the pipeline and aggregate its data. The startDateTime and endDateTime can be no more than 30 days apart.
     * @param endDateTime The end date for when to get the pipeline and aggregate its data. The startDateTime and endDateTime can be no more than 30 days apart.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobPipelineInformation object if successful.
     */
    public JobPipelineInformation get(String accountName, UUID pipelineIdentity, DateTime startDateTime, DateTime endDateTime) {
        return getWithServiceResponseAsync(accountName, pipelineIdentity, startDateTime, endDateTime).toBlocking().single().body();
    }

    /**
     * Gets the Pipeline information for the specified pipeline ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param pipelineIdentity Pipeline ID.
     * @param startDateTime The start date for when to get the pipeline and aggregate its data. The startDateTime and endDateTime can be no more than 30 days apart.
     * @param endDateTime The end date for when to get the pipeline and aggregate its data. The startDateTime and endDateTime can be no more than 30 days apart.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobPipelineInformation> getAsync(String accountName, UUID pipelineIdentity, DateTime startDateTime, DateTime endDateTime, final ServiceCallback<JobPipelineInformation> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(accountName, pipelineIdentity, startDateTime, endDateTime), serviceCallback);
    }

    /**
     * Gets the Pipeline information for the specified pipeline ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param pipelineIdentity Pipeline ID.
     * @param startDateTime The start date for when to get the pipeline and aggregate its data. The startDateTime and endDateTime can be no more than 30 days apart.
     * @param endDateTime The end date for when to get the pipeline and aggregate its data. The startDateTime and endDateTime can be no more than 30 days apart.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobPipelineInformation object
     */
    public Observable<JobPipelineInformation> getAsync(String accountName, UUID pipelineIdentity, DateTime startDateTime, DateTime endDateTime) {
        return getWithServiceResponseAsync(accountName, pipelineIdentity, startDateTime, endDateTime).map(new Func1<ServiceResponse<JobPipelineInformation>, JobPipelineInformation>() {
            @Override
            public JobPipelineInformation call(ServiceResponse<JobPipelineInformation> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the Pipeline information for the specified pipeline ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param pipelineIdentity Pipeline ID.
     * @param startDateTime The start date for when to get the pipeline and aggregate its data. The startDateTime and endDateTime can be no more than 30 days apart.
     * @param endDateTime The end date for when to get the pipeline and aggregate its data. The startDateTime and endDateTime can be no more than 30 days apart.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobPipelineInformation object
     */
    public Observable<ServiceResponse<JobPipelineInformation>> getWithServiceResponseAsync(String accountName, UUID pipelineIdentity, DateTime startDateTime, DateTime endDateTime) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (pipelineIdentity == null) {
            throw new IllegalArgumentException("Parameter pipelineIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        return service.get(pipelineIdentity, startDateTime, endDateTime, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobPipelineInformation>>>() {
                @Override
                public Observable<ServiceResponse<JobPipelineInformation>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobPipelineInformation> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<JobPipelineInformation> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<JobPipelineInformation, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<JobPipelineInformation>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all pipelines.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobPipelineInformation&gt; object if successful.
     */
    public PagedList<JobPipelineInformation> listNext(final String nextPageLink) {
        ServiceResponse<Page<JobPipelineInformation>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobPipelineInformation>(response.body()) {
            @Override
            public Page<JobPipelineInformation> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all pipelines.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobPipelineInformation>> listNextAsync(final String nextPageLink, final ServiceFuture<List<JobPipelineInformation>> serviceFuture, final ListOperationCallback<JobPipelineInformation> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<JobPipelineInformation>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobPipelineInformation>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all pipelines.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobPipelineInformation&gt; object
     */
    public Observable<Page<JobPipelineInformation>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<JobPipelineInformation>>, Page<JobPipelineInformation>>() {
                @Override
                public Page<JobPipelineInformation> call(ServiceResponse<Page<JobPipelineInformation>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all pipelines.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobPipelineInformation&gt; object
     */
    public Observable<ServiceResponse<Page<JobPipelineInformation>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<JobPipelineInformation>>, Observable<ServiceResponse<Page<JobPipelineInformation>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobPipelineInformation>>> call(ServiceResponse<Page<JobPipelineInformation>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all pipelines.
     *
    ServiceResponse<PageImpl<JobPipelineInformation>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobPipelineInformation&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobPipelineInformation>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobPipelineInformation>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobPipelineInformation>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<JobPipelineInformation>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobPipelineInformation>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<JobPipelineInformation>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<JobPipelineInformation>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<JobPipelineInformation>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
