/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.analytics.implementation;

import retrofit2.Retrofit;
import com.microsoft.azure.management.datalake.analytics.Catalogs;
import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.datalake.analytics.models.Acl;
import com.microsoft.azure.management.datalake.analytics.models.AclCreateOrUpdateParameters;
import com.microsoft.azure.management.datalake.analytics.models.AclDeleteParameters;
import com.microsoft.azure.management.datalake.analytics.models.DataLakeAnalyticsCatalogCredentialCreateParameters;
import com.microsoft.azure.management.datalake.analytics.models.DataLakeAnalyticsCatalogCredentialDeleteParameters;
import com.microsoft.azure.management.datalake.analytics.models.DataLakeAnalyticsCatalogCredentialUpdateParameters;
import com.microsoft.azure.management.datalake.analytics.models.DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters;
import com.microsoft.azure.management.datalake.analytics.models.PageImpl;
import com.microsoft.azure.management.datalake.analytics.models.USqlAssembly;
import com.microsoft.azure.management.datalake.analytics.models.USqlAssemblyClr;
import com.microsoft.azure.management.datalake.analytics.models.USqlCredential;
import com.microsoft.azure.management.datalake.analytics.models.USqlDatabase;
import com.microsoft.azure.management.datalake.analytics.models.USqlExternalDataSource;
import com.microsoft.azure.management.datalake.analytics.models.USqlPackage;
import com.microsoft.azure.management.datalake.analytics.models.USqlProcedure;
import com.microsoft.azure.management.datalake.analytics.models.USqlSchema;
import com.microsoft.azure.management.datalake.analytics.models.USqlSecret;
import com.microsoft.azure.management.datalake.analytics.models.USqlTable;
import com.microsoft.azure.management.datalake.analytics.models.USqlTableFragment;
import com.microsoft.azure.management.datalake.analytics.models.USqlTablePartition;
import com.microsoft.azure.management.datalake.analytics.models.USqlTablePreview;
import com.microsoft.azure.management.datalake.analytics.models.USqlTableStatistics;
import com.microsoft.azure.management.datalake.analytics.models.USqlTableType;
import com.microsoft.azure.management.datalake.analytics.models.USqlTableValuedFunction;
import com.microsoft.azure.management.datalake.analytics.models.USqlType;
import com.microsoft.azure.management.datalake.analytics.models.USqlView;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Catalogs.
 */
public class CatalogsImpl implements Catalogs {
    /** The Retrofit service to perform REST calls. */
    private CatalogsService service;
    /** The service client containing this operation class. */
    private DataLakeAnalyticsCatalogManagementClientImpl client;

    /**
     * Initializes an instance of CatalogsImpl.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public CatalogsImpl(Retrofit retrofit, DataLakeAnalyticsCatalogManagementClientImpl client) {
        this.service = retrofit.create(CatalogsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Catalogs to be
     * used by Retrofit to perform actually REST calls.
     */
    interface CatalogsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs createSecret" })
        @PUT("catalog/usql/databases/{databaseName}/secrets/{secretName}")
        Observable<Response<ResponseBody>> createSecret(@Path("databaseName") String databaseName, @Path("secretName") String secretName, @Body DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getSecret" })
        @GET("catalog/usql/databases/{databaseName}/secrets/{secretName}")
        Observable<Response<ResponseBody>> getSecret(@Path("databaseName") String databaseName, @Path("secretName") String secretName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs updateSecret" })
        @PATCH("catalog/usql/databases/{databaseName}/secrets/{secretName}")
        Observable<Response<ResponseBody>> updateSecret(@Path("databaseName") String databaseName, @Path("secretName") String secretName, @Body DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs deleteSecret" })
        @HTTP(path = "catalog/usql/databases/{databaseName}/secrets/{secretName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteSecret(@Path("databaseName") String databaseName, @Path("secretName") String secretName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs deleteAllSecrets" })
        @HTTP(path = "catalog/usql/databases/{databaseName}/secrets", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteAllSecrets(@Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs createCredential" })
        @PUT("catalog/usql/databases/{databaseName}/credentials/{credentialName}")
        Observable<Response<ResponseBody>> createCredential(@Path("databaseName") String databaseName, @Path("credentialName") String credentialName, @Body DataLakeAnalyticsCatalogCredentialCreateParameters parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getCredential" })
        @GET("catalog/usql/databases/{databaseName}/credentials/{credentialName}")
        Observable<Response<ResponseBody>> getCredential(@Path("databaseName") String databaseName, @Path("credentialName") String credentialName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs updateCredential" })
        @PATCH("catalog/usql/databases/{databaseName}/credentials/{credentialName}")
        Observable<Response<ResponseBody>> updateCredential(@Path("databaseName") String databaseName, @Path("credentialName") String credentialName, @Body DataLakeAnalyticsCatalogCredentialUpdateParameters parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs deleteCredential" })
        @POST("catalog/usql/databases/{databaseName}/credentials/{credentialName}")
        Observable<Response<ResponseBody>> deleteCredential(@Path("databaseName") String databaseName, @Path("credentialName") String credentialName, @Query("cascade") Boolean cascade, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body DataLakeAnalyticsCatalogCredentialDeleteParameters parameters, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listCredentials" })
        @GET("catalog/usql/databases/{databaseName}/credentials")
        Observable<Response<ResponseBody>> listCredentials(@Path("databaseName") String databaseName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getExternalDataSource" })
        @GET("catalog/usql/databases/{databaseName}/externaldatasources/{externalDataSourceName}")
        Observable<Response<ResponseBody>> getExternalDataSource(@Path("databaseName") String databaseName, @Path("externalDataSourceName") String externalDataSourceName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listExternalDataSources" })
        @GET("catalog/usql/databases/{databaseName}/externaldatasources")
        Observable<Response<ResponseBody>> listExternalDataSources(@Path("databaseName") String databaseName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getProcedure" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/procedures/{procedureName}")
        Observable<Response<ResponseBody>> getProcedure(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Path("procedureName") String procedureName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listProcedures" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/procedures")
        Observable<Response<ResponseBody>> listProcedures(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getTable" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}")
        Observable<Response<ResponseBody>> getTable(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Path("tableName") String tableName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableFragments" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/tablefragments")
        Observable<Response<ResponseBody>> listTableFragments(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Path("tableName") String tableName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTables" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables")
        Observable<Response<ResponseBody>> listTables(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("basic") Boolean basic, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableStatisticsByDatabaseAndSchema" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/statistics")
        Observable<Response<ResponseBody>> listTableStatisticsByDatabaseAndSchema(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getTableType" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/tabletypes/{tableTypeName}")
        Observable<Response<ResponseBody>> getTableType(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Path("tableTypeName") String tableTypeName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableTypes" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/tabletypes")
        Observable<Response<ResponseBody>> listTableTypes(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getPackage" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/packages/{packageName}")
        Observable<Response<ResponseBody>> getPackage(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Path("packageName") String packageName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listPackages" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/packages")
        Observable<Response<ResponseBody>> listPackages(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getView" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/views/{viewName}")
        Observable<Response<ResponseBody>> getView(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Path("viewName") String viewName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listViews" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/views")
        Observable<Response<ResponseBody>> listViews(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getTableStatistic" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/statistics/{statisticsName}")
        Observable<Response<ResponseBody>> getTableStatistic(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Path("tableName") String tableName, @Path("statisticsName") String statisticsName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableStatistics" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/statistics")
        Observable<Response<ResponseBody>> listTableStatistics(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Path("tableName") String tableName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs previewTablePartition" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/partitions/{partitionName}/previewrows")
        Observable<Response<ResponseBody>> previewTablePartition(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Path("tableName") String tableName, @Path("partitionName") String partitionName, @Query("maxRows") Long maxRows, @Query("maxColumns") Long maxColumns, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getTablePartition" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/partitions/{partitionName}")
        Observable<Response<ResponseBody>> getTablePartition(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Path("tableName") String tableName, @Path("partitionName") String partitionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs previewTable" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/previewrows")
        Observable<Response<ResponseBody>> previewTable(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Path("tableName") String tableName, @Query("maxRows") Long maxRows, @Query("maxColumns") Long maxColumns, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTablePartitions" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/partitions")
        Observable<Response<ResponseBody>> listTablePartitions(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Path("tableName") String tableName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTypes" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/types")
        Observable<Response<ResponseBody>> listTypes(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getTableValuedFunction" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/tablevaluedfunctions/{tableValuedFunctionName}")
        Observable<Response<ResponseBody>> getTableValuedFunction(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Path("tableValuedFunctionName") String tableValuedFunctionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableValuedFunctions" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}/tablevaluedfunctions")
        Observable<Response<ResponseBody>> listTableValuedFunctions(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getAssembly" })
        @GET("catalog/usql/databases/{databaseName}/assemblies/{assemblyName}")
        Observable<Response<ResponseBody>> getAssembly(@Path("databaseName") String databaseName, @Path("assemblyName") String assemblyName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listAssemblies" })
        @GET("catalog/usql/databases/{databaseName}/assemblies")
        Observable<Response<ResponseBody>> listAssemblies(@Path("databaseName") String databaseName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getSchema" })
        @GET("catalog/usql/databases/{databaseName}/schemas/{schemaName}")
        Observable<Response<ResponseBody>> getSchema(@Path("databaseName") String databaseName, @Path("schemaName") String schemaName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listSchemas" })
        @GET("catalog/usql/databases/{databaseName}/schemas")
        Observable<Response<ResponseBody>> listSchemas(@Path("databaseName") String databaseName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableStatisticsByDatabase" })
        @GET("catalog/usql/databases/{databaseName}/statistics")
        Observable<Response<ResponseBody>> listTableStatisticsByDatabase(@Path("databaseName") String databaseName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTablesByDatabase" })
        @GET("catalog/usql/databases/{databaseName}/tables")
        Observable<Response<ResponseBody>> listTablesByDatabase(@Path("databaseName") String databaseName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("basic") Boolean basic, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableValuedFunctionsByDatabase" })
        @GET("catalog/usql/databases/{databaseName}/tablevaluedfunctions")
        Observable<Response<ResponseBody>> listTableValuedFunctionsByDatabase(@Path("databaseName") String databaseName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listViewsByDatabase" })
        @GET("catalog/usql/databases/{databaseName}/views")
        Observable<Response<ResponseBody>> listViewsByDatabase(@Path("databaseName") String databaseName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listAclsByDatabase" })
        @GET("catalog/usql/databases/{databaseName}/acl")
        Observable<Response<ResponseBody>> listAclsByDatabase(@Path("databaseName") String databaseName, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listAcls" })
        @GET("catalog/usql/acl")
        Observable<Response<ResponseBody>> listAcls(@Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs getDatabase" })
        @GET("catalog/usql/databases/{databaseName}")
        Observable<Response<ResponseBody>> getDatabase(@Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listDatabases" })
        @GET("catalog/usql/databases")
        Observable<Response<ResponseBody>> listDatabases(@Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs grantAcl" })
        @POST("catalog/usql/acl")
        Observable<Response<ResponseBody>> grantAcl(@Body AclCreateOrUpdateParameters parameters, @Query("op") String op, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs grantAclToDatabase" })
        @POST("catalog/usql/databases/{databaseName}/acl")
        Observable<Response<ResponseBody>> grantAclToDatabase(@Path("databaseName") String databaseName, @Body AclCreateOrUpdateParameters parameters, @Query("op") String op, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs revokeAcl" })
        @POST("catalog/usql/acl")
        Observable<Response<ResponseBody>> revokeAcl(@Body AclDeleteParameters parameters, @Query("op") String op, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs revokeAclFromDatabase" })
        @POST("catalog/usql/databases/{databaseName}/acl")
        Observable<Response<ResponseBody>> revokeAclFromDatabase(@Path("databaseName") String databaseName, @Body AclDeleteParameters parameters, @Query("op") String op, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listCredentialsNext" })
        @GET
        Observable<Response<ResponseBody>> listCredentialsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listExternalDataSourcesNext" })
        @GET
        Observable<Response<ResponseBody>> listExternalDataSourcesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listProceduresNext" })
        @GET
        Observable<Response<ResponseBody>> listProceduresNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableFragmentsNext" })
        @GET
        Observable<Response<ResponseBody>> listTableFragmentsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTablesNext" })
        @GET
        Observable<Response<ResponseBody>> listTablesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableStatisticsByDatabaseAndSchemaNext" })
        @GET
        Observable<Response<ResponseBody>> listTableStatisticsByDatabaseAndSchemaNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableTypesNext" })
        @GET
        Observable<Response<ResponseBody>> listTableTypesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listPackagesNext" })
        @GET
        Observable<Response<ResponseBody>> listPackagesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listViewsNext" })
        @GET
        Observable<Response<ResponseBody>> listViewsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableStatisticsNext" })
        @GET
        Observable<Response<ResponseBody>> listTableStatisticsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTablePartitionsNext" })
        @GET
        Observable<Response<ResponseBody>> listTablePartitionsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTypesNext" })
        @GET
        Observable<Response<ResponseBody>> listTypesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableValuedFunctionsNext" })
        @GET
        Observable<Response<ResponseBody>> listTableValuedFunctionsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listAssembliesNext" })
        @GET
        Observable<Response<ResponseBody>> listAssembliesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listSchemasNext" })
        @GET
        Observable<Response<ResponseBody>> listSchemasNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableStatisticsByDatabaseNext" })
        @GET
        Observable<Response<ResponseBody>> listTableStatisticsByDatabaseNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTablesByDatabaseNext" })
        @GET
        Observable<Response<ResponseBody>> listTablesByDatabaseNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listTableValuedFunctionsByDatabaseNext" })
        @GET
        Observable<Response<ResponseBody>> listTableValuedFunctionsByDatabaseNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listViewsByDatabaseNext" })
        @GET
        Observable<Response<ResponseBody>> listViewsByDatabaseNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listAclsByDatabaseNext" })
        @GET
        Observable<Response<ResponseBody>> listAclsByDatabaseNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listAclsNext" })
        @GET
        Observable<Response<ResponseBody>> listAclsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Catalogs listDatabasesNext" })
        @GET
        Observable<Response<ResponseBody>> listDatabasesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Creates the specified secret for use with external data sources in the specified database. This is deprecated and will be removed in the next release. Please use CreateCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database in which to create the secret.
     * @param secretName The name of the secret.
     * @param parameters The parameters required to create the secret (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void createSecret(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters) {
        createSecretWithServiceResponseAsync(accountName, databaseName, secretName, parameters).toBlocking().single().body();
    }

    /**
     * Creates the specified secret for use with external data sources in the specified database. This is deprecated and will be removed in the next release. Please use CreateCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database in which to create the secret.
     * @param secretName The name of the secret.
     * @param parameters The parameters required to create the secret (name and password)
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> createSecretAsync(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(createSecretWithServiceResponseAsync(accountName, databaseName, secretName, parameters), serviceCallback);
    }

    /**
     * Creates the specified secret for use with external data sources in the specified database. This is deprecated and will be removed in the next release. Please use CreateCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database in which to create the secret.
     * @param secretName The name of the secret.
     * @param parameters The parameters required to create the secret (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> createSecretAsync(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters) {
        return createSecretWithServiceResponseAsync(accountName, databaseName, secretName, parameters).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates the specified secret for use with external data sources in the specified database. This is deprecated and will be removed in the next release. Please use CreateCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database in which to create the secret.
     * @param secretName The name of the secret.
     * @param parameters The parameters required to create the secret (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> createSecretWithServiceResponseAsync(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.createSecret(databaseName, secretName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = createSecretDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> createSecretDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the specified secret in the specified database. This is deprecated and will be removed in the next release. Please use GetCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret to get
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlSecret object if successful.
     */
    public USqlSecret getSecret(String accountName, String databaseName, String secretName) {
        return getSecretWithServiceResponseAsync(accountName, databaseName, secretName).toBlocking().single().body();
    }

    /**
     * Gets the specified secret in the specified database. This is deprecated and will be removed in the next release. Please use GetCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret to get
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<USqlSecret> getSecretAsync(String accountName, String databaseName, String secretName, final ServiceCallback<USqlSecret> serviceCallback) {
        return ServiceFuture.fromResponse(getSecretWithServiceResponseAsync(accountName, databaseName, secretName), serviceCallback);
    }

    /**
     * Gets the specified secret in the specified database. This is deprecated and will be removed in the next release. Please use GetCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret to get
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlSecret object
     */
    public Observable<USqlSecret> getSecretAsync(String accountName, String databaseName, String secretName) {
        return getSecretWithServiceResponseAsync(accountName, databaseName, secretName).map(new Func1<ServiceResponse<USqlSecret>, USqlSecret>() {
            @Override
            public USqlSecret call(ServiceResponse<USqlSecret> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified secret in the specified database. This is deprecated and will be removed in the next release. Please use GetCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret to get
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlSecret object
     */
    public Observable<ServiceResponse<USqlSecret>> getSecretWithServiceResponseAsync(String accountName, String databaseName, String secretName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.getSecret(databaseName, secretName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlSecret>>>() {
                @Override
                public Observable<ServiceResponse<USqlSecret>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<USqlSecret> clientResponse = getSecretDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<USqlSecret> getSecretDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<USqlSecret, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<USqlSecret>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Modifies the specified secret for use with external data sources in the specified database. This is deprecated and will be removed in the next release. Please use UpdateCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret.
     * @param parameters The parameters required to modify the secret (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void updateSecret(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters) {
        updateSecretWithServiceResponseAsync(accountName, databaseName, secretName, parameters).toBlocking().single().body();
    }

    /**
     * Modifies the specified secret for use with external data sources in the specified database. This is deprecated and will be removed in the next release. Please use UpdateCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret.
     * @param parameters The parameters required to modify the secret (name and password)
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> updateSecretAsync(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(updateSecretWithServiceResponseAsync(accountName, databaseName, secretName, parameters), serviceCallback);
    }

    /**
     * Modifies the specified secret for use with external data sources in the specified database. This is deprecated and will be removed in the next release. Please use UpdateCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret.
     * @param parameters The parameters required to modify the secret (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> updateSecretAsync(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters) {
        return updateSecretWithServiceResponseAsync(accountName, databaseName, secretName, parameters).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Modifies the specified secret for use with external data sources in the specified database. This is deprecated and will be removed in the next release. Please use UpdateCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret.
     * @param parameters The parameters required to modify the secret (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> updateSecretWithServiceResponseAsync(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.updateSecret(databaseName, secretName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = updateSecretDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> updateSecretDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes the specified secret in the specified database. This is deprecated and will be removed in the next release. Please use DeleteCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret to delete
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteSecret(String accountName, String databaseName, String secretName) {
        deleteSecretWithServiceResponseAsync(accountName, databaseName, secretName).toBlocking().single().body();
    }

    /**
     * Deletes the specified secret in the specified database. This is deprecated and will be removed in the next release. Please use DeleteCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret to delete
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteSecretAsync(String accountName, String databaseName, String secretName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteSecretWithServiceResponseAsync(accountName, databaseName, secretName), serviceCallback);
    }

    /**
     * Deletes the specified secret in the specified database. This is deprecated and will be removed in the next release. Please use DeleteCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret to delete
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteSecretAsync(String accountName, String databaseName, String secretName) {
        return deleteSecretWithServiceResponseAsync(accountName, databaseName, secretName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified secret in the specified database. This is deprecated and will be removed in the next release. Please use DeleteCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret to delete
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteSecretWithServiceResponseAsync(String accountName, String databaseName, String secretName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.deleteSecret(databaseName, secretName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteSecretDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteSecretDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes all secrets in the specified database. This is deprecated and will be removed in the next release. In the future, please only drop individual credentials using DeleteCredential.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteAllSecrets(String accountName, String databaseName) {
        deleteAllSecretsWithServiceResponseAsync(accountName, databaseName).toBlocking().single().body();
    }

    /**
     * Deletes all secrets in the specified database. This is deprecated and will be removed in the next release. In the future, please only drop individual credentials using DeleteCredential.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAllSecretsAsync(String accountName, String databaseName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteAllSecretsWithServiceResponseAsync(accountName, databaseName), serviceCallback);
    }

    /**
     * Deletes all secrets in the specified database. This is deprecated and will be removed in the next release. In the future, please only drop individual credentials using DeleteCredential.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAllSecretsAsync(String accountName, String databaseName) {
        return deleteAllSecretsWithServiceResponseAsync(accountName, databaseName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes all secrets in the specified database. This is deprecated and will be removed in the next release. In the future, please only drop individual credentials using DeleteCredential.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteAllSecretsWithServiceResponseAsync(String accountName, String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.deleteAllSecrets(databaseName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteAllSecretsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteAllSecretsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates the specified credential for use with external data sources in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database in which to create the credential. Note: This is NOT an external database name, but the name of an existing U-SQL database that should contain the new credential object.
     * @param credentialName The name of the credential.
     * @param parameters The parameters required to create the credential (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void createCredential(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialCreateParameters parameters) {
        createCredentialWithServiceResponseAsync(accountName, databaseName, credentialName, parameters).toBlocking().single().body();
    }

    /**
     * Creates the specified credential for use with external data sources in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database in which to create the credential. Note: This is NOT an external database name, but the name of an existing U-SQL database that should contain the new credential object.
     * @param credentialName The name of the credential.
     * @param parameters The parameters required to create the credential (name and password)
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> createCredentialAsync(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialCreateParameters parameters, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(createCredentialWithServiceResponseAsync(accountName, databaseName, credentialName, parameters), serviceCallback);
    }

    /**
     * Creates the specified credential for use with external data sources in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database in which to create the credential. Note: This is NOT an external database name, but the name of an existing U-SQL database that should contain the new credential object.
     * @param credentialName The name of the credential.
     * @param parameters The parameters required to create the credential (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> createCredentialAsync(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialCreateParameters parameters) {
        return createCredentialWithServiceResponseAsync(accountName, databaseName, credentialName, parameters).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates the specified credential for use with external data sources in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database in which to create the credential. Note: This is NOT an external database name, but the name of an existing U-SQL database that should contain the new credential object.
     * @param credentialName The name of the credential.
     * @param parameters The parameters required to create the credential (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> createCredentialWithServiceResponseAsync(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialCreateParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (credentialName == null) {
            throw new IllegalArgumentException("Parameter credentialName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.createCredential(databaseName, credentialName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = createCredentialDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> createCredentialDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the specified credential from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param credentialName The name of the credential.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlCredential object if successful.
     */
    public USqlCredential getCredential(String accountName, String databaseName, String credentialName) {
        return getCredentialWithServiceResponseAsync(accountName, databaseName, credentialName).toBlocking().single().body();
    }

    /**
     * Retrieves the specified credential from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param credentialName The name of the credential.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<USqlCredential> getCredentialAsync(String accountName, String databaseName, String credentialName, final ServiceCallback<USqlCredential> serviceCallback) {
        return ServiceFuture.fromResponse(getCredentialWithServiceResponseAsync(accountName, databaseName, credentialName), serviceCallback);
    }

    /**
     * Retrieves the specified credential from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param credentialName The name of the credential.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlCredential object
     */
    public Observable<USqlCredential> getCredentialAsync(String accountName, String databaseName, String credentialName) {
        return getCredentialWithServiceResponseAsync(accountName, databaseName, credentialName).map(new Func1<ServiceResponse<USqlCredential>, USqlCredential>() {
            @Override
            public USqlCredential call(ServiceResponse<USqlCredential> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the specified credential from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param credentialName The name of the credential.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlCredential object
     */
    public Observable<ServiceResponse<USqlCredential>> getCredentialWithServiceResponseAsync(String accountName, String databaseName, String credentialName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (credentialName == null) {
            throw new IllegalArgumentException("Parameter credentialName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.getCredential(databaseName, credentialName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlCredential>>>() {
                @Override
                public Observable<ServiceResponse<USqlCredential>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<USqlCredential> clientResponse = getCredentialDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<USqlCredential> getCredentialDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<USqlCredential, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<USqlCredential>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Modifies the specified credential for use with external data sources in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential.
     * @param parameters The parameters required to modify the credential (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void updateCredential(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialUpdateParameters parameters) {
        updateCredentialWithServiceResponseAsync(accountName, databaseName, credentialName, parameters).toBlocking().single().body();
    }

    /**
     * Modifies the specified credential for use with external data sources in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential.
     * @param parameters The parameters required to modify the credential (name and password)
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> updateCredentialAsync(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialUpdateParameters parameters, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(updateCredentialWithServiceResponseAsync(accountName, databaseName, credentialName, parameters), serviceCallback);
    }

    /**
     * Modifies the specified credential for use with external data sources in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential.
     * @param parameters The parameters required to modify the credential (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> updateCredentialAsync(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialUpdateParameters parameters) {
        return updateCredentialWithServiceResponseAsync(accountName, databaseName, credentialName, parameters).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Modifies the specified credential for use with external data sources in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential.
     * @param parameters The parameters required to modify the credential (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> updateCredentialWithServiceResponseAsync(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialUpdateParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (credentialName == null) {
            throw new IllegalArgumentException("Parameter credentialName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.updateCredential(databaseName, credentialName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = updateCredentialDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> updateCredentialDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes the specified credential in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential to delete
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteCredential(String accountName, String databaseName, String credentialName) {
        deleteCredentialWithServiceResponseAsync(accountName, databaseName, credentialName).toBlocking().single().body();
    }

    /**
     * Deletes the specified credential in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential to delete
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteCredentialAsync(String accountName, String databaseName, String credentialName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteCredentialWithServiceResponseAsync(accountName, databaseName, credentialName), serviceCallback);
    }

    /**
     * Deletes the specified credential in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential to delete
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteCredentialAsync(String accountName, String databaseName, String credentialName) {
        return deleteCredentialWithServiceResponseAsync(accountName, databaseName, credentialName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified credential in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential to delete
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteCredentialWithServiceResponseAsync(String accountName, String databaseName, String credentialName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (credentialName == null) {
            throw new IllegalArgumentException("Parameter credentialName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Boolean cascade = null;
        final String password = null;
        DataLakeAnalyticsCatalogCredentialDeleteParameters parameters = new DataLakeAnalyticsCatalogCredentialDeleteParameters();
        parameters.withPassword(null);
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.deleteCredential(databaseName, credentialName, cascade, this.client.apiVersion(), this.client.acceptLanguage(), parameters, parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteCredentialDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Deletes the specified credential in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential to delete
     * @param cascade Indicates if the delete should be a cascading delete (which deletes all resources dependent on the credential as well as the credential) or not. If false will fail if there are any resources relying on the credential.
     * @param password the current password for the credential and user with access to the data source. This is required if the requester is not the account owner.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteCredential(String accountName, String databaseName, String credentialName, Boolean cascade, String password) {
        deleteCredentialWithServiceResponseAsync(accountName, databaseName, credentialName, cascade, password).toBlocking().single().body();
    }

    /**
     * Deletes the specified credential in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential to delete
     * @param cascade Indicates if the delete should be a cascading delete (which deletes all resources dependent on the credential as well as the credential) or not. If false will fail if there are any resources relying on the credential.
     * @param password the current password for the credential and user with access to the data source. This is required if the requester is not the account owner.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteCredentialAsync(String accountName, String databaseName, String credentialName, Boolean cascade, String password, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteCredentialWithServiceResponseAsync(accountName, databaseName, credentialName, cascade, password), serviceCallback);
    }

    /**
     * Deletes the specified credential in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential to delete
     * @param cascade Indicates if the delete should be a cascading delete (which deletes all resources dependent on the credential as well as the credential) or not. If false will fail if there are any resources relying on the credential.
     * @param password the current password for the credential and user with access to the data source. This is required if the requester is not the account owner.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteCredentialAsync(String accountName, String databaseName, String credentialName, Boolean cascade, String password) {
        return deleteCredentialWithServiceResponseAsync(accountName, databaseName, credentialName, cascade, password).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified credential in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential to delete
     * @param cascade Indicates if the delete should be a cascading delete (which deletes all resources dependent on the credential as well as the credential) or not. If false will fail if there are any resources relying on the credential.
     * @param password the current password for the credential and user with access to the data source. This is required if the requester is not the account owner.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteCredentialWithServiceResponseAsync(String accountName, String databaseName, String credentialName, Boolean cascade, String password) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (credentialName == null) {
            throw new IllegalArgumentException("Parameter credentialName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        DataLakeAnalyticsCatalogCredentialDeleteParameters parameters = null;
        if (password != null) {
            parameters = new DataLakeAnalyticsCatalogCredentialDeleteParameters();
            parameters.withPassword(password);
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.deleteCredential(databaseName, credentialName, cascade, this.client.apiVersion(), this.client.acceptLanguage(), parameters, parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteCredentialDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteCredentialDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlCredential&gt; object if successful.
     */
    public PagedList<USqlCredential> listCredentials(final String accountName, final String databaseName) {
        ServiceResponse<Page<USqlCredential>> response = listCredentialsSinglePageAsync(accountName, databaseName).toBlocking().single();
        return new PagedList<USqlCredential>(response.body()) {
            @Override
            public Page<USqlCredential> nextPage(String nextPageLink) {
                return listCredentialsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlCredential>> listCredentialsAsync(final String accountName, final String databaseName, final ListOperationCallback<USqlCredential> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listCredentialsSinglePageAsync(accountName, databaseName),
            new Func1<String, Observable<ServiceResponse<Page<USqlCredential>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlCredential>>> call(String nextPageLink) {
                    return listCredentialsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlCredential&gt; object
     */
    public Observable<Page<USqlCredential>> listCredentialsAsync(final String accountName, final String databaseName) {
        return listCredentialsWithServiceResponseAsync(accountName, databaseName)
            .map(new Func1<ServiceResponse<Page<USqlCredential>>, Page<USqlCredential>>() {
                @Override
                public Page<USqlCredential> call(ServiceResponse<Page<USqlCredential>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlCredential&gt; object
     */
    public Observable<ServiceResponse<Page<USqlCredential>>> listCredentialsWithServiceResponseAsync(final String accountName, final String databaseName) {
        return listCredentialsSinglePageAsync(accountName, databaseName)
            .concatMap(new Func1<ServiceResponse<Page<USqlCredential>>, Observable<ServiceResponse<Page<USqlCredential>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlCredential>>> call(ServiceResponse<Page<USqlCredential>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listCredentialsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlCredential&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlCredential>>> listCredentialsSinglePageAsync(final String accountName, final String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listCredentials(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlCredential>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlCredential>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlCredential>> result = listCredentialsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlCredential>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlCredential&gt; object if successful.
     */
    public PagedList<USqlCredential> listCredentials(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<USqlCredential>> response = listCredentialsSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlCredential>(response.body()) {
            @Override
            public Page<USqlCredential> nextPage(String nextPageLink) {
                return listCredentialsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlCredential>> listCredentialsAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlCredential> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listCredentialsSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<USqlCredential>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlCredential>>> call(String nextPageLink) {
                    return listCredentialsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlCredential&gt; object
     */
    public Observable<Page<USqlCredential>> listCredentialsAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listCredentialsWithServiceResponseAsync(accountName, databaseName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<USqlCredential>>, Page<USqlCredential>>() {
                @Override
                public Page<USqlCredential> call(ServiceResponse<Page<USqlCredential>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlCredential&gt; object
     */
    public Observable<ServiceResponse<Page<USqlCredential>>> listCredentialsWithServiceResponseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listCredentialsSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<USqlCredential>>, Observable<ServiceResponse<Page<USqlCredential>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlCredential>>> call(ServiceResponse<Page<USqlCredential>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listCredentialsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlCredential>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlCredential>> * @param databaseName The name of the database containing the schema.
    ServiceResponse<PageImpl<USqlCredential>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlCredential>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlCredential>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlCredential>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlCredential>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlCredential>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlCredential&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlCredential>>> listCredentialsSinglePageAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listCredentials(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlCredential>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlCredential>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlCredential>> result = listCredentialsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlCredential>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlCredential>> listCredentialsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlCredential>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlCredential>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the specified external data source from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data source.
     * @param externalDataSourceName The name of the external data source.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlExternalDataSource object if successful.
     */
    public USqlExternalDataSource getExternalDataSource(String accountName, String databaseName, String externalDataSourceName) {
        return getExternalDataSourceWithServiceResponseAsync(accountName, databaseName, externalDataSourceName).toBlocking().single().body();
    }

    /**
     * Retrieves the specified external data source from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data source.
     * @param externalDataSourceName The name of the external data source.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<USqlExternalDataSource> getExternalDataSourceAsync(String accountName, String databaseName, String externalDataSourceName, final ServiceCallback<USqlExternalDataSource> serviceCallback) {
        return ServiceFuture.fromResponse(getExternalDataSourceWithServiceResponseAsync(accountName, databaseName, externalDataSourceName), serviceCallback);
    }

    /**
     * Retrieves the specified external data source from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data source.
     * @param externalDataSourceName The name of the external data source.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlExternalDataSource object
     */
    public Observable<USqlExternalDataSource> getExternalDataSourceAsync(String accountName, String databaseName, String externalDataSourceName) {
        return getExternalDataSourceWithServiceResponseAsync(accountName, databaseName, externalDataSourceName).map(new Func1<ServiceResponse<USqlExternalDataSource>, USqlExternalDataSource>() {
            @Override
            public USqlExternalDataSource call(ServiceResponse<USqlExternalDataSource> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the specified external data source from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data source.
     * @param externalDataSourceName The name of the external data source.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlExternalDataSource object
     */
    public Observable<ServiceResponse<USqlExternalDataSource>> getExternalDataSourceWithServiceResponseAsync(String accountName, String databaseName, String externalDataSourceName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (externalDataSourceName == null) {
            throw new IllegalArgumentException("Parameter externalDataSourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.getExternalDataSource(databaseName, externalDataSourceName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlExternalDataSource>>>() {
                @Override
                public Observable<ServiceResponse<USqlExternalDataSource>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<USqlExternalDataSource> clientResponse = getExternalDataSourceDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<USqlExternalDataSource> getExternalDataSourceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<USqlExternalDataSource, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<USqlExternalDataSource>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data sources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlExternalDataSource&gt; object if successful.
     */
    public PagedList<USqlExternalDataSource> listExternalDataSources(final String accountName, final String databaseName) {
        ServiceResponse<Page<USqlExternalDataSource>> response = listExternalDataSourcesSinglePageAsync(accountName, databaseName).toBlocking().single();
        return new PagedList<USqlExternalDataSource>(response.body()) {
            @Override
            public Page<USqlExternalDataSource> nextPage(String nextPageLink) {
                return listExternalDataSourcesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data sources.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlExternalDataSource>> listExternalDataSourcesAsync(final String accountName, final String databaseName, final ListOperationCallback<USqlExternalDataSource> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listExternalDataSourcesSinglePageAsync(accountName, databaseName),
            new Func1<String, Observable<ServiceResponse<Page<USqlExternalDataSource>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlExternalDataSource>>> call(String nextPageLink) {
                    return listExternalDataSourcesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data sources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlExternalDataSource&gt; object
     */
    public Observable<Page<USqlExternalDataSource>> listExternalDataSourcesAsync(final String accountName, final String databaseName) {
        return listExternalDataSourcesWithServiceResponseAsync(accountName, databaseName)
            .map(new Func1<ServiceResponse<Page<USqlExternalDataSource>>, Page<USqlExternalDataSource>>() {
                @Override
                public Page<USqlExternalDataSource> call(ServiceResponse<Page<USqlExternalDataSource>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data sources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlExternalDataSource&gt; object
     */
    public Observable<ServiceResponse<Page<USqlExternalDataSource>>> listExternalDataSourcesWithServiceResponseAsync(final String accountName, final String databaseName) {
        return listExternalDataSourcesSinglePageAsync(accountName, databaseName)
            .concatMap(new Func1<ServiceResponse<Page<USqlExternalDataSource>>, Observable<ServiceResponse<Page<USqlExternalDataSource>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlExternalDataSource>>> call(ServiceResponse<Page<USqlExternalDataSource>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listExternalDataSourcesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data sources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlExternalDataSource&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlExternalDataSource>>> listExternalDataSourcesSinglePageAsync(final String accountName, final String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listExternalDataSources(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlExternalDataSource>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlExternalDataSource>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlExternalDataSource>> result = listExternalDataSourcesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlExternalDataSource>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data sources.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlExternalDataSource&gt; object if successful.
     */
    public PagedList<USqlExternalDataSource> listExternalDataSources(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<USqlExternalDataSource>> response = listExternalDataSourcesSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlExternalDataSource>(response.body()) {
            @Override
            public Page<USqlExternalDataSource> nextPage(String nextPageLink) {
                return listExternalDataSourcesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data sources.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlExternalDataSource>> listExternalDataSourcesAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlExternalDataSource> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listExternalDataSourcesSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<USqlExternalDataSource>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlExternalDataSource>>> call(String nextPageLink) {
                    return listExternalDataSourcesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data sources.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlExternalDataSource&gt; object
     */
    public Observable<Page<USqlExternalDataSource>> listExternalDataSourcesAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listExternalDataSourcesWithServiceResponseAsync(accountName, databaseName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<USqlExternalDataSource>>, Page<USqlExternalDataSource>>() {
                @Override
                public Page<USqlExternalDataSource> call(ServiceResponse<Page<USqlExternalDataSource>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data sources.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlExternalDataSource&gt; object
     */
    public Observable<ServiceResponse<Page<USqlExternalDataSource>>> listExternalDataSourcesWithServiceResponseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listExternalDataSourcesSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<USqlExternalDataSource>>, Observable<ServiceResponse<Page<USqlExternalDataSource>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlExternalDataSource>>> call(ServiceResponse<Page<USqlExternalDataSource>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listExternalDataSourcesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlExternalDataSource>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlExternalDataSource>> * @param databaseName The name of the database containing the external data sources.
    ServiceResponse<PageImpl<USqlExternalDataSource>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlExternalDataSource>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlExternalDataSource>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlExternalDataSource>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlExternalDataSource>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlExternalDataSource>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlExternalDataSource&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlExternalDataSource>>> listExternalDataSourcesSinglePageAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listExternalDataSources(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlExternalDataSource>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlExternalDataSource>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlExternalDataSource>> result = listExternalDataSourcesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlExternalDataSource>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlExternalDataSource>> listExternalDataSourcesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlExternalDataSource>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlExternalDataSource>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the specified procedure from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedure.
     * @param schemaName The name of the schema containing the procedure.
     * @param procedureName The name of the procedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlProcedure object if successful.
     */
    public USqlProcedure getProcedure(String accountName, String databaseName, String schemaName, String procedureName) {
        return getProcedureWithServiceResponseAsync(accountName, databaseName, schemaName, procedureName).toBlocking().single().body();
    }

    /**
     * Retrieves the specified procedure from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedure.
     * @param schemaName The name of the schema containing the procedure.
     * @param procedureName The name of the procedure.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<USqlProcedure> getProcedureAsync(String accountName, String databaseName, String schemaName, String procedureName, final ServiceCallback<USqlProcedure> serviceCallback) {
        return ServiceFuture.fromResponse(getProcedureWithServiceResponseAsync(accountName, databaseName, schemaName, procedureName), serviceCallback);
    }

    /**
     * Retrieves the specified procedure from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedure.
     * @param schemaName The name of the schema containing the procedure.
     * @param procedureName The name of the procedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlProcedure object
     */
    public Observable<USqlProcedure> getProcedureAsync(String accountName, String databaseName, String schemaName, String procedureName) {
        return getProcedureWithServiceResponseAsync(accountName, databaseName, schemaName, procedureName).map(new Func1<ServiceResponse<USqlProcedure>, USqlProcedure>() {
            @Override
            public USqlProcedure call(ServiceResponse<USqlProcedure> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the specified procedure from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedure.
     * @param schemaName The name of the schema containing the procedure.
     * @param procedureName The name of the procedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlProcedure object
     */
    public Observable<ServiceResponse<USqlProcedure>> getProcedureWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String procedureName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (procedureName == null) {
            throw new IllegalArgumentException("Parameter procedureName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.getProcedure(databaseName, schemaName, procedureName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlProcedure>>>() {
                @Override
                public Observable<ServiceResponse<USqlProcedure>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<USqlProcedure> clientResponse = getProcedureDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<USqlProcedure> getProcedureDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<USqlProcedure, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<USqlProcedure>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedures.
     * @param schemaName The name of the schema containing the procedures.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlProcedure&gt; object if successful.
     */
    public PagedList<USqlProcedure> listProcedures(final String accountName, final String databaseName, final String schemaName) {
        ServiceResponse<Page<USqlProcedure>> response = listProceduresSinglePageAsync(accountName, databaseName, schemaName).toBlocking().single();
        return new PagedList<USqlProcedure>(response.body()) {
            @Override
            public Page<USqlProcedure> nextPage(String nextPageLink) {
                return listProceduresNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedures.
     * @param schemaName The name of the schema containing the procedures.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlProcedure>> listProceduresAsync(final String accountName, final String databaseName, final String schemaName, final ListOperationCallback<USqlProcedure> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listProceduresSinglePageAsync(accountName, databaseName, schemaName),
            new Func1<String, Observable<ServiceResponse<Page<USqlProcedure>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlProcedure>>> call(String nextPageLink) {
                    return listProceduresNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedures.
     * @param schemaName The name of the schema containing the procedures.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlProcedure&gt; object
     */
    public Observable<Page<USqlProcedure>> listProceduresAsync(final String accountName, final String databaseName, final String schemaName) {
        return listProceduresWithServiceResponseAsync(accountName, databaseName, schemaName)
            .map(new Func1<ServiceResponse<Page<USqlProcedure>>, Page<USqlProcedure>>() {
                @Override
                public Page<USqlProcedure> call(ServiceResponse<Page<USqlProcedure>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedures.
     * @param schemaName The name of the schema containing the procedures.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlProcedure&gt; object
     */
    public Observable<ServiceResponse<Page<USqlProcedure>>> listProceduresWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName) {
        return listProceduresSinglePageAsync(accountName, databaseName, schemaName)
            .concatMap(new Func1<ServiceResponse<Page<USqlProcedure>>, Observable<ServiceResponse<Page<USqlProcedure>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlProcedure>>> call(ServiceResponse<Page<USqlProcedure>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listProceduresNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedures.
     * @param schemaName The name of the schema containing the procedures.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlProcedure&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlProcedure>>> listProceduresSinglePageAsync(final String accountName, final String databaseName, final String schemaName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listProcedures(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlProcedure>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlProcedure>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlProcedure>> result = listProceduresDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlProcedure>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedures.
     * @param schemaName The name of the schema containing the procedures.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlProcedure&gt; object if successful.
     */
    public PagedList<USqlProcedure> listProcedures(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<USqlProcedure>> response = listProceduresSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlProcedure>(response.body()) {
            @Override
            public Page<USqlProcedure> nextPage(String nextPageLink) {
                return listProceduresNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedures.
     * @param schemaName The name of the schema containing the procedures.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlProcedure>> listProceduresAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlProcedure> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listProceduresSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<USqlProcedure>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlProcedure>>> call(String nextPageLink) {
                    return listProceduresNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedures.
     * @param schemaName The name of the schema containing the procedures.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlProcedure&gt; object
     */
    public Observable<Page<USqlProcedure>> listProceduresAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listProceduresWithServiceResponseAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<USqlProcedure>>, Page<USqlProcedure>>() {
                @Override
                public Page<USqlProcedure> call(ServiceResponse<Page<USqlProcedure>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedures.
     * @param schemaName The name of the schema containing the procedures.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlProcedure&gt; object
     */
    public Observable<ServiceResponse<Page<USqlProcedure>>> listProceduresWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listProceduresSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<USqlProcedure>>, Observable<ServiceResponse<Page<USqlProcedure>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlProcedure>>> call(ServiceResponse<Page<USqlProcedure>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listProceduresNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlProcedure>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlProcedure>> * @param databaseName The name of the database containing the procedures.
    ServiceResponse<PageImpl<USqlProcedure>> * @param schemaName The name of the schema containing the procedures.
    ServiceResponse<PageImpl<USqlProcedure>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlProcedure>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlProcedure>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlProcedure>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlProcedure>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlProcedure>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlProcedure&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlProcedure>>> listProceduresSinglePageAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listProcedures(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlProcedure>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlProcedure>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlProcedure>> result = listProceduresDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlProcedure>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlProcedure>> listProceduresDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlProcedure>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlProcedure>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the specified table from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlTable object if successful.
     */
    public USqlTable getTable(String accountName, String databaseName, String schemaName, String tableName) {
        return getTableWithServiceResponseAsync(accountName, databaseName, schemaName, tableName).toBlocking().single().body();
    }

    /**
     * Retrieves the specified table from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<USqlTable> getTableAsync(String accountName, String databaseName, String schemaName, String tableName, final ServiceCallback<USqlTable> serviceCallback) {
        return ServiceFuture.fromResponse(getTableWithServiceResponseAsync(accountName, databaseName, schemaName, tableName), serviceCallback);
    }

    /**
     * Retrieves the specified table from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTable object
     */
    public Observable<USqlTable> getTableAsync(String accountName, String databaseName, String schemaName, String tableName) {
        return getTableWithServiceResponseAsync(accountName, databaseName, schemaName, tableName).map(new Func1<ServiceResponse<USqlTable>, USqlTable>() {
            @Override
            public USqlTable call(ServiceResponse<USqlTable> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the specified table from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTable object
     */
    public Observable<ServiceResponse<USqlTable>> getTableWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.getTable(databaseName, schemaName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlTable>>>() {
                @Override
                public Observable<ServiceResponse<USqlTable>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<USqlTable> clientResponse = getTableDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<USqlTable> getTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<USqlTable, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<USqlTable>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table fragments.
     * @param schemaName The name of the schema containing the table fragments.
     * @param tableName The name of the table containing the table fragments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableFragment&gt; object if successful.
     */
    public PagedList<USqlTableFragment> listTableFragments(final String accountName, final String databaseName, final String schemaName, final String tableName) {
        ServiceResponse<Page<USqlTableFragment>> response = listTableFragmentsSinglePageAsync(accountName, databaseName, schemaName, tableName).toBlocking().single();
        return new PagedList<USqlTableFragment>(response.body()) {
            @Override
            public Page<USqlTableFragment> nextPage(String nextPageLink) {
                return listTableFragmentsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table fragments.
     * @param schemaName The name of the schema containing the table fragments.
     * @param tableName The name of the table containing the table fragments.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableFragment>> listTableFragmentsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final ListOperationCallback<USqlTableFragment> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableFragmentsSinglePageAsync(accountName, databaseName, schemaName, tableName),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableFragment>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableFragment>>> call(String nextPageLink) {
                    return listTableFragmentsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table fragments.
     * @param schemaName The name of the schema containing the table fragments.
     * @param tableName The name of the table containing the table fragments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableFragment&gt; object
     */
    public Observable<Page<USqlTableFragment>> listTableFragmentsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName) {
        return listTableFragmentsWithServiceResponseAsync(accountName, databaseName, schemaName, tableName)
            .map(new Func1<ServiceResponse<Page<USqlTableFragment>>, Page<USqlTableFragment>>() {
                @Override
                public Page<USqlTableFragment> call(ServiceResponse<Page<USqlTableFragment>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table fragments.
     * @param schemaName The name of the schema containing the table fragments.
     * @param tableName The name of the table containing the table fragments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableFragment&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableFragment>>> listTableFragmentsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String tableName) {
        return listTableFragmentsSinglePageAsync(accountName, databaseName, schemaName, tableName)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableFragment>>, Observable<ServiceResponse<Page<USqlTableFragment>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableFragment>>> call(ServiceResponse<Page<USqlTableFragment>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableFragmentsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table fragments.
     * @param schemaName The name of the schema containing the table fragments.
     * @param tableName The name of the table containing the table fragments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableFragment&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableFragment>>> listTableFragmentsSinglePageAsync(final String accountName, final String databaseName, final String schemaName, final String tableName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTableFragments(databaseName, schemaName, tableName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableFragment>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableFragment>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableFragment>> result = listTableFragmentsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableFragment>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table fragments.
     * @param schemaName The name of the schema containing the table fragments.
     * @param tableName The name of the table containing the table fragments.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableFragment&gt; object if successful.
     */
    public PagedList<USqlTableFragment> listTableFragments(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<USqlTableFragment>> response = listTableFragmentsSinglePageAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlTableFragment>(response.body()) {
            @Override
            public Page<USqlTableFragment> nextPage(String nextPageLink) {
                return listTableFragmentsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table fragments.
     * @param schemaName The name of the schema containing the table fragments.
     * @param tableName The name of the table containing the table fragments.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableFragment>> listTableFragmentsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlTableFragment> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableFragmentsSinglePageAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableFragment>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableFragment>>> call(String nextPageLink) {
                    return listTableFragmentsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table fragments.
     * @param schemaName The name of the schema containing the table fragments.
     * @param tableName The name of the table containing the table fragments.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableFragment&gt; object
     */
    public Observable<Page<USqlTableFragment>> listTableFragmentsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listTableFragmentsWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<USqlTableFragment>>, Page<USqlTableFragment>>() {
                @Override
                public Page<USqlTableFragment> call(ServiceResponse<Page<USqlTableFragment>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table fragments.
     * @param schemaName The name of the schema containing the table fragments.
     * @param tableName The name of the table containing the table fragments.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableFragment&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableFragment>>> listTableFragmentsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listTableFragmentsSinglePageAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableFragment>>, Observable<ServiceResponse<Page<USqlTableFragment>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableFragment>>> call(ServiceResponse<Page<USqlTableFragment>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableFragmentsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTableFragment>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlTableFragment>> * @param databaseName The name of the database containing the table fragments.
    ServiceResponse<PageImpl<USqlTableFragment>> * @param schemaName The name of the schema containing the table fragments.
    ServiceResponse<PageImpl<USqlTableFragment>> * @param tableName The name of the table containing the table fragments.
    ServiceResponse<PageImpl<USqlTableFragment>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlTableFragment>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlTableFragment>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlTableFragment>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlTableFragment>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlTableFragment>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableFragment&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableFragment>>> listTableFragmentsSinglePageAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTableFragments(databaseName, schemaName, tableName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableFragment>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableFragment>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableFragment>> result = listTableFragmentsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableFragment>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTableFragment>> listTableFragmentsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTableFragment>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTableFragment>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param schemaName The name of the schema containing the tables.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTable&gt; object if successful.
     */
    public PagedList<USqlTable> listTables(final String accountName, final String databaseName, final String schemaName) {
        ServiceResponse<Page<USqlTable>> response = listTablesSinglePageAsync(accountName, databaseName, schemaName).toBlocking().single();
        return new PagedList<USqlTable>(response.body()) {
            @Override
            public Page<USqlTable> nextPage(String nextPageLink) {
                return listTablesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param schemaName The name of the schema containing the tables.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTable>> listTablesAsync(final String accountName, final String databaseName, final String schemaName, final ListOperationCallback<USqlTable> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTablesSinglePageAsync(accountName, databaseName, schemaName),
            new Func1<String, Observable<ServiceResponse<Page<USqlTable>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTable>>> call(String nextPageLink) {
                    return listTablesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param schemaName The name of the schema containing the tables.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    public Observable<Page<USqlTable>> listTablesAsync(final String accountName, final String databaseName, final String schemaName) {
        return listTablesWithServiceResponseAsync(accountName, databaseName, schemaName)
            .map(new Func1<ServiceResponse<Page<USqlTable>>, Page<USqlTable>>() {
                @Override
                public Page<USqlTable> call(ServiceResponse<Page<USqlTable>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param schemaName The name of the schema containing the tables.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTable>>> listTablesWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName) {
        return listTablesSinglePageAsync(accountName, databaseName, schemaName)
            .concatMap(new Func1<ServiceResponse<Page<USqlTable>>, Observable<ServiceResponse<Page<USqlTable>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTable>>> call(ServiceResponse<Page<USqlTable>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTablesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param schemaName The name of the schema containing the tables.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTable&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTable>>> listTablesSinglePageAsync(final String accountName, final String databaseName, final String schemaName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        final Boolean basic = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTables(databaseName, schemaName, filter, top, skip, select, orderby, count, basic, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTable>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTable>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTable>> result = listTablesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTable>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param schemaName The name of the schema containing the tables.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param basic The basic switch indicates what level of information to return when listing tables. When basic is true, only database_name, schema_name, table_name and version are returned for each table, otherwise all table metadata is returned. By default, it is false. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTable&gt; object if successful.
     */
    public PagedList<USqlTable> listTables(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final Boolean basic) {
        ServiceResponse<Page<USqlTable>> response = listTablesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count, basic).toBlocking().single();
        return new PagedList<USqlTable>(response.body()) {
            @Override
            public Page<USqlTable> nextPage(String nextPageLink) {
                return listTablesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param schemaName The name of the schema containing the tables.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param basic The basic switch indicates what level of information to return when listing tables. When basic is true, only database_name, schema_name, table_name and version are returned for each table, otherwise all table metadata is returned. By default, it is false. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTable>> listTablesAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final Boolean basic, final ListOperationCallback<USqlTable> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTablesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count, basic),
            new Func1<String, Observable<ServiceResponse<Page<USqlTable>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTable>>> call(String nextPageLink) {
                    return listTablesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param schemaName The name of the schema containing the tables.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param basic The basic switch indicates what level of information to return when listing tables. When basic is true, only database_name, schema_name, table_name and version are returned for each table, otherwise all table metadata is returned. By default, it is false. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    public Observable<Page<USqlTable>> listTablesAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final Boolean basic) {
        return listTablesWithServiceResponseAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count, basic)
            .map(new Func1<ServiceResponse<Page<USqlTable>>, Page<USqlTable>>() {
                @Override
                public Page<USqlTable> call(ServiceResponse<Page<USqlTable>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param schemaName The name of the schema containing the tables.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param basic The basic switch indicates what level of information to return when listing tables. When basic is true, only database_name, schema_name, table_name and version are returned for each table, otherwise all table metadata is returned. By default, it is false. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTable>>> listTablesWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final Boolean basic) {
        return listTablesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count, basic)
            .concatMap(new Func1<ServiceResponse<Page<USqlTable>>, Observable<ServiceResponse<Page<USqlTable>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTable>>> call(ServiceResponse<Page<USqlTable>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTablesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTable>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlTable>> * @param databaseName The name of the database containing the tables.
    ServiceResponse<PageImpl<USqlTable>> * @param schemaName The name of the schema containing the tables.
    ServiceResponse<PageImpl<USqlTable>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlTable>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlTable>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlTable>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlTable>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlTable>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
    ServiceResponse<PageImpl<USqlTable>> * @param basic The basic switch indicates what level of information to return when listing tables. When basic is true, only database_name, schema_name, table_name and version are returned for each table, otherwise all table metadata is returned. By default, it is false. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTable&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTable>>> listTablesSinglePageAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final Boolean basic) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTables(databaseName, schemaName, filter, top, skip, select, orderby, count, basic, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTable>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTable>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTable>> result = listTablesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTable>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTable>> listTablesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTable>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTable>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableStatistics&gt; object if successful.
     */
    public PagedList<USqlTableStatistics> listTableStatisticsByDatabaseAndSchema(final String accountName, final String databaseName, final String schemaName) {
        ServiceResponse<Page<USqlTableStatistics>> response = listTableStatisticsByDatabaseAndSchemaSinglePageAsync(accountName, databaseName, schemaName).toBlocking().single();
        return new PagedList<USqlTableStatistics>(response.body()) {
            @Override
            public Page<USqlTableStatistics> nextPage(String nextPageLink) {
                return listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaAsync(final String accountName, final String databaseName, final String schemaName, final ListOperationCallback<USqlTableStatistics> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableStatisticsByDatabaseAndSchemaSinglePageAsync(accountName, databaseName, schemaName),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(String nextPageLink) {
                    return listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    public Observable<Page<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaAsync(final String accountName, final String databaseName, final String schemaName) {
        return listTableStatisticsByDatabaseAndSchemaWithServiceResponseAsync(accountName, databaseName, schemaName)
            .map(new Func1<ServiceResponse<Page<USqlTableStatistics>>, Page<USqlTableStatistics>>() {
                @Override
                public Page<USqlTableStatistics> call(ServiceResponse<Page<USqlTableStatistics>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseAndSchemaWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName) {
        return listTableStatisticsByDatabaseAndSchemaSinglePageAsync(accountName, databaseName, schemaName)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableStatistics>>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(ServiceResponse<Page<USqlTableStatistics>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableStatisticsByDatabaseAndSchemaNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableStatistics&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseAndSchemaSinglePageAsync(final String accountName, final String databaseName, final String schemaName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTableStatisticsByDatabaseAndSchema(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableStatistics>> result = listTableStatisticsByDatabaseAndSchemaDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableStatistics>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableStatistics&gt; object if successful.
     */
    public PagedList<USqlTableStatistics> listTableStatisticsByDatabaseAndSchema(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<USqlTableStatistics>> response = listTableStatisticsByDatabaseAndSchemaSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlTableStatistics>(response.body()) {
            @Override
            public Page<USqlTableStatistics> nextPage(String nextPageLink) {
                return listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlTableStatistics> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableStatisticsByDatabaseAndSchemaSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(String nextPageLink) {
                    return listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    public Observable<Page<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listTableStatisticsByDatabaseAndSchemaWithServiceResponseAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<USqlTableStatistics>>, Page<USqlTableStatistics>>() {
                @Override
                public Page<USqlTableStatistics> call(ServiceResponse<Page<USqlTableStatistics>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseAndSchemaWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listTableStatisticsByDatabaseAndSchemaSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableStatistics>>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(ServiceResponse<Page<USqlTableStatistics>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableStatisticsByDatabaseAndSchemaNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param databaseName The name of the database containing the statistics.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param schemaName The name of the schema containing the statistics.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableStatistics&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseAndSchemaSinglePageAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTableStatisticsByDatabaseAndSchema(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableStatistics>> result = listTableStatisticsByDatabaseAndSchemaDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableStatistics>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTableStatistics>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTableStatistics>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the specified table type from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table type.
     * @param schemaName The name of the schema containing the table type.
     * @param tableTypeName The name of the table type to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlTableType object if successful.
     */
    public USqlTableType getTableType(String accountName, String databaseName, String schemaName, String tableTypeName) {
        return getTableTypeWithServiceResponseAsync(accountName, databaseName, schemaName, tableTypeName).toBlocking().single().body();
    }

    /**
     * Retrieves the specified table type from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table type.
     * @param schemaName The name of the schema containing the table type.
     * @param tableTypeName The name of the table type to retrieve.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<USqlTableType> getTableTypeAsync(String accountName, String databaseName, String schemaName, String tableTypeName, final ServiceCallback<USqlTableType> serviceCallback) {
        return ServiceFuture.fromResponse(getTableTypeWithServiceResponseAsync(accountName, databaseName, schemaName, tableTypeName), serviceCallback);
    }

    /**
     * Retrieves the specified table type from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table type.
     * @param schemaName The name of the schema containing the table type.
     * @param tableTypeName The name of the table type to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTableType object
     */
    public Observable<USqlTableType> getTableTypeAsync(String accountName, String databaseName, String schemaName, String tableTypeName) {
        return getTableTypeWithServiceResponseAsync(accountName, databaseName, schemaName, tableTypeName).map(new Func1<ServiceResponse<USqlTableType>, USqlTableType>() {
            @Override
            public USqlTableType call(ServiceResponse<USqlTableType> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the specified table type from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table type.
     * @param schemaName The name of the schema containing the table type.
     * @param tableTypeName The name of the table type to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTableType object
     */
    public Observable<ServiceResponse<USqlTableType>> getTableTypeWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableTypeName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableTypeName == null) {
            throw new IllegalArgumentException("Parameter tableTypeName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.getTableType(databaseName, schemaName, tableTypeName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlTableType>>>() {
                @Override
                public Observable<ServiceResponse<USqlTableType>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<USqlTableType> clientResponse = getTableTypeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<USqlTableType> getTableTypeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<USqlTableType, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<USqlTableType>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table types.
     * @param schemaName The name of the schema containing the table types.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableType&gt; object if successful.
     */
    public PagedList<USqlTableType> listTableTypes(final String accountName, final String databaseName, final String schemaName) {
        ServiceResponse<Page<USqlTableType>> response = listTableTypesSinglePageAsync(accountName, databaseName, schemaName).toBlocking().single();
        return new PagedList<USqlTableType>(response.body()) {
            @Override
            public Page<USqlTableType> nextPage(String nextPageLink) {
                return listTableTypesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table types.
     * @param schemaName The name of the schema containing the table types.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableType>> listTableTypesAsync(final String accountName, final String databaseName, final String schemaName, final ListOperationCallback<USqlTableType> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableTypesSinglePageAsync(accountName, databaseName, schemaName),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableType>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableType>>> call(String nextPageLink) {
                    return listTableTypesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table types.
     * @param schemaName The name of the schema containing the table types.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableType&gt; object
     */
    public Observable<Page<USqlTableType>> listTableTypesAsync(final String accountName, final String databaseName, final String schemaName) {
        return listTableTypesWithServiceResponseAsync(accountName, databaseName, schemaName)
            .map(new Func1<ServiceResponse<Page<USqlTableType>>, Page<USqlTableType>>() {
                @Override
                public Page<USqlTableType> call(ServiceResponse<Page<USqlTableType>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table types.
     * @param schemaName The name of the schema containing the table types.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableType&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableType>>> listTableTypesWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName) {
        return listTableTypesSinglePageAsync(accountName, databaseName, schemaName)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableType>>, Observable<ServiceResponse<Page<USqlTableType>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableType>>> call(ServiceResponse<Page<USqlTableType>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableTypesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table types.
     * @param schemaName The name of the schema containing the table types.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableType&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableType>>> listTableTypesSinglePageAsync(final String accountName, final String databaseName, final String schemaName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTableTypes(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableType>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableType>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableType>> result = listTableTypesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableType>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table types.
     * @param schemaName The name of the schema containing the table types.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableType&gt; object if successful.
     */
    public PagedList<USqlTableType> listTableTypes(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<USqlTableType>> response = listTableTypesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlTableType>(response.body()) {
            @Override
            public Page<USqlTableType> nextPage(String nextPageLink) {
                return listTableTypesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table types.
     * @param schemaName The name of the schema containing the table types.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableType>> listTableTypesAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlTableType> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableTypesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableType>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableType>>> call(String nextPageLink) {
                    return listTableTypesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table types.
     * @param schemaName The name of the schema containing the table types.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableType&gt; object
     */
    public Observable<Page<USqlTableType>> listTableTypesAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listTableTypesWithServiceResponseAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<USqlTableType>>, Page<USqlTableType>>() {
                @Override
                public Page<USqlTableType> call(ServiceResponse<Page<USqlTableType>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table types.
     * @param schemaName The name of the schema containing the table types.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableType&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableType>>> listTableTypesWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listTableTypesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableType>>, Observable<ServiceResponse<Page<USqlTableType>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableType>>> call(ServiceResponse<Page<USqlTableType>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableTypesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTableType>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlTableType>> * @param databaseName The name of the database containing the table types.
    ServiceResponse<PageImpl<USqlTableType>> * @param schemaName The name of the schema containing the table types.
    ServiceResponse<PageImpl<USqlTableType>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlTableType>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlTableType>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlTableType>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlTableType>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlTableType>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableType&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableType>>> listTableTypesSinglePageAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTableTypes(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableType>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableType>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableType>> result = listTableTypesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableType>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTableType>> listTableTypesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTableType>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTableType>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the specified package from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the package.
     * @param schemaName The name of the schema containing the package.
     * @param packageName The name of the package.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlPackage object if successful.
     */
    public USqlPackage getPackage(String accountName, String databaseName, String schemaName, String packageName) {
        return getPackageWithServiceResponseAsync(accountName, databaseName, schemaName, packageName).toBlocking().single().body();
    }

    /**
     * Retrieves the specified package from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the package.
     * @param schemaName The name of the schema containing the package.
     * @param packageName The name of the package.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<USqlPackage> getPackageAsync(String accountName, String databaseName, String schemaName, String packageName, final ServiceCallback<USqlPackage> serviceCallback) {
        return ServiceFuture.fromResponse(getPackageWithServiceResponseAsync(accountName, databaseName, schemaName, packageName), serviceCallback);
    }

    /**
     * Retrieves the specified package from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the package.
     * @param schemaName The name of the schema containing the package.
     * @param packageName The name of the package.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlPackage object
     */
    public Observable<USqlPackage> getPackageAsync(String accountName, String databaseName, String schemaName, String packageName) {
        return getPackageWithServiceResponseAsync(accountName, databaseName, schemaName, packageName).map(new Func1<ServiceResponse<USqlPackage>, USqlPackage>() {
            @Override
            public USqlPackage call(ServiceResponse<USqlPackage> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the specified package from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the package.
     * @param schemaName The name of the schema containing the package.
     * @param packageName The name of the package.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlPackage object
     */
    public Observable<ServiceResponse<USqlPackage>> getPackageWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String packageName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("Parameter packageName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.getPackage(databaseName, schemaName, packageName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlPackage>>>() {
                @Override
                public Observable<ServiceResponse<USqlPackage>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<USqlPackage> clientResponse = getPackageDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<USqlPackage> getPackageDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<USqlPackage, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<USqlPackage>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the packages.
     * @param schemaName The name of the schema containing the packages.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlPackage&gt; object if successful.
     */
    public PagedList<USqlPackage> listPackages(final String accountName, final String databaseName, final String schemaName) {
        ServiceResponse<Page<USqlPackage>> response = listPackagesSinglePageAsync(accountName, databaseName, schemaName).toBlocking().single();
        return new PagedList<USqlPackage>(response.body()) {
            @Override
            public Page<USqlPackage> nextPage(String nextPageLink) {
                return listPackagesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the packages.
     * @param schemaName The name of the schema containing the packages.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlPackage>> listPackagesAsync(final String accountName, final String databaseName, final String schemaName, final ListOperationCallback<USqlPackage> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listPackagesSinglePageAsync(accountName, databaseName, schemaName),
            new Func1<String, Observable<ServiceResponse<Page<USqlPackage>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlPackage>>> call(String nextPageLink) {
                    return listPackagesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the packages.
     * @param schemaName The name of the schema containing the packages.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlPackage&gt; object
     */
    public Observable<Page<USqlPackage>> listPackagesAsync(final String accountName, final String databaseName, final String schemaName) {
        return listPackagesWithServiceResponseAsync(accountName, databaseName, schemaName)
            .map(new Func1<ServiceResponse<Page<USqlPackage>>, Page<USqlPackage>>() {
                @Override
                public Page<USqlPackage> call(ServiceResponse<Page<USqlPackage>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the packages.
     * @param schemaName The name of the schema containing the packages.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlPackage&gt; object
     */
    public Observable<ServiceResponse<Page<USqlPackage>>> listPackagesWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName) {
        return listPackagesSinglePageAsync(accountName, databaseName, schemaName)
            .concatMap(new Func1<ServiceResponse<Page<USqlPackage>>, Observable<ServiceResponse<Page<USqlPackage>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlPackage>>> call(ServiceResponse<Page<USqlPackage>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listPackagesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the packages.
     * @param schemaName The name of the schema containing the packages.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlPackage&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlPackage>>> listPackagesSinglePageAsync(final String accountName, final String databaseName, final String schemaName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listPackages(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlPackage>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlPackage>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlPackage>> result = listPackagesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlPackage>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the packages.
     * @param schemaName The name of the schema containing the packages.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlPackage&gt; object if successful.
     */
    public PagedList<USqlPackage> listPackages(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<USqlPackage>> response = listPackagesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlPackage>(response.body()) {
            @Override
            public Page<USqlPackage> nextPage(String nextPageLink) {
                return listPackagesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the packages.
     * @param schemaName The name of the schema containing the packages.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlPackage>> listPackagesAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlPackage> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listPackagesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<USqlPackage>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlPackage>>> call(String nextPageLink) {
                    return listPackagesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the packages.
     * @param schemaName The name of the schema containing the packages.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlPackage&gt; object
     */
    public Observable<Page<USqlPackage>> listPackagesAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listPackagesWithServiceResponseAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<USqlPackage>>, Page<USqlPackage>>() {
                @Override
                public Page<USqlPackage> call(ServiceResponse<Page<USqlPackage>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the packages.
     * @param schemaName The name of the schema containing the packages.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlPackage&gt; object
     */
    public Observable<ServiceResponse<Page<USqlPackage>>> listPackagesWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listPackagesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<USqlPackage>>, Observable<ServiceResponse<Page<USqlPackage>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlPackage>>> call(ServiceResponse<Page<USqlPackage>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listPackagesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlPackage>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlPackage>> * @param databaseName The name of the database containing the packages.
    ServiceResponse<PageImpl<USqlPackage>> * @param schemaName The name of the schema containing the packages.
    ServiceResponse<PageImpl<USqlPackage>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlPackage>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlPackage>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlPackage>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlPackage>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlPackage>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlPackage&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlPackage>>> listPackagesSinglePageAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listPackages(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlPackage>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlPackage>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlPackage>> result = listPackagesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlPackage>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlPackage>> listPackagesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlPackage>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlPackage>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the specified view from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the view.
     * @param schemaName The name of the schema containing the view.
     * @param viewName The name of the view.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlView object if successful.
     */
    public USqlView getView(String accountName, String databaseName, String schemaName, String viewName) {
        return getViewWithServiceResponseAsync(accountName, databaseName, schemaName, viewName).toBlocking().single().body();
    }

    /**
     * Retrieves the specified view from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the view.
     * @param schemaName The name of the schema containing the view.
     * @param viewName The name of the view.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<USqlView> getViewAsync(String accountName, String databaseName, String schemaName, String viewName, final ServiceCallback<USqlView> serviceCallback) {
        return ServiceFuture.fromResponse(getViewWithServiceResponseAsync(accountName, databaseName, schemaName, viewName), serviceCallback);
    }

    /**
     * Retrieves the specified view from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the view.
     * @param schemaName The name of the schema containing the view.
     * @param viewName The name of the view.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlView object
     */
    public Observable<USqlView> getViewAsync(String accountName, String databaseName, String schemaName, String viewName) {
        return getViewWithServiceResponseAsync(accountName, databaseName, schemaName, viewName).map(new Func1<ServiceResponse<USqlView>, USqlView>() {
            @Override
            public USqlView call(ServiceResponse<USqlView> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the specified view from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the view.
     * @param schemaName The name of the schema containing the view.
     * @param viewName The name of the view.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlView object
     */
    public Observable<ServiceResponse<USqlView>> getViewWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String viewName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (viewName == null) {
            throw new IllegalArgumentException("Parameter viewName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.getView(databaseName, schemaName, viewName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlView>>>() {
                @Override
                public Observable<ServiceResponse<USqlView>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<USqlView> clientResponse = getViewDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<USqlView> getViewDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<USqlView, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<USqlView>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param schemaName The name of the schema containing the views.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlView&gt; object if successful.
     */
    public PagedList<USqlView> listViews(final String accountName, final String databaseName, final String schemaName) {
        ServiceResponse<Page<USqlView>> response = listViewsSinglePageAsync(accountName, databaseName, schemaName).toBlocking().single();
        return new PagedList<USqlView>(response.body()) {
            @Override
            public Page<USqlView> nextPage(String nextPageLink) {
                return listViewsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param schemaName The name of the schema containing the views.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlView>> listViewsAsync(final String accountName, final String databaseName, final String schemaName, final ListOperationCallback<USqlView> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listViewsSinglePageAsync(accountName, databaseName, schemaName),
            new Func1<String, Observable<ServiceResponse<Page<USqlView>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlView>>> call(String nextPageLink) {
                    return listViewsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param schemaName The name of the schema containing the views.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    public Observable<Page<USqlView>> listViewsAsync(final String accountName, final String databaseName, final String schemaName) {
        return listViewsWithServiceResponseAsync(accountName, databaseName, schemaName)
            .map(new Func1<ServiceResponse<Page<USqlView>>, Page<USqlView>>() {
                @Override
                public Page<USqlView> call(ServiceResponse<Page<USqlView>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param schemaName The name of the schema containing the views.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    public Observable<ServiceResponse<Page<USqlView>>> listViewsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName) {
        return listViewsSinglePageAsync(accountName, databaseName, schemaName)
            .concatMap(new Func1<ServiceResponse<Page<USqlView>>, Observable<ServiceResponse<Page<USqlView>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlView>>> call(ServiceResponse<Page<USqlView>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listViewsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param schemaName The name of the schema containing the views.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlView&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlView>>> listViewsSinglePageAsync(final String accountName, final String databaseName, final String schemaName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listViews(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlView>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlView>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlView>> result = listViewsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlView>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param schemaName The name of the schema containing the views.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlView&gt; object if successful.
     */
    public PagedList<USqlView> listViews(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<USqlView>> response = listViewsSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlView>(response.body()) {
            @Override
            public Page<USqlView> nextPage(String nextPageLink) {
                return listViewsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param schemaName The name of the schema containing the views.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlView>> listViewsAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlView> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listViewsSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<USqlView>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlView>>> call(String nextPageLink) {
                    return listViewsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param schemaName The name of the schema containing the views.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    public Observable<Page<USqlView>> listViewsAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listViewsWithServiceResponseAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<USqlView>>, Page<USqlView>>() {
                @Override
                public Page<USqlView> call(ServiceResponse<Page<USqlView>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param schemaName The name of the schema containing the views.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    public Observable<ServiceResponse<Page<USqlView>>> listViewsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listViewsSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<USqlView>>, Observable<ServiceResponse<Page<USqlView>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlView>>> call(ServiceResponse<Page<USqlView>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listViewsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlView>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlView>> * @param databaseName The name of the database containing the views.
    ServiceResponse<PageImpl<USqlView>> * @param schemaName The name of the schema containing the views.
    ServiceResponse<PageImpl<USqlView>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlView>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlView>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlView>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlView>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlView>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlView&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlView>>> listViewsSinglePageAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listViews(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlView>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlView>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlView>> result = listViewsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlView>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlView>> listViewsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlView>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlView>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the specified table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @param statisticsName The name of the table statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlTableStatistics object if successful.
     */
    public USqlTableStatistics getTableStatistic(String accountName, String databaseName, String schemaName, String tableName, String statisticsName) {
        return getTableStatisticWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, statisticsName).toBlocking().single().body();
    }

    /**
     * Retrieves the specified table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @param statisticsName The name of the table statistics.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<USqlTableStatistics> getTableStatisticAsync(String accountName, String databaseName, String schemaName, String tableName, String statisticsName, final ServiceCallback<USqlTableStatistics> serviceCallback) {
        return ServiceFuture.fromResponse(getTableStatisticWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, statisticsName), serviceCallback);
    }

    /**
     * Retrieves the specified table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @param statisticsName The name of the table statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTableStatistics object
     */
    public Observable<USqlTableStatistics> getTableStatisticAsync(String accountName, String databaseName, String schemaName, String tableName, String statisticsName) {
        return getTableStatisticWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, statisticsName).map(new Func1<ServiceResponse<USqlTableStatistics>, USqlTableStatistics>() {
            @Override
            public USqlTableStatistics call(ServiceResponse<USqlTableStatistics> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the specified table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @param statisticsName The name of the table statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTableStatistics object
     */
    public Observable<ServiceResponse<USqlTableStatistics>> getTableStatisticWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName, String statisticsName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (statisticsName == null) {
            throw new IllegalArgumentException("Parameter statisticsName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.getTableStatistic(databaseName, schemaName, tableName, statisticsName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlTableStatistics>>>() {
                @Override
                public Observable<ServiceResponse<USqlTableStatistics>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<USqlTableStatistics> clientResponse = getTableStatisticDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<USqlTableStatistics> getTableStatisticDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<USqlTableStatistics, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<USqlTableStatistics>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableStatistics&gt; object if successful.
     */
    public PagedList<USqlTableStatistics> listTableStatistics(final String accountName, final String databaseName, final String schemaName, final String tableName) {
        ServiceResponse<Page<USqlTableStatistics>> response = listTableStatisticsSinglePageAsync(accountName, databaseName, schemaName, tableName).toBlocking().single();
        return new PagedList<USqlTableStatistics>(response.body()) {
            @Override
            public Page<USqlTableStatistics> nextPage(String nextPageLink) {
                return listTableStatisticsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableStatistics>> listTableStatisticsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final ListOperationCallback<USqlTableStatistics> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableStatisticsSinglePageAsync(accountName, databaseName, schemaName, tableName),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(String nextPageLink) {
                    return listTableStatisticsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    public Observable<Page<USqlTableStatistics>> listTableStatisticsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName) {
        return listTableStatisticsWithServiceResponseAsync(accountName, databaseName, schemaName, tableName)
            .map(new Func1<ServiceResponse<Page<USqlTableStatistics>>, Page<USqlTableStatistics>>() {
                @Override
                public Page<USqlTableStatistics> call(ServiceResponse<Page<USqlTableStatistics>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String tableName) {
        return listTableStatisticsSinglePageAsync(accountName, databaseName, schemaName, tableName)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableStatistics>>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(ServiceResponse<Page<USqlTableStatistics>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableStatisticsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableStatistics&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsSinglePageAsync(final String accountName, final String databaseName, final String schemaName, final String tableName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTableStatistics(databaseName, schemaName, tableName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableStatistics>> result = listTableStatisticsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableStatistics>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableStatistics&gt; object if successful.
     */
    public PagedList<USqlTableStatistics> listTableStatistics(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<USqlTableStatistics>> response = listTableStatisticsSinglePageAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlTableStatistics>(response.body()) {
            @Override
            public Page<USqlTableStatistics> nextPage(String nextPageLink) {
                return listTableStatisticsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableStatistics>> listTableStatisticsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlTableStatistics> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableStatisticsSinglePageAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(String nextPageLink) {
                    return listTableStatisticsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    public Observable<Page<USqlTableStatistics>> listTableStatisticsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listTableStatisticsWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<USqlTableStatistics>>, Page<USqlTableStatistics>>() {
                @Override
                public Page<USqlTableStatistics> call(ServiceResponse<Page<USqlTableStatistics>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listTableStatisticsSinglePageAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableStatistics>>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(ServiceResponse<Page<USqlTableStatistics>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableStatisticsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param databaseName The name of the database containing the statistics.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param schemaName The name of the schema containing the statistics.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param tableName The name of the table containing the statistics.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableStatistics&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsSinglePageAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTableStatistics(databaseName, schemaName, tableName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableStatistics>> result = listTableStatisticsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableStatistics>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTableStatistics>> listTableStatisticsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTableStatistics>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTableStatistics>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves a preview set of rows in given partition.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlTablePreview object if successful.
     */
    public USqlTablePreview previewTablePartition(String accountName, String databaseName, String schemaName, String tableName, String partitionName) {
        return previewTablePartitionWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, partitionName).toBlocking().single().body();
    }

    /**
     * Retrieves a preview set of rows in given partition.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<USqlTablePreview> previewTablePartitionAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName, final ServiceCallback<USqlTablePreview> serviceCallback) {
        return ServiceFuture.fromResponse(previewTablePartitionWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, partitionName), serviceCallback);
    }

    /**
     * Retrieves a preview set of rows in given partition.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePreview object
     */
    public Observable<USqlTablePreview> previewTablePartitionAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName) {
        return previewTablePartitionWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, partitionName).map(new Func1<ServiceResponse<USqlTablePreview>, USqlTablePreview>() {
            @Override
            public USqlTablePreview call(ServiceResponse<USqlTablePreview> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves a preview set of rows in given partition.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePreview object
     */
    public Observable<ServiceResponse<USqlTablePreview>> previewTablePartitionWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (partitionName == null) {
            throw new IllegalArgumentException("Parameter partitionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Long maxRows = null;
        final Long maxColumns = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.previewTablePartition(databaseName, schemaName, tableName, partitionName, maxRows, maxColumns, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlTablePreview>>>() {
                @Override
                public Observable<ServiceResponse<USqlTablePreview>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<USqlTablePreview> clientResponse = previewTablePartitionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves a preview set of rows in given partition.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @param maxRows The maximum number of preview rows to be retrieved.Rows returned may be less than or equal to this number depending on row sizes and number of rows in the partition.
     * @param maxColumns The maximum number of columns to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlTablePreview object if successful.
     */
    public USqlTablePreview previewTablePartition(String accountName, String databaseName, String schemaName, String tableName, String partitionName, Long maxRows, Long maxColumns) {
        return previewTablePartitionWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, partitionName, maxRows, maxColumns).toBlocking().single().body();
    }

    /**
     * Retrieves a preview set of rows in given partition.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @param maxRows The maximum number of preview rows to be retrieved.Rows returned may be less than or equal to this number depending on row sizes and number of rows in the partition.
     * @param maxColumns The maximum number of columns to be retrieved.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<USqlTablePreview> previewTablePartitionAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName, Long maxRows, Long maxColumns, final ServiceCallback<USqlTablePreview> serviceCallback) {
        return ServiceFuture.fromResponse(previewTablePartitionWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, partitionName, maxRows, maxColumns), serviceCallback);
    }

    /**
     * Retrieves a preview set of rows in given partition.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @param maxRows The maximum number of preview rows to be retrieved.Rows returned may be less than or equal to this number depending on row sizes and number of rows in the partition.
     * @param maxColumns The maximum number of columns to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePreview object
     */
    public Observable<USqlTablePreview> previewTablePartitionAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName, Long maxRows, Long maxColumns) {
        return previewTablePartitionWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, partitionName, maxRows, maxColumns).map(new Func1<ServiceResponse<USqlTablePreview>, USqlTablePreview>() {
            @Override
            public USqlTablePreview call(ServiceResponse<USqlTablePreview> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves a preview set of rows in given partition.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @param maxRows The maximum number of preview rows to be retrieved.Rows returned may be less than or equal to this number depending on row sizes and number of rows in the partition.
     * @param maxColumns The maximum number of columns to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePreview object
     */
    public Observable<ServiceResponse<USqlTablePreview>> previewTablePartitionWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName, Long maxRows, Long maxColumns) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (partitionName == null) {
            throw new IllegalArgumentException("Parameter partitionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.previewTablePartition(databaseName, schemaName, tableName, partitionName, maxRows, maxColumns, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlTablePreview>>>() {
                @Override
                public Observable<ServiceResponse<USqlTablePreview>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<USqlTablePreview> clientResponse = previewTablePartitionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<USqlTablePreview> previewTablePartitionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<USqlTablePreview, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<USqlTablePreview>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the specified table partition from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlTablePartition object if successful.
     */
    public USqlTablePartition getTablePartition(String accountName, String databaseName, String schemaName, String tableName, String partitionName) {
        return getTablePartitionWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, partitionName).toBlocking().single().body();
    }

    /**
     * Retrieves the specified table partition from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<USqlTablePartition> getTablePartitionAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName, final ServiceCallback<USqlTablePartition> serviceCallback) {
        return ServiceFuture.fromResponse(getTablePartitionWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, partitionName), serviceCallback);
    }

    /**
     * Retrieves the specified table partition from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePartition object
     */
    public Observable<USqlTablePartition> getTablePartitionAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName) {
        return getTablePartitionWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, partitionName).map(new Func1<ServiceResponse<USqlTablePartition>, USqlTablePartition>() {
            @Override
            public USqlTablePartition call(ServiceResponse<USqlTablePartition> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the specified table partition from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePartition object
     */
    public Observable<ServiceResponse<USqlTablePartition>> getTablePartitionWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (partitionName == null) {
            throw new IllegalArgumentException("Parameter partitionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.getTablePartition(databaseName, schemaName, tableName, partitionName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlTablePartition>>>() {
                @Override
                public Observable<ServiceResponse<USqlTablePartition>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<USqlTablePartition> clientResponse = getTablePartitionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<USqlTablePartition> getTablePartitionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<USqlTablePartition, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<USqlTablePartition>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves a preview set of rows in given table.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlTablePreview object if successful.
     */
    public USqlTablePreview previewTable(String accountName, String databaseName, String schemaName, String tableName) {
        return previewTableWithServiceResponseAsync(accountName, databaseName, schemaName, tableName).toBlocking().single().body();
    }

    /**
     * Retrieves a preview set of rows in given table.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<USqlTablePreview> previewTableAsync(String accountName, String databaseName, String schemaName, String tableName, final ServiceCallback<USqlTablePreview> serviceCallback) {
        return ServiceFuture.fromResponse(previewTableWithServiceResponseAsync(accountName, databaseName, schemaName, tableName), serviceCallback);
    }

    /**
     * Retrieves a preview set of rows in given table.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePreview object
     */
    public Observable<USqlTablePreview> previewTableAsync(String accountName, String databaseName, String schemaName, String tableName) {
        return previewTableWithServiceResponseAsync(accountName, databaseName, schemaName, tableName).map(new Func1<ServiceResponse<USqlTablePreview>, USqlTablePreview>() {
            @Override
            public USqlTablePreview call(ServiceResponse<USqlTablePreview> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves a preview set of rows in given table.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePreview object
     */
    public Observable<ServiceResponse<USqlTablePreview>> previewTableWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Long maxRows = null;
        final Long maxColumns = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.previewTable(databaseName, schemaName, tableName, maxRows, maxColumns, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlTablePreview>>>() {
                @Override
                public Observable<ServiceResponse<USqlTablePreview>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<USqlTablePreview> clientResponse = previewTableDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves a preview set of rows in given table.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @param maxRows The maximum number of preview rows to be retrieved. Rows returned may be less than or equal to this number depending on row sizes and number of rows in the table.
     * @param maxColumns The maximum number of columns to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlTablePreview object if successful.
     */
    public USqlTablePreview previewTable(String accountName, String databaseName, String schemaName, String tableName, Long maxRows, Long maxColumns) {
        return previewTableWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, maxRows, maxColumns).toBlocking().single().body();
    }

    /**
     * Retrieves a preview set of rows in given table.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @param maxRows The maximum number of preview rows to be retrieved. Rows returned may be less than or equal to this number depending on row sizes and number of rows in the table.
     * @param maxColumns The maximum number of columns to be retrieved.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<USqlTablePreview> previewTableAsync(String accountName, String databaseName, String schemaName, String tableName, Long maxRows, Long maxColumns, final ServiceCallback<USqlTablePreview> serviceCallback) {
        return ServiceFuture.fromResponse(previewTableWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, maxRows, maxColumns), serviceCallback);
    }

    /**
     * Retrieves a preview set of rows in given table.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @param maxRows The maximum number of preview rows to be retrieved. Rows returned may be less than or equal to this number depending on row sizes and number of rows in the table.
     * @param maxColumns The maximum number of columns to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePreview object
     */
    public Observable<USqlTablePreview> previewTableAsync(String accountName, String databaseName, String schemaName, String tableName, Long maxRows, Long maxColumns) {
        return previewTableWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, maxRows, maxColumns).map(new Func1<ServiceResponse<USqlTablePreview>, USqlTablePreview>() {
            @Override
            public USqlTablePreview call(ServiceResponse<USqlTablePreview> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves a preview set of rows in given table.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @param maxRows The maximum number of preview rows to be retrieved. Rows returned may be less than or equal to this number depending on row sizes and number of rows in the table.
     * @param maxColumns The maximum number of columns to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePreview object
     */
    public Observable<ServiceResponse<USqlTablePreview>> previewTableWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName, Long maxRows, Long maxColumns) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.previewTable(databaseName, schemaName, tableName, maxRows, maxColumns, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlTablePreview>>>() {
                @Override
                public Observable<ServiceResponse<USqlTablePreview>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<USqlTablePreview> clientResponse = previewTableDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<USqlTablePreview> previewTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<USqlTablePreview, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<USqlTablePreview>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partitions.
     * @param schemaName The name of the schema containing the partitions.
     * @param tableName The name of the table containing the partitions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTablePartition&gt; object if successful.
     */
    public PagedList<USqlTablePartition> listTablePartitions(final String accountName, final String databaseName, final String schemaName, final String tableName) {
        ServiceResponse<Page<USqlTablePartition>> response = listTablePartitionsSinglePageAsync(accountName, databaseName, schemaName, tableName).toBlocking().single();
        return new PagedList<USqlTablePartition>(response.body()) {
            @Override
            public Page<USqlTablePartition> nextPage(String nextPageLink) {
                return listTablePartitionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partitions.
     * @param schemaName The name of the schema containing the partitions.
     * @param tableName The name of the table containing the partitions.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTablePartition>> listTablePartitionsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final ListOperationCallback<USqlTablePartition> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTablePartitionsSinglePageAsync(accountName, databaseName, schemaName, tableName),
            new Func1<String, Observable<ServiceResponse<Page<USqlTablePartition>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTablePartition>>> call(String nextPageLink) {
                    return listTablePartitionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partitions.
     * @param schemaName The name of the schema containing the partitions.
     * @param tableName The name of the table containing the partitions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTablePartition&gt; object
     */
    public Observable<Page<USqlTablePartition>> listTablePartitionsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName) {
        return listTablePartitionsWithServiceResponseAsync(accountName, databaseName, schemaName, tableName)
            .map(new Func1<ServiceResponse<Page<USqlTablePartition>>, Page<USqlTablePartition>>() {
                @Override
                public Page<USqlTablePartition> call(ServiceResponse<Page<USqlTablePartition>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partitions.
     * @param schemaName The name of the schema containing the partitions.
     * @param tableName The name of the table containing the partitions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTablePartition&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTablePartition>>> listTablePartitionsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String tableName) {
        return listTablePartitionsSinglePageAsync(accountName, databaseName, schemaName, tableName)
            .concatMap(new Func1<ServiceResponse<Page<USqlTablePartition>>, Observable<ServiceResponse<Page<USqlTablePartition>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTablePartition>>> call(ServiceResponse<Page<USqlTablePartition>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTablePartitionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partitions.
     * @param schemaName The name of the schema containing the partitions.
     * @param tableName The name of the table containing the partitions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTablePartition&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTablePartition>>> listTablePartitionsSinglePageAsync(final String accountName, final String databaseName, final String schemaName, final String tableName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTablePartitions(databaseName, schemaName, tableName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTablePartition>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTablePartition>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTablePartition>> result = listTablePartitionsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTablePartition>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partitions.
     * @param schemaName The name of the schema containing the partitions.
     * @param tableName The name of the table containing the partitions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTablePartition&gt; object if successful.
     */
    public PagedList<USqlTablePartition> listTablePartitions(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<USqlTablePartition>> response = listTablePartitionsSinglePageAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlTablePartition>(response.body()) {
            @Override
            public Page<USqlTablePartition> nextPage(String nextPageLink) {
                return listTablePartitionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partitions.
     * @param schemaName The name of the schema containing the partitions.
     * @param tableName The name of the table containing the partitions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTablePartition>> listTablePartitionsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlTablePartition> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTablePartitionsSinglePageAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<USqlTablePartition>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTablePartition>>> call(String nextPageLink) {
                    return listTablePartitionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partitions.
     * @param schemaName The name of the schema containing the partitions.
     * @param tableName The name of the table containing the partitions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTablePartition&gt; object
     */
    public Observable<Page<USqlTablePartition>> listTablePartitionsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listTablePartitionsWithServiceResponseAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<USqlTablePartition>>, Page<USqlTablePartition>>() {
                @Override
                public Page<USqlTablePartition> call(ServiceResponse<Page<USqlTablePartition>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partitions.
     * @param schemaName The name of the schema containing the partitions.
     * @param tableName The name of the table containing the partitions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTablePartition&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTablePartition>>> listTablePartitionsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listTablePartitionsSinglePageAsync(accountName, databaseName, schemaName, tableName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<USqlTablePartition>>, Observable<ServiceResponse<Page<USqlTablePartition>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTablePartition>>> call(ServiceResponse<Page<USqlTablePartition>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTablePartitionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTablePartition>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlTablePartition>> * @param databaseName The name of the database containing the partitions.
    ServiceResponse<PageImpl<USqlTablePartition>> * @param schemaName The name of the schema containing the partitions.
    ServiceResponse<PageImpl<USqlTablePartition>> * @param tableName The name of the table containing the partitions.
    ServiceResponse<PageImpl<USqlTablePartition>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlTablePartition>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlTablePartition>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlTablePartition>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlTablePartition>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlTablePartition>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTablePartition&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTablePartition>>> listTablePartitionsSinglePageAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTablePartitions(databaseName, schemaName, tableName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTablePartition>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTablePartition>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTablePartition>> result = listTablePartitionsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTablePartition>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTablePartition>> listTablePartitionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTablePartition>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTablePartition>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the types.
     * @param schemaName The name of the schema containing the types.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlType&gt; object if successful.
     */
    public PagedList<USqlType> listTypes(final String accountName, final String databaseName, final String schemaName) {
        ServiceResponse<Page<USqlType>> response = listTypesSinglePageAsync(accountName, databaseName, schemaName).toBlocking().single();
        return new PagedList<USqlType>(response.body()) {
            @Override
            public Page<USqlType> nextPage(String nextPageLink) {
                return listTypesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the types.
     * @param schemaName The name of the schema containing the types.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlType>> listTypesAsync(final String accountName, final String databaseName, final String schemaName, final ListOperationCallback<USqlType> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTypesSinglePageAsync(accountName, databaseName, schemaName),
            new Func1<String, Observable<ServiceResponse<Page<USqlType>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlType>>> call(String nextPageLink) {
                    return listTypesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the types.
     * @param schemaName The name of the schema containing the types.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlType&gt; object
     */
    public Observable<Page<USqlType>> listTypesAsync(final String accountName, final String databaseName, final String schemaName) {
        return listTypesWithServiceResponseAsync(accountName, databaseName, schemaName)
            .map(new Func1<ServiceResponse<Page<USqlType>>, Page<USqlType>>() {
                @Override
                public Page<USqlType> call(ServiceResponse<Page<USqlType>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the types.
     * @param schemaName The name of the schema containing the types.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlType&gt; object
     */
    public Observable<ServiceResponse<Page<USqlType>>> listTypesWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName) {
        return listTypesSinglePageAsync(accountName, databaseName, schemaName)
            .concatMap(new Func1<ServiceResponse<Page<USqlType>>, Observable<ServiceResponse<Page<USqlType>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlType>>> call(ServiceResponse<Page<USqlType>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTypesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the types.
     * @param schemaName The name of the schema containing the types.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlType&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlType>>> listTypesSinglePageAsync(final String accountName, final String databaseName, final String schemaName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTypes(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlType>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlType>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlType>> result = listTypesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlType>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the types.
     * @param schemaName The name of the schema containing the types.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlType&gt; object if successful.
     */
    public PagedList<USqlType> listTypes(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<USqlType>> response = listTypesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlType>(response.body()) {
            @Override
            public Page<USqlType> nextPage(String nextPageLink) {
                return listTypesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the types.
     * @param schemaName The name of the schema containing the types.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlType>> listTypesAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlType> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTypesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<USqlType>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlType>>> call(String nextPageLink) {
                    return listTypesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the types.
     * @param schemaName The name of the schema containing the types.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlType&gt; object
     */
    public Observable<Page<USqlType>> listTypesAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listTypesWithServiceResponseAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<USqlType>>, Page<USqlType>>() {
                @Override
                public Page<USqlType> call(ServiceResponse<Page<USqlType>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the types.
     * @param schemaName The name of the schema containing the types.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlType&gt; object
     */
    public Observable<ServiceResponse<Page<USqlType>>> listTypesWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listTypesSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<USqlType>>, Observable<ServiceResponse<Page<USqlType>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlType>>> call(ServiceResponse<Page<USqlType>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTypesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlType>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlType>> * @param databaseName The name of the database containing the types.
    ServiceResponse<PageImpl<USqlType>> * @param schemaName The name of the schema containing the types.
    ServiceResponse<PageImpl<USqlType>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlType>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlType>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlType>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlType>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlType>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlType&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlType>>> listTypesSinglePageAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTypes(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlType>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlType>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlType>> result = listTypesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlType>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlType>> listTypesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlType>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlType>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the specified table valued function from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued function.
     * @param schemaName The name of the schema containing the table valued function.
     * @param tableValuedFunctionName The name of the tableValuedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlTableValuedFunction object if successful.
     */
    public USqlTableValuedFunction getTableValuedFunction(String accountName, String databaseName, String schemaName, String tableValuedFunctionName) {
        return getTableValuedFunctionWithServiceResponseAsync(accountName, databaseName, schemaName, tableValuedFunctionName).toBlocking().single().body();
    }

    /**
     * Retrieves the specified table valued function from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued function.
     * @param schemaName The name of the schema containing the table valued function.
     * @param tableValuedFunctionName The name of the tableValuedFunction.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<USqlTableValuedFunction> getTableValuedFunctionAsync(String accountName, String databaseName, String schemaName, String tableValuedFunctionName, final ServiceCallback<USqlTableValuedFunction> serviceCallback) {
        return ServiceFuture.fromResponse(getTableValuedFunctionWithServiceResponseAsync(accountName, databaseName, schemaName, tableValuedFunctionName), serviceCallback);
    }

    /**
     * Retrieves the specified table valued function from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued function.
     * @param schemaName The name of the schema containing the table valued function.
     * @param tableValuedFunctionName The name of the tableValuedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTableValuedFunction object
     */
    public Observable<USqlTableValuedFunction> getTableValuedFunctionAsync(String accountName, String databaseName, String schemaName, String tableValuedFunctionName) {
        return getTableValuedFunctionWithServiceResponseAsync(accountName, databaseName, schemaName, tableValuedFunctionName).map(new Func1<ServiceResponse<USqlTableValuedFunction>, USqlTableValuedFunction>() {
            @Override
            public USqlTableValuedFunction call(ServiceResponse<USqlTableValuedFunction> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the specified table valued function from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued function.
     * @param schemaName The name of the schema containing the table valued function.
     * @param tableValuedFunctionName The name of the tableValuedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTableValuedFunction object
     */
    public Observable<ServiceResponse<USqlTableValuedFunction>> getTableValuedFunctionWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableValuedFunctionName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableValuedFunctionName == null) {
            throw new IllegalArgumentException("Parameter tableValuedFunctionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.getTableValuedFunction(databaseName, schemaName, tableValuedFunctionName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlTableValuedFunction>>>() {
                @Override
                public Observable<ServiceResponse<USqlTableValuedFunction>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<USqlTableValuedFunction> clientResponse = getTableValuedFunctionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<USqlTableValuedFunction> getTableValuedFunctionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<USqlTableValuedFunction, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<USqlTableValuedFunction>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param schemaName The name of the schema containing the table valued functions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableValuedFunction&gt; object if successful.
     */
    public PagedList<USqlTableValuedFunction> listTableValuedFunctions(final String accountName, final String databaseName, final String schemaName) {
        ServiceResponse<Page<USqlTableValuedFunction>> response = listTableValuedFunctionsSinglePageAsync(accountName, databaseName, schemaName).toBlocking().single();
        return new PagedList<USqlTableValuedFunction>(response.body()) {
            @Override
            public Page<USqlTableValuedFunction> nextPage(String nextPageLink) {
                return listTableValuedFunctionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param schemaName The name of the schema containing the table valued functions.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableValuedFunction>> listTableValuedFunctionsAsync(final String accountName, final String databaseName, final String schemaName, final ListOperationCallback<USqlTableValuedFunction> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableValuedFunctionsSinglePageAsync(accountName, databaseName, schemaName),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(String nextPageLink) {
                    return listTableValuedFunctionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param schemaName The name of the schema containing the table valued functions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    public Observable<Page<USqlTableValuedFunction>> listTableValuedFunctionsAsync(final String accountName, final String databaseName, final String schemaName) {
        return listTableValuedFunctionsWithServiceResponseAsync(accountName, databaseName, schemaName)
            .map(new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Page<USqlTableValuedFunction>>() {
                @Override
                public Page<USqlTableValuedFunction> call(ServiceResponse<Page<USqlTableValuedFunction>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param schemaName The name of the schema containing the table valued functions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName) {
        return listTableValuedFunctionsSinglePageAsync(accountName, databaseName, schemaName)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(ServiceResponse<Page<USqlTableValuedFunction>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableValuedFunctionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param schemaName The name of the schema containing the table valued functions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableValuedFunction&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsSinglePageAsync(final String accountName, final String databaseName, final String schemaName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTableValuedFunctions(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableValuedFunction>> result = listTableValuedFunctionsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableValuedFunction>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param schemaName The name of the schema containing the table valued functions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableValuedFunction&gt; object if successful.
     */
    public PagedList<USqlTableValuedFunction> listTableValuedFunctions(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<USqlTableValuedFunction>> response = listTableValuedFunctionsSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlTableValuedFunction>(response.body()) {
            @Override
            public Page<USqlTableValuedFunction> nextPage(String nextPageLink) {
                return listTableValuedFunctionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param schemaName The name of the schema containing the table valued functions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableValuedFunction>> listTableValuedFunctionsAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlTableValuedFunction> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableValuedFunctionsSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(String nextPageLink) {
                    return listTableValuedFunctionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param schemaName The name of the schema containing the table valued functions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    public Observable<Page<USqlTableValuedFunction>> listTableValuedFunctionsAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listTableValuedFunctionsWithServiceResponseAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Page<USqlTableValuedFunction>>() {
                @Override
                public Page<USqlTableValuedFunction> call(ServiceResponse<Page<USqlTableValuedFunction>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param schemaName The name of the schema containing the table valued functions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listTableValuedFunctionsSinglePageAsync(accountName, databaseName, schemaName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(ServiceResponse<Page<USqlTableValuedFunction>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableValuedFunctionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param databaseName The name of the database containing the table valued functions.
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param schemaName The name of the schema containing the table valued functions.
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableValuedFunction&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsSinglePageAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTableValuedFunctions(databaseName, schemaName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableValuedFunction>> result = listTableValuedFunctionsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableValuedFunction>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTableValuedFunction>> listTableValuedFunctionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTableValuedFunction>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTableValuedFunction>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the specified assembly from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @param assemblyName The name of the assembly.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlAssembly object if successful.
     */
    public USqlAssembly getAssembly(String accountName, String databaseName, String assemblyName) {
        return getAssemblyWithServiceResponseAsync(accountName, databaseName, assemblyName).toBlocking().single().body();
    }

    /**
     * Retrieves the specified assembly from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @param assemblyName The name of the assembly.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<USqlAssembly> getAssemblyAsync(String accountName, String databaseName, String assemblyName, final ServiceCallback<USqlAssembly> serviceCallback) {
        return ServiceFuture.fromResponse(getAssemblyWithServiceResponseAsync(accountName, databaseName, assemblyName), serviceCallback);
    }

    /**
     * Retrieves the specified assembly from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @param assemblyName The name of the assembly.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlAssembly object
     */
    public Observable<USqlAssembly> getAssemblyAsync(String accountName, String databaseName, String assemblyName) {
        return getAssemblyWithServiceResponseAsync(accountName, databaseName, assemblyName).map(new Func1<ServiceResponse<USqlAssembly>, USqlAssembly>() {
            @Override
            public USqlAssembly call(ServiceResponse<USqlAssembly> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the specified assembly from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @param assemblyName The name of the assembly.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlAssembly object
     */
    public Observable<ServiceResponse<USqlAssembly>> getAssemblyWithServiceResponseAsync(String accountName, String databaseName, String assemblyName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (assemblyName == null) {
            throw new IllegalArgumentException("Parameter assemblyName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.getAssembly(databaseName, assemblyName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlAssembly>>>() {
                @Override
                public Observable<ServiceResponse<USqlAssembly>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<USqlAssembly> clientResponse = getAssemblyDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<USqlAssembly> getAssemblyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<USqlAssembly, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<USqlAssembly>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlAssemblyClr&gt; object if successful.
     */
    public PagedList<USqlAssemblyClr> listAssemblies(final String accountName, final String databaseName) {
        ServiceResponse<Page<USqlAssemblyClr>> response = listAssembliesSinglePageAsync(accountName, databaseName).toBlocking().single();
        return new PagedList<USqlAssemblyClr>(response.body()) {
            @Override
            public Page<USqlAssemblyClr> nextPage(String nextPageLink) {
                return listAssembliesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlAssemblyClr>> listAssembliesAsync(final String accountName, final String databaseName, final ListOperationCallback<USqlAssemblyClr> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAssembliesSinglePageAsync(accountName, databaseName),
            new Func1<String, Observable<ServiceResponse<Page<USqlAssemblyClr>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlAssemblyClr>>> call(String nextPageLink) {
                    return listAssembliesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlAssemblyClr&gt; object
     */
    public Observable<Page<USqlAssemblyClr>> listAssembliesAsync(final String accountName, final String databaseName) {
        return listAssembliesWithServiceResponseAsync(accountName, databaseName)
            .map(new Func1<ServiceResponse<Page<USqlAssemblyClr>>, Page<USqlAssemblyClr>>() {
                @Override
                public Page<USqlAssemblyClr> call(ServiceResponse<Page<USqlAssemblyClr>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlAssemblyClr&gt; object
     */
    public Observable<ServiceResponse<Page<USqlAssemblyClr>>> listAssembliesWithServiceResponseAsync(final String accountName, final String databaseName) {
        return listAssembliesSinglePageAsync(accountName, databaseName)
            .concatMap(new Func1<ServiceResponse<Page<USqlAssemblyClr>>, Observable<ServiceResponse<Page<USqlAssemblyClr>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlAssemblyClr>>> call(ServiceResponse<Page<USqlAssemblyClr>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAssembliesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlAssemblyClr&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlAssemblyClr>>> listAssembliesSinglePageAsync(final String accountName, final String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listAssemblies(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlAssemblyClr>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlAssemblyClr>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlAssemblyClr>> result = listAssembliesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlAssemblyClr>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlAssemblyClr&gt; object if successful.
     */
    public PagedList<USqlAssemblyClr> listAssemblies(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<USqlAssemblyClr>> response = listAssembliesSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlAssemblyClr>(response.body()) {
            @Override
            public Page<USqlAssemblyClr> nextPage(String nextPageLink) {
                return listAssembliesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlAssemblyClr>> listAssembliesAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlAssemblyClr> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAssembliesSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<USqlAssemblyClr>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlAssemblyClr>>> call(String nextPageLink) {
                    return listAssembliesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlAssemblyClr&gt; object
     */
    public Observable<Page<USqlAssemblyClr>> listAssembliesAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listAssembliesWithServiceResponseAsync(accountName, databaseName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<USqlAssemblyClr>>, Page<USqlAssemblyClr>>() {
                @Override
                public Page<USqlAssemblyClr> call(ServiceResponse<Page<USqlAssemblyClr>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlAssemblyClr&gt; object
     */
    public Observable<ServiceResponse<Page<USqlAssemblyClr>>> listAssembliesWithServiceResponseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listAssembliesSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<USqlAssemblyClr>>, Observable<ServiceResponse<Page<USqlAssemblyClr>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlAssemblyClr>>> call(ServiceResponse<Page<USqlAssemblyClr>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAssembliesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlAssemblyClr>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlAssemblyClr>> * @param databaseName The name of the database containing the assembly.
    ServiceResponse<PageImpl<USqlAssemblyClr>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlAssemblyClr>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlAssemblyClr>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlAssemblyClr>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlAssemblyClr>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlAssemblyClr>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlAssemblyClr&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlAssemblyClr>>> listAssembliesSinglePageAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listAssemblies(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlAssemblyClr>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlAssemblyClr>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlAssemblyClr>> result = listAssembliesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlAssemblyClr>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlAssemblyClr>> listAssembliesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlAssemblyClr>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlAssemblyClr>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param schemaName The name of the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlSchema object if successful.
     */
    public USqlSchema getSchema(String accountName, String databaseName, String schemaName) {
        return getSchemaWithServiceResponseAsync(accountName, databaseName, schemaName).toBlocking().single().body();
    }

    /**
     * Retrieves the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param schemaName The name of the schema.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<USqlSchema> getSchemaAsync(String accountName, String databaseName, String schemaName, final ServiceCallback<USqlSchema> serviceCallback) {
        return ServiceFuture.fromResponse(getSchemaWithServiceResponseAsync(accountName, databaseName, schemaName), serviceCallback);
    }

    /**
     * Retrieves the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param schemaName The name of the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlSchema object
     */
    public Observable<USqlSchema> getSchemaAsync(String accountName, String databaseName, String schemaName) {
        return getSchemaWithServiceResponseAsync(accountName, databaseName, schemaName).map(new Func1<ServiceResponse<USqlSchema>, USqlSchema>() {
            @Override
            public USqlSchema call(ServiceResponse<USqlSchema> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param schemaName The name of the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlSchema object
     */
    public Observable<ServiceResponse<USqlSchema>> getSchemaWithServiceResponseAsync(String accountName, String databaseName, String schemaName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.getSchema(databaseName, schemaName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlSchema>>>() {
                @Override
                public Observable<ServiceResponse<USqlSchema>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<USqlSchema> clientResponse = getSchemaDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<USqlSchema> getSchemaDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<USqlSchema, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<USqlSchema>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlSchema&gt; object if successful.
     */
    public PagedList<USqlSchema> listSchemas(final String accountName, final String databaseName) {
        ServiceResponse<Page<USqlSchema>> response = listSchemasSinglePageAsync(accountName, databaseName).toBlocking().single();
        return new PagedList<USqlSchema>(response.body()) {
            @Override
            public Page<USqlSchema> nextPage(String nextPageLink) {
                return listSchemasNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlSchema>> listSchemasAsync(final String accountName, final String databaseName, final ListOperationCallback<USqlSchema> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSchemasSinglePageAsync(accountName, databaseName),
            new Func1<String, Observable<ServiceResponse<Page<USqlSchema>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlSchema>>> call(String nextPageLink) {
                    return listSchemasNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlSchema&gt; object
     */
    public Observable<Page<USqlSchema>> listSchemasAsync(final String accountName, final String databaseName) {
        return listSchemasWithServiceResponseAsync(accountName, databaseName)
            .map(new Func1<ServiceResponse<Page<USqlSchema>>, Page<USqlSchema>>() {
                @Override
                public Page<USqlSchema> call(ServiceResponse<Page<USqlSchema>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlSchema&gt; object
     */
    public Observable<ServiceResponse<Page<USqlSchema>>> listSchemasWithServiceResponseAsync(final String accountName, final String databaseName) {
        return listSchemasSinglePageAsync(accountName, databaseName)
            .concatMap(new Func1<ServiceResponse<Page<USqlSchema>>, Observable<ServiceResponse<Page<USqlSchema>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlSchema>>> call(ServiceResponse<Page<USqlSchema>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSchemasNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlSchema&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlSchema>>> listSchemasSinglePageAsync(final String accountName, final String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listSchemas(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlSchema>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlSchema>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlSchema>> result = listSchemasDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlSchema>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlSchema&gt; object if successful.
     */
    public PagedList<USqlSchema> listSchemas(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<USqlSchema>> response = listSchemasSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlSchema>(response.body()) {
            @Override
            public Page<USqlSchema> nextPage(String nextPageLink) {
                return listSchemasNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlSchema>> listSchemasAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlSchema> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSchemasSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<USqlSchema>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlSchema>>> call(String nextPageLink) {
                    return listSchemasNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlSchema&gt; object
     */
    public Observable<Page<USqlSchema>> listSchemasAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listSchemasWithServiceResponseAsync(accountName, databaseName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<USqlSchema>>, Page<USqlSchema>>() {
                @Override
                public Page<USqlSchema> call(ServiceResponse<Page<USqlSchema>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlSchema&gt; object
     */
    public Observable<ServiceResponse<Page<USqlSchema>>> listSchemasWithServiceResponseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listSchemasSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<USqlSchema>>, Observable<ServiceResponse<Page<USqlSchema>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlSchema>>> call(ServiceResponse<Page<USqlSchema>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSchemasNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlSchema>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlSchema>> * @param databaseName The name of the database containing the schema.
    ServiceResponse<PageImpl<USqlSchema>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlSchema>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlSchema>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlSchema>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlSchema>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlSchema>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlSchema&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlSchema>>> listSchemasSinglePageAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listSchemas(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlSchema>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlSchema>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlSchema>> result = listSchemasDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlSchema>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlSchema>> listSchemasDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlSchema>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlSchema>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableStatistics&gt; object if successful.
     */
    public PagedList<USqlTableStatistics> listTableStatisticsByDatabase(final String accountName, final String databaseName) {
        ServiceResponse<Page<USqlTableStatistics>> response = listTableStatisticsByDatabaseSinglePageAsync(accountName, databaseName).toBlocking().single();
        return new PagedList<USqlTableStatistics>(response.body()) {
            @Override
            public Page<USqlTableStatistics> nextPage(String nextPageLink) {
                return listTableStatisticsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table statistics.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableStatistics>> listTableStatisticsByDatabaseAsync(final String accountName, final String databaseName, final ListOperationCallback<USqlTableStatistics> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableStatisticsByDatabaseSinglePageAsync(accountName, databaseName),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(String nextPageLink) {
                    return listTableStatisticsByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    public Observable<Page<USqlTableStatistics>> listTableStatisticsByDatabaseAsync(final String accountName, final String databaseName) {
        return listTableStatisticsByDatabaseWithServiceResponseAsync(accountName, databaseName)
            .map(new Func1<ServiceResponse<Page<USqlTableStatistics>>, Page<USqlTableStatistics>>() {
                @Override
                public Page<USqlTableStatistics> call(ServiceResponse<Page<USqlTableStatistics>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName) {
        return listTableStatisticsByDatabaseSinglePageAsync(accountName, databaseName)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableStatistics>>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(ServiceResponse<Page<USqlTableStatistics>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableStatisticsByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableStatistics&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseSinglePageAsync(final String accountName, final String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTableStatisticsByDatabase(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableStatistics>> result = listTableStatisticsByDatabaseDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableStatistics>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableStatistics&gt; object if successful.
     */
    public PagedList<USqlTableStatistics> listTableStatisticsByDatabase(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<USqlTableStatistics>> response = listTableStatisticsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlTableStatistics>(response.body()) {
            @Override
            public Page<USqlTableStatistics> nextPage(String nextPageLink) {
                return listTableStatisticsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableStatistics>> listTableStatisticsByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlTableStatistics> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableStatisticsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(String nextPageLink) {
                    return listTableStatisticsByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    public Observable<Page<USqlTableStatistics>> listTableStatisticsByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listTableStatisticsByDatabaseWithServiceResponseAsync(accountName, databaseName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<USqlTableStatistics>>, Page<USqlTableStatistics>>() {
                @Override
                public Page<USqlTableStatistics> call(ServiceResponse<Page<USqlTableStatistics>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listTableStatisticsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableStatistics>>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(ServiceResponse<Page<USqlTableStatistics>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableStatisticsByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param databaseName The name of the database containing the table statistics.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableStatistics&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseSinglePageAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTableStatisticsByDatabase(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableStatistics>> result = listTableStatisticsByDatabaseDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableStatistics>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTableStatistics>> listTableStatisticsByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTableStatistics>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTableStatistics>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTable&gt; object if successful.
     */
    public PagedList<USqlTable> listTablesByDatabase(final String accountName, final String databaseName) {
        ServiceResponse<Page<USqlTable>> response = listTablesByDatabaseSinglePageAsync(accountName, databaseName).toBlocking().single();
        return new PagedList<USqlTable>(response.body()) {
            @Override
            public Page<USqlTable> nextPage(String nextPageLink) {
                return listTablesByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTable>> listTablesByDatabaseAsync(final String accountName, final String databaseName, final ListOperationCallback<USqlTable> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTablesByDatabaseSinglePageAsync(accountName, databaseName),
            new Func1<String, Observable<ServiceResponse<Page<USqlTable>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTable>>> call(String nextPageLink) {
                    return listTablesByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    public Observable<Page<USqlTable>> listTablesByDatabaseAsync(final String accountName, final String databaseName) {
        return listTablesByDatabaseWithServiceResponseAsync(accountName, databaseName)
            .map(new Func1<ServiceResponse<Page<USqlTable>>, Page<USqlTable>>() {
                @Override
                public Page<USqlTable> call(ServiceResponse<Page<USqlTable>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTable>>> listTablesByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName) {
        return listTablesByDatabaseSinglePageAsync(accountName, databaseName)
            .concatMap(new Func1<ServiceResponse<Page<USqlTable>>, Observable<ServiceResponse<Page<USqlTable>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTable>>> call(ServiceResponse<Page<USqlTable>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTablesByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTable&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTable>>> listTablesByDatabaseSinglePageAsync(final String accountName, final String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        final Boolean basic = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTablesByDatabase(databaseName, filter, top, skip, select, orderby, count, basic, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTable>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTable>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTable>> result = listTablesByDatabaseDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTable>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param basic The basic switch indicates what level of information to return when listing tables. When basic is true, only database_name, schema_name, table_name and version are returned for each table, otherwise all table metadata is returned. By default, it is false
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTable&gt; object if successful.
     */
    public PagedList<USqlTable> listTablesByDatabase(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final Boolean basic) {
        ServiceResponse<Page<USqlTable>> response = listTablesByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count, basic).toBlocking().single();
        return new PagedList<USqlTable>(response.body()) {
            @Override
            public Page<USqlTable> nextPage(String nextPageLink) {
                return listTablesByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param basic The basic switch indicates what level of information to return when listing tables. When basic is true, only database_name, schema_name, table_name and version are returned for each table, otherwise all table metadata is returned. By default, it is false
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTable>> listTablesByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final Boolean basic, final ListOperationCallback<USqlTable> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTablesByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count, basic),
            new Func1<String, Observable<ServiceResponse<Page<USqlTable>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTable>>> call(String nextPageLink) {
                    return listTablesByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param basic The basic switch indicates what level of information to return when listing tables. When basic is true, only database_name, schema_name, table_name and version are returned for each table, otherwise all table metadata is returned. By default, it is false
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    public Observable<Page<USqlTable>> listTablesByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final Boolean basic) {
        return listTablesByDatabaseWithServiceResponseAsync(accountName, databaseName, filter, top, skip, select, orderby, count, basic)
            .map(new Func1<ServiceResponse<Page<USqlTable>>, Page<USqlTable>>() {
                @Override
                public Page<USqlTable> call(ServiceResponse<Page<USqlTable>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param basic The basic switch indicates what level of information to return when listing tables. When basic is true, only database_name, schema_name, table_name and version are returned for each table, otherwise all table metadata is returned. By default, it is false
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTable>>> listTablesByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final Boolean basic) {
        return listTablesByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count, basic)
            .concatMap(new Func1<ServiceResponse<Page<USqlTable>>, Observable<ServiceResponse<Page<USqlTable>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTable>>> call(ServiceResponse<Page<USqlTable>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTablesByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTable>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlTable>> * @param databaseName The name of the database containing the tables.
    ServiceResponse<PageImpl<USqlTable>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlTable>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlTable>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlTable>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlTable>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlTable>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
    ServiceResponse<PageImpl<USqlTable>> * @param basic The basic switch indicates what level of information to return when listing tables. When basic is true, only database_name, schema_name, table_name and version are returned for each table, otherwise all table metadata is returned. By default, it is false
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTable&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTable>>> listTablesByDatabaseSinglePageAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final Boolean basic) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTablesByDatabase(databaseName, filter, top, skip, select, orderby, count, basic, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTable>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTable>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTable>> result = listTablesByDatabaseDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTable>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTable>> listTablesByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTable>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTable>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableValuedFunction&gt; object if successful.
     */
    public PagedList<USqlTableValuedFunction> listTableValuedFunctionsByDatabase(final String accountName, final String databaseName) {
        ServiceResponse<Page<USqlTableValuedFunction>> response = listTableValuedFunctionsByDatabaseSinglePageAsync(accountName, databaseName).toBlocking().single();
        return new PagedList<USqlTableValuedFunction>(response.body()) {
            @Override
            public Page<USqlTableValuedFunction> nextPage(String nextPageLink) {
                return listTableValuedFunctionsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseAsync(final String accountName, final String databaseName, final ListOperationCallback<USqlTableValuedFunction> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableValuedFunctionsByDatabaseSinglePageAsync(accountName, databaseName),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(String nextPageLink) {
                    return listTableValuedFunctionsByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    public Observable<Page<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseAsync(final String accountName, final String databaseName) {
        return listTableValuedFunctionsByDatabaseWithServiceResponseAsync(accountName, databaseName)
            .map(new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Page<USqlTableValuedFunction>>() {
                @Override
                public Page<USqlTableValuedFunction> call(ServiceResponse<Page<USqlTableValuedFunction>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName) {
        return listTableValuedFunctionsByDatabaseSinglePageAsync(accountName, databaseName)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(ServiceResponse<Page<USqlTableValuedFunction>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableValuedFunctionsByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableValuedFunction&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsByDatabaseSinglePageAsync(final String accountName, final String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTableValuedFunctionsByDatabase(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableValuedFunction>> result = listTableValuedFunctionsByDatabaseDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableValuedFunction>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableValuedFunction&gt; object if successful.
     */
    public PagedList<USqlTableValuedFunction> listTableValuedFunctionsByDatabase(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<USqlTableValuedFunction>> response = listTableValuedFunctionsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlTableValuedFunction>(response.body()) {
            @Override
            public Page<USqlTableValuedFunction> nextPage(String nextPageLink) {
                return listTableValuedFunctionsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlTableValuedFunction> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableValuedFunctionsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(String nextPageLink) {
                    return listTableValuedFunctionsByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    public Observable<Page<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listTableValuedFunctionsByDatabaseWithServiceResponseAsync(accountName, databaseName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Page<USqlTableValuedFunction>>() {
                @Override
                public Page<USqlTableValuedFunction> call(ServiceResponse<Page<USqlTableValuedFunction>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listTableValuedFunctionsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(ServiceResponse<Page<USqlTableValuedFunction>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableValuedFunctionsByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param databaseName The name of the database containing the table valued functions.
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableValuedFunction&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsByDatabaseSinglePageAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listTableValuedFunctionsByDatabase(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableValuedFunction>> result = listTableValuedFunctionsByDatabaseDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableValuedFunction>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTableValuedFunction>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTableValuedFunction>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlView&gt; object if successful.
     */
    public PagedList<USqlView> listViewsByDatabase(final String accountName, final String databaseName) {
        ServiceResponse<Page<USqlView>> response = listViewsByDatabaseSinglePageAsync(accountName, databaseName).toBlocking().single();
        return new PagedList<USqlView>(response.body()) {
            @Override
            public Page<USqlView> nextPage(String nextPageLink) {
                return listViewsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlView>> listViewsByDatabaseAsync(final String accountName, final String databaseName, final ListOperationCallback<USqlView> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listViewsByDatabaseSinglePageAsync(accountName, databaseName),
            new Func1<String, Observable<ServiceResponse<Page<USqlView>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlView>>> call(String nextPageLink) {
                    return listViewsByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    public Observable<Page<USqlView>> listViewsByDatabaseAsync(final String accountName, final String databaseName) {
        return listViewsByDatabaseWithServiceResponseAsync(accountName, databaseName)
            .map(new Func1<ServiceResponse<Page<USqlView>>, Page<USqlView>>() {
                @Override
                public Page<USqlView> call(ServiceResponse<Page<USqlView>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    public Observable<ServiceResponse<Page<USqlView>>> listViewsByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName) {
        return listViewsByDatabaseSinglePageAsync(accountName, databaseName)
            .concatMap(new Func1<ServiceResponse<Page<USqlView>>, Observable<ServiceResponse<Page<USqlView>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlView>>> call(ServiceResponse<Page<USqlView>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listViewsByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlView&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlView>>> listViewsByDatabaseSinglePageAsync(final String accountName, final String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listViewsByDatabase(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlView>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlView>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlView>> result = listViewsByDatabaseDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlView>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlView&gt; object if successful.
     */
    public PagedList<USqlView> listViewsByDatabase(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<USqlView>> response = listViewsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlView>(response.body()) {
            @Override
            public Page<USqlView> nextPage(String nextPageLink) {
                return listViewsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlView>> listViewsByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlView> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listViewsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<USqlView>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlView>>> call(String nextPageLink) {
                    return listViewsByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    public Observable<Page<USqlView>> listViewsByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listViewsByDatabaseWithServiceResponseAsync(accountName, databaseName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<USqlView>>, Page<USqlView>>() {
                @Override
                public Page<USqlView> call(ServiceResponse<Page<USqlView>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    public Observable<ServiceResponse<Page<USqlView>>> listViewsByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listViewsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<USqlView>>, Observable<ServiceResponse<Page<USqlView>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlView>>> call(ServiceResponse<Page<USqlView>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listViewsByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlView>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlView>> * @param databaseName The name of the database containing the views.
    ServiceResponse<PageImpl<USqlView>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlView>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlView>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlView>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlView>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlView>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlView&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlView>>> listViewsByDatabaseSinglePageAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listViewsByDatabase(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlView>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlView>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlView>> result = listViewsByDatabaseDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlView>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlView>> listViewsByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlView>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlView>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;Acl&gt; object if successful.
     */
    public PagedList<Acl> listAclsByDatabase(final String accountName, final String databaseName) {
        ServiceResponse<Page<Acl>> response = listAclsByDatabaseSinglePageAsync(accountName, databaseName).toBlocking().single();
        return new PagedList<Acl>(response.body()) {
            @Override
            public Page<Acl> nextPage(String nextPageLink) {
                return listAclsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<Acl>> listAclsByDatabaseAsync(final String accountName, final String databaseName, final ListOperationCallback<Acl> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAclsByDatabaseSinglePageAsync(accountName, databaseName),
            new Func1<String, Observable<ServiceResponse<Page<Acl>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Acl>>> call(String nextPageLink) {
                    return listAclsByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    public Observable<Page<Acl>> listAclsByDatabaseAsync(final String accountName, final String databaseName) {
        return listAclsByDatabaseWithServiceResponseAsync(accountName, databaseName)
            .map(new Func1<ServiceResponse<Page<Acl>>, Page<Acl>>() {
                @Override
                public Page<Acl> call(ServiceResponse<Page<Acl>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    public Observable<ServiceResponse<Page<Acl>>> listAclsByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName) {
        return listAclsByDatabaseSinglePageAsync(accountName, databaseName)
            .concatMap(new Func1<ServiceResponse<Page<Acl>>, Observable<ServiceResponse<Page<Acl>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Acl>>> call(ServiceResponse<Page<Acl>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAclsByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;Acl&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<Acl>>> listAclsByDatabaseSinglePageAsync(final String accountName, final String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listAclsByDatabase(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Acl>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Acl>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<Acl>> result = listAclsByDatabaseDelegate(response);
                        return Observable.just(new ServiceResponse<Page<Acl>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;Acl&gt; object if successful.
     */
    public PagedList<Acl> listAclsByDatabase(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<Acl>> response = listAclsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<Acl>(response.body()) {
            @Override
            public Page<Acl> nextPage(String nextPageLink) {
                return listAclsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<Acl>> listAclsByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<Acl> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAclsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<Acl>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Acl>>> call(String nextPageLink) {
                    return listAclsByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    public Observable<Page<Acl>> listAclsByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listAclsByDatabaseWithServiceResponseAsync(accountName, databaseName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<Acl>>, Page<Acl>>() {
                @Override
                public Page<Acl> call(ServiceResponse<Page<Acl>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    public Observable<ServiceResponse<Page<Acl>>> listAclsByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listAclsByDatabaseSinglePageAsync(accountName, databaseName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<Acl>>, Observable<ServiceResponse<Page<Acl>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Acl>>> call(ServiceResponse<Page<Acl>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAclsByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<Acl>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<Acl>> * @param databaseName The name of the database.
    ServiceResponse<PageImpl<Acl>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<Acl>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<Acl>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<Acl>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<Acl>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<Acl>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;Acl&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<Acl>>> listAclsByDatabaseSinglePageAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listAclsByDatabase(databaseName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Acl>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Acl>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<Acl>> result = listAclsByDatabaseDelegate(response);
                        return Observable.just(new ServiceResponse<Page<Acl>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<Acl>> listAclsByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<Acl>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<Acl>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;Acl&gt; object if successful.
     */
    public PagedList<Acl> listAcls(final String accountName) {
        ServiceResponse<Page<Acl>> response = listAclsSinglePageAsync(accountName).toBlocking().single();
        return new PagedList<Acl>(response.body()) {
            @Override
            public Page<Acl> nextPage(String nextPageLink) {
                return listAclsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<Acl>> listAclsAsync(final String accountName, final ListOperationCallback<Acl> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAclsSinglePageAsync(accountName),
            new Func1<String, Observable<ServiceResponse<Page<Acl>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Acl>>> call(String nextPageLink) {
                    return listAclsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    public Observable<Page<Acl>> listAclsAsync(final String accountName) {
        return listAclsWithServiceResponseAsync(accountName)
            .map(new Func1<ServiceResponse<Page<Acl>>, Page<Acl>>() {
                @Override
                public Page<Acl> call(ServiceResponse<Page<Acl>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    public Observable<ServiceResponse<Page<Acl>>> listAclsWithServiceResponseAsync(final String accountName) {
        return listAclsSinglePageAsync(accountName)
            .concatMap(new Func1<ServiceResponse<Page<Acl>>, Observable<ServiceResponse<Page<Acl>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Acl>>> call(ServiceResponse<Page<Acl>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAclsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;Acl&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<Acl>>> listAclsSinglePageAsync(final String accountName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listAcls(filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Acl>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Acl>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<Acl>> result = listAclsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<Acl>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;Acl&gt; object if successful.
     */
    public PagedList<Acl> listAcls(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<Acl>> response = listAclsSinglePageAsync(accountName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<Acl>(response.body()) {
            @Override
            public Page<Acl> nextPage(String nextPageLink) {
                return listAclsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<Acl>> listAclsAsync(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<Acl> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAclsSinglePageAsync(accountName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<Acl>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Acl>>> call(String nextPageLink) {
                    return listAclsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    public Observable<Page<Acl>> listAclsAsync(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listAclsWithServiceResponseAsync(accountName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<Acl>>, Page<Acl>>() {
                @Override
                public Page<Acl> call(ServiceResponse<Page<Acl>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    public Observable<ServiceResponse<Page<Acl>>> listAclsWithServiceResponseAsync(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listAclsSinglePageAsync(accountName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<Acl>>, Observable<ServiceResponse<Page<Acl>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Acl>>> call(ServiceResponse<Page<Acl>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAclsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<Acl>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<Acl>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<Acl>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<Acl>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<Acl>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<Acl>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<Acl>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;Acl&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<Acl>>> listAclsSinglePageAsync(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listAcls(filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Acl>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Acl>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<Acl>> result = listAclsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<Acl>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<Acl>> listAclsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<Acl>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<Acl>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the specified database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlDatabase object if successful.
     */
    public USqlDatabase getDatabase(String accountName, String databaseName) {
        return getDatabaseWithServiceResponseAsync(accountName, databaseName).toBlocking().single().body();
    }

    /**
     * Retrieves the specified database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<USqlDatabase> getDatabaseAsync(String accountName, String databaseName, final ServiceCallback<USqlDatabase> serviceCallback) {
        return ServiceFuture.fromResponse(getDatabaseWithServiceResponseAsync(accountName, databaseName), serviceCallback);
    }

    /**
     * Retrieves the specified database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlDatabase object
     */
    public Observable<USqlDatabase> getDatabaseAsync(String accountName, String databaseName) {
        return getDatabaseWithServiceResponseAsync(accountName, databaseName).map(new Func1<ServiceResponse<USqlDatabase>, USqlDatabase>() {
            @Override
            public USqlDatabase call(ServiceResponse<USqlDatabase> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the specified database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlDatabase object
     */
    public Observable<ServiceResponse<USqlDatabase>> getDatabaseWithServiceResponseAsync(String accountName, String databaseName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.getDatabase(databaseName, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<USqlDatabase>>>() {
                @Override
                public Observable<ServiceResponse<USqlDatabase>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<USqlDatabase> clientResponse = getDatabaseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<USqlDatabase> getDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<USqlDatabase, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<USqlDatabase>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlDatabase&gt; object if successful.
     */
    public PagedList<USqlDatabase> listDatabases(final String accountName) {
        ServiceResponse<Page<USqlDatabase>> response = listDatabasesSinglePageAsync(accountName).toBlocking().single();
        return new PagedList<USqlDatabase>(response.body()) {
            @Override
            public Page<USqlDatabase> nextPage(String nextPageLink) {
                return listDatabasesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlDatabase>> listDatabasesAsync(final String accountName, final ListOperationCallback<USqlDatabase> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listDatabasesSinglePageAsync(accountName),
            new Func1<String, Observable<ServiceResponse<Page<USqlDatabase>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlDatabase>>> call(String nextPageLink) {
                    return listDatabasesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlDatabase&gt; object
     */
    public Observable<Page<USqlDatabase>> listDatabasesAsync(final String accountName) {
        return listDatabasesWithServiceResponseAsync(accountName)
            .map(new Func1<ServiceResponse<Page<USqlDatabase>>, Page<USqlDatabase>>() {
                @Override
                public Page<USqlDatabase> call(ServiceResponse<Page<USqlDatabase>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlDatabase&gt; object
     */
    public Observable<ServiceResponse<Page<USqlDatabase>>> listDatabasesWithServiceResponseAsync(final String accountName) {
        return listDatabasesSinglePageAsync(accountName)
            .concatMap(new Func1<ServiceResponse<Page<USqlDatabase>>, Observable<ServiceResponse<Page<USqlDatabase>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlDatabase>>> call(ServiceResponse<Page<USqlDatabase>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listDatabasesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlDatabase&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlDatabase>>> listDatabasesSinglePageAsync(final String accountName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listDatabases(filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlDatabase>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlDatabase>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlDatabase>> result = listDatabasesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlDatabase>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlDatabase&gt; object if successful.
     */
    public PagedList<USqlDatabase> listDatabases(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<USqlDatabase>> response = listDatabasesSinglePageAsync(accountName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<USqlDatabase>(response.body()) {
            @Override
            public Page<USqlDatabase> nextPage(String nextPageLink) {
                return listDatabasesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlDatabase>> listDatabasesAsync(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlDatabase> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listDatabasesSinglePageAsync(accountName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<USqlDatabase>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlDatabase>>> call(String nextPageLink) {
                    return listDatabasesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlDatabase&gt; object
     */
    public Observable<Page<USqlDatabase>> listDatabasesAsync(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listDatabasesWithServiceResponseAsync(accountName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<USqlDatabase>>, Page<USqlDatabase>>() {
                @Override
                public Page<USqlDatabase> call(ServiceResponse<Page<USqlDatabase>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlDatabase&gt; object
     */
    public Observable<ServiceResponse<Page<USqlDatabase>>> listDatabasesWithServiceResponseAsync(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listDatabasesSinglePageAsync(accountName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<USqlDatabase>>, Observable<ServiceResponse<Page<USqlDatabase>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlDatabase>>> call(ServiceResponse<Page<USqlDatabase>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listDatabasesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlDatabase>> * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
    ServiceResponse<PageImpl<USqlDatabase>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<USqlDatabase>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<USqlDatabase>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<USqlDatabase>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<USqlDatabase>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<USqlDatabase>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlDatabase&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlDatabase>>> listDatabasesSinglePageAsync(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.listDatabases(filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlDatabase>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlDatabase>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlDatabase>> result = listDatabasesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlDatabase>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlDatabase>> listDatabasesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlDatabase>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlDatabase>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Grants an access control list (ACL) entry to the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param parameters Parameters supplied to create or update an access control list (ACL) entry for a Data Lake Analytics catalog.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void grantAcl(String accountName, AclCreateOrUpdateParameters parameters) {
        grantAclWithServiceResponseAsync(accountName, parameters).toBlocking().single().body();
    }

    /**
     * Grants an access control list (ACL) entry to the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param parameters Parameters supplied to create or update an access control list (ACL) entry for a Data Lake Analytics catalog.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> grantAclAsync(String accountName, AclCreateOrUpdateParameters parameters, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(grantAclWithServiceResponseAsync(accountName, parameters), serviceCallback);
    }

    /**
     * Grants an access control list (ACL) entry to the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param parameters Parameters supplied to create or update an access control list (ACL) entry for a Data Lake Analytics catalog.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> grantAclAsync(String accountName, AclCreateOrUpdateParameters parameters) {
        return grantAclWithServiceResponseAsync(accountName, parameters).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Grants an access control list (ACL) entry to the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param parameters Parameters supplied to create or update an access control list (ACL) entry for a Data Lake Analytics catalog.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> grantAclWithServiceResponseAsync(String accountName, AclCreateOrUpdateParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String op = "GRANTACE";
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.grantAcl(parameters, op, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = grantAclDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> grantAclDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Grants an access control list (ACL) entry to the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param parameters Parameters supplied to create or update an access control list (ACL) entry for a database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void grantAclToDatabase(String accountName, String databaseName, AclCreateOrUpdateParameters parameters) {
        grantAclToDatabaseWithServiceResponseAsync(accountName, databaseName, parameters).toBlocking().single().body();
    }

    /**
     * Grants an access control list (ACL) entry to the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param parameters Parameters supplied to create or update an access control list (ACL) entry for a database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> grantAclToDatabaseAsync(String accountName, String databaseName, AclCreateOrUpdateParameters parameters, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(grantAclToDatabaseWithServiceResponseAsync(accountName, databaseName, parameters), serviceCallback);
    }

    /**
     * Grants an access control list (ACL) entry to the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param parameters Parameters supplied to create or update an access control list (ACL) entry for a database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> grantAclToDatabaseAsync(String accountName, String databaseName, AclCreateOrUpdateParameters parameters) {
        return grantAclToDatabaseWithServiceResponseAsync(accountName, databaseName, parameters).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Grants an access control list (ACL) entry to the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param parameters Parameters supplied to create or update an access control list (ACL) entry for a database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> grantAclToDatabaseWithServiceResponseAsync(String accountName, String databaseName, AclCreateOrUpdateParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String op = "GRANTACE";
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.grantAclToDatabase(databaseName, parameters, op, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = grantAclToDatabaseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> grantAclToDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Revokes an access control list (ACL) entry from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param parameters Parameters supplied to delete an access control list (ACL) entry from a Data Lake Analytics catalog.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void revokeAcl(String accountName, AclDeleteParameters parameters) {
        revokeAclWithServiceResponseAsync(accountName, parameters).toBlocking().single().body();
    }

    /**
     * Revokes an access control list (ACL) entry from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param parameters Parameters supplied to delete an access control list (ACL) entry from a Data Lake Analytics catalog.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> revokeAclAsync(String accountName, AclDeleteParameters parameters, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(revokeAclWithServiceResponseAsync(accountName, parameters), serviceCallback);
    }

    /**
     * Revokes an access control list (ACL) entry from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param parameters Parameters supplied to delete an access control list (ACL) entry from a Data Lake Analytics catalog.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> revokeAclAsync(String accountName, AclDeleteParameters parameters) {
        return revokeAclWithServiceResponseAsync(accountName, parameters).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Revokes an access control list (ACL) entry from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param parameters Parameters supplied to delete an access control list (ACL) entry from a Data Lake Analytics catalog.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> revokeAclWithServiceResponseAsync(String accountName, AclDeleteParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String op = "REVOKEACE";
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.revokeAcl(parameters, op, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = revokeAclDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> revokeAclDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Revokes an access control list (ACL) entry for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param parameters Parameters supplied to delete an access control list (ACL) entry for a database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void revokeAclFromDatabase(String accountName, String databaseName, AclDeleteParameters parameters) {
        revokeAclFromDatabaseWithServiceResponseAsync(accountName, databaseName, parameters).toBlocking().single().body();
    }

    /**
     * Revokes an access control list (ACL) entry for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param parameters Parameters supplied to delete an access control list (ACL) entry for a database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> revokeAclFromDatabaseAsync(String accountName, String databaseName, AclDeleteParameters parameters, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(revokeAclFromDatabaseWithServiceResponseAsync(accountName, databaseName, parameters), serviceCallback);
    }

    /**
     * Revokes an access control list (ACL) entry for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param parameters Parameters supplied to delete an access control list (ACL) entry for a database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> revokeAclFromDatabaseAsync(String accountName, String databaseName, AclDeleteParameters parameters) {
        return revokeAclFromDatabaseWithServiceResponseAsync(accountName, databaseName, parameters).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Revokes an access control list (ACL) entry for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param parameters Parameters supplied to delete an access control list (ACL) entry for a database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> revokeAclFromDatabaseWithServiceResponseAsync(String accountName, String databaseName, AclDeleteParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaCatalogDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaCatalogDnsSuffix() is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String op = "REVOKEACE";
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaCatalogDnsSuffix}", this.client.adlaCatalogDnsSuffix());
        return service.revokeAclFromDatabase(databaseName, parameters, op, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = revokeAclFromDatabaseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> revokeAclFromDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlCredential&gt; object if successful.
     */
    public PagedList<USqlCredential> listCredentialsNext(final String nextPageLink) {
        ServiceResponse<Page<USqlCredential>> response = listCredentialsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlCredential>(response.body()) {
            @Override
            public Page<USqlCredential> nextPage(String nextPageLink) {
                return listCredentialsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlCredential>> listCredentialsNextAsync(final String nextPageLink, final ServiceFuture<List<USqlCredential>> serviceFuture, final ListOperationCallback<USqlCredential> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listCredentialsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlCredential>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlCredential>>> call(String nextPageLink) {
                    return listCredentialsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlCredential&gt; object
     */
    public Observable<Page<USqlCredential>> listCredentialsNextAsync(final String nextPageLink) {
        return listCredentialsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlCredential>>, Page<USqlCredential>>() {
                @Override
                public Page<USqlCredential> call(ServiceResponse<Page<USqlCredential>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlCredential&gt; object
     */
    public Observable<ServiceResponse<Page<USqlCredential>>> listCredentialsNextWithServiceResponseAsync(final String nextPageLink) {
        return listCredentialsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlCredential>>, Observable<ServiceResponse<Page<USqlCredential>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlCredential>>> call(ServiceResponse<Page<USqlCredential>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listCredentialsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlCredential>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlCredential&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlCredential>>> listCredentialsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listCredentialsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlCredential>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlCredential>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlCredential>> result = listCredentialsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlCredential>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlCredential>> listCredentialsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlCredential>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlCredential>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlExternalDataSource&gt; object if successful.
     */
    public PagedList<USqlExternalDataSource> listExternalDataSourcesNext(final String nextPageLink) {
        ServiceResponse<Page<USqlExternalDataSource>> response = listExternalDataSourcesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlExternalDataSource>(response.body()) {
            @Override
            public Page<USqlExternalDataSource> nextPage(String nextPageLink) {
                return listExternalDataSourcesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlExternalDataSource>> listExternalDataSourcesNextAsync(final String nextPageLink, final ServiceFuture<List<USqlExternalDataSource>> serviceFuture, final ListOperationCallback<USqlExternalDataSource> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listExternalDataSourcesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlExternalDataSource>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlExternalDataSource>>> call(String nextPageLink) {
                    return listExternalDataSourcesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlExternalDataSource&gt; object
     */
    public Observable<Page<USqlExternalDataSource>> listExternalDataSourcesNextAsync(final String nextPageLink) {
        return listExternalDataSourcesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlExternalDataSource>>, Page<USqlExternalDataSource>>() {
                @Override
                public Page<USqlExternalDataSource> call(ServiceResponse<Page<USqlExternalDataSource>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlExternalDataSource&gt; object
     */
    public Observable<ServiceResponse<Page<USqlExternalDataSource>>> listExternalDataSourcesNextWithServiceResponseAsync(final String nextPageLink) {
        return listExternalDataSourcesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlExternalDataSource>>, Observable<ServiceResponse<Page<USqlExternalDataSource>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlExternalDataSource>>> call(ServiceResponse<Page<USqlExternalDataSource>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listExternalDataSourcesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlExternalDataSource>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlExternalDataSource&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlExternalDataSource>>> listExternalDataSourcesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listExternalDataSourcesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlExternalDataSource>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlExternalDataSource>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlExternalDataSource>> result = listExternalDataSourcesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlExternalDataSource>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlExternalDataSource>> listExternalDataSourcesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlExternalDataSource>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlExternalDataSource>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlProcedure&gt; object if successful.
     */
    public PagedList<USqlProcedure> listProceduresNext(final String nextPageLink) {
        ServiceResponse<Page<USqlProcedure>> response = listProceduresNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlProcedure>(response.body()) {
            @Override
            public Page<USqlProcedure> nextPage(String nextPageLink) {
                return listProceduresNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlProcedure>> listProceduresNextAsync(final String nextPageLink, final ServiceFuture<List<USqlProcedure>> serviceFuture, final ListOperationCallback<USqlProcedure> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listProceduresNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlProcedure>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlProcedure>>> call(String nextPageLink) {
                    return listProceduresNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlProcedure&gt; object
     */
    public Observable<Page<USqlProcedure>> listProceduresNextAsync(final String nextPageLink) {
        return listProceduresNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlProcedure>>, Page<USqlProcedure>>() {
                @Override
                public Page<USqlProcedure> call(ServiceResponse<Page<USqlProcedure>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlProcedure&gt; object
     */
    public Observable<ServiceResponse<Page<USqlProcedure>>> listProceduresNextWithServiceResponseAsync(final String nextPageLink) {
        return listProceduresNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlProcedure>>, Observable<ServiceResponse<Page<USqlProcedure>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlProcedure>>> call(ServiceResponse<Page<USqlProcedure>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listProceduresNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlProcedure>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlProcedure&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlProcedure>>> listProceduresNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listProceduresNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlProcedure>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlProcedure>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlProcedure>> result = listProceduresNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlProcedure>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlProcedure>> listProceduresNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlProcedure>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlProcedure>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableFragment&gt; object if successful.
     */
    public PagedList<USqlTableFragment> listTableFragmentsNext(final String nextPageLink) {
        ServiceResponse<Page<USqlTableFragment>> response = listTableFragmentsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTableFragment>(response.body()) {
            @Override
            public Page<USqlTableFragment> nextPage(String nextPageLink) {
                return listTableFragmentsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableFragment>> listTableFragmentsNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTableFragment>> serviceFuture, final ListOperationCallback<USqlTableFragment> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableFragmentsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableFragment>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableFragment>>> call(String nextPageLink) {
                    return listTableFragmentsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableFragment&gt; object
     */
    public Observable<Page<USqlTableFragment>> listTableFragmentsNextAsync(final String nextPageLink) {
        return listTableFragmentsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlTableFragment>>, Page<USqlTableFragment>>() {
                @Override
                public Page<USqlTableFragment> call(ServiceResponse<Page<USqlTableFragment>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableFragment&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableFragment>>> listTableFragmentsNextWithServiceResponseAsync(final String nextPageLink) {
        return listTableFragmentsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableFragment>>, Observable<ServiceResponse<Page<USqlTableFragment>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableFragment>>> call(ServiceResponse<Page<USqlTableFragment>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableFragmentsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTableFragment>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableFragment&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableFragment>>> listTableFragmentsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listTableFragmentsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableFragment>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableFragment>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableFragment>> result = listTableFragmentsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableFragment>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTableFragment>> listTableFragmentsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTableFragment>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTableFragment>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTable&gt; object if successful.
     */
    public PagedList<USqlTable> listTablesNext(final String nextPageLink) {
        ServiceResponse<Page<USqlTable>> response = listTablesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTable>(response.body()) {
            @Override
            public Page<USqlTable> nextPage(String nextPageLink) {
                return listTablesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTable>> listTablesNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTable>> serviceFuture, final ListOperationCallback<USqlTable> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTablesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlTable>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTable>>> call(String nextPageLink) {
                    return listTablesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    public Observable<Page<USqlTable>> listTablesNextAsync(final String nextPageLink) {
        return listTablesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlTable>>, Page<USqlTable>>() {
                @Override
                public Page<USqlTable> call(ServiceResponse<Page<USqlTable>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTable>>> listTablesNextWithServiceResponseAsync(final String nextPageLink) {
        return listTablesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlTable>>, Observable<ServiceResponse<Page<USqlTable>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTable>>> call(ServiceResponse<Page<USqlTable>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTablesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTable>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTable&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTable>>> listTablesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listTablesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTable>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTable>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTable>> result = listTablesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTable>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTable>> listTablesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTable>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTable>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableStatistics&gt; object if successful.
     */
    public PagedList<USqlTableStatistics> listTableStatisticsByDatabaseAndSchemaNext(final String nextPageLink) {
        ServiceResponse<Page<USqlTableStatistics>> response = listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTableStatistics>(response.body()) {
            @Override
            public Page<USqlTableStatistics> nextPage(String nextPageLink) {
                return listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTableStatistics>> serviceFuture, final ListOperationCallback<USqlTableStatistics> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(String nextPageLink) {
                    return listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    public Observable<Page<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaNextAsync(final String nextPageLink) {
        return listTableStatisticsByDatabaseAndSchemaNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlTableStatistics>>, Page<USqlTableStatistics>>() {
                @Override
                public Page<USqlTableStatistics> call(ServiceResponse<Page<USqlTableStatistics>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseAndSchemaNextWithServiceResponseAsync(final String nextPageLink) {
        return listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableStatistics>>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(ServiceResponse<Page<USqlTableStatistics>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableStatisticsByDatabaseAndSchemaNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableStatistics&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseAndSchemaNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listTableStatisticsByDatabaseAndSchemaNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableStatistics>> result = listTableStatisticsByDatabaseAndSchemaNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableStatistics>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTableStatistics>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTableStatistics>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableType&gt; object if successful.
     */
    public PagedList<USqlTableType> listTableTypesNext(final String nextPageLink) {
        ServiceResponse<Page<USqlTableType>> response = listTableTypesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTableType>(response.body()) {
            @Override
            public Page<USqlTableType> nextPage(String nextPageLink) {
                return listTableTypesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableType>> listTableTypesNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTableType>> serviceFuture, final ListOperationCallback<USqlTableType> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableTypesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableType>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableType>>> call(String nextPageLink) {
                    return listTableTypesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableType&gt; object
     */
    public Observable<Page<USqlTableType>> listTableTypesNextAsync(final String nextPageLink) {
        return listTableTypesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlTableType>>, Page<USqlTableType>>() {
                @Override
                public Page<USqlTableType> call(ServiceResponse<Page<USqlTableType>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableType&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableType>>> listTableTypesNextWithServiceResponseAsync(final String nextPageLink) {
        return listTableTypesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableType>>, Observable<ServiceResponse<Page<USqlTableType>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableType>>> call(ServiceResponse<Page<USqlTableType>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableTypesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTableType>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableType&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableType>>> listTableTypesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listTableTypesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableType>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableType>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableType>> result = listTableTypesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableType>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTableType>> listTableTypesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTableType>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTableType>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlPackage&gt; object if successful.
     */
    public PagedList<USqlPackage> listPackagesNext(final String nextPageLink) {
        ServiceResponse<Page<USqlPackage>> response = listPackagesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlPackage>(response.body()) {
            @Override
            public Page<USqlPackage> nextPage(String nextPageLink) {
                return listPackagesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlPackage>> listPackagesNextAsync(final String nextPageLink, final ServiceFuture<List<USqlPackage>> serviceFuture, final ListOperationCallback<USqlPackage> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listPackagesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlPackage>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlPackage>>> call(String nextPageLink) {
                    return listPackagesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlPackage&gt; object
     */
    public Observable<Page<USqlPackage>> listPackagesNextAsync(final String nextPageLink) {
        return listPackagesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlPackage>>, Page<USqlPackage>>() {
                @Override
                public Page<USqlPackage> call(ServiceResponse<Page<USqlPackage>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlPackage&gt; object
     */
    public Observable<ServiceResponse<Page<USqlPackage>>> listPackagesNextWithServiceResponseAsync(final String nextPageLink) {
        return listPackagesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlPackage>>, Observable<ServiceResponse<Page<USqlPackage>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlPackage>>> call(ServiceResponse<Page<USqlPackage>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listPackagesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlPackage>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlPackage&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlPackage>>> listPackagesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listPackagesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlPackage>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlPackage>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlPackage>> result = listPackagesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlPackage>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlPackage>> listPackagesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlPackage>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlPackage>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlView&gt; object if successful.
     */
    public PagedList<USqlView> listViewsNext(final String nextPageLink) {
        ServiceResponse<Page<USqlView>> response = listViewsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlView>(response.body()) {
            @Override
            public Page<USqlView> nextPage(String nextPageLink) {
                return listViewsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlView>> listViewsNextAsync(final String nextPageLink, final ServiceFuture<List<USqlView>> serviceFuture, final ListOperationCallback<USqlView> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listViewsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlView>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlView>>> call(String nextPageLink) {
                    return listViewsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    public Observable<Page<USqlView>> listViewsNextAsync(final String nextPageLink) {
        return listViewsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlView>>, Page<USqlView>>() {
                @Override
                public Page<USqlView> call(ServiceResponse<Page<USqlView>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    public Observable<ServiceResponse<Page<USqlView>>> listViewsNextWithServiceResponseAsync(final String nextPageLink) {
        return listViewsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlView>>, Observable<ServiceResponse<Page<USqlView>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlView>>> call(ServiceResponse<Page<USqlView>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listViewsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlView>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlView&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlView>>> listViewsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listViewsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlView>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlView>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlView>> result = listViewsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlView>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlView>> listViewsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlView>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlView>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableStatistics&gt; object if successful.
     */
    public PagedList<USqlTableStatistics> listTableStatisticsNext(final String nextPageLink) {
        ServiceResponse<Page<USqlTableStatistics>> response = listTableStatisticsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTableStatistics>(response.body()) {
            @Override
            public Page<USqlTableStatistics> nextPage(String nextPageLink) {
                return listTableStatisticsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableStatistics>> listTableStatisticsNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTableStatistics>> serviceFuture, final ListOperationCallback<USqlTableStatistics> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableStatisticsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(String nextPageLink) {
                    return listTableStatisticsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    public Observable<Page<USqlTableStatistics>> listTableStatisticsNextAsync(final String nextPageLink) {
        return listTableStatisticsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlTableStatistics>>, Page<USqlTableStatistics>>() {
                @Override
                public Page<USqlTableStatistics> call(ServiceResponse<Page<USqlTableStatistics>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsNextWithServiceResponseAsync(final String nextPageLink) {
        return listTableStatisticsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableStatistics>>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(ServiceResponse<Page<USqlTableStatistics>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableStatisticsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableStatistics&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listTableStatisticsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableStatistics>> result = listTableStatisticsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableStatistics>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTableStatistics>> listTableStatisticsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTableStatistics>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTableStatistics>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTablePartition&gt; object if successful.
     */
    public PagedList<USqlTablePartition> listTablePartitionsNext(final String nextPageLink) {
        ServiceResponse<Page<USqlTablePartition>> response = listTablePartitionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTablePartition>(response.body()) {
            @Override
            public Page<USqlTablePartition> nextPage(String nextPageLink) {
                return listTablePartitionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTablePartition>> listTablePartitionsNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTablePartition>> serviceFuture, final ListOperationCallback<USqlTablePartition> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTablePartitionsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlTablePartition>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTablePartition>>> call(String nextPageLink) {
                    return listTablePartitionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTablePartition&gt; object
     */
    public Observable<Page<USqlTablePartition>> listTablePartitionsNextAsync(final String nextPageLink) {
        return listTablePartitionsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlTablePartition>>, Page<USqlTablePartition>>() {
                @Override
                public Page<USqlTablePartition> call(ServiceResponse<Page<USqlTablePartition>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTablePartition&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTablePartition>>> listTablePartitionsNextWithServiceResponseAsync(final String nextPageLink) {
        return listTablePartitionsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlTablePartition>>, Observable<ServiceResponse<Page<USqlTablePartition>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTablePartition>>> call(ServiceResponse<Page<USqlTablePartition>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTablePartitionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTablePartition>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTablePartition&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTablePartition>>> listTablePartitionsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listTablePartitionsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTablePartition>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTablePartition>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTablePartition>> result = listTablePartitionsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTablePartition>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTablePartition>> listTablePartitionsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTablePartition>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTablePartition>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlType&gt; object if successful.
     */
    public PagedList<USqlType> listTypesNext(final String nextPageLink) {
        ServiceResponse<Page<USqlType>> response = listTypesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlType>(response.body()) {
            @Override
            public Page<USqlType> nextPage(String nextPageLink) {
                return listTypesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlType>> listTypesNextAsync(final String nextPageLink, final ServiceFuture<List<USqlType>> serviceFuture, final ListOperationCallback<USqlType> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTypesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlType>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlType>>> call(String nextPageLink) {
                    return listTypesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlType&gt; object
     */
    public Observable<Page<USqlType>> listTypesNextAsync(final String nextPageLink) {
        return listTypesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlType>>, Page<USqlType>>() {
                @Override
                public Page<USqlType> call(ServiceResponse<Page<USqlType>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlType&gt; object
     */
    public Observable<ServiceResponse<Page<USqlType>>> listTypesNextWithServiceResponseAsync(final String nextPageLink) {
        return listTypesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlType>>, Observable<ServiceResponse<Page<USqlType>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlType>>> call(ServiceResponse<Page<USqlType>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTypesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlType>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlType&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlType>>> listTypesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listTypesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlType>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlType>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlType>> result = listTypesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlType>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlType>> listTypesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlType>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlType>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableValuedFunction&gt; object if successful.
     */
    public PagedList<USqlTableValuedFunction> listTableValuedFunctionsNext(final String nextPageLink) {
        ServiceResponse<Page<USqlTableValuedFunction>> response = listTableValuedFunctionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTableValuedFunction>(response.body()) {
            @Override
            public Page<USqlTableValuedFunction> nextPage(String nextPageLink) {
                return listTableValuedFunctionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableValuedFunction>> listTableValuedFunctionsNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTableValuedFunction>> serviceFuture, final ListOperationCallback<USqlTableValuedFunction> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableValuedFunctionsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(String nextPageLink) {
                    return listTableValuedFunctionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    public Observable<Page<USqlTableValuedFunction>> listTableValuedFunctionsNextAsync(final String nextPageLink) {
        return listTableValuedFunctionsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Page<USqlTableValuedFunction>>() {
                @Override
                public Page<USqlTableValuedFunction> call(ServiceResponse<Page<USqlTableValuedFunction>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsNextWithServiceResponseAsync(final String nextPageLink) {
        return listTableValuedFunctionsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(ServiceResponse<Page<USqlTableValuedFunction>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableValuedFunctionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableValuedFunction&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listTableValuedFunctionsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableValuedFunction>> result = listTableValuedFunctionsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableValuedFunction>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTableValuedFunction>> listTableValuedFunctionsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTableValuedFunction>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTableValuedFunction>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlAssemblyClr&gt; object if successful.
     */
    public PagedList<USqlAssemblyClr> listAssembliesNext(final String nextPageLink) {
        ServiceResponse<Page<USqlAssemblyClr>> response = listAssembliesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlAssemblyClr>(response.body()) {
            @Override
            public Page<USqlAssemblyClr> nextPage(String nextPageLink) {
                return listAssembliesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlAssemblyClr>> listAssembliesNextAsync(final String nextPageLink, final ServiceFuture<List<USqlAssemblyClr>> serviceFuture, final ListOperationCallback<USqlAssemblyClr> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAssembliesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlAssemblyClr>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlAssemblyClr>>> call(String nextPageLink) {
                    return listAssembliesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlAssemblyClr&gt; object
     */
    public Observable<Page<USqlAssemblyClr>> listAssembliesNextAsync(final String nextPageLink) {
        return listAssembliesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlAssemblyClr>>, Page<USqlAssemblyClr>>() {
                @Override
                public Page<USqlAssemblyClr> call(ServiceResponse<Page<USqlAssemblyClr>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlAssemblyClr&gt; object
     */
    public Observable<ServiceResponse<Page<USqlAssemblyClr>>> listAssembliesNextWithServiceResponseAsync(final String nextPageLink) {
        return listAssembliesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlAssemblyClr>>, Observable<ServiceResponse<Page<USqlAssemblyClr>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlAssemblyClr>>> call(ServiceResponse<Page<USqlAssemblyClr>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAssembliesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlAssemblyClr>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlAssemblyClr&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlAssemblyClr>>> listAssembliesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listAssembliesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlAssemblyClr>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlAssemblyClr>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlAssemblyClr>> result = listAssembliesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlAssemblyClr>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlAssemblyClr>> listAssembliesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlAssemblyClr>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlAssemblyClr>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlSchema&gt; object if successful.
     */
    public PagedList<USqlSchema> listSchemasNext(final String nextPageLink) {
        ServiceResponse<Page<USqlSchema>> response = listSchemasNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlSchema>(response.body()) {
            @Override
            public Page<USqlSchema> nextPage(String nextPageLink) {
                return listSchemasNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlSchema>> listSchemasNextAsync(final String nextPageLink, final ServiceFuture<List<USqlSchema>> serviceFuture, final ListOperationCallback<USqlSchema> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSchemasNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlSchema>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlSchema>>> call(String nextPageLink) {
                    return listSchemasNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlSchema&gt; object
     */
    public Observable<Page<USqlSchema>> listSchemasNextAsync(final String nextPageLink) {
        return listSchemasNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlSchema>>, Page<USqlSchema>>() {
                @Override
                public Page<USqlSchema> call(ServiceResponse<Page<USqlSchema>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlSchema&gt; object
     */
    public Observable<ServiceResponse<Page<USqlSchema>>> listSchemasNextWithServiceResponseAsync(final String nextPageLink) {
        return listSchemasNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlSchema>>, Observable<ServiceResponse<Page<USqlSchema>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlSchema>>> call(ServiceResponse<Page<USqlSchema>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSchemasNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlSchema>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlSchema&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlSchema>>> listSchemasNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listSchemasNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlSchema>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlSchema>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlSchema>> result = listSchemasNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlSchema>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlSchema>> listSchemasNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlSchema>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlSchema>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableStatistics&gt; object if successful.
     */
    public PagedList<USqlTableStatistics> listTableStatisticsByDatabaseNext(final String nextPageLink) {
        ServiceResponse<Page<USqlTableStatistics>> response = listTableStatisticsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTableStatistics>(response.body()) {
            @Override
            public Page<USqlTableStatistics> nextPage(String nextPageLink) {
                return listTableStatisticsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableStatistics>> listTableStatisticsByDatabaseNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTableStatistics>> serviceFuture, final ListOperationCallback<USqlTableStatistics> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableStatisticsByDatabaseNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(String nextPageLink) {
                    return listTableStatisticsByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    public Observable<Page<USqlTableStatistics>> listTableStatisticsByDatabaseNextAsync(final String nextPageLink) {
        return listTableStatisticsByDatabaseNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlTableStatistics>>, Page<USqlTableStatistics>>() {
                @Override
                public Page<USqlTableStatistics> call(ServiceResponse<Page<USqlTableStatistics>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseNextWithServiceResponseAsync(final String nextPageLink) {
        return listTableStatisticsByDatabaseNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableStatistics>>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(ServiceResponse<Page<USqlTableStatistics>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableStatisticsByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTableStatistics>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableStatistics&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listTableStatisticsByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableStatistics>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableStatistics>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableStatistics>> result = listTableStatisticsByDatabaseNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableStatistics>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTableStatistics>> listTableStatisticsByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTableStatistics>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTableStatistics>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTable&gt; object if successful.
     */
    public PagedList<USqlTable> listTablesByDatabaseNext(final String nextPageLink) {
        ServiceResponse<Page<USqlTable>> response = listTablesByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTable>(response.body()) {
            @Override
            public Page<USqlTable> nextPage(String nextPageLink) {
                return listTablesByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTable>> listTablesByDatabaseNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTable>> serviceFuture, final ListOperationCallback<USqlTable> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTablesByDatabaseNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlTable>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTable>>> call(String nextPageLink) {
                    return listTablesByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    public Observable<Page<USqlTable>> listTablesByDatabaseNextAsync(final String nextPageLink) {
        return listTablesByDatabaseNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlTable>>, Page<USqlTable>>() {
                @Override
                public Page<USqlTable> call(ServiceResponse<Page<USqlTable>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTable>>> listTablesByDatabaseNextWithServiceResponseAsync(final String nextPageLink) {
        return listTablesByDatabaseNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlTable>>, Observable<ServiceResponse<Page<USqlTable>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTable>>> call(ServiceResponse<Page<USqlTable>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTablesByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTable>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTable&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTable>>> listTablesByDatabaseNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listTablesByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTable>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTable>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTable>> result = listTablesByDatabaseNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTable>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTable>> listTablesByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTable>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTable>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableValuedFunction&gt; object if successful.
     */
    public PagedList<USqlTableValuedFunction> listTableValuedFunctionsByDatabaseNext(final String nextPageLink) {
        ServiceResponse<Page<USqlTableValuedFunction>> response = listTableValuedFunctionsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlTableValuedFunction>(response.body()) {
            @Override
            public Page<USqlTableValuedFunction> nextPage(String nextPageLink) {
                return listTableValuedFunctionsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTableValuedFunction>> serviceFuture, final ListOperationCallback<USqlTableValuedFunction> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listTableValuedFunctionsByDatabaseNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(String nextPageLink) {
                    return listTableValuedFunctionsByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    public Observable<Page<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseNextAsync(final String nextPageLink) {
        return listTableValuedFunctionsByDatabaseNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Page<USqlTableValuedFunction>>() {
                @Override
                public Page<USqlTableValuedFunction> call(ServiceResponse<Page<USqlTableValuedFunction>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsByDatabaseNextWithServiceResponseAsync(final String nextPageLink) {
        return listTableValuedFunctionsByDatabaseNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlTableValuedFunction>>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(ServiceResponse<Page<USqlTableValuedFunction>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listTableValuedFunctionsByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlTableValuedFunction>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlTableValuedFunction&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsByDatabaseNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listTableValuedFunctionsByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlTableValuedFunction>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlTableValuedFunction>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlTableValuedFunction>> result = listTableValuedFunctionsByDatabaseNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlTableValuedFunction>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlTableValuedFunction>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlTableValuedFunction>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlView&gt; object if successful.
     */
    public PagedList<USqlView> listViewsByDatabaseNext(final String nextPageLink) {
        ServiceResponse<Page<USqlView>> response = listViewsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlView>(response.body()) {
            @Override
            public Page<USqlView> nextPage(String nextPageLink) {
                return listViewsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlView>> listViewsByDatabaseNextAsync(final String nextPageLink, final ServiceFuture<List<USqlView>> serviceFuture, final ListOperationCallback<USqlView> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listViewsByDatabaseNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlView>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlView>>> call(String nextPageLink) {
                    return listViewsByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    public Observable<Page<USqlView>> listViewsByDatabaseNextAsync(final String nextPageLink) {
        return listViewsByDatabaseNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlView>>, Page<USqlView>>() {
                @Override
                public Page<USqlView> call(ServiceResponse<Page<USqlView>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    public Observable<ServiceResponse<Page<USqlView>>> listViewsByDatabaseNextWithServiceResponseAsync(final String nextPageLink) {
        return listViewsByDatabaseNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlView>>, Observable<ServiceResponse<Page<USqlView>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlView>>> call(ServiceResponse<Page<USqlView>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listViewsByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlView>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlView&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlView>>> listViewsByDatabaseNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listViewsByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlView>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlView>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlView>> result = listViewsByDatabaseNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlView>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlView>> listViewsByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlView>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlView>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;Acl&gt; object if successful.
     */
    public PagedList<Acl> listAclsByDatabaseNext(final String nextPageLink) {
        ServiceResponse<Page<Acl>> response = listAclsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<Acl>(response.body()) {
            @Override
            public Page<Acl> nextPage(String nextPageLink) {
                return listAclsByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<Acl>> listAclsByDatabaseNextAsync(final String nextPageLink, final ServiceFuture<List<Acl>> serviceFuture, final ListOperationCallback<Acl> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAclsByDatabaseNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<Acl>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Acl>>> call(String nextPageLink) {
                    return listAclsByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    public Observable<Page<Acl>> listAclsByDatabaseNextAsync(final String nextPageLink) {
        return listAclsByDatabaseNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<Acl>>, Page<Acl>>() {
                @Override
                public Page<Acl> call(ServiceResponse<Page<Acl>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    public Observable<ServiceResponse<Page<Acl>>> listAclsByDatabaseNextWithServiceResponseAsync(final String nextPageLink) {
        return listAclsByDatabaseNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<Acl>>, Observable<ServiceResponse<Page<Acl>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Acl>>> call(ServiceResponse<Page<Acl>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAclsByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<Acl>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;Acl&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<Acl>>> listAclsByDatabaseNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listAclsByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Acl>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Acl>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<Acl>> result = listAclsByDatabaseNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<Acl>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<Acl>> listAclsByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<Acl>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<Acl>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;Acl&gt; object if successful.
     */
    public PagedList<Acl> listAclsNext(final String nextPageLink) {
        ServiceResponse<Page<Acl>> response = listAclsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<Acl>(response.body()) {
            @Override
            public Page<Acl> nextPage(String nextPageLink) {
                return listAclsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<Acl>> listAclsNextAsync(final String nextPageLink, final ServiceFuture<List<Acl>> serviceFuture, final ListOperationCallback<Acl> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAclsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<Acl>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Acl>>> call(String nextPageLink) {
                    return listAclsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    public Observable<Page<Acl>> listAclsNextAsync(final String nextPageLink) {
        return listAclsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<Acl>>, Page<Acl>>() {
                @Override
                public Page<Acl> call(ServiceResponse<Page<Acl>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    public Observable<ServiceResponse<Page<Acl>>> listAclsNextWithServiceResponseAsync(final String nextPageLink) {
        return listAclsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<Acl>>, Observable<ServiceResponse<Page<Acl>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Acl>>> call(ServiceResponse<Page<Acl>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAclsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<Acl>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;Acl&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<Acl>>> listAclsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listAclsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Acl>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Acl>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<Acl>> result = listAclsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<Acl>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<Acl>> listAclsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<Acl>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<Acl>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlDatabase&gt; object if successful.
     */
    public PagedList<USqlDatabase> listDatabasesNext(final String nextPageLink) {
        ServiceResponse<Page<USqlDatabase>> response = listDatabasesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<USqlDatabase>(response.body()) {
            @Override
            public Page<USqlDatabase> nextPage(String nextPageLink) {
                return listDatabasesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<USqlDatabase>> listDatabasesNextAsync(final String nextPageLink, final ServiceFuture<List<USqlDatabase>> serviceFuture, final ListOperationCallback<USqlDatabase> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listDatabasesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<USqlDatabase>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlDatabase>>> call(String nextPageLink) {
                    return listDatabasesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlDatabase&gt; object
     */
    public Observable<Page<USqlDatabase>> listDatabasesNextAsync(final String nextPageLink) {
        return listDatabasesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<USqlDatabase>>, Page<USqlDatabase>>() {
                @Override
                public Page<USqlDatabase> call(ServiceResponse<Page<USqlDatabase>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlDatabase&gt; object
     */
    public Observable<ServiceResponse<Page<USqlDatabase>>> listDatabasesNextWithServiceResponseAsync(final String nextPageLink) {
        return listDatabasesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<USqlDatabase>>, Observable<ServiceResponse<Page<USqlDatabase>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlDatabase>>> call(ServiceResponse<Page<USqlDatabase>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listDatabasesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
    ServiceResponse<PageImpl<USqlDatabase>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;USqlDatabase&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<USqlDatabase>>> listDatabasesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listDatabasesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<USqlDatabase>>>>() {
                @Override
                public Observable<ServiceResponse<Page<USqlDatabase>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<USqlDatabase>> result = listDatabasesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<USqlDatabase>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<USqlDatabase>> listDatabasesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<USqlDatabase>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<USqlDatabase>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
