/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.analytics;

import com.microsoft.azure.AzureClient;
import com.microsoft.rest.RestClient;

/**
 * The interface for DataLakeAnalyticsJobManagementClient class.
 */
public interface DataLakeAnalyticsJobManagementClient {
    /**
     * Gets the REST client.
     *
     * @return the {@link RestClient} object.
    */
    RestClient restClient();

    /**
     * Gets the {@link AzureClient} used for long running operations.
     * @return the azure client;
     */
    AzureClient getAzureClient();

    /**
     * Gets the User-Agent header for the client.
     *
     * @return the user agent string.
     */
    String userAgent();

    /**
     * Gets The DNS suffix used as the base for all Azure Data Lake Analytics Job service requests..
     *
     * @return the adlaJobDnsSuffix value.
     */
    String adlaJobDnsSuffix();

    /**
     * Sets The DNS suffix used as the base for all Azure Data Lake Analytics Job service requests..
     *
     * @param adlaJobDnsSuffix the adlaJobDnsSuffix value.
     * @return the service client itself
     */
    DataLakeAnalyticsJobManagementClient withAdlaJobDnsSuffix(String adlaJobDnsSuffix);

    /**
     * Gets Client Api Version..
     *
     * @return the apiVersion value.
     */
    String apiVersion();

    /**
     * Gets The preferred language for the response..
     *
     * @return the acceptLanguage value.
     */
    String acceptLanguage();

    /**
     * Sets The preferred language for the response..
     *
     * @param acceptLanguage the acceptLanguage value.
     * @return the service client itself
     */
    DataLakeAnalyticsJobManagementClient withAcceptLanguage(String acceptLanguage);

    /**
     * Gets The retry timeout in seconds for Long Running Operations. Default value is 30..
     *
     * @return the longRunningOperationRetryTimeout value.
     */
    int longRunningOperationRetryTimeout();

    /**
     * Sets The retry timeout in seconds for Long Running Operations. Default value is 30..
     *
     * @param longRunningOperationRetryTimeout the longRunningOperationRetryTimeout value.
     * @return the service client itself
     */
    DataLakeAnalyticsJobManagementClient withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout);

    /**
     * Gets Whether a unique x-ms-client-request-id should be generated. When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true..
     *
     * @return the generateClientRequestId value.
     */
    boolean generateClientRequestId();

    /**
     * Sets Whether a unique x-ms-client-request-id should be generated. When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true..
     *
     * @param generateClientRequestId the generateClientRequestId value.
     * @return the service client itself
     */
    DataLakeAnalyticsJobManagementClient withGenerateClientRequestId(boolean generateClientRequestId);

    /**
     * Gets the Jobs object to access its operations.
     * @return the Jobs object.
     */
    Jobs jobs();

    /**
     * Gets the Pipelines object to access its operations.
     * @return the Pipelines object.
     */
    Pipelines pipelines();

    /**
     * Gets the Recurrences object to access its operations.
     * @return the Recurrences object.
     */
    Recurrences recurrences();

}
