/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerinstance.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.containerinstance.implementation.ContainerInstanceManagementClientImpl;
import com.microsoft.azure.management.containerinstance.implementation.OperationListResultInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class OperationsInner {
    private OperationsService service;
    private ContainerInstanceManagementClientImpl client;

    public OperationsInner(Retrofit retrofit, ContainerInstanceManagementClientImpl client) {
        this.service = (OperationsService)retrofit.create(OperationsService.class);
        this.client = client;
    }

    public OperationListResultInner list() {
        return (OperationListResultInner)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<OperationListResultInner> listAsync(ServiceCallback<OperationListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<OperationListResultInner> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<OperationListResultInner>, OperationListResultInner>(){

            public OperationListResultInner call(ServiceResponse<OperationListResultInner> response) {
                return (OperationListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationListResultInner>> listWithServiceResponseAsync() {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OperationListResultInner>>>(){

            public Observable<ServiceResponse<OperationListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = OperationsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OperationListResultInner> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OperationListResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface OperationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.Operations list"})
        @GET(value="providers/Microsoft.ContainerInstance/operations")
        public Observable<Response<ResponseBody>> list(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

