/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerinstance.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerinstance.Container;
import com.microsoft.azure.management.containerinstance.ContainerGroup;
import com.microsoft.azure.management.containerinstance.ContainerGroupNetworkProtocol;
import com.microsoft.azure.management.containerinstance.ContainerRestartPolicy;
import com.microsoft.azure.management.containerinstance.ImageRegistryCredential;
import com.microsoft.azure.management.containerinstance.OperatingSystemTypes;
import com.microsoft.azure.management.containerinstance.Port;
import com.microsoft.azure.management.containerinstance.Volume;
import com.microsoft.azure.management.containerinstance.implementation.ContainerGroupInner;
import com.microsoft.azure.management.containerinstance.implementation.ContainerImpl;
import com.microsoft.azure.management.containerinstance.implementation.ContainerInstanceManagementClientImpl;
import com.microsoft.azure.management.containerinstance.implementation.ContainerInstanceManager;
import com.microsoft.azure.management.containerinstance.implementation.VolumeImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.StorageAccountKey;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.file.CloudFileClient;
import com.microsoft.azure.storage.file.CloudFileShare;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.tuple.Triple;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Action2;
import rx.functions.Func0;
import rx.functions.Func1;

@LangDefinition
public class ContainerGroupImpl
extends GroupableParentResourceImpl<ContainerGroup, ContainerGroupInner, ContainerGroupImpl, ContainerInstanceManager>
implements ContainerGroup,
ContainerGroup.Definition {
    private final StorageManager storageManager;
    private String creatableStorageAccountKey;
    private Map<String, String> newFileShares;
    private Map<String, Container> containers;
    private Map<String, Volume> volumes;
    private List<String> imageRegistryServers;
    private int[] externalTcpPorts;
    private int[] externalUdpPorts;

    protected ContainerGroupImpl(String name, ContainerGroupInner innerObject, ContainerInstanceManager manager, StorageManager storageManager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
        this.storageManager = storageManager;
    }

    protected void beforeCreating() {
    }

    protected Observable<ContainerGroupInner> createInner() {
        final ContainerGroupImpl self = this;
        if (!this.isInCreateMode()) {
            throw new UnsupportedOperationException("Update on an existing container group resource is not supported");
        }
        if (this.newFileShares == null || this.creatableStorageAccountKey == null) {
            return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containerGroups().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ContainerGroupInner)((Object)this.inner()));
        }
        final StorageAccount storageAccount = (StorageAccount)this.createdResource(this.creatableStorageAccountKey);
        return this.createFileShareAsync(storageAccount).collect((Func0)new Func0<List<Triple<String, String, String>>>(){

            public List<Triple<String, String, String>> call() {
                return new ArrayList<Triple<String, String, String>>();
            }
        }, (Action2)new Action2<List<Triple<String, String, String>>, Triple<String, String, String>>(){

            public void call(List<Triple<String, String, String>> cloudFileShares, Triple<String, String, String> fileShare) {
                cloudFileShares.add(fileShare);
            }
        }).flatMap((Func1)new Func1<List<Triple<String, String, String>>, Observable<? extends ContainerGroupInner>>(){

            public Observable<? extends ContainerGroupInner> call(List<Triple<String, String, String>> fileShares) {
                for (Triple<String, String, String> fileShareEntry : fileShares) {
                    self.defineVolume((String)fileShareEntry.getLeft()).withExistingReadWriteAzureFileShare((String)fileShareEntry.getMiddle()).withStorageAccountName(storageAccount.name()).withStorageAccountKey((String)fileShareEntry.getRight()).attach();
                }
                return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)self.manager()).inner())).containerGroups().createOrUpdateAsync(self.resourceGroupName(), self.name(), (ContainerGroupInner)((Object)self.inner()));
            }
        });
    }

    private Observable<Triple<String, String, String>> createFileShareAsync(final StorageAccount storageAccount) {
        return storageAccount.getKeysAsync().map((Func1)new Func1<List<StorageAccountKey>, String>(){

            public String call(List<StorageAccountKey> storageAccountKeys) {
                return storageAccountKeys.get(0).value();
            }
        }).flatMap((Func1)new Func1<String, Observable<Triple<String, String, String>>>(){
            CloudFileClient cloudFileClient;

            public Observable<Triple<String, String, String>> call(final String storageAccountKey) {
                try {
                    this.cloudFileClient = CloudStorageAccount.parse((String)String.format("DefaultEndpointsProtocol=https;AccountName=%s;AccountKey=%s;EndpointSuffix=core.windows.net", storageAccount.name(), storageAccountKey)).createCloudFileClient();
                }
                catch (URISyntaxException syntaxException) {
                    throw Exceptions.propagate((Throwable)syntaxException);
                }
                catch (InvalidKeyException keyException) {
                    throw Exceptions.propagate((Throwable)keyException);
                }
                return Observable.from(ContainerGroupImpl.this.newFileShares.entrySet()).flatMap((Func1)new Func1<Map.Entry<String, String>, Observable<Triple<String, String, String>>>(){

                    public Observable<Triple<String, String, String>> call(Map.Entry<String, String> fileShareEntry) {
                        return ContainerGroupImpl.this.createSingleFileShareAsync(cloudFileClient, fileShareEntry.getKey(), fileShareEntry.getValue(), storageAccountKey);
                    }
                });
            }
        });
    }

    private Observable<Triple<String, String, String>> createSingleFileShareAsync(final CloudFileClient client, final String volumeName, final String fileShareName, final String storageAccountKey) {
        return Observable.fromCallable((Callable)new Callable<Triple<String, String, String>>(){

            @Override
            public Triple<String, String, String> call() throws Exception {
                CloudFileShare cloudFileShare = client.getShareReference(fileShareName);
                cloudFileShare.createIfNotExists();
                return Triple.of((Object)volumeName, (Object)fileShareName, (Object)storageAccountKey);
            }
        });
    }

    protected void afterCreating() {
        this.initializeChildrenFromInner();
    }

    protected void initializeChildrenFromInner() {
        this.containers = new HashMap<String, Container>();
        if (((ContainerGroupInner)((Object)this.inner())).containers() != null && ((ContainerGroupInner)((Object)this.inner())).containers().size() > 0) {
            for (Container containerInstance : ((ContainerGroupInner)((Object)this.inner())).containers()) {
                this.containers.put(containerInstance.name(), containerInstance);
            }
        }
        this.volumes = new HashMap<String, Volume>();
        if (((ContainerGroupInner)((Object)this.inner())).volumes() != null && ((ContainerGroupInner)((Object)this.inner())).volumes().size() > 0) {
            for (Volume volume : ((ContainerGroupInner)((Object)this.inner())).volumes()) {
                this.volumes.put(volume.name(), volume);
            }
        }
        this.imageRegistryServers = new ArrayList<String>();
        if (((ContainerGroupInner)((Object)this.inner())).imageRegistryCredentials() != null && ((ContainerGroupInner)((Object)this.inner())).imageRegistryCredentials().size() > 0) {
            for (ImageRegistryCredential imageRegistry : ((ContainerGroupInner)((Object)this.inner())).imageRegistryCredentials()) {
                this.imageRegistryServers.add(imageRegistry.server());
            }
        }
        if (((ContainerGroupInner)((Object)this.inner())).ipAddress() != null && ((ContainerGroupInner)((Object)this.inner())).ipAddress().ports() != null) {
            int i;
            ArrayList<Port> tcpPorts = new ArrayList<Port>();
            ArrayList<Port> udpPorts = new ArrayList<Port>();
            for (Port port : ((ContainerGroupInner)((Object)this.inner())).ipAddress().ports()) {
                if (port.protocol().equals(ContainerGroupNetworkProtocol.TCP)) {
                    tcpPorts.add(port);
                    continue;
                }
                if (!port.protocol().equals(ContainerGroupNetworkProtocol.UDP)) continue;
                udpPorts.add(port);
            }
            this.externalTcpPorts = new int[tcpPorts.size()];
            for (i = 0; i < this.externalTcpPorts.length; ++i) {
                this.externalTcpPorts[i] = ((Port)tcpPorts.get(i)).port();
            }
            this.externalUdpPorts = new int[udpPorts.size()];
            for (i = 0; i < this.externalTcpPorts.length; ++i) {
                this.externalTcpPorts[i] = ((Port)tcpPorts.get(i)).port();
            }
        } else {
            this.externalTcpPorts = new int[0];
            this.externalUdpPorts = new int[0];
        }
    }

    public Observable<ContainerGroup> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<ContainerGroup, ContainerGroup>(){

            public ContainerGroup call(ContainerGroup containerGroup) {
                ContainerGroupImpl impl = (ContainerGroupImpl)containerGroup;
                impl.initializeChildrenFromInner();
                return impl;
            }
        });
    }

    protected Observable<ContainerGroupInner> getInnerAsync() {
        return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containerGroups().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public ContainerGroupImpl withLinux() {
        ((ContainerGroupInner)((Object)this.inner())).withOsType(OperatingSystemTypes.LINUX);
        return this;
    }

    @Override
    public ContainerGroupImpl withWindows() {
        ((ContainerGroupInner)((Object)this.inner())).withOsType(OperatingSystemTypes.WINDOWS);
        return this;
    }

    @Override
    public ContainerGroupImpl withPublicImageRegistryOnly() {
        ((ContainerGroupInner)((Object)this.inner())).withImageRegistryCredentials(null);
        return this;
    }

    @Override
    public ContainerGroupImpl withPrivateImageRegistry(String server, String username, String password) {
        if (((ContainerGroupInner)((Object)this.inner())).imageRegistryCredentials() == null) {
            ((ContainerGroupInner)((Object)this.inner())).withImageRegistryCredentials(new ArrayList<ImageRegistryCredential>());
        }
        ((ContainerGroupInner)((Object)this.inner())).imageRegistryCredentials().add(new ImageRegistryCredential().withServer(server).withUsername(username).withPassword(password));
        return this;
    }

    @Override
    public ContainerGroupImpl withNewAzureFileShareVolume(String volumeName, String shareName) {
        if (this.newFileShares == null || this.creatableStorageAccountKey == null) {
            StorageAccount.DefinitionStages.WithGroup definitionWithGroup = (StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(SdkContext.randomResourceName((String)"fs", (int)24))).withRegion(this.regionName());
            Creatable creatable = this.creatableGroup != null ? (Creatable)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (Creatable)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
            this.creatableStorageAccountKey = creatable.key();
            this.addCreatableDependency(creatable);
            this.newFileShares = new HashMap<String, String>();
        }
        this.newFileShares.put(volumeName, shareName);
        return this;
    }

    public VolumeImpl defineVolume(String name) {
        return new VolumeImpl(this, name);
    }

    @Override
    public ContainerGroupImpl withoutVolume() {
        ((ContainerGroupInner)((Object)this.inner())).withVolumes(null);
        return this;
    }

    public ContainerImpl defineContainerInstance(String name) {
        return new ContainerImpl(this, name);
    }

    @Override
    public ContainerGroupImpl withContainerInstance(String imageName) {
        return this.defineContainerInstance(this.name()).withImage(imageName).withoutPorts().withCpuCoreCount(1.0).withMemorySizeInGB(1.5).attach();
    }

    @Override
    public ContainerGroupImpl withContainerInstance(String imageName, int port) {
        return this.defineContainerInstance(this.name()).withImage(imageName).withExternalTcpPort(port).withCpuCoreCount(1.0).withMemorySizeInGB(1.5).attach();
    }

    @Override
    public Map<String, Container> containers() {
        return Collections.unmodifiableMap(this.containers);
    }

    @Override
    public Collection<Port> externalPorts() {
        if (((ContainerGroupInner)((Object)this.inner())).ipAddress() != null && ((ContainerGroupInner)((Object)this.inner())).ipAddress().ports() != null) {
            return Collections.unmodifiableCollection(((ContainerGroupInner)((Object)this.inner())).ipAddress().ports());
        }
        return null;
    }

    @Override
    public int[] externalTcpPorts() {
        return this.externalTcpPorts;
    }

    @Override
    public int[] externalUdpPorts() {
        return this.externalUdpPorts;
    }

    @Override
    public Map<String, Volume> volumes() {
        return Collections.unmodifiableMap(this.volumes);
    }

    @Override
    public Collection<String> imageRegistryServers() {
        return Collections.unmodifiableCollection(this.imageRegistryServers);
    }

    @Override
    public ContainerRestartPolicy restartPolicy() {
        return ((ContainerGroupInner)((Object)this.inner())).restartPolicy();
    }

    @Override
    public String ipAddress() {
        if (((ContainerGroupInner)((Object)this.inner())).ipAddress() != null) {
            return ((ContainerGroupInner)((Object)this.inner())).ipAddress().ip();
        }
        return null;
    }

    @Override
    public boolean isIPAddressPublic() {
        return ((ContainerGroupInner)((Object)this.inner())).ipAddress() != null && ((ContainerGroupInner)((Object)this.inner())).ipAddress().type().toLowerCase().equals("public");
    }

    @Override
    public OperatingSystemTypes osType() {
        return ((ContainerGroupInner)((Object)this.inner())).osType();
    }

    @Override
    public String state() {
        if (((ContainerGroupInner)((Object)this.inner())).state() != null) {
            return ((ContainerGroupInner)((Object)this.inner())).state();
        }
        return null;
    }

    @Override
    public String provisioningState() {
        if (((ContainerGroupInner)((Object)this.inner())).provisioningState() != null) {
            return ((ContainerGroupInner)((Object)this.inner())).provisioningState();
        }
        return null;
    }

    @Override
    public String getLogContent(String containerName) {
        return ((ContainerInstanceManager)this.manager()).containerGroups().getLogContent(this.resourceGroupName(), containerName, this.name());
    }

    @Override
    public String getLogContent(String containerName, int tailLineCount) {
        return ((ContainerInstanceManager)this.manager()).containerGroups().getLogContent(this.resourceGroupName(), containerName, this.name(), tailLineCount);
    }

    @Override
    public Observable<String> getLogContentAsync(String containerName) {
        return ((ContainerInstanceManager)this.manager()).containerGroups().getLogContentAsync(this.resourceGroupName(), containerName, this.name());
    }

    @Override
    public Observable<String> getLogContentAsync(String containerName, int tailLineCount) {
        return ((ContainerInstanceManager)this.manager()).containerGroups().getLogContentAsync(this.resourceGroupName(), containerName, this.name(), tailLineCount);
    }
}

