/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The Azure file volume.
 */
public class AzureFileVolume {
    /**
     * The Azure file share name.
     */
    @JsonProperty(value = "shareName", required = true)
    private String shareName;

    /**
     * The flag indicating whether the Azure file volume is read only.
     */
    @JsonProperty(value = "readOnly")
    private Boolean readOnly;

    /**
     * The storage account name to access to the Azure file.
     */
    @JsonProperty(value = "storageAccountName", required = true)
    private String storageAccountName;

    /**
     * The storage account key to access to the Azure file.
     */
    @JsonProperty(value = "storageAccountKey")
    private String storageAccountKey;

    /**
     * Get the shareName value.
     *
     * @return the shareName value
     */
    public String shareName() {
        return this.shareName;
    }

    /**
     * Set the shareName value.
     *
     * @param shareName the shareName value to set
     * @return the AzureFileVolume object itself.
     */
    public AzureFileVolume withShareName(String shareName) {
        this.shareName = shareName;
        return this;
    }

    /**
     * Get the readOnly value.
     *
     * @return the readOnly value
     */
    public Boolean readOnly() {
        return this.readOnly;
    }

    /**
     * Set the readOnly value.
     *
     * @param readOnly the readOnly value to set
     * @return the AzureFileVolume object itself.
     */
    public AzureFileVolume withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    /**
     * Get the storageAccountName value.
     *
     * @return the storageAccountName value
     */
    public String storageAccountName() {
        return this.storageAccountName;
    }

    /**
     * Set the storageAccountName value.
     *
     * @param storageAccountName the storageAccountName value to set
     * @return the AzureFileVolume object itself.
     */
    public AzureFileVolume withStorageAccountName(String storageAccountName) {
        this.storageAccountName = storageAccountName;
        return this;
    }

    /**
     * Get the storageAccountKey value.
     *
     * @return the storageAccountKey value
     */
    public String storageAccountKey() {
        return this.storageAccountKey;
    }

    /**
     * Set the storageAccountKey value.
     *
     * @param storageAccountKey the storageAccountKey value to set
     * @return the AzureFileVolume object itself.
     */
    public AzureFileVolume withStorageAccountKey(String storageAccountKey) {
        this.storageAccountKey = storageAccountKey;
        return this;
    }

}
