/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance.implementation;

import java.util.List;
import com.microsoft.azure.management.containerinstance.Capabilities;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The response containing list of capabilities.
 */
public class CapabilitiesListResultInner {
    /**
     * The list of capabilities.
     */
    @JsonProperty(value = "value")
    private List<Capabilities> value;

    /**
     * The URI to fetch the next page of capabilities.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Get the list of capabilities.
     *
     * @return the value value
     */
    public List<Capabilities> value() {
        return this.value;
    }

    /**
     * Set the list of capabilities.
     *
     * @param value the value value to set
     * @return the CapabilitiesListResultInner object itself.
     */
    public CapabilitiesListResultInner withValue(List<Capabilities> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the URI to fetch the next page of capabilities.
     *
     * @return the nextLink value
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the URI to fetch the next page of capabilities.
     *
     * @param nextLink the nextLink value to set
     * @return the CapabilitiesListResultInner object itself.
     */
    public CapabilitiesListResultInner withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

}
