/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for ContainerGroupIpAddressType.
 */
public final class ContainerGroupIpAddressType extends ExpandableStringEnum<ContainerGroupIpAddressType> {
    /** Static value Public for ContainerGroupIpAddressType. */
    public static final ContainerGroupIpAddressType PUBLIC = fromString("Public");

    /** Static value Private for ContainerGroupIpAddressType. */
    public static final ContainerGroupIpAddressType PRIVATE = fromString("Private");

    /**
     * Creates or finds a ContainerGroupIpAddressType from its string representation.
     * @param name a name to look for
     * @return the corresponding ContainerGroupIpAddressType
     */
    @JsonCreator
    public static ContainerGroupIpAddressType fromString(String name) {
        return fromString(name, ContainerGroupIpAddressType.class);
    }

    /**
     * @return known ContainerGroupIpAddressType values
     */
    public static Collection<ContainerGroupIpAddressType> values() {
        return values(ContainerGroupIpAddressType.class);
    }
}
