/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batchai.AzureFileShare;
import com.microsoft.azure.management.batchai.AzureFileShareReference;
import com.microsoft.azure.management.batchai.AzureStorageCredentialsInfo;
import com.microsoft.azure.management.batchai.KeyVaultSecretReference;
import com.microsoft.azure.management.batchai.model.HasMountVolumes;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableWrapperImpl;

@LangDefinition
class AzureFileShareImpl<ParentT>
extends IndexableWrapperImpl<AzureFileShareReference>
implements AzureFileShare,
AzureFileShare.Definition<ParentT> {
    private HasMountVolumes parent;

    AzureFileShareImpl(AzureFileShareReference inner, HasMountVolumes parent) {
        super((Object)inner);
        this.parent = parent;
    }

    @Override
    public AzureFileShare.Definition<ParentT> withStorageAccountName(String storageAccountName) {
        ((AzureFileShareReference)this.inner()).withAccountName(storageAccountName);
        return this;
    }

    @Override
    public AzureFileShare.Definition<ParentT> withAzureFileUrl(String azureFileUrl) {
        ((AzureFileShareReference)this.inner()).withAzureFileUrl(azureFileUrl);
        return this;
    }

    @Override
    public AzureFileShare.Definition<ParentT> withRelativeMountPath(String mountPath) {
        ((AzureFileShareReference)this.inner()).withRelativeMountPath(mountPath);
        return this;
    }

    public ParentT attach() {
        this.parent.attachAzureFileShare(this);
        return (ParentT)this.parent;
    }

    @Override
    public AzureFileShare.DefinitionStages.WithAttach<ParentT> withAccountKey(String accountKey) {
        this.ensureCredentials().withAccountKey(accountKey);
        return this;
    }

    private AzureStorageCredentialsInfo ensureCredentials() {
        if (((AzureFileShareReference)this.inner()).credentials() == null) {
            ((AzureFileShareReference)this.inner()).withCredentials(new AzureStorageCredentialsInfo());
        }
        return ((AzureFileShareReference)this.inner()).credentials();
    }

    @Override
    public AzureFileShare.DefinitionStages.WithAttach<ParentT> withKeyVaultSecretReference(KeyVaultSecretReference keyVaultSecretReference) {
        this.ensureCredentials().withAccountKeySecretReference(keyVaultSecretReference);
        return this;
    }

    @Override
    public AzureFileShare.DefinitionStages.WithAttach<ParentT> withFileMode(String fileMode) {
        ((AzureFileShareReference)this.inner()).withFileMode(fileMode);
        return this;
    }

    @Override
    public AzureFileShare.DefinitionStages.WithAttach<ParentT> withDirectoryMode(String directoryMode) {
        ((AzureFileShareReference)this.inner()).withDirectoryMode(directoryMode);
        return this;
    }
}

