/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Workspace creation parameters.
 */
public class WorkspaceCreateParameters {
    /**
     * Location.
     * The region in which to create the Workspace.
     */
    @JsonProperty(value = "location", required = true)
    private String location;

    /**
     * Tags.
     * The user specified tags associated with the Workspace.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /**
     * Get the region in which to create the Workspace.
     *
     * @return the location value
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the region in which to create the Workspace.
     *
     * @param location the location value to set
     * @return the WorkspaceCreateParameters object itself.
     */
    public WorkspaceCreateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the user specified tags associated with the Workspace.
     *
     * @return the tags value
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the user specified tags associated with the Workspace.
     *
     * @param tags the tags value to set
     * @return the WorkspaceCreateParameters object itself.
     */
    public WorkspaceCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

}
