/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Output directory for the job.
 */
public class OutputDirectory {
    /**
     * ID.
     * The ID of the output directory. The job can use
     * AZ_BATCHAI_OUTPUT_&lt;id&gt; environment variale to find the directory
     * path, where &lt;id&gt; is the value of id attribute.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /**
     * Path prefix.
     * The prefix path where the output directory will be created. Note, this
     * is an absolute path to prefix. E.g. $AZ_BATCHAI_MOUNT_ROOT/MyNFS/MyLogs.
     * The full path to the output directory by combining pathPrefix,
     * jobOutputDirectoryPathSegment (reported by get job) and pathSuffix.
     */
    @JsonProperty(value = "pathPrefix", required = true)
    private String pathPrefix;

    /**
     * Path suffix.
     * The suffix path where the output directory will be created. E.g. models.
     * You can find the full path to the output directory by combining
     * pathPrefix, jobOutputDirectoryPathSegment (reported by get job) and
     * pathSuffix.
     */
    @JsonProperty(value = "pathSuffix")
    private String pathSuffix;

    /**
     * Get the ID of the output directory. The job can use AZ_BATCHAI_OUTPUT_&lt;id&gt; environment variale to find the directory path, where &lt;id&gt; is the value of id attribute.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the ID of the output directory. The job can use AZ_BATCHAI_OUTPUT_&lt;id&gt; environment variale to find the directory path, where &lt;id&gt; is the value of id attribute.
     *
     * @param id the id value to set
     * @return the OutputDirectory object itself.
     */
    public OutputDirectory withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the prefix path where the output directory will be created. Note, this is an absolute path to prefix. E.g. $AZ_BATCHAI_MOUNT_ROOT/MyNFS/MyLogs. The full path to the output directory by combining pathPrefix, jobOutputDirectoryPathSegment (reported by get job) and pathSuffix.
     *
     * @return the pathPrefix value
     */
    public String pathPrefix() {
        return this.pathPrefix;
    }

    /**
     * Set the prefix path where the output directory will be created. Note, this is an absolute path to prefix. E.g. $AZ_BATCHAI_MOUNT_ROOT/MyNFS/MyLogs. The full path to the output directory by combining pathPrefix, jobOutputDirectoryPathSegment (reported by get job) and pathSuffix.
     *
     * @param pathPrefix the pathPrefix value to set
     * @return the OutputDirectory object itself.
     */
    public OutputDirectory withPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
        return this;
    }

    /**
     * Get the suffix path where the output directory will be created. E.g. models. You can find the full path to the output directory by combining pathPrefix, jobOutputDirectoryPathSegment (reported by get job) and pathSuffix.
     *
     * @return the pathSuffix value
     */
    public String pathSuffix() {
        return this.pathSuffix;
    }

    /**
     * Set the suffix path where the output directory will be created. E.g. models. You can find the full path to the output directory by combining pathPrefix, jobOutputDirectoryPathSegment (reported by get job) and pathSuffix.
     *
     * @param pathSuffix the pathSuffix value to set
     * @return the OutputDirectory object itself.
     */
    public OutputDirectory withPathSuffix(String pathSuffix) {
        this.pathSuffix = pathSuffix;
        return this;
    }

}
