/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for FileType.
 */
public final class FileType extends ExpandableStringEnum<FileType> {
    /** Static value file for FileType. */
    public static final FileType FILE = fromString("file");

    /** Static value directory for FileType. */
    public static final FileType DIRECTORY = fromString("directory");

    /**
     * Creates or finds a FileType from its string representation.
     * @param name a name to look for
     * @return the corresponding FileType
     */
    @JsonCreator
    public static FileType fromString(String name) {
        return fromString(name, FileType.class);
    }

    /**
     * @return known FileType values
     */
    public static Collection<FileType> values() {
        return values(FileType.class);
    }
}
