/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * File Server mounting configuration.
 */
public class FileServerReference {
    /**
     * File server.
     * Resource ID of the existing File Server to be mounted.
     */
    @JsonProperty(value = "fileServer", required = true)
    private ResourceId fileServer;

    /**
     * Source directory.
     * File Server directory that needs to be mounted. If this property is not
     * specified, the entire File Server will be mounted.
     */
    @JsonProperty(value = "sourceDirectory")
    private String sourceDirectory;

    /**
     * Relative mount path.
     * The relative path on the compute node where the File Server will be
     * mounted. Note that all cluster level file servers will be mounted under
     * $AZ_BATCHAI_MOUNT_ROOT location and all job level file servers will be
     * mounted under $AZ_BATCHAI_JOB_MOUNT_ROOT.
     */
    @JsonProperty(value = "relativeMountPath", required = true)
    private String relativeMountPath;

    /**
     * Mount options.
     * Mount options to be passed to mount command.
     */
    @JsonProperty(value = "mountOptions")
    private String mountOptions;

    /**
     * Get resource ID of the existing File Server to be mounted.
     *
     * @return the fileServer value
     */
    public ResourceId fileServer() {
        return this.fileServer;
    }

    /**
     * Set resource ID of the existing File Server to be mounted.
     *
     * @param fileServer the fileServer value to set
     * @return the FileServerReference object itself.
     */
    public FileServerReference withFileServer(ResourceId fileServer) {
        this.fileServer = fileServer;
        return this;
    }

    /**
     * Get file Server directory that needs to be mounted. If this property is not specified, the entire File Server will be mounted.
     *
     * @return the sourceDirectory value
     */
    public String sourceDirectory() {
        return this.sourceDirectory;
    }

    /**
     * Set file Server directory that needs to be mounted. If this property is not specified, the entire File Server will be mounted.
     *
     * @param sourceDirectory the sourceDirectory value to set
     * @return the FileServerReference object itself.
     */
    public FileServerReference withSourceDirectory(String sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
        return this;
    }

    /**
     * Get the relative path on the compute node where the File Server will be mounted. Note that all cluster level file servers will be mounted under $AZ_BATCHAI_MOUNT_ROOT location and all job level file servers will be mounted under $AZ_BATCHAI_JOB_MOUNT_ROOT.
     *
     * @return the relativeMountPath value
     */
    public String relativeMountPath() {
        return this.relativeMountPath;
    }

    /**
     * Set the relative path on the compute node where the File Server will be mounted. Note that all cluster level file servers will be mounted under $AZ_BATCHAI_MOUNT_ROOT location and all job level file servers will be mounted under $AZ_BATCHAI_JOB_MOUNT_ROOT.
     *
     * @param relativeMountPath the relativeMountPath value to set
     * @return the FileServerReference object itself.
     */
    public FileServerReference withRelativeMountPath(String relativeMountPath) {
        this.relativeMountPath = relativeMountPath;
        return this;
    }

    /**
     * Get mount options to be passed to mount command.
     *
     * @return the mountOptions value
     */
    public String mountOptions() {
        return this.mountOptions;
    }

    /**
     * Set mount options to be passed to mount command.
     *
     * @param mountOptions the mountOptions value to set
     * @return the FileServerReference object itself.
     */
    public FileServerReference withMountOptions(String mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

}
