/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Custom MPI job settings.
 */
public class CustomMpiSettings {
    /**
     * Command line.
     * The command line to be executed by mpi runtime on each compute node.
     */
    @JsonProperty(value = "commandLine", required = true)
    private String commandLine;

    /**
     * Process count.
     * Number of processes to launch for the job execution. The default value
     * for this property is equal to nodeCount property.
     */
    @JsonProperty(value = "processCount")
    private Integer processCount;

    /**
     * Get the command line to be executed by mpi runtime on each compute node.
     *
     * @return the commandLine value
     */
    public String commandLine() {
        return this.commandLine;
    }

    /**
     * Set the command line to be executed by mpi runtime on each compute node.
     *
     * @param commandLine the commandLine value to set
     * @return the CustomMpiSettings object itself.
     */
    public CustomMpiSettings withCommandLine(String commandLine) {
        this.commandLine = commandLine;
        return this;
    }

    /**
     * Get number of processes to launch for the job execution. The default value for this property is equal to nodeCount property.
     *
     * @return the processCount value
     */
    public Integer processCount() {
        return this.processCount;
    }

    /**
     * Set number of processes to launch for the job execution. The default value for this property is equal to nodeCount property.
     *
     * @param processCount the processCount value to set
     * @return the CustomMpiSettings object itself.
     */
    public CustomMpiSettings withProcessCount(Integer processCount) {
        this.processCount = processCount;
        return this;
    }

}
