/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Cluster update parameters.
 */
@JsonFlatten
public class ClusterUpdateParameters {
    /**
     * Scale settings.
     * Desired scale settings for the cluster. Batch AI service supports manual
     * and auto scale clusters.
     */
    @JsonProperty(value = "properties.scaleSettings")
    private ScaleSettings scaleSettings;

    /**
     * Get desired scale settings for the cluster. Batch AI service supports manual and auto scale clusters.
     *
     * @return the scaleSettings value
     */
    public ScaleSettings scaleSettings() {
        return this.scaleSettings;
    }

    /**
     * Set desired scale settings for the cluster. Batch AI service supports manual and auto scale clusters.
     *
     * @param scaleSettings the scaleSettings value to set
     * @return the ClusterUpdateParameters object itself.
     */
    public ClusterUpdateParameters withScaleSettings(ScaleSettings scaleSettings) {
        this.scaleSettings = scaleSettings;
        return this;
    }

}
