/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 */
package com.microsoft.azure.management.batchai;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.batchai.implementation.BatchAIManager;
import com.microsoft.azure.management.batchai.implementation.ExperimentsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsGettingById;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsGettingByNameAsync;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasParent;
import com.microsoft.azure.management.resources.fluentcore.collection.SupportsCreating;
import com.microsoft.azure.management.resources.fluentcore.collection.SupportsDeletingById;
import com.microsoft.azure.management.resources.fluentcore.collection.SupportsDeletingByName;
import com.microsoft.azure.management.resources.fluentcore.collection.SupportsListing;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;

/**
 * Entry point to Batch AI experiments management API in Azure.
 */
@Fluent
@Beta(Beta.SinceVersion.V1_12_0)
public interface BatchAIExperiments extends
        SupportsCreating<BatchAIExperiment.DefinitionStages.WithCreate>,
        SupportsListing<BatchAIExperiment>,
        SupportsGettingById<BatchAIExperiment>,
        SupportsGettingByNameAsync<BatchAIExperiment>,
        SupportsDeletingById,
        SupportsDeletingByName,
        HasManager<BatchAIManager>,
        HasInner<ExperimentsInner>,
        HasParent<BatchAIWorkspace> {
}

