/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * An error response from the Batch AI service.
 */
public class BatchAIError {
    /**
     * An identifier of the error. Codes are invariant and are intended to be
     * consumed programmatically.
     */
    @JsonProperty(value = "code", access = JsonProperty.Access.WRITE_ONLY)
    private String code;

    /**
     * A message describing the error, intended to be suitable for display in a
     * user interface.
     */
    @JsonProperty(value = "message", access = JsonProperty.Access.WRITE_ONLY)
    private String message;

    /**
     * A list of additional details about the error.
     */
    @JsonProperty(value = "details", access = JsonProperty.Access.WRITE_ONLY)
    private List<NameValuePair> details;

    /**
     * Get an identifier of the error. Codes are invariant and are intended to be consumed programmatically.
     *
     * @return the code value
     */
    public String code() {
        return this.code;
    }

    /**
     * Get a message describing the error, intended to be suitable for display in a user interface.
     *
     * @return the message value
     */
    public String message() {
        return this.message;
    }

    /**
     * Get a list of additional details about the error.
     *
     * @return the details value
     */
    public List<NameValuePair> details() {
        return this.details;
    }

}
