/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.batch.implementation.BatchLocationQuotaInner;
import com.microsoft.azure.management.batch.implementation.BatchManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class LocationsInner {
    private LocationsService service;
    private BatchManagementClientImpl client;

    public LocationsInner(Retrofit retrofit, BatchManagementClientImpl client) {
        this.service = (LocationsService)retrofit.create(LocationsService.class);
        this.client = client;
    }

    public BatchLocationQuotaInner getQuotas(String locationName) {
        return (BatchLocationQuotaInner)((ServiceResponse)this.getQuotasWithServiceResponseAsync(locationName).toBlocking().single()).body();
    }

    public ServiceFuture<BatchLocationQuotaInner> getQuotasAsync(String locationName, ServiceCallback<BatchLocationQuotaInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getQuotasWithServiceResponseAsync(locationName), serviceCallback);
    }

    public Observable<BatchLocationQuotaInner> getQuotasAsync(String locationName) {
        return this.getQuotasWithServiceResponseAsync(locationName).map((Func1)new Func1<ServiceResponse<BatchLocationQuotaInner>, BatchLocationQuotaInner>(){

            public BatchLocationQuotaInner call(ServiceResponse<BatchLocationQuotaInner> response) {
                return (BatchLocationQuotaInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BatchLocationQuotaInner>> getQuotasWithServiceResponseAsync(String locationName) {
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getQuotas(locationName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BatchLocationQuotaInner>>>(){

            public Observable<ServiceResponse<BatchLocationQuotaInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LocationsInner.this.getQuotasDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BatchLocationQuotaInner> getQuotasDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BatchLocationQuotaInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface LocationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Locations getQuotas"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Batch/locations/{locationName}/quotas")
        public Observable<Response<ResponseBody>> getQuotas(@Path(value="locationName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);
    }
}

