/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.auth;

import com.microsoft.azure.maven.exception.MavenDecryptException;
import com.microsoft.azure.maven.model.MavenAuthConfiguration;
import com.microsoft.azure.tools.auth.exception.InvalidConfigurationException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenSettingHelper {
    public static MavenAuthConfiguration buildAuthConfigurationByServerId(MavenSession session, SettingsDecrypter settingsDecrypter, String serverId) throws InvalidConfigurationException, MavenDecryptException {
        if (StringUtils.isBlank((CharSequence)serverId)) {
            throw new IllegalArgumentException("Parameter 'serverId' cannot be null or empty.");
        }
        Server server = session.getSettings().getServer(serverId);
        if (server == null) {
            throw new InvalidConfigurationException(String.format("serverId '%s' cannot be found in maven settings.xml.", serverId));
        }
        MavenAuthConfiguration configurationFromServer = new MavenAuthConfiguration();
        Xpp3Dom configuration = (Xpp3Dom)server.getConfiguration();
        configurationFromServer.setServerId(serverId);
        if (configuration == null) {
            return configurationFromServer;
        }
        configurationFromServer.setTenant(MavenSettingHelper.getPropertyValue(configuration, "tenant"));
        configurationFromServer.setClient(MavenSettingHelper.getPropertyValue(configuration, "client"));
        String rawKey = MavenSettingHelper.getPropertyValue(configuration, "key");
        configurationFromServer.setKey(MavenSettingHelper.isPropertyEncrypted(rawKey) ? MavenSettingHelper.decryptMavenSettingProperty(settingsDecrypter, "key", rawKey) : rawKey);
        configurationFromServer.setCertificate(MavenSettingHelper.getPropertyValue(configuration, "certificate"));
        String rawCertificatePassword = MavenSettingHelper.getPropertyValue(configuration, "certificatePassword");
        configurationFromServer.setCertificatePassword(MavenSettingHelper.isPropertyEncrypted(rawCertificatePassword) ? MavenSettingHelper.decryptMavenSettingProperty(settingsDecrypter, "certificatePassword", rawCertificatePassword) : rawCertificatePassword);
        configurationFromServer.setEnvironment(MavenSettingHelper.getPropertyValue(configuration, "environment"));
        configurationFromServer.setServerId(serverId);
        return configurationFromServer;
    }

    private static String getPropertyValue(Xpp3Dom configuration, String property) {
        Xpp3Dom node = configuration.getChild(property);
        return Objects.isNull(node) ? null : node.getValue();
    }

    private static boolean isPropertyEncrypted(String value) {
        return value != null && value.startsWith("{") && value.endsWith("}");
    }

    private static String decryptMavenSettingProperty(SettingsDecrypter settingsDecrypter, String propertyName, String value) throws MavenDecryptException {
        Server server = new Server();
        server.setPassword(value);
        DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(server);
        SettingsDecryptionResult result = settingsDecrypter.decrypt((SettingsDecryptionRequest)request);
        for (SettingsProblem problem : result.getProblems()) {
            if (problem.getSeverity() != SettingsProblem.Severity.ERROR && problem.getSeverity() != SettingsProblem.Severity.FATAL) continue;
            throw new MavenDecryptException(String.format("Unable to decrypt property(%s), value(%s) from maven settings.xml due to error: %s", propertyName, value, problem.toString()));
        }
        return result.getServer().getPassword();
    }

    private MavenSettingHelper() {
    }
}

