/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.telemetry;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class GetHashMac {
    private static final String MAC_REGEX = "([0-9A-Fa-f]{2}[:-]){5}[0-9A-Fa-f]{2}";
    private static final String MAC_REGEX_ZERO = "([0]{2}[:-]){5}[0]{2}";
    private static final Pattern MAC_PATTERN = Pattern.compile("([0-9A-Fa-f]{2}[:-]){5}[0-9A-Fa-f]{2}");

    public static String getHashMac() {
        String rawMac = GetHashMac.getRawMac();
        if (!GetHashMac.isValidRawMac(rawMac)) {
            return null;
        }
        Pattern patternZero = Pattern.compile(MAC_REGEX_ZERO);
        Matcher matcher = MAC_PATTERN.matcher(rawMac);
        String mac = "";
        while (matcher.find() && patternZero.matcher(mac = matcher.group(0)).matches()) {
        }
        return GetHashMac.hash(mac);
    }

    private static boolean isValidRawMac(String mac) {
        return StringUtils.isNotEmpty((CharSequence)mac) && MAC_PATTERN.matcher(mac).find();
    }

    private static String getRawMac() {
        String ret = null;
        try {
            String os = System.getProperty("os.name").toLowerCase();
            String[] command = new String[]{"ifconfig", "-a"};
            if (os != null && !os.isEmpty() && os.startsWith("win")) {
                command = new String[]{"getmac"};
            }
            ProcessBuilder builder = new ProcessBuilder(command);
            Process process = builder.start();
            try (InputStream inputStream = process.getInputStream();
                 InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                 BufferedReader br = new BufferedReader(inputStreamReader);){
                String tmp;
                while ((tmp = br.readLine()) != null) {
                    ret = ret + tmp;
                }
            }
            if (process.waitFor() != 0) {
                throw new IOException("Command execute fail.");
            }
        }
        catch (IOException | InterruptedException ex) {
            return GetHashMac.getRawMacWithNetworkInterface();
        }
        return ret;
    }

    private static String getRawMacWithNetworkInterface() {
        ArrayList<String> macSet = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.getHardwareAddress() == null) continue;
                byte[] mac = networkInterface.getHardwareAddress();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                }
                macSet.add(sb.toString());
            }
        }
        catch (SocketException e) {
            return "";
        }
        Collections.sort(macSet);
        return StringUtils.join(macSet, (String)" ");
    }

    private static String hash(String mac) {
        String ret;
        if (mac == null || mac.isEmpty()) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] bytes = mac.getBytes("UTF-8");
            md.update(bytes);
            byte[] bytesAfterDigest = md.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < bytesAfterDigest.length; ++i) {
                sb.append(Integer.toString((bytesAfterDigest[i] & 0xFF) + 256, 16).substring(1));
            }
            ret = sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
        return ret;
    }
}

