/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.telemetry;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.channel.concrete.inprocess.InProcessTelemetryChannel;
import com.microsoft.applicationinsights.internal.config.TelemetryConfigurationFactory;
import com.microsoft.azure.maven.telemetry.TelemetryConfiguration;
import com.microsoft.azure.maven.telemetry.TelemetryProxy;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class AppInsightsProxy
implements TelemetryProxy {
    public static final String CONFIGURATION_FILE = "ApplicationInsights.xml";
    public static final Pattern INSTRUMENTATION_KEY_PATTERN = Pattern.compile("<InstrumentationKey>(.*)</InstrumentationKey>");
    protected TelemetryClient client = new TelemetryClient(this.readConfigurationFromFile());
    protected TelemetryConfiguration configuration;
    protected Map<String, String> defaultProperties;
    protected boolean isEnabled = true;

    public AppInsightsProxy(TelemetryConfiguration config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this.configuration = config;
        this.defaultProperties = this.configuration.getTelemetryProperties();
    }

    private com.microsoft.applicationinsights.TelemetryConfiguration readConfigurationFromFile() {
        com.microsoft.applicationinsights.TelemetryConfiguration telemetryConfiguration = new com.microsoft.applicationinsights.TelemetryConfiguration();
        HashMap<String, String> channelProperties = new HashMap<String, String>();
        channelProperties.put("FlushIntervalInSeconds", "1");
        InProcessTelemetryChannel channel = new InProcessTelemetryChannel(channelProperties);
        telemetryConfiguration.setChannel((TelemetryChannel)channel);
        telemetryConfiguration.setInstrumentationKey(this.readInstrumentationKeyFromConfiguration());
        TelemetryConfigurationFactory.INSTANCE.initialize(telemetryConfiguration);
        return telemetryConfiguration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readInstrumentationKeyFromConfiguration() {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(CONFIGURATION_FILE);){
            String configuration = IOUtils.toString((InputStream)inputStream);
            Matcher matcher = INSTRUMENTATION_KEY_PATTERN.matcher(configuration);
            if (matcher.find()) {
                String string2 = matcher.group(1);
                return string2;
            }
            String string = "";
            return string;
        }
        catch (IOException exception) {
            return "";
        }
    }

    @Override
    public void addDefaultProperty(String key, String value) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        this.defaultProperties.put(key, value);
    }

    @Override
    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    @Override
    public void enable() {
        this.isEnabled = true;
    }

    @Override
    public void disable() {
        this.isEnabled = false;
    }

    @Override
    public void trackEvent(String eventName) {
        this.trackEvent(eventName, null, false);
    }

    @Override
    public void trackEvent(String eventName, Map<String, String> customProperties) {
        this.trackEvent(eventName, customProperties, false);
    }

    @Override
    public void trackEvent(String eventName, Map<String, String> customProperties, boolean overrideDefaultProperties) {
        if (!this.isEnabled) {
            return;
        }
        Map<String, String> properties = this.mergeProperties(this.getDefaultProperties(), customProperties, overrideDefaultProperties);
        this.client.trackEvent(eventName, properties, null);
        this.client.flush();
    }

    protected Map<String, String> mergeProperties(Map<String, String> defaultProperties, Map<String, String> customProperties, boolean overrideDefaultProperties) {
        if (customProperties == null) {
            return defaultProperties;
        }
        HashMap<String, String> merged = new HashMap<String, String>();
        if (overrideDefaultProperties) {
            merged.putAll(defaultProperties);
            merged.putAll(customProperties);
        } else {
            merged.putAll(customProperties);
            merged.putAll(defaultProperties);
        }
        Iterator it = merged.entrySet().iterator();
        while (it.hasNext()) {
            if (!StringUtils.isEmpty((CharSequence)((CharSequence)it.next().getValue()))) continue;
            it.remove();
        }
        return merged;
    }
}

