/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.artifacthandler;

import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.maven.artifacthandler.ArtifactHandlerBase;
import com.microsoft.azure.maven.deploytarget.DeployTarget;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.zeroturnaround.zip.ZipUtil;

public class ZIPArtifactHandlerImpl
extends ArtifactHandlerBase {
    private static final int DEFAULT_MAX_RETRY_TIMES = 3;
    private static final String LOCAL_SETTINGS_FILE = "local.settings.json";

    protected ZIPArtifactHandlerImpl(Builder builder) {
        super(builder);
    }

    protected boolean isResourcesPreparationRequired(DeployTarget target) {
        return !(target.getApp() instanceof FunctionApp);
    }

    public void publish(DeployTarget target) throws MojoExecutionException, IOException {
        int retryCount;
        if (this.isResourcesPreparationRequired(target)) {
            this.prepareResources();
        }
        this.assureStagingDirectoryNotEmpty();
        File zipFile = this.getZipFile();
        this.log.info((CharSequence)String.format("Trying to deploy artifact to %s...", target.getName()));
        for (retryCount = 0; retryCount < 3; ++retryCount) {
            try {
                target.zipDeploy(zipFile);
                this.log.info((CharSequence)String.format("Successfully deployed the artifact to https://%s", target.getDefaultHostName()));
                return;
            }
            catch (Exception e) {
                this.log.debug((CharSequence)String.format("Exception occurred when deploying the zip package: %s, retrying immediately (%d/%d)", e.getMessage(), retryCount, 3));
                continue;
            }
        }
        throw new MojoExecutionException(String.format("The zip deploy failed after %d times of retry.", retryCount));
    }

    protected File getZipFile() {
        File zipFile = new File(this.stagingDirectoryPath + ".zip");
        File stagingDirectory = new File(this.stagingDirectoryPath);
        ZipUtil.pack((File)stagingDirectory, (File)zipFile);
        ZipUtil.removeEntry((File)zipFile, (String)LOCAL_SETTINGS_FILE);
        return zipFile;
    }

    public static class Builder
    extends ArtifactHandlerBase.Builder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ZIPArtifactHandlerImpl build() {
            return new ZIPArtifactHandlerImpl(this);
        }
    }
}

