/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.utils;

import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.PricingTier;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.codehaus.plexus.util.StringUtils;

public class AppServiceUtils {
    private static final List<PricingTier> pricingTiers = new ArrayList<PricingTier>();

    public static AppServicePlan getAppServicePlan(String servicePlanName, Azure azureClient, String resourceGroup, String servicePlanResourceGroup) {
        if (StringUtils.isNotEmpty((String)servicePlanName)) {
            String servicePlanResGrp = AppServiceUtils.getAppServicePlanResourceGroup(resourceGroup, servicePlanResourceGroup);
            return (AppServicePlan)azureClient.appServices().appServicePlans().getByResourceGroup(servicePlanResGrp, servicePlanName);
        }
        return null;
    }

    public static String getAppServicePlanResourceGroup(String resourceGroup, String appServicePlanResGrp) {
        return StringUtils.isEmpty((String)appServicePlanResGrp) ? resourceGroup : appServicePlanResGrp;
    }

    public static String getAppServicePlanName(String servicePlanName) {
        return StringUtils.isEmpty((String)servicePlanName) ? AppServiceUtils.generateRandomServicePlanName() : servicePlanName;
    }

    private static String generateRandomServicePlanName() {
        return "ServicePlan" + UUID.randomUUID().toString().substring(0, 18);
    }

    public static PricingTier getPricingTierFromString(String pricingTierString) {
        for (PricingTier pricingTier : pricingTiers) {
            if (!pricingTier.toSkuDescription().size().equalsIgnoreCase(pricingTierString)) continue;
            return pricingTier;
        }
        return null;
    }

    public static String convertPricingTierToString(PricingTier pricingTier) {
        return pricingTier == null ? null : pricingTier.toSkuDescription().size();
    }

    public static List<PricingTier> getAvailablePricingTiers(OperatingSystem operatingSystem) {
        ArrayList<PricingTier> result = new ArrayList<PricingTier>(pricingTiers);
        if (operatingSystem == OperatingSystem.LINUX) {
            result.remove(PricingTier.PREMIUM_P1);
            result.remove(PricingTier.PREMIUM_P2);
            result.remove(PricingTier.PREMIUM_P3);
        }
        return result;
    }

    static {
        for (Field field : PricingTier.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                pricingTiers.add((PricingTier)field.get(null));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

