/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.queryer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.BidiMap;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;

public abstract class MavenPluginQueryer {
    public abstract String assureInputFromUser(String var1, String var2, List<String> var3, String var4) throws MojoFailureException;

    public abstract String assureInputFromUser(String var1, String var2, String var3, String var4, String var5) throws MojoFailureException;

    public abstract void close();

    public String assureInputFromUser(String attribute, Enum defaultValue, String prompt) throws MojoFailureException {
        String defaultValueForAttribute = defaultValue.name();
        HashSet<String> optionSet = new HashSet<String>();
        for (Enum option : (Enum[])defaultValue.getClass().getEnumConstants()) {
            optionSet.add(option.name().toLowerCase(Locale.ENGLISH));
        }
        ArrayList<String> options = new ArrayList<String>(optionSet);
        return this.assureInputFromUser(attribute, defaultValueForAttribute, options, prompt);
    }

    public String assureInputFromUser(String attribute, String defaultValue, BidiMap<String, String> options, String prompt) throws MojoFailureException {
        String defaultDisplayName = (String)options.getKey((Object)defaultValue);
        ArrayList<String> displayNames = new ArrayList<String>(options.keySet());
        Collections.sort(displayNames);
        return (String)options.get((Object)this.assureInputFromUser(attribute, defaultDisplayName, displayNames, prompt));
    }

    protected boolean validateInputByOptions(String input, List<String> options) {
        for (String option : options) {
            if (!option.equalsIgnoreCase(input)) continue;
            return true;
        }
        return false;
    }

    protected boolean validateInputByRegex(String input, String regex) {
        return StringUtils.isEmpty((String)regex) || input != null && input.matches(regex);
    }

    protected String getInitValue(String attribute) {
        return System.getProperty(attribute);
    }
}

