/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.auth;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.auth.AzureAuthHelper;
import com.microsoft.azure.auth.AzureCredential;
import com.microsoft.azure.auth.configuration.AuthConfiguration;
import com.microsoft.azure.auth.exception.AzureLoginFailureException;
import com.microsoft.azure.auth.exception.DesktopNotSupportedException;
import com.microsoft.azure.auth.exception.InvalidConfigurationException;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.maven.auth.AzureAuthHelperLegacy;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.codehaus.plexus.util.StringUtils;

public class AzureClientFactory {
    public static Azure getAzureClient(AuthConfiguration auth, String subscriptionId) throws InvalidConfigurationException, IOException, AzureLoginFailureException, InterruptedException, ExecutionException {
        AzureTokenCredentials azureTokenCredentials = AzureAuthHelper.getAzureTokenCredentials((AuthConfiguration)auth);
        if (azureTokenCredentials == null) {
            AzureCredential azureCredential;
            AzureEnvironment environment = AzureEnvironment.AZURE;
            try {
                azureCredential = AzureAuthHelper.oAuthLogin((AzureEnvironment)environment);
            }
            catch (DesktopNotSupportedException e) {
                azureCredential = AzureAuthHelper.deviceLogin((AzureEnvironment)environment);
            }
            AzureAuthHelper.writeAzureCredentials((AzureCredential)azureCredential, (File)AzureAuthHelper.getAzureSecretFile());
            azureTokenCredentials = AzureAuthHelper.getMavenAzureLoginCredentials((AzureCredential)azureCredential, (AzureEnvironment)environment);
        }
        if (azureTokenCredentials != null) {
            Azure.Authenticated authenticated = Azure.configure().authenticate(azureTokenCredentials);
            if (StringUtils.isEmpty((String)subscriptionId) && AzureAuthHelperLegacy.isInCloudShell()) {
                subscriptionId = AzureAuthHelperLegacy.getSubscriptionOfCloudShell();
            }
            return StringUtils.isEmpty((String)subscriptionId) ? authenticated.withDefaultSubscription() : authenticated.withSubscription(subscriptionId);
        }
        return null;
    }
}

