/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.artifacthandler;

import com.microsoft.azure.management.appservice.DeploymentSlot;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.PublishingProfile;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.maven.FTPUploader;
import com.microsoft.azure.maven.artifacthandler.ArtifactHandlerBase;
import com.microsoft.azure.maven.deploytarget.DeployTarget;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;

public class FTPArtifactHandlerImpl
extends ArtifactHandlerBase {
    private static final String DEFAULT_WEBAPP_ROOT = "/site/wwwroot";
    private static final int DEFAULT_MAX_RETRY_TIMES = 3;

    private FTPArtifactHandlerImpl(Builder builder) {
        super(builder);
    }

    protected boolean isResourcesPreparationRequired(DeployTarget target) {
        return target.getApp() instanceof WebApp || target.getApp() instanceof DeploymentSlot;
    }

    public void publish(DeployTarget target) throws IOException, MojoExecutionException {
        if (this.isResourcesPreparationRequired(target)) {
            this.prepareResources();
        }
        this.assureStagingDirectoryNotEmpty();
        this.log.info((CharSequence)String.format("Trying to deploy artifact to %s...", target.getName()));
        this.uploadDirectoryToFTP(target);
        if (target.getApp() instanceof FunctionApp) {
            ((FunctionApp)target.getApp()).syncTriggers();
        }
        this.log.info((CharSequence)String.format("Successfully deployed the artifact to https://%s", target.getDefaultHostName()));
    }

    protected void uploadDirectoryToFTP(DeployTarget target) throws MojoExecutionException {
        FTPUploader uploader = this.getUploader();
        PublishingProfile profile = target.getPublishingProfile();
        String serverUrl = profile.ftpUrl().split("/", 2)[0];
        uploader.uploadDirectoryWithRetries(serverUrl, profile.ftpUsername(), profile.ftpPassword(), this.stagingDirectoryPath, DEFAULT_WEBAPP_ROOT, 3);
    }

    protected FTPUploader getUploader() {
        return new FTPUploader(this.log);
    }

    public static class Builder
    extends ArtifactHandlerBase.Builder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FTPArtifactHandlerImpl build() {
            return new FTPArtifactHandlerImpl(this);
        }
    }
}

