/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.telemetry;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.azure.maven.telemetry.TelemetryConfiguration;
import com.microsoft.azure.maven.telemetry.TelemetryProxy;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.util.StringUtils;

public class AppInsightsProxy
implements TelemetryProxy {
    protected TelemetryClient client = new TelemetryClient();
    protected TelemetryConfiguration configuration;
    protected Map<String, String> defaultProperties;
    protected boolean isEnabled = true;

    public AppInsightsProxy(TelemetryConfiguration config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this.configuration = config;
        this.defaultProperties = this.configuration.getTelemetryProperties();
    }

    @Override
    public void addDefaultProperty(String key, String value) {
        if (StringUtils.isEmpty((String)key)) {
            return;
        }
        this.defaultProperties.put(key, value);
    }

    @Override
    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    @Override
    public void enable() {
        this.isEnabled = true;
    }

    @Override
    public void disable() {
        this.isEnabled = false;
    }

    @Override
    public void trackEvent(String eventName) {
        this.trackEvent(eventName, null, false);
    }

    @Override
    public void trackEvent(String eventName, Map<String, String> customProperties) {
        this.trackEvent(eventName, customProperties, false);
    }

    @Override
    public void trackEvent(String eventName, Map<String, String> customProperties, boolean overrideDefaultProperties) {
        if (!this.isEnabled) {
            return;
        }
        Map<String, String> properties = this.mergeProperties(this.getDefaultProperties(), customProperties, overrideDefaultProperties);
        this.client.trackEvent(eventName, properties, null);
        this.client.flush();
    }

    protected Map<String, String> mergeProperties(Map<String, String> defaultProperties, Map<String, String> customProperties, boolean overrideDefaultProperties) {
        if (customProperties == null) {
            return defaultProperties;
        }
        HashMap<String, String> merged = new HashMap<String, String>();
        if (overrideDefaultProperties) {
            merged.putAll(defaultProperties);
            merged.putAll(customProperties);
        } else {
            merged.putAll(customProperties);
            merged.putAll(defaultProperties);
        }
        return merged;
    }
}

