/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.authentication;

import com.microsoft.azure.keyvault.authentication.AuthenticationResult;
import com.microsoft.azure.keyvault.authentication.ChallengeCache;
import com.microsoft.azure.keyvault.messagesecurity.HttpMessageSecurity;
import com.microsoft.azure.keyvault.webkey.JsonWebKey;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.tuple.Pair;

public abstract class KeyVaultCredentials
implements ServiceClientCredentials {
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String BEARER_TOKEP_REFIX = "Bearer ";
    private static final String CLIENT_ENCRYPTION_KEY_TYPE = "RSA";
    private static final int CLIENT_ENCRYPTION_KEY_SIZE = 2048;
    private List<String> supportedMethods = Arrays.asList("sign", "verify", "encrypt", "decrypt", "wrapkey", "unwrapkey");
    private JsonWebKey clientEncryptionKey = null;
    private final ChallengeCache cache = new ChallengeCache();

    public void applyCredentialsFilter(OkHttpClient.Builder clientBuilder) {
        clientBuilder.addInterceptor(new Interceptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response response;
                Pair authenticatedRequestPair;
                Request originalRequest = chain.request();
                HttpUrl url = chain.request().url();
                Map<String, String> challengeMap = KeyVaultCredentials.this.cache.getCachedChallenge(url);
                if (challengeMap != null) {
                    authenticatedRequestPair = KeyVaultCredentials.this.buildAuthenticatedRequest(originalRequest, challengeMap);
                } else {
                    response = chain.proceed(KeyVaultCredentials.this.buildEmptyRequest(originalRequest));
                    if (response.code() != 401) {
                        return response;
                    }
                    try {
                        authenticatedRequestPair = KeyVaultCredentials.this.buildAuthenticatedRequest(originalRequest, response);
                    }
                    finally {
                        response.close();
                    }
                }
                response = chain.proceed((Request)authenticatedRequestPair.getLeft());
                if (response.code() == 200) {
                    return ((HttpMessageSecurity)authenticatedRequestPair.getRight()).unprotectResponse(response);
                }
                return response;
            }
        });
    }

    private Pair<Request, HttpMessageSecurity> buildAuthenticatedRequest(Request originalRequest, Map<String, String> challengeMap) throws IOException {
        AuthenticationResult authResult;
        Boolean supportsPop = this.supportsMessageProtection(originalRequest.url().toString(), challengeMap);
        if (supportsPop.booleanValue() && this.clientEncryptionKey == null) {
            try {
                KeyPairGenerator generator = KeyPairGenerator.getInstance(CLIENT_ENCRYPTION_KEY_TYPE);
                generator.initialize(2048);
                this.clientEncryptionKey = JsonWebKey.fromRSA((KeyPair)generator.generateKeyPair()).withKid(UUID.randomUUID().toString());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        if ((authResult = this.getAuthenticationCredentials(supportsPop, challengeMap)) == null) {
            return null;
        }
        HttpMessageSecurity httpMessageSecurity = new HttpMessageSecurity(authResult.getAuthToken(), supportsPop != false ? authResult.getPopKey() : "", supportsPop != false ? challengeMap.get("x-ms-message-encryption-key") : "", supportsPop != false ? challengeMap.get("x-ms-message-signing-key") : "", this.clientEncryptionKey);
        Request request = httpMessageSecurity.protectRequest(originalRequest);
        return Pair.of((Object)request, (Object)httpMessageSecurity);
    }

    private Pair<Request, HttpMessageSecurity> buildAuthenticatedRequest(Request originalRequest, Response response) throws IOException {
        String authenticateHeader = response.header(WWW_AUTHENTICATE);
        Map<String, String> challengeMap = KeyVaultCredentials.extractChallenge(authenticateHeader, BEARER_TOKEP_REFIX);
        challengeMap.put("x-ms-message-encryption-key", response.header("x-ms-message-encryption-key"));
        challengeMap.put("x-ms-message-signing-key", response.header("x-ms-message-signing-key"));
        this.cache.addCachedChallenge(originalRequest.url(), challengeMap);
        return this.buildAuthenticatedRequest(originalRequest, challengeMap);
    }

    private Request buildEmptyRequest(Request request) {
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)"{}");
        if (request.method().equalsIgnoreCase("get")) {
            return request;
        }
        return request.newBuilder().method(request.method(), body).build();
    }

    private Boolean supportsMessageProtection(String url, Map<String, String> challengeMap) {
        if (!"true".equals(challengeMap.get("supportspop"))) {
            return false;
        }
        if (!url.toLowerCase().contains("/keys/")) {
            return false;
        }
        String[] tokens = url.split("\\?")[0].split("/");
        return this.supportedMethods.contains(tokens[tokens.length - 1]);
    }

    private AuthenticationResult getAuthenticationCredentials(Boolean supportsPop, Map<String, String> challengeMap) {
        String authorization = challengeMap.get("authorization");
        if (authorization == null) {
            authorization = challengeMap.get("authorization_uri");
        }
        String resource = challengeMap.get("resource");
        String scope = challengeMap.get("scope");
        String schema = supportsPop != false ? "pop" : "bearer";
        return this.doAuthenticate(authorization, resource, scope, schema);
    }

    private static Map<String, String> extractChallenge(String authenticateHeader, String authChallengePrefix) {
        if (!KeyVaultCredentials.isValidChallenge(authenticateHeader, authChallengePrefix)) {
            return null;
        }
        authenticateHeader = authenticateHeader.toLowerCase().replace(authChallengePrefix.toLowerCase(), "");
        String[] challenges = authenticateHeader.split(", ");
        HashMap<String, String> challengeMap = new HashMap<String, String>();
        for (String pair : challenges) {
            String[] keyValue = pair.split("=");
            challengeMap.put(keyValue[0].replaceAll("\"", ""), keyValue[1].replaceAll("\"", ""));
        }
        return challengeMap;
    }

    private static boolean isValidChallenge(String authenticateHeader, String authChallengePrefix) {
        return authenticateHeader != null && !authenticateHeader.isEmpty() && authenticateHeader.toLowerCase().startsWith(authChallengePrefix.toLowerCase());
    }

    public String doAuthenticate(String authorization, String resource, String scope) {
        return "";
    }

    public AuthenticationResult doAuthenticate(String authorization, String resource, String scope, String schema) {
        return new AuthenticationResult(this.doAuthenticate(authorization, resource, scope), "");
    }
}

