// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator

package com.microsoft.azure.keyvault.models;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The subject alternate names of a X509 object.
 */
public class SubjectAlternativeNames {
    /**
     * Email addresses.
     */
    @JsonProperty(value = "emails")
    private List<String> emails;

    /**
     * Domain names.
     */
    @JsonProperty(value = "dns_names")
    private List<String> dnsNames;

    /**
     * User principal names.
     */
    @JsonProperty(value = "upns")
    private List<String> upns;

    /**
     * Get the emails value.
     *
     * @return the emails value
     */
    public List<String> emails() {
        return this.emails;
    }

    /**
     * Set the emails value.
     *
     * @param emails the emails value to set
     * @return the SubjectAlternativeNames object itself.
     */
    public SubjectAlternativeNames withEmails(List<String> emails) {
        this.emails = emails;
        return this;
    }

    /**
     * Get the dnsNames value.
     *
     * @return the dnsNames value
     */
    public List<String> dnsNames() {
        return this.dnsNames;
    }

    /**
     * Set the dnsNames value.
     *
     * @param dnsNames the dnsNames value to set
     * @return the SubjectAlternativeNames object itself.
     */
    public SubjectAlternativeNames withDnsNames(List<String> dnsNames) {
        this.dnsNames = dnsNames;
        return this;
    }

    /**
     * Get the upns value.
     *
     * @return the upns value
     */
    public List<String> upns() {
        return this.upns;
    }

    /**
     * Set the upns value.
     *
     * @param upns the upns value to set
     * @return the SubjectAlternativeNames object itself.
     */
    public SubjectAlternativeNames withUpns(List<String> upns) {
        this.upns = upns;
        return this;
    }

}
