// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator

package com.microsoft.azure.keyvault.models;

import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The storage account create parameters.
 */
public class StorageAccountCreateParameters {
    /**
     * Storage account resource id.
     */
    @JsonProperty(value = "resourceId", required = true)
    private String resourceId;

    /**
     * Current active storage account key name.
     */
    @JsonProperty(value = "activeKeyName", required = true)
    private String activeKeyName;

    /**
     * whether keyvault should manage the storage account for the user.
     */
    @JsonProperty(value = "autoRegenerateKey", required = true)
    private boolean autoRegenerateKey;

    /**
     * The key regeneration time duration specified in ISO-8601 format.
     */
    @JsonProperty(value = "regenerationPeriod")
    private String regenerationPeriod;

    /**
     * The attributes of the storage account.
     */
    @JsonProperty(value = "attributes")
    private StorageAccountAttributes storageAccountAttributes;

    /**
     * Application specific metadata in the form of key-value pairs.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /**
     * Get the resourceId value.
     *
     * @return the resourceId value
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId value.
     *
     * @param resourceId the resourceId value to set
     * @return the StorageAccountCreateParameters object itself.
     */
    public StorageAccountCreateParameters withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the activeKeyName value.
     *
     * @return the activeKeyName value
     */
    public String activeKeyName() {
        return this.activeKeyName;
    }

    /**
     * Set the activeKeyName value.
     *
     * @param activeKeyName the activeKeyName value to set
     * @return the StorageAccountCreateParameters object itself.
     */
    public StorageAccountCreateParameters withActiveKeyName(String activeKeyName) {
        this.activeKeyName = activeKeyName;
        return this;
    }

    /**
     * Get the autoRegenerateKey value.
     *
     * @return the autoRegenerateKey value
     */
    public boolean autoRegenerateKey() {
        return this.autoRegenerateKey;
    }

    /**
     * Set the autoRegenerateKey value.
     *
     * @param autoRegenerateKey the autoRegenerateKey value to set
     * @return the StorageAccountCreateParameters object itself.
     */
    public StorageAccountCreateParameters withAutoRegenerateKey(boolean autoRegenerateKey) {
        this.autoRegenerateKey = autoRegenerateKey;
        return this;
    }

    /**
     * Get the regenerationPeriod value.
     *
     * @return the regenerationPeriod value
     */
    public String regenerationPeriod() {
        return this.regenerationPeriod;
    }

    /**
     * Set the regenerationPeriod value.
     *
     * @param regenerationPeriod the regenerationPeriod value to set
     * @return the StorageAccountCreateParameters object itself.
     */
    public StorageAccountCreateParameters withRegenerationPeriod(String regenerationPeriod) {
        this.regenerationPeriod = regenerationPeriod;
        return this;
    }

    /**
     * Get the storageAccountAttributes value.
     *
     * @return the storageAccountAttributes value
     */
    public StorageAccountAttributes storageAccountAttributes() {
        return this.storageAccountAttributes;
    }

    /**
     * Set the storageAccountAttributes value.
     *
     * @param storageAccountAttributes the storageAccountAttributes value to set
     * @return the StorageAccountCreateParameters object itself.
     */
    public StorageAccountCreateParameters withStorageAccountAttributes(StorageAccountAttributes storageAccountAttributes) {
        this.storageAccountAttributes = storageAccountAttributes;
        return this;
    }

    /**
     * Get the tags value.
     *
     * @return the tags value
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags value.
     *
     * @param tags the tags value to set
     * @return the StorageAccountCreateParameters object itself.
     */
    public StorageAccountCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

}
