/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.requests;

import com.microsoft.azure.keyvault.SecretIdentifier;
import com.microsoft.azure.keyvault.models.Attributes;
import com.microsoft.azure.keyvault.models.SecretAttributes;
import java.util.Collections;
import java.util.Map;

public final class UpdateSecretRequest {
    private final String vaultBaseUrl;
    private final String secretName;
    private final String secretVersion;
    private final String contentType;
    private final SecretAttributes secretAttributes;
    private final Map<String, String> tags;

    private UpdateSecretRequest(Builder builder) {
        this.vaultBaseUrl = builder.vaultBaseUrl;
        this.secretName = builder.secretName;
        this.secretVersion = builder.secretVersion == null ? "" : builder.secretVersion;
        this.contentType = builder.contentType;
        this.secretAttributes = builder.attributes != null ? (SecretAttributes)new SecretAttributes().withNotBefore(builder.attributes.notBefore()).withEnabled(builder.attributes.enabled()).withExpires(builder.attributes.expires()) : null;
        this.tags = builder.tags != null ? Collections.unmodifiableMap(builder.tags) : null;
    }

    public String vaultBaseUrl() {
        return this.vaultBaseUrl;
    }

    public String secretName() {
        return this.secretName;
    }

    public String secretVersion() {
        return this.secretVersion;
    }

    public String contentType() {
        return this.contentType;
    }

    public SecretAttributes secretAttributes() {
        return this.secretAttributes;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public static class Builder {
        private final String vaultBaseUrl;
        private final String secretName;
        private String secretVersion;
        private String contentType;
        private SecretAttributes attributes;
        private Map<String, String> tags;

        public Builder(String vaultBaseUrl, String secretName) {
            this.vaultBaseUrl = vaultBaseUrl;
            this.secretName = secretName;
        }

        public Builder(String secretId) {
            SecretIdentifier id = new SecretIdentifier(secretId);
            this.vaultBaseUrl = id.vault();
            this.secretName = id.name();
            this.secretVersion = id.version();
        }

        public Builder withVersion(String version) {
            this.secretVersion = version;
            return this;
        }

        public Builder withContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder withAttributes(Attributes attributes) {
            this.attributes = (SecretAttributes)attributes;
            return this;
        }

        public Builder withTags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public UpdateSecretRequest build() {
            return new UpdateSecretRequest(this);
        }
    }
}

