/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.messagesecurity;

import com.microsoft.azure.keyvault.cryptography.RsaKey;
import com.microsoft.azure.keyvault.cryptography.SymmetricKey;
import com.microsoft.azure.keyvault.messagesecurity.JWEHeader;
import com.microsoft.azure.keyvault.messagesecurity.JWEObject;
import com.microsoft.azure.keyvault.messagesecurity.JWSHeader;
import com.microsoft.azure.keyvault.messagesecurity.JWSObject;
import com.microsoft.azure.keyvault.messagesecurity.MessageSecurityHelper;
import com.microsoft.azure.keyvault.webkey.JsonWebKey;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class HttpMessageSecurity {
    private static final String AUTHENTICATE = "Authorization";
    private static final String BEARER_TOKEP_REFIX = "Bearer ";
    private boolean testMode = false;
    private String clientSecurityToken;
    private JsonWebKey clientSignatureKey;
    private JsonWebKey clientEncryptionKey;
    private JsonWebKey serverSignatureKey;
    private JsonWebKey serverEncryptionKey;

    public HttpMessageSecurity(String clientSecurityToken, String clientSignatureKeyString, String serverEncryptionKeyString, String serverSignatureKeyString) throws IOException {
        this(clientSecurityToken, clientSignatureKeyString, serverEncryptionKeyString, serverSignatureKeyString, MessageSecurityHelper.generateJsonWebKey());
    }

    public HttpMessageSecurity(String clientSecurityToken, String clientSignatureKeyString, String serverEncryptionKeyString, String serverSignatureKeyString, JsonWebKey clientEncryptionKey) throws IOException {
        this.clientSecurityToken = clientSecurityToken;
        if (clientSignatureKeyString != null && !clientSignatureKeyString.equals("")) {
            this.clientSignatureKey = MessageSecurityHelper.jsonWebKeyFromString(clientSignatureKeyString);
        }
        if (serverSignatureKeyString != null && !serverSignatureKeyString.equals("")) {
            this.serverSignatureKey = MessageSecurityHelper.jsonWebKeyFromString(serverSignatureKeyString);
        }
        if (serverEncryptionKeyString != null && !serverEncryptionKeyString.equals("")) {
            this.serverEncryptionKey = MessageSecurityHelper.jsonWebKeyFromString(serverEncryptionKeyString);
        }
        this.clientEncryptionKey = clientEncryptionKey;
    }

    public HttpMessageSecurity(String clientSecurityToken, String clientEncryptionString, String clientSignatureKeyString, String serverEncryptionKeyString, String serverSignatureKeyString, boolean testMode) throws IOException {
        this(clientSecurityToken, clientSignatureKeyString, serverEncryptionKeyString, serverSignatureKeyString);
        this.testMode = testMode;
        if (clientEncryptionString != null && !clientEncryptionString.equals("")) {
            this.clientEncryptionKey = MessageSecurityHelper.jsonWebKeyFromString(clientEncryptionString);
        }
    }

    public Request protectRequest(Request request) throws IOException {
        try {
            Request result = request.newBuilder().header(AUTHENTICATE, BEARER_TOKEP_REFIX + this.clientSecurityToken).build();
            if (!this.supportsProtection()) {
                return result;
            }
            Buffer buffer = new Buffer();
            request.body().writeTo((BufferedSink)buffer);
            String currentbody = buffer.readUtf8();
            if (currentbody == null || currentbody.length() == 0) {
                return result;
            }
            JsonWebKey clientPublicEncryptionKey = MessageSecurityHelper.getJwkWithPublicKeyOnly(this.clientEncryptionKey);
            String payload = currentbody.substring(0, currentbody.length() - 1) + ",\"rek\":{\"jwk\":" + clientPublicEncryptionKey.toString() + "}}";
            JWEObject jweObject = this.protectPayload(payload);
            JWSHeader jwsHeader = new JWSHeader("RS256", this.clientSignatureKey.kid(), this.clientSecurityToken, this.getCurrentTimestamp(), "PoP", null);
            String jwsHeaderJsonb64 = MessageSecurityHelper.stringToBase64Url(jwsHeader.serialize());
            String protectedPayload = MessageSecurityHelper.stringToBase64Url(jweObject.serialize());
            byte[] data = (jwsHeaderJsonb64 + "." + protectedPayload).getBytes();
            RsaKey clientSignatureRsaKey = new RsaKey(this.clientSignatureKey.kid(), this.clientSignatureKey.toRSA(true));
            Pair signature = (Pair)clientSignatureRsaKey.signAsync(this.getSha256(data), "RS256").get();
            JWSObject jwsObject = new JWSObject(jwsHeader, protectedPayload, MessageSecurityHelper.bytesToBase64Url((byte[])signature.getKey()));
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/jose+json"), (String)jwsObject.serialize());
            return result.newBuilder().method(request.method(), body).build();
        }
        catch (ExecutionException e) {
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public Response unprotectResponse(Response response) throws IOException {
        try {
            if (!this.supportsProtection() || !HttpHeaders.hasBody((Response)response)) {
                return response;
            }
            if (!response.header("content-type").toLowerCase().contains("application/jose+json")) {
                return response;
            }
            JWSObject jwsObject = JWSObject.deserialize(response.body().string());
            JWSHeader jwsHeader = jwsObject.jwsHeader();
            if (!jwsHeader.kid().equals(this.serverSignatureKey.kid()) || !jwsHeader.alg().equals("RS256")) {
                throw new IOException("Invalid protected response");
            }
            byte[] data = (jwsObject.originalProtected() + "." + jwsObject.payload()).getBytes();
            byte[] signature = MessageSecurityHelper.base64UrltoByteArray(jwsObject.signature());
            RsaKey serverSignatureRsaKey = new RsaKey(this.serverSignatureKey.kid(), this.serverSignatureKey.toRSA(false));
            boolean signed = (Boolean)serverSignatureRsaKey.verifyAsync(this.getSha256(data), signature, "RS256").get();
            if (!signed) {
                throw new IOException("Wrong signature.");
            }
            String decrypted = this.unprotectPayload(jwsObject.payload());
            MediaType contentType = response.body().contentType();
            ResponseBody body = ResponseBody.create((MediaType)contentType, (String)decrypted);
            return response.newBuilder().body(body).build();
        }
        catch (ExecutionException e) {
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private long getCurrentTimestamp() {
        if (this.testMode) {
            return 0L;
        }
        return System.currentTimeMillis() / 1000L;
    }

    private boolean supportsProtection() {
        return this.clientSignatureKey != null && this.serverSignatureKey != null && this.serverEncryptionKey != null;
    }

    private JWEObject protectPayload(String payload) throws IOException {
        try {
            JWEHeader jweHeader = new JWEHeader("RSA-OAEP", this.serverEncryptionKey.kid(), "A128CBC-HS256");
            byte[] aesKeyBytes = this.generateAesKey();
            SymmetricKey aesKey = new SymmetricKey(UUID.randomUUID().toString(), aesKeyBytes);
            byte[] iv = this.generateAesIv();
            RsaKey serverEncryptionRsaKey = new RsaKey(this.serverEncryptionKey.kid(), this.serverEncryptionKey.toRSA(false));
            Triple encryptedKey = (Triple)serverEncryptionRsaKey.encryptAsync(aesKeyBytes, null, null, "RSA-OAEP").get();
            Triple cipher = (Triple)aesKey.encryptAsync(payload.getBytes(), iv, MessageSecurityHelper.stringToBase64Url(jweHeader.serialize()).getBytes(), "A128CBC-HS256").get();
            JWEObject jweObject = new JWEObject(jweHeader, MessageSecurityHelper.bytesToBase64Url(!this.testMode ? (byte[])encryptedKey.getLeft() : "key".getBytes()), MessageSecurityHelper.bytesToBase64Url(iv), MessageSecurityHelper.bytesToBase64Url((byte[])cipher.getLeft()), MessageSecurityHelper.bytesToBase64Url((byte[])cipher.getMiddle()));
            return jweObject;
        }
        catch (ExecutionException e) {
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private String unprotectPayload(String payload) throws IOException {
        try {
            JWEObject jweObject = JWEObject.deserialize(MessageSecurityHelper.base64UrltoString(payload));
            JWEHeader jweHeader = jweObject.jweHeader();
            if (!(this.clientEncryptionKey.kid().equals(jweHeader.kid()) && jweHeader.alg().equals("RSA-OAEP") && jweHeader.enc().equals("A128CBC-HS256"))) {
                throw new IOException("Invalid protected response");
            }
            byte[] key = MessageSecurityHelper.base64UrltoByteArray(jweObject.encryptedKey());
            RsaKey clientEncryptionRsaKey = new RsaKey(this.clientEncryptionKey.kid(), this.clientEncryptionKey.toRSA(true));
            byte[] aesKeyBytes = (byte[])clientEncryptionRsaKey.decryptAsync(key, null, null, null, "RSA-OAEP").get();
            SymmetricKey aesKey = new SymmetricKey(UUID.randomUUID().toString(), aesKeyBytes);
            byte[] result = (byte[])aesKey.decryptAsync(MessageSecurityHelper.base64UrltoByteArray(jweObject.cipherText()), MessageSecurityHelper.base64UrltoByteArray(jweObject.iv()), jweObject.originalProtected().getBytes(), MessageSecurityHelper.base64UrltoByteArray(jweObject.tag()), "A128CBC-HS256").get();
            return new String(result);
        }
        catch (ExecutionException e) {
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private byte[] getSha256(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        return digest.digest(data);
    }

    private byte[] generateAesKey() {
        byte[] bytes = new byte[32];
        if (!this.testMode) {
            SecureRandom random = new SecureRandom();
            random.nextBytes(bytes);
        } else {
            bytes = "TEST1234TEST1234TEST1234TEST1234".getBytes();
        }
        return bytes;
    }

    private byte[] generateAesIv() {
        byte[] bytes = new byte[16];
        if (!this.testMode) {
            SecureRandom random = new SecureRandom();
            random.nextBytes(bytes);
        } else {
            bytes = "TEST1234TEST1234".getBytes();
        }
        return bytes;
    }
}

