/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.implementation;

import com.google.common.base.Joiner;
import com.microsoft.azure.AzureClient;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.keyvault.CertificateIdentifier;
import com.microsoft.azure.keyvault.KeyIdentifier;
import com.microsoft.azure.keyvault.KeyVaultClientCustom;
import com.microsoft.azure.keyvault.SecretIdentifier;
import com.microsoft.azure.keyvault.implementation.KeyVaultClientBaseImpl;
import com.microsoft.azure.keyvault.models.CertificateBundle;
import com.microsoft.azure.keyvault.models.CertificateCreateParameters;
import com.microsoft.azure.keyvault.models.CertificateImportParameters;
import com.microsoft.azure.keyvault.models.CertificateIssuerItem;
import com.microsoft.azure.keyvault.models.CertificateIssuerSetParameters;
import com.microsoft.azure.keyvault.models.CertificateIssuerUpdateParameters;
import com.microsoft.azure.keyvault.models.CertificateItem;
import com.microsoft.azure.keyvault.models.CertificateMergeParameters;
import com.microsoft.azure.keyvault.models.CertificateOperation;
import com.microsoft.azure.keyvault.models.CertificateOperationUpdateParameter;
import com.microsoft.azure.keyvault.models.CertificatePolicy;
import com.microsoft.azure.keyvault.models.CertificateUpdateParameters;
import com.microsoft.azure.keyvault.models.Contacts;
import com.microsoft.azure.keyvault.models.DeletedCertificateItem;
import com.microsoft.azure.keyvault.models.IssuerBundle;
import com.microsoft.azure.keyvault.models.JsonWebKeyCurveName;
import com.microsoft.azure.keyvault.models.KeyAttributes;
import com.microsoft.azure.keyvault.models.KeyBundle;
import com.microsoft.azure.keyvault.models.KeyCreateParameters;
import com.microsoft.azure.keyvault.models.KeyImportParameters;
import com.microsoft.azure.keyvault.models.KeyItem;
import com.microsoft.azure.keyvault.models.KeyOperationResult;
import com.microsoft.azure.keyvault.models.KeyOperationsParameters;
import com.microsoft.azure.keyvault.models.KeyRestoreParameters;
import com.microsoft.azure.keyvault.models.KeySignParameters;
import com.microsoft.azure.keyvault.models.KeyUpdateParameters;
import com.microsoft.azure.keyvault.models.KeyVerifyParameters;
import com.microsoft.azure.keyvault.models.KeyVerifyResult;
import com.microsoft.azure.keyvault.models.SecretBundle;
import com.microsoft.azure.keyvault.models.SecretItem;
import com.microsoft.azure.keyvault.models.SecretSetParameters;
import com.microsoft.azure.keyvault.models.SecretUpdateParameters;
import com.microsoft.azure.keyvault.requests.CreateCertificateRequest;
import com.microsoft.azure.keyvault.requests.CreateKeyRequest;
import com.microsoft.azure.keyvault.requests.ImportCertificateRequest;
import com.microsoft.azure.keyvault.requests.ImportKeyRequest;
import com.microsoft.azure.keyvault.requests.MergeCertificateRequest;
import com.microsoft.azure.keyvault.requests.SetCertificateIssuerRequest;
import com.microsoft.azure.keyvault.requests.SetSecretRequest;
import com.microsoft.azure.keyvault.requests.UpdateCertificateIssuerRequest;
import com.microsoft.azure.keyvault.requests.UpdateCertificateOperationRequest;
import com.microsoft.azure.keyvault.requests.UpdateCertificatePolicyRequest;
import com.microsoft.azure.keyvault.requests.UpdateCertificateRequest;
import com.microsoft.azure.keyvault.requests.UpdateKeyRequest;
import com.microsoft.azure.keyvault.requests.UpdateSecretRequest;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyEncryptionAlgorithm;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyOperation;
import com.microsoft.azure.keyvault.webkey.JsonWebKeySignatureAlgorithm;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyType;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.SerializerAdapter;
import java.util.List;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class KeyVaultClientCustomImpl
extends KeyVaultClientBaseImpl
implements KeyVaultClientCustom {
    private KeyVaultClientService service;
    private AzureClient azureClient;

    protected KeyVaultClientCustomImpl(ServiceClientCredentials credentials) {
        super(credentials);
    }

    protected KeyVaultClientCustomImpl(RestClient restClient) {
        super(restClient);
    }

    @Override
    public void initializeService() {
        this.service = (KeyVaultClientService)this.restClient().retrofit().create(KeyVaultClientService.class);
    }

    @Override
    public OkHttpClient httpClient() {
        return super.httpClient();
    }

    @Override
    public SerializerAdapter<?> serializerAdapter() {
        return super.serializerAdapter();
    }

    @Override
    public KeyBundle createKey(CreateKeyRequest createKeyRequest) {
        return this.createKey(createKeyRequest.vaultBaseUrl(), createKeyRequest.keyName(), createKeyRequest.keyType(), createKeyRequest.keySize(), createKeyRequest.keyOperations(), createKeyRequest.keyAttributes(), createKeyRequest.tags(), createKeyRequest.curve());
    }

    @Override
    public ServiceFuture<KeyBundle> createKeyAsync(CreateKeyRequest createKeyRequest, ServiceCallback<KeyBundle> serviceCallback) {
        createKeyRequest.vaultBaseUrl();
        return this.createKeyAsync(createKeyRequest.vaultBaseUrl(), createKeyRequest.keyName(), createKeyRequest.keyType(), createKeyRequest.keySize(), createKeyRequest.keyOperations(), createKeyRequest.keyAttributes(), createKeyRequest.tags(), createKeyRequest.curve(), serviceCallback);
    }

    @Override
    public KeyBundle importKey(ImportKeyRequest importKeyRequest) {
        return this.importKey(importKeyRequest.vaultBaseUrl(), importKeyRequest.keyName(), importKeyRequest.key(), importKeyRequest.isHsm(), importKeyRequest.keyAttributes(), importKeyRequest.tags());
    }

    @Override
    public ServiceFuture<KeyBundle> importKeyAsync(ImportKeyRequest importKeyRequest, ServiceCallback<KeyBundle> serviceCallback) {
        return this.importKeyAsync(importKeyRequest.vaultBaseUrl(), importKeyRequest.keyName(), importKeyRequest.key(), importKeyRequest.isHsm(), importKeyRequest.keyAttributes(), importKeyRequest.tags(), serviceCallback);
    }

    @Override
    public KeyBundle updateKey(UpdateKeyRequest updateKeyRequest) {
        return this.updateKey(updateKeyRequest.vaultBaseUrl(), updateKeyRequest.keyName(), updateKeyRequest.keyVersion(), updateKeyRequest.keyOperations(), updateKeyRequest.keyAttributes(), updateKeyRequest.tags());
    }

    @Override
    public ServiceFuture<KeyBundle> updateKeyAsync(UpdateKeyRequest updateKeyRequest, ServiceCallback<KeyBundle> serviceCallback) {
        return this.updateKeyAsync(updateKeyRequest.vaultBaseUrl(), updateKeyRequest.keyName(), updateKeyRequest.keyVersion(), updateKeyRequest.keyOperations(), updateKeyRequest.keyAttributes(), updateKeyRequest.tags(), serviceCallback);
    }

    @Override
    public KeyBundle getKey(String keyIdentifier) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.getKey(id.vault(), id.name(), id.version() == null ? "" : id.version());
    }

    @Override
    public ServiceFuture<KeyBundle> getKeyAsync(String keyIdentifier, ServiceCallback<KeyBundle> serviceCallback) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.getKeyAsync(id.vault(), id.name(), id.version() == null ? "" : id.version(), serviceCallback);
    }

    @Override
    public KeyBundle getKey(String vaultBaseUrl, String keyName) {
        return this.getKey(vaultBaseUrl, keyName, "");
    }

    @Override
    public ServiceFuture<KeyBundle> getKeyAsync(String vaultBaseUrl, String keyName, ServiceCallback<KeyBundle> serviceCallback) {
        return this.getKeyAsync(vaultBaseUrl, keyName, "", serviceCallback);
    }

    @Override
    public PagedList<KeyItem> listKeyVersions(String vaultBaseUrl, String keyName) {
        return this.getKeyVersions(vaultBaseUrl, keyName);
    }

    @Override
    public ServiceFuture<KeyOperationResult> wrapKeyAsync(String keyIdentifier, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.wrapKeyAsync(id.vault(), id.name(), id.version() == null ? "" : id.version(), algorithm, value, serviceCallback);
    }

    @Override
    public KeyOperationResult unwrapKey(String keyIdentifier, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.unwrapKey(id.vault(), id.name(), id.version() == null ? "" : id.version(), algorithm, value);
    }

    @Override
    public ServiceFuture<KeyOperationResult> unwrapKeyAsync(String keyIdentifier, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.unwrapKeyAsync(id.vault(), id.name(), id.version() == null ? "" : id.version(), algorithm, value, serviceCallback);
    }

    @Override
    public KeyOperationResult wrapKey(String keyIdentifier, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.wrapKey(id.vault(), id.name(), id.version() == null ? "" : id.version(), algorithm, value);
    }

    @Override
    public ServiceFuture<List<KeyItem>> listKeyVersionsAsync(String vaultBaseUrl, String keyName, ListOperationCallback<KeyItem> serviceCallback) {
        return this.getKeyVersionsAsync(vaultBaseUrl, keyName, serviceCallback);
    }

    @Override
    public ServiceFuture<List<KeyItem>> listKeyVersionsAsync(String vaultBaseUrl, String keyName, Integer maxresults, ListOperationCallback<KeyItem> serviceCallback) {
        return this.getKeyVersionsAsync(vaultBaseUrl, keyName, maxresults, serviceCallback);
    }

    @Override
    public PagedList<KeyItem> listKeyVersions(String vaultBaseUrl, String keyName, Integer maxresults) {
        return this.getKeyVersions(vaultBaseUrl, keyName, maxresults);
    }

    @Override
    public PagedList<KeyItem> listKeys(String vaultBaseUrl) {
        return this.getKeys(vaultBaseUrl);
    }

    @Override
    public ServiceFuture<List<KeyItem>> listKeysAsync(String vaultBaseUrl, ListOperationCallback<KeyItem> serviceCallback) {
        return this.getKeysAsync(vaultBaseUrl, serviceCallback);
    }

    @Override
    public ServiceFuture<List<KeyItem>> listKeysAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<KeyItem> serviceCallback) {
        return this.getKeysAsync(vaultBaseUrl, maxresults, serviceCallback);
    }

    @Override
    public PagedList<KeyItem> listKeys(String vaultBaseUrl, Integer maxresults) {
        return this.getKeys(vaultBaseUrl, maxresults);
    }

    @Override
    public KeyOperationResult encrypt(String keyIdentifier, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.encrypt(id.vault(), id.name(), id.version() == null ? "" : id.version(), algorithm, value);
    }

    @Override
    public ServiceFuture<KeyOperationResult> encryptAsync(String keyIdentifier, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.encryptAsync(id.vault(), id.name(), id.version() == null ? "" : id.version(), algorithm, value, serviceCallback);
    }

    @Override
    public KeyOperationResult decrypt(String keyIdentifier, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.decrypt(id.vault(), id.name(), id.version() == null ? "" : id.version(), algorithm, value);
    }

    @Override
    public ServiceFuture<KeyOperationResult> decryptAsync(String keyIdentifier, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.decryptAsync(id.vault(), id.name(), id.version() == null ? "" : id.version(), algorithm, value, serviceCallback);
    }

    @Override
    public KeyOperationResult sign(String keyIdentifier, JsonWebKeySignatureAlgorithm algorithm, byte[] value) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.sign(id.vault(), id.name(), id.version() == null ? "" : id.version(), algorithm, value);
    }

    @Override
    public ServiceFuture<KeyOperationResult> signAsync(String keyIdentifier, JsonWebKeySignatureAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.signAsync(id.vault(), id.name(), id.version() == null ? "" : id.version(), algorithm, value, serviceCallback);
    }

    @Override
    public KeyVerifyResult verify(String keyIdentifier, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.verify(id.vault(), id.name(), id.version() == null ? "" : id.version(), algorithm, digest, signature);
    }

    @Override
    public ServiceFuture<KeyVerifyResult> verifyAsync(String keyIdentifier, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature, ServiceCallback<KeyVerifyResult> serviceCallback) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.verifyAsync(id.vault(), id.name(), id.version() == null ? "" : id.version(), algorithm, digest, signature, serviceCallback);
    }

    @Override
    public SecretBundle setSecret(SetSecretRequest setSecretRequest) {
        return this.setSecret(setSecretRequest.vaultBaseUrl(), setSecretRequest.secretName(), setSecretRequest.value(), setSecretRequest.tags(), setSecretRequest.contentType(), setSecretRequest.secretAttributes());
    }

    @Override
    public ServiceFuture<SecretBundle> setSecretAsync(SetSecretRequest setSecretRequest, ServiceCallback<SecretBundle> serviceCallback) {
        return this.setSecretAsync(setSecretRequest.vaultBaseUrl(), setSecretRequest.secretName(), setSecretRequest.value(), setSecretRequest.tags(), setSecretRequest.contentType(), setSecretRequest.secretAttributes(), serviceCallback);
    }

    @Override
    public SecretBundle updateSecret(UpdateSecretRequest updateSecretRequest) {
        return this.updateSecret(updateSecretRequest.vaultBaseUrl(), updateSecretRequest.secretName(), updateSecretRequest.secretVersion(), updateSecretRequest.contentType(), updateSecretRequest.secretAttributes(), updateSecretRequest.tags());
    }

    @Override
    public ServiceFuture<SecretBundle> updateSecretAsync(UpdateSecretRequest updateSecretRequest, ServiceCallback<SecretBundle> serviceCallback) {
        return this.updateSecretAsync(updateSecretRequest.vaultBaseUrl(), updateSecretRequest.secretName(), updateSecretRequest.secretVersion(), updateSecretRequest.contentType(), updateSecretRequest.secretAttributes(), updateSecretRequest.tags(), serviceCallback);
    }

    @Override
    public SecretBundle getSecret(String secretIdentifier) {
        SecretIdentifier id = new SecretIdentifier(secretIdentifier);
        return this.getSecret(id.vault(), id.name(), id.version() == null ? "" : id.version());
    }

    @Override
    public ServiceFuture<SecretBundle> getSecretAsync(String secretIdentifier, ServiceCallback<SecretBundle> serviceCallback) {
        SecretIdentifier id = new SecretIdentifier(secretIdentifier);
        return this.getSecretAsync(id.vault(), id.name(), id.version() == null ? "" : id.version(), serviceCallback);
    }

    @Override
    public SecretBundle getSecret(String vaultBaseUrl, String secretName) {
        return this.getSecret(vaultBaseUrl, secretName, "");
    }

    @Override
    public ServiceFuture<SecretBundle> getSecretAsync(String vaultBaseUrl, String secretName, ServiceCallback<SecretBundle> serviceCallback) {
        return this.getSecretAsync(vaultBaseUrl, secretName, "", serviceCallback);
    }

    @Override
    public PagedList<SecretItem> listSecrets(String vaultBaseUrl) {
        return this.getSecrets(vaultBaseUrl);
    }

    @Override
    public ServiceFuture<List<SecretItem>> listSecretsAsync(String vaultBaseUrl, ListOperationCallback<SecretItem> serviceCallback) {
        return this.getSecretsAsync(vaultBaseUrl, serviceCallback);
    }

    @Override
    public PagedList<SecretItem> listSecrets(String vaultBaseUrl, Integer maxresults) {
        return this.getSecrets(vaultBaseUrl, maxresults);
    }

    @Override
    public ServiceFuture<List<SecretItem>> listSecretsAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<SecretItem> serviceCallback) {
        return this.getSecretsAsync(vaultBaseUrl, maxresults, serviceCallback);
    }

    @Override
    public PagedList<SecretItem> listSecretVersions(String vaultBaseUrl, String secretName) {
        return this.getSecretVersions(vaultBaseUrl, secretName);
    }

    @Override
    public ServiceFuture<List<SecretItem>> listSecretVersionsAsync(String vaultBaseUrl, String secretName, ListOperationCallback<SecretItem> serviceCallback) {
        return this.getSecretVersionsAsync(vaultBaseUrl, secretName, serviceCallback);
    }

    @Override
    public PagedList<SecretItem> listSecretVersions(String vaultBaseUrl, String secretName, Integer maxresults) {
        return this.getSecretVersions(vaultBaseUrl, secretName, maxresults);
    }

    @Override
    public ServiceFuture<List<SecretItem>> listSecretVersionsAsync(String vaultBaseUrl, String secretName, Integer maxresults, ListOperationCallback<SecretItem> serviceCallback) {
        return this.getSecretVersionsAsync(vaultBaseUrl, secretName, maxresults, serviceCallback);
    }

    @Override
    public PagedList<CertificateItem> listCertificates(String vaultBaseUrl) {
        return this.getCertificates(vaultBaseUrl);
    }

    @Override
    public ServiceFuture<List<CertificateItem>> listCertificatesAsync(String vaultBaseUrl, ListOperationCallback<CertificateItem> serviceCallback) {
        return this.getCertificatesAsync(vaultBaseUrl, serviceCallback);
    }

    @Override
    public PagedList<CertificateItem> listCertificates(String vaultBaseUrl, Integer maxresults) {
        return this.getCertificates(vaultBaseUrl, maxresults);
    }

    @Override
    public ServiceFuture<List<CertificateItem>> listCertificatesAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<CertificateItem> serviceCallback) {
        return this.getCertificatesAsync(vaultBaseUrl, maxresults, serviceCallback);
    }

    @Override
    public PagedList<CertificateIssuerItem> listCertificateIssuers(String vaultBaseUrl) {
        return this.getCertificateIssuers(vaultBaseUrl);
    }

    @Override
    public ServiceFuture<List<CertificateIssuerItem>> listCertificateIssuersAsync(String vaultBaseUrl, ListOperationCallback<CertificateIssuerItem> serviceCallback) {
        return this.getCertificateIssuersAsync(vaultBaseUrl, serviceCallback);
    }

    @Override
    public PagedList<CertificateIssuerItem> listCertificateIssuers(String vaultBaseUrl, Integer maxresults) {
        return this.getCertificateIssuers(vaultBaseUrl, maxresults);
    }

    @Override
    public ServiceFuture<List<CertificateIssuerItem>> listCertificateIssuersAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<CertificateIssuerItem> serviceCallback) {
        return this.getCertificateIssuersAsync(vaultBaseUrl, maxresults, serviceCallback);
    }

    @Override
    public IssuerBundle setCertificateIssuer(SetCertificateIssuerRequest setCertificateIssuerRequest) {
        return this.setCertificateIssuer(setCertificateIssuerRequest.vaultBaseUrl(), setCertificateIssuerRequest.issuerName(), setCertificateIssuerRequest.provider(), setCertificateIssuerRequest.credentials(), setCertificateIssuerRequest.organizationDetails(), setCertificateIssuerRequest.attributes());
    }

    @Override
    public ServiceFuture<IssuerBundle> setCertificateIssuerAsync(SetCertificateIssuerRequest setCertificateIssuerRequest, ServiceCallback<IssuerBundle> serviceCallback) {
        return this.setCertificateIssuerAsync(setCertificateIssuerRequest.vaultBaseUrl(), setCertificateIssuerRequest.issuerName(), setCertificateIssuerRequest.provider(), setCertificateIssuerRequest.credentials(), setCertificateIssuerRequest.organizationDetails(), setCertificateIssuerRequest.attributes(), serviceCallback);
    }

    @Override
    public IssuerBundle updateCertificateIssuer(UpdateCertificateIssuerRequest updateCertificateIssuerRequest) {
        return this.updateCertificateIssuer(updateCertificateIssuerRequest.vaultBaseUrl(), updateCertificateIssuerRequest.issuerName(), updateCertificateIssuerRequest.provider(), updateCertificateIssuerRequest.credentials(), updateCertificateIssuerRequest.organizationDetails(), updateCertificateIssuerRequest.attributes());
    }

    @Override
    public ServiceFuture<IssuerBundle> updateCertificateIssuerAsync(UpdateCertificateIssuerRequest updateCertificateIssuerRequest, ServiceCallback<IssuerBundle> serviceCallback) {
        return this.updateCertificateIssuerAsync(updateCertificateIssuerRequest.vaultBaseUrl(), updateCertificateIssuerRequest.issuerName(), updateCertificateIssuerRequest.provider(), updateCertificateIssuerRequest.credentials(), updateCertificateIssuerRequest.organizationDetails(), updateCertificateIssuerRequest.attributes(), serviceCallback);
    }

    @Override
    public CertificateOperation createCertificate(CreateCertificateRequest createCertificateRequest) {
        return this.createCertificate(createCertificateRequest.vaultBaseUrl(), createCertificateRequest.certificateName(), createCertificateRequest.certificatePolicy(), createCertificateRequest.certificateAttributes(), createCertificateRequest.tags());
    }

    @Override
    public ServiceFuture<CertificateOperation> createCertificateAsync(CreateCertificateRequest createCertificateRequest, ServiceCallback<CertificateOperation> serviceCallback) {
        return this.createCertificateAsync(createCertificateRequest.vaultBaseUrl(), createCertificateRequest.certificateName(), createCertificateRequest.certificatePolicy(), createCertificateRequest.certificateAttributes(), createCertificateRequest.tags(), serviceCallback);
    }

    @Override
    public CertificateBundle importCertificate(ImportCertificateRequest importCertificateRequest) {
        return this.importCertificate(importCertificateRequest.vaultBaseUrl(), importCertificateRequest.certificateName(), importCertificateRequest.base64EncodedCertificate(), importCertificateRequest.password(), importCertificateRequest.certificatePolicy(), importCertificateRequest.certificateAttributes(), importCertificateRequest.tags());
    }

    @Override
    public ServiceFuture<CertificateBundle> importCertificateAsync(ImportCertificateRequest importCertificateRequest, ServiceCallback<CertificateBundle> serviceCallback) {
        return this.importCertificateAsync(importCertificateRequest.vaultBaseUrl(), importCertificateRequest.certificateName(), importCertificateRequest.base64EncodedCertificate(), importCertificateRequest.password(), importCertificateRequest.certificatePolicy(), importCertificateRequest.certificateAttributes(), importCertificateRequest.tags(), serviceCallback);
    }

    @Override
    public PagedList<CertificateItem> listCertificateVersions(String vaultBaseUrl, String certificateName) {
        return this.getCertificateVersions(vaultBaseUrl, certificateName);
    }

    @Override
    public ServiceFuture<List<CertificateItem>> listCertificateVersionsAsync(String vaultBaseUrl, String certificateName, ListOperationCallback<CertificateItem> serviceCallback) {
        return this.getCertificateVersionsAsync(vaultBaseUrl, certificateName, serviceCallback);
    }

    @Override
    public PagedList<CertificateItem> listCertificateVersions(String vaultBaseUrl, String certificateName, Integer maxresults) {
        return this.getCertificateVersions(vaultBaseUrl, certificateName, maxresults);
    }

    @Override
    public ServiceFuture<List<CertificateItem>> listCertificateVersionsAsync(String vaultBaseUrl, String certificateName, Integer maxresults, ListOperationCallback<CertificateItem> serviceCallback) {
        return this.getCertificateVersionsAsync(vaultBaseUrl, certificateName, maxresults, serviceCallback);
    }

    @Override
    public CertificatePolicy updateCertificatePolicy(UpdateCertificatePolicyRequest updateCertificatePolicyRequest) {
        return this.updateCertificatePolicy(updateCertificatePolicyRequest.vaultBaseUrl(), updateCertificatePolicyRequest.certificateName(), updateCertificatePolicyRequest.certificatePolicy());
    }

    @Override
    public ServiceFuture<CertificatePolicy> updateCertificatePolicyAsync(UpdateCertificatePolicyRequest updateCertificatePolicyRequest, ServiceCallback<CertificatePolicy> serviceCallback) {
        return this.updateCertificatePolicyAsync(updateCertificatePolicyRequest.vaultBaseUrl(), updateCertificatePolicyRequest.certificateName(), updateCertificatePolicyRequest.certificatePolicy(), serviceCallback);
    }

    @Override
    public CertificateBundle updateCertificate(UpdateCertificateRequest updateCertificateRequest) {
        return this.updateCertificate(updateCertificateRequest.vaultBaseUrl(), updateCertificateRequest.certificateName(), updateCertificateRequest.certificateVersion(), updateCertificateRequest.certificatePolicy(), updateCertificateRequest.certificateAttributes(), updateCertificateRequest.tags());
    }

    @Override
    public ServiceFuture<CertificateBundle> updateCertificateAsync(UpdateCertificateRequest updateCertificateRequest, ServiceCallback<CertificateBundle> serviceCallback) {
        return this.updateCertificateAsync(updateCertificateRequest.vaultBaseUrl(), updateCertificateRequest.certificateName(), updateCertificateRequest.certificateVersion(), updateCertificateRequest.certificatePolicy(), updateCertificateRequest.certificateAttributes(), updateCertificateRequest.tags(), serviceCallback);
    }

    @Override
    public CertificateBundle getCertificate(String certificateIdentifier) {
        CertificateIdentifier id = new CertificateIdentifier(certificateIdentifier);
        return this.getCertificate(id.vault(), id.name(), id.version() == null ? "" : id.version());
    }

    @Override
    public ServiceFuture<CertificateBundle> getCertificateAsync(String certificateIdentifier, ServiceCallback<CertificateBundle> serviceCallback) {
        CertificateIdentifier id = new CertificateIdentifier(certificateIdentifier);
        return this.getCertificateAsync(id.vault(), id.name(), id.version() == null ? "" : id.version(), serviceCallback);
    }

    @Override
    public CertificateBundle getCertificate(String vaultBaseUrl, String certificateName) {
        return this.getCertificate(vaultBaseUrl, certificateName, "");
    }

    public ServiceFuture<CertificateBundle> getCertificateAsync(String vaultBaseUrl, String certificateName, ServiceCallback<CertificateBundle> serviceCallback) {
        return this.getCertificateAsync(vaultBaseUrl, certificateName, "", serviceCallback);
    }

    @Override
    public CertificateOperation updateCertificateOperation(UpdateCertificateOperationRequest updateCertificateOperationRequest) {
        return this.updateCertificateOperation(updateCertificateOperationRequest.vaultBaseUrl(), updateCertificateOperationRequest.certificateName(), updateCertificateOperationRequest.cancellationRequested());
    }

    @Override
    public ServiceFuture<CertificateOperation> updateCertificateOperationAsync(UpdateCertificateOperationRequest updateCertificateOperationRequest, ServiceCallback<CertificateOperation> serviceCallback) {
        return this.updateCertificateOperationAsync(updateCertificateOperationRequest.vaultBaseUrl(), updateCertificateOperationRequest.certificateName(), updateCertificateOperationRequest.cancellationRequested(), serviceCallback);
    }

    @Override
    public CertificateBundle mergeCertificate(MergeCertificateRequest mergeCertificateRequest) {
        return this.mergeCertificate(mergeCertificateRequest.vaultBaseUrl(), mergeCertificateRequest.certificateName(), mergeCertificateRequest.x509Certificates(), mergeCertificateRequest.certificateAttributes(), mergeCertificateRequest.tags());
    }

    @Override
    public ServiceFuture<CertificateBundle> mergeCertificateAsync(MergeCertificateRequest mergeCertificateRequest, ServiceCallback<CertificateBundle> serviceCallback) {
        return this.mergeCertificateAsync(mergeCertificateRequest.vaultBaseUrl(), mergeCertificateRequest.certificateName(), mergeCertificateRequest.x509Certificates(), mergeCertificateRequest.certificateAttributes(), mergeCertificateRequest.tags(), serviceCallback);
    }

    @Override
    public String getPendingCertificateSigningRequest(String vaultBaseUrl, String certificateName) {
        return (String)((ServiceResponse)this.getPendingCertificateSigningRequestWithServiceResponseAsync(vaultBaseUrl, certificateName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<String> getPendingCertificateSigningRequestAsync(String vaultBaseUrl, String certificateName, ServiceCallback<String> serviceCallback) {
        return ServiceFuture.fromResponse(this.getPendingCertificateSigningRequestWithServiceResponseAsync(vaultBaseUrl, certificateName), serviceCallback);
    }

    private Observable<ServiceResponse<String>> getPendingCertificateSigningRequestWithServiceResponseAsync(String vaultBaseUrl, String certificateName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getPendingCertificateSigningRequest(certificateName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<String>>>(){

            public Observable<ServiceResponse<String>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = new ServiceResponse((Object)((ResponseBody)response.body()).string(), response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public KeyBundle createKey(String vaultBaseUrl, String keyName, JsonWebKeyType kty, Integer keySize, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags) {
        return this.createKey(vaultBaseUrl, keyName, kty, keySize, keyOps, keyAttributes, tags, null);
    }

    @Override
    public ServiceFuture<KeyBundle> createKeyAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty, Integer keySize, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, ServiceCallback<KeyBundle> serviceCallback) {
        return this.createKeyAsync(vaultBaseUrl, keyName, kty, keySize, keyOps, keyAttributes, tags, null, serviceCallback);
    }

    @Override
    public Observable<KeyBundle> createKeyAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty, Integer keySize, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags) {
        return this.createKeyAsync(vaultBaseUrl, keyName, kty, keySize, keyOps, keyAttributes, tags, (JsonWebKeyCurveName)null);
    }

    @Override
    public Observable<ServiceResponse<KeyBundle>> createKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty, Integer keySize, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags) {
        return this.createKeyWithServiceResponseAsync(vaultBaseUrl, keyName, kty, keySize, keyOps, keyAttributes, tags, null);
    }

    @Override
    public PagedList<CertificateItem> getCertificates(String vaultBaseUrl, Integer maxresults) {
        return this.getCertificates(vaultBaseUrl, maxresults, false);
    }

    @Override
    public ServiceFuture<List<CertificateItem>> getCertificatesAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<CertificateItem> serviceCallback) {
        return this.getCertificatesAsync(vaultBaseUrl, maxresults, false, serviceCallback);
    }

    @Override
    public Observable<Page<CertificateItem>> getCertificatesAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getCertificatesAsync(vaultBaseUrl, maxresults, false);
    }

    @Override
    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificatesWithServiceResponseAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getCertificatesWithServiceResponseAsync(vaultBaseUrl, maxresults, false);
    }

    @Override
    public PagedList<DeletedCertificateItem> getDeletedCertificates(String vaultBaseUrl, Integer maxresults) {
        return this.getDeletedCertificates(vaultBaseUrl, maxresults, false);
    }

    @Override
    public ServiceFuture<List<DeletedCertificateItem>> getDeletedCertificatesAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<DeletedCertificateItem> serviceCallback) {
        return this.getDeletedCertificatesAsync(vaultBaseUrl, maxresults, false, serviceCallback);
    }

    @Override
    public Observable<Page<DeletedCertificateItem>> getDeletedCertificatesAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getDeletedCertificatesAsync(vaultBaseUrl, maxresults, false);
    }

    @Override
    public Observable<ServiceResponse<Page<DeletedCertificateItem>>> getDeletedCertificatesWithServiceResponseAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getDeletedCertificatesWithServiceResponseAsync(vaultBaseUrl, maxresults, false);
    }

    static interface KeyVaultClientService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient createKey"})
        @POST(value="keys/{key-name}/create")
        public Observable<Response<ResponseBody>> createKey(@Path(value="key-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body KeyCreateParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient importKey"})
        @PUT(value="keys/{key-name}")
        public Observable<Response<ResponseBody>> importKey(@Path(value="key-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body KeyImportParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient deleteKey"})
        @HTTP(path="keys/{key-name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteKey(@Path(value="key-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient updateKey"})
        @PATCH(value="keys/{key-name}/{key-version}")
        public Observable<Response<ResponseBody>> updateKey(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyUpdateParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getKey"})
        @GET(value="keys/{key-name}/{key-version}")
        public Observable<Response<ResponseBody>> getKey(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getKeyVersions"})
        @GET(value="keys/{key-name}/versions")
        public Observable<Response<ResponseBody>> getKeyVersions(@Path(value="key-name") String var1, @Query(value="maxresults") Integer var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getKeys"})
        @GET(value="keys")
        public Observable<Response<ResponseBody>> getKeys(@Query(value="maxresults") Integer var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient backupKey"})
        @POST(value="keys/{key-name}/backup")
        public Observable<Response<ResponseBody>> backupKey(@Path(value="key-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient restoreKey"})
        @POST(value="keys/restore")
        public Observable<Response<ResponseBody>> restoreKey(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Body KeyRestoreParameters var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient encrypt"})
        @POST(value="keys/{key-name}/{key-version}/encrypt")
        public Observable<Response<ResponseBody>> encrypt(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyOperationsParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient decrypt"})
        @POST(value="keys/{key-name}/{key-version}/decrypt")
        public Observable<Response<ResponseBody>> decrypt(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyOperationsParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient sign"})
        @POST(value="keys/{key-name}/{key-version}/sign")
        public Observable<Response<ResponseBody>> sign(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeySignParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient verify"})
        @POST(value="keys/{key-name}/{key-version}/verify")
        public Observable<Response<ResponseBody>> verify(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyVerifyParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient wrapKey"})
        @POST(value="keys/{key-name}/{key-version}/wrapkey")
        public Observable<Response<ResponseBody>> wrapKey(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyOperationsParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient unwrapKey"})
        @POST(value="keys/{key-name}/{key-version}/unwrapkey")
        public Observable<Response<ResponseBody>> unwrapKey(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyOperationsParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient setSecret"})
        @PUT(value="secrets/{secret-name}")
        public Observable<Response<ResponseBody>> setSecret(@Path(value="secret-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body SecretSetParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient deleteSecret"})
        @HTTP(path="secrets/{secret-name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteSecret(@Path(value="secret-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient updateSecret"})
        @PATCH(value="secrets/{secret-name}/{secret-version}")
        public Observable<Response<ResponseBody>> updateSecret(@Path(value="secret-name") String var1, @Path(value="secret-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body SecretUpdateParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getSecret"})
        @GET(value="secrets/{secret-name}/{secret-version}")
        public Observable<Response<ResponseBody>> getSecret(@Path(value="secret-name") String var1, @Path(value="secret-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getSecrets"})
        @GET(value="secrets")
        public Observable<Response<ResponseBody>> getSecrets(@Query(value="maxresults") Integer var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getSecretVersions"})
        @GET(value="secrets/{secret-name}/versions")
        public Observable<Response<ResponseBody>> getSecretVersions(@Path(value="secret-name") String var1, @Query(value="maxresults") Integer var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getCertificates"})
        @GET(value="certificates")
        public Observable<Response<ResponseBody>> getCertificates(@Query(value="maxresults") Integer var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient deleteCertificate"})
        @HTTP(path="certificates/{certificate-name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCertificate(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient setCertificateContacts"})
        @PUT(value="certificates/contacts")
        public Observable<Response<ResponseBody>> setCertificateContacts(@Body Contacts var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getCertificateContacts"})
        @GET(value="certificates/contacts")
        public Observable<Response<ResponseBody>> getCertificateContacts(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="x-ms-parameterized-host") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient deleteCertificateContacts"})
        @HTTP(path="certificates/contacts", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCertificateContacts(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="x-ms-parameterized-host") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getCertificateIssuers"})
        @GET(value="certificates/issuers")
        public Observable<Response<ResponseBody>> getCertificateIssuers(@Query(value="maxresults") Integer var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient setCertificateIssuer"})
        @PUT(value="certificates/issuers/{issuer-name}")
        public Observable<Response<ResponseBody>> setCertificateIssuer(@Path(value="issuer-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CertificateIssuerSetParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient updateCertificateIssuer"})
        @PATCH(value="certificates/issuers/{issuer-name}")
        public Observable<Response<ResponseBody>> updateCertificateIssuer(@Path(value="issuer-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CertificateIssuerUpdateParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getCertificateIssuer"})
        @GET(value="certificates/issuers/{issuer-name}")
        public Observable<Response<ResponseBody>> getCertificateIssuer(@Path(value="issuer-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient deleteCertificateIssuer"})
        @HTTP(path="certificates/issuers/{issuer-name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCertificateIssuer(@Path(value="issuer-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient createCertificate"})
        @POST(value="certificates/{certificate-name}/create")
        public Observable<Response<ResponseBody>> createCertificate(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CertificateCreateParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient importCertificate"})
        @POST(value="certificates/{certificate-name}/import")
        public Observable<Response<ResponseBody>> importCertificate(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CertificateImportParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getCertificateVersions"})
        @GET(value="certificates/{certificate-name}/versions")
        public Observable<Response<ResponseBody>> getCertificateVersions(@Path(value="certificate-name") String var1, @Query(value="maxresults") Integer var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getCertificatePolicy"})
        @GET(value="certificates/{certificate-name}/policy")
        public Observable<Response<ResponseBody>> getCertificatePolicy(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient updateCertificatePolicy"})
        @PATCH(value="certificates/{certificate-name}/policy")
        public Observable<Response<ResponseBody>> updateCertificatePolicy(@Path(value="certificate-name") String var1, @Body CertificatePolicy var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient updateCertificate"})
        @PATCH(value="certificates/{certificate-name}/{certificate-version}")
        public Observable<Response<ResponseBody>> updateCertificate(@Path(value="certificate-name") String var1, @Path(value="certificate-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body CertificateUpdateParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getCertificate"})
        @GET(value="certificates/{certificate-name}/{certificate-version}")
        public Observable<Response<ResponseBody>> getCertificate(@Path(value="certificate-name") String var1, @Path(value="certificate-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient updateCertificateOperation"})
        @PATCH(value="certificates/{certificate-name}/pending")
        public Observable<Response<ResponseBody>> updateCertificateOperation(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CertificateOperationUpdateParameter var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getCertificateOperation"})
        @GET(value="certificates/{certificate-name}/pending")
        public Observable<Response<ResponseBody>> getCertificateOperation(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient deleteCertificateOperation"})
        @HTTP(path="certificates/{certificate-name}/pending", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCertificateOperation(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient mergeCertificate"})
        @POST(value="certificates/{certificate-name}/pending/merge")
        public Observable<Response<ResponseBody>> mergeCertificate(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CertificateMergeParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getKeyVersionsNext"})
        @GET
        public Observable<Response<ResponseBody>> getKeyVersionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getKeysNext"})
        @GET
        public Observable<Response<ResponseBody>> getKeysNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getSecretsNext"})
        @GET
        public Observable<Response<ResponseBody>> getSecretsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getSecretVersionsNext"})
        @GET
        public Observable<Response<ResponseBody>> getSecretVersionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getCertificatesNext"})
        @GET
        public Observable<Response<ResponseBody>> getCertificatesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getCertificateIssuersNext"})
        @GET
        public Observable<Response<ResponseBody>> getCertificateIssuersNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getCertificateVersionsNext"})
        @GET
        public Observable<Response<ResponseBody>> getCertificateVersionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "Accept: application/pkcs10", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClient getPendingCertificateSigningRequest"})
        @GET(value="certificates/{certificate-name}/pending")
        public Observable<Response<ResponseBody>> getPendingCertificateSigningRequest(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);
    }
}

