/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault;

import com.microsoft.azure.keyvault.ObjectIdentifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;

public final class IssuerIdentifier
extends ObjectIdentifier {
    public static boolean isIssuerIdentifier(String identifier) {
        URI baseUri;
        identifier = IssuerIdentifier.verifyNonEmpty(identifier, "identifier");
        try {
            baseUri = new URI(identifier);
        }
        catch (URISyntaxException e) {
            return false;
        }
        String[] segments = baseUri.getPath().split("/");
        return segments.length == 4 && segments[1] == "certificates" && segments[2] == "issuers";
    }

    public IssuerIdentifier(String vault, String name) {
        URI baseUri;
        vault = IssuerIdentifier.verifyNonEmpty(vault, "vault");
        name = IssuerIdentifier.verifyNonEmpty(name, "name");
        try {
            baseUri = new URI(vault);
        }
        catch (URISyntaxException e) {
            throw new InvalidParameterException(String.format("Invalid ObjectIdentifier: %s. Not a valid URI", vault));
        }
        this.name = name;
        this.version = null;
        this.vault = String.format("%s://%s", baseUri.getScheme(), this.getFullAuthority(baseUri));
        this.identifier = this.baseIdentifier = String.format("%s/%s/%s", this.vault, "certificates/issuers", this.name);
    }

    public IssuerIdentifier(String identifier) {
        URI baseUri;
        identifier = IssuerIdentifier.verifyNonEmpty(identifier, "identifier");
        try {
            baseUri = new URI(identifier);
        }
        catch (URISyntaxException e) {
            throw new InvalidParameterException(String.format("Invalid ObjectIdentifier: %s. Not a valid URI", identifier));
        }
        String[] segments = baseUri.getPath().split("/");
        if (segments.length != 4) {
            throw new InvalidParameterException(String.format("Invalid ObjectIdentifier: %s. Bad number of segments: %d", identifier, segments.length));
        }
        if (!segments[1].equals("certificates")) {
            throw new InvalidParameterException(String.format("Invalid ObjectIdentifier: %s. Segment [1] should be '%s', found '%s'", identifier, "certificates", segments[1]));
        }
        if (!segments[2].equals("issuers")) {
            throw new InvalidParameterException(String.format("Invalid ObjectIdentifier: %s. Segment [2] should be '%s', found '%s'", identifier, "issuers", segments[2]));
        }
        this.name = segments[3];
        this.version = "";
        this.vault = String.format("%s://%s", baseUri.getScheme(), this.getFullAuthority(baseUri));
        this.identifier = this.baseIdentifier = String.format("%s/%s/%s", this.vault, "certificates/issuers", this.name);
    }
}

