/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.requests;

import com.microsoft.azure.keyvault.models.Attributes;
import com.microsoft.azure.keyvault.models.KeyAttributes;
import com.microsoft.azure.keyvault.webkey.JsonWebKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public final class ImportKeyRequest {
    private final String vaultBaseUrl;
    private final String keyName;
    private final JsonWebKey key;
    private final boolean isHsm;
    private final KeyAttributes keyAttributes;
    private final Map<String, String> tags;

    private ImportKeyRequest(Builder builder) {
        this.vaultBaseUrl = builder.vaultBaseUrl;
        this.keyName = builder.keyName;
        this.isHsm = builder.isHsm;
        if (builder.key != null) {
            this.key = new JsonWebKey().withKty(builder.key.kty()).withN(builder.key.n()).withE(builder.key.e()).withD(builder.key.d()).withP(builder.key.p()).withQ(builder.key.q()).withDp(builder.key.dp()).withDq(builder.key.dq()).withQi(builder.key.qi()).withK(builder.key.k()).withT(builder.key.t());
            if (builder.key.keyOps() != null) {
                this.key.withKeyOps(new ArrayList(builder.key.keyOps()));
            }
        } else {
            this.key = null;
        }
        this.keyAttributes = builder.attributes != null ? (KeyAttributes)new KeyAttributes().withNotBefore(builder.attributes.notBefore()).withEnabled(builder.attributes.enabled()).withExpires(builder.attributes.expires()) : null;
        this.tags = builder.tags != null ? Collections.unmodifiableMap(builder.tags) : null;
    }

    public String vaultBaseUrl() {
        return this.vaultBaseUrl;
    }

    public String keyName() {
        return this.keyName;
    }

    public JsonWebKey key() {
        return this.key;
    }

    public boolean isHsm() {
        return this.isHsm;
    }

    public KeyAttributes keyAttributes() {
        return this.keyAttributes;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public static class Builder {
        private final String vaultBaseUrl;
        private final String keyName;
        private final JsonWebKey key;
        private boolean isHsm;
        private KeyAttributes attributes;
        private Map<String, String> tags;

        public Builder(String vaultBaseUrl, String keyName, JsonWebKey key) {
            this.vaultBaseUrl = vaultBaseUrl;
            this.keyName = keyName;
            this.key = key;
        }

        public Builder withHsm(boolean isHsm) {
            this.isHsm = isHsm;
            return this;
        }

        public Builder withAttributes(Attributes attributes) {
            this.attributes = (KeyAttributes)attributes;
            return this;
        }

        public Builder withTags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public ImportKeyRequest build() {
            return new ImportKeyRequest(this);
        }
    }
}

