/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.authentication;

import com.microsoft.azure.keyvault.authentication.BearerAuthenticationProvider;
import com.microsoft.azure.keyvault.authentication.BearerCredentialsProvider;
import com.microsoft.azure.keyvault.authentication.BearerCredentialsSupport;
import com.microsoft.windowsazure.credentials.CloudCredentials;
import java.util.Arrays;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.client.HttpClientBuilder;

public final class BearerAuthenticationSetup {
    private BearerAuthenticationSetup() {
    }

    public static void configureClientBuilder(HttpClientBuilder httpBuilder, CloudCredentials credentials) {
        if (!(credentials instanceof BearerCredentialsSupport)) {
            return;
        }
        BearerCredentialsSupport support = (BearerCredentialsSupport)credentials;
        BearerAuthenticationSetup.configureClientBuilder(httpBuilder, support);
    }

    public static void configureClientBuilder(HttpClientBuilder httpBuilder, BearerCredentialsSupport support) {
        RequestConfig.Builder configBuilder = RequestConfig.custom().setTargetPreferredAuthSchemes(Arrays.asList("bearer"));
        httpBuilder.setDefaultRequestConfig(configBuilder.build());
        RegistryBuilder schemeProviderBuilder = RegistryBuilder.create();
        schemeProviderBuilder.register("bearer", (Object)BearerAuthenticationProvider.INSTANCE);
        httpBuilder.setDefaultAuthSchemeRegistry((Lookup)schemeProviderBuilder.build());
        httpBuilder.setDefaultCredentialsProvider((CredentialsProvider)new BearerCredentialsProvider(support));
    }
}

