/**
 *
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.microsoft.azure.keyvault.models;

public final class MessagePropertyNames {

    public static final String ALG         = "alg";
    public static final String ATTRIBUTES  = "attributes";
    public static final String DIGEST      = "digest";
    public static final String HSM         = "hsm";
    public static final String KEY         = "key";
    public static final String KEY_OPS     = "key_ops";
    public static final String KEY_SIZE    = "key_size";
    public static final String KID         = "kid";
    public static final String KTY         = "kty";
    public static final String RESULT      = "result";
    public static final String SIGNATURE   = "signature";
    public static final String VALUE       = "value";
    public static final String ID          = "id";
    public static final String NEXTLINK    = "nextLink";
    public static final String TAGS        = "tags";
    public static final String CONTENTTYPE = "contentType";

    private MessagePropertyNames() {
        // not instantiable
    }

}