/**
 *
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

// Warning: This code was generated by a tool.
//
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.keyvault;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

import javax.inject.Inject;
import javax.inject.Named;

import org.apache.http.impl.client.HttpClientBuilder;

import com.microsoft.azure.keyvault.authentication.BearerAuthenticationSetup;
import com.microsoft.azure.keyvault.models.CreateKeyRequestMessage;
import com.microsoft.azure.keyvault.models.ImportKeyRequestMessage;
import com.microsoft.azure.keyvault.models.KeyAttributes;
import com.microsoft.azure.keyvault.models.KeyBundle;
import com.microsoft.azure.keyvault.models.KeyIdentifier;
import com.microsoft.azure.keyvault.models.KeyOperationRequest;
import com.microsoft.azure.keyvault.models.KeyOperationResult;
import com.microsoft.azure.keyvault.models.ListKeysResponseMessage;
import com.microsoft.azure.keyvault.models.ListSecretsResponseMessage;
import com.microsoft.azure.keyvault.models.RestoreKeyRequestMessage;
import com.microsoft.azure.keyvault.models.Secret;
import com.microsoft.azure.keyvault.models.SecretAttributes;
import com.microsoft.azure.keyvault.models.SecretIdentifier;
import com.microsoft.azure.keyvault.models.UpdateKeyRequestMessage;
import com.microsoft.azure.keyvault.models.VerifyRequestMessage;
import com.microsoft.windowsazure.core.ServiceClient;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.credentials.CloudCredentials;
import com.microsoft.windowsazure.management.configuration.ManagementConfiguration;

public class KeyVaultClientImpl implements KeyVaultClient {

    private final KeyVaultInternalClient internalClient;

    public KeyVaultClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        internalClient = new KeyVaultInternalClientImpl(httpBuilder, executorService);
    }

    @Inject
    public KeyVaultClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, @Named(ManagementConfiguration.SUBSCRIPTION_CLOUD_CREDENTIALS) CloudCredentials credentials) {
        BearerAuthenticationSetup.configureClientBuilder(httpBuilder, credentials);
        internalClient = new KeyVaultInternalClientImpl(httpBuilder, executorService, credentials);
    }

    private KeyVaultClientImpl(KeyVaultInternalClient internalClient) {
        this.internalClient = internalClient;
    }

    @Override
    public void close() throws IOException {
        internalClient.close();
    }

    @Override
    public KeyVaultClient withRequestFilterFirst(ServiceRequestFilter serviceRequestFilter) {
        KeyVaultInternalClient newClient = internalClient.withRequestFilterFirst(serviceRequestFilter);
        if (newClient != internalClient) {
            return new KeyVaultClientImpl(newClient);
        }
        return this;
    }

    @Override
    public KeyVaultClient withRequestFilterLast(ServiceRequestFilter serviceRequestFilter) {
        KeyVaultInternalClient newClient = internalClient.withRequestFilterLast(serviceRequestFilter);
        if (newClient != internalClient) {
            return new KeyVaultClientImpl(newClient);
        }
        return this;
    }

    @Override
    public KeyVaultClient withResponseFilterFirst(ServiceResponseFilter serviceResponseFilter) {
        KeyVaultInternalClient newClient = internalClient.withResponseFilterFirst(serviceResponseFilter);
        if (newClient != internalClient) {
            return new KeyVaultClientImpl(newClient);
        }
        return this;
    }

    @Override
    public KeyVaultClient withResponseFilterLast(ServiceResponseFilter serviceResponseFilter) {
        KeyVaultInternalClient newClient = internalClient.withResponseFilterLast(serviceResponseFilter);
        if (newClient != internalClient) {
            return new KeyVaultClientImpl(newClient);
        }
        return this;
    }

    @Override
    public String getApiVersion() {
        return internalClient.getApiVersion();
    }

    @Override
    public URI getBaseUri() {
        return internalClient.getBaseUri();
    }

    @Override
    public CloudCredentials getCredentials() {
        return internalClient.getCredentials();
    }

    @Override
    public void setCredentials(CloudCredentials credentialsValue) {
        internalClient.setCredentials(credentialsValue);
    }

    @Override
    public int getLongRunningOperationInitialTimeout() {
        return internalClient.getLongRunningOperationInitialTimeout();
    }

    @Override
    public void setLongRunningOperationInitialTimeout(int longRunningOperationInitialTimeoutValue) {
        internalClient.setLongRunningOperationInitialTimeout(longRunningOperationInitialTimeoutValue);
    }

    @Override
    public int getLongRunningOperationRetryTimeout() {
        return internalClient.getLongRunningOperationRetryTimeout();
    }

    @Override
    public void setLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeoutValue) {
        internalClient.setLongRunningOperationRetryTimeout(longRunningOperationRetryTimeoutValue);
    }

    @Override
    public ServiceClient<?> getServiceClient() {
        return (ServiceClient<?>) internalClient;
    }

    @Override
    public Future<KeyOperationResult> encryptAsync(String vault, String keyName, String keyVersion, String algorithm, byte[] plainText) {
        String keyIdentifier = createKeyIdentifier(vault, keyName, keyVersion);
        return encryptAsync(keyIdentifier, algorithm, plainText);
    }

    @Override
    public Future<KeyOperationResult> encryptAsync(String keyIdentifier, String algorithm, byte[] plainText) {
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = createKeyOpRequest(algorithm, plainText);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = getKeysOperations().encryptDataAsync(keyIdentifier, keyOpRequest);
        KeyOperationFuture result = new KeyOperationFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyOperationResult> decryptAsync(String keyIdentifier, String algorithm, byte[] cipherText) {
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = createKeyOpRequest(algorithm, cipherText);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = getKeysOperations().decryptDataAsync(keyIdentifier, keyOpRequest);
        KeyOperationFuture result = new KeyOperationFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyOperationResult> signAsync(String vault, String keyName, String keyVersion, String algorithm, byte[] digest) {
        String keyIdentifier = createKeyIdentifier(vault, keyName, keyVersion);
        return signAsync(keyIdentifier, algorithm, digest);
    }

    @Override
    public Future<KeyOperationResult> signAsync(String keyIdentifier, String algorithm, byte[] digest) {
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = createKeyOpRequest(algorithm, digest);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = getKeysOperations().signAsync(keyIdentifier, keyOpRequest);
        KeyOperationFuture result = new KeyOperationFuture(rawResult);
        return result;
    }

    @Override
    public Future<Boolean> verifyAsync(String keyIdentifier, String algorithm, byte[] digest, byte[] signature) {
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = createVerifyOpRequest(algorithm, digest, signature);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = getKeysOperations().verifyAsync(keyIdentifier, keyOpRequest);
        VerifyFuture result = new VerifyFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyOperationResult> wrapKeyAsync(String vault, String keyName, String keyVersion, String algorithm, byte[] key) {
        String keyIdentifier = createKeyIdentifier(vault, keyName, keyVersion);
        return wrapKeyAsync(keyIdentifier, algorithm, key);
    }

    @Override
    public Future<KeyOperationResult> wrapKeyAsync(String keyIdentifier, String algorithm, byte[] key) {
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = createKeyOpRequest(algorithm, key);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = getKeysOperations().wrapKeyAsync(keyIdentifier, keyOpRequest);
        KeyOperationFuture result = new KeyOperationFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyOperationResult> unwrapKeyAsync(String keyIdentifier, String algorithm, byte[] wrappedKey) {
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = createKeyOpRequest(algorithm, wrappedKey);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = getKeysOperations().unwrapKeyAsync(keyIdentifier, keyOpRequest);
        KeyOperationFuture result = new KeyOperationFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyBundle> createKeyAsync(String vault, String keyName, String keyType, Integer keySize, String[] keyOps, KeyAttributes keyAttributes, Map<String, String> tags) {
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = createCreateKeyRequest(keyType, keySize, keyOps, keyAttributes, tags);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = getKeysOperations().createAsync(vault, keyName, keyOpRequest);
        KeyBundleFuture result = new KeyBundleFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyBundle> getKeyAsync(String vault, String keyName, String keyVersion) {
        String keyIdentifier = createKeyIdentifier(vault, keyName, keyVersion);
        return getKeyAsync(keyIdentifier);
    }

    @Override
    public Future<KeyBundle> getKeyAsync(String keyIdentifier) {
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = getKeysOperations().getAsync(keyIdentifier);
        KeyBundleFuture result = new KeyBundleFuture(rawResult);
        return result;
    }

    @Override
    public Future<ListKeysResponseMessage> getKeysAsync(String vault, Integer maxresults) {
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = getKeysOperations().listAsync(vault, maxresults);
        ListKeysFuture result = new ListKeysFuture(rawResult);
        return result;
    }

    @Override
    public Future<ListKeysResponseMessage> getKeysNextAsync(String nextLink) {
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = getKeysOperations().listNextAsync(nextLink);
        ListKeysFuture result = new ListKeysFuture(rawResult);
        return result;
    }

    @Override
    public Future<ListKeysResponseMessage> getKeyVersionsAsync(String vault, String keyName, Integer maxresults) {
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = getKeysOperations().listVersionsAsync(vault, keyName, maxresults);
        ListKeysFuture result = new ListKeysFuture(rawResult);
        return result;
    }

    @Override
    public Future<ListKeysResponseMessage> getKeyVersionsNextAsync(String nextLink) {
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = getKeysOperations().listVersionsNextAsync(nextLink);
        ListKeysFuture result = new ListKeysFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyBundle> deleteKeyAsync(String vault, String keyName) {
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = getKeysOperations().deleteKeyAsync(vault, keyName);
        KeyBundleFuture result = new KeyBundleFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyBundle> updateKeyAsync(String vault, String keyName, String[] keyOps, KeyAttributes attributes, Map<String, String> tags) {
        String keyIdentifier = createKeyIdentifier(vault, keyName);
        return updateKeyAsync(keyIdentifier, keyOps, attributes, tags);
    }

    @Override
    public Future<KeyBundle> updateKeyAsync(String keyIdentifier, String[] keyOps, KeyAttributes attributes, Map<String, String> tags) {
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = createUpdateKeyRequest(keyOps, attributes, tags);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = getKeysOperations().updateAsync(keyIdentifier, keyOpRequest);
        KeyBundleFuture result = new KeyBundleFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyBundle> importKeyAsync(String vault, String keyName, KeyBundle keyBundle, Boolean importToHardware) {
        String keyIdentifier = createKeyIdentifier(vault, keyName);
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = createImportKeyRequest(keyBundle, importToHardware);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = getKeysOperations().importMethodAsync(keyIdentifier, keyOpRequest);
        KeyBundleFuture result = new KeyBundleFuture(rawResult);
        return result;
    }

    @Override
    public Future<byte[]> backupKeyAsync(String vault, String keyName) {
        String keyIdentifier = createKeyIdentifier(vault, keyName);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = getKeysOperations().backupAsync(keyIdentifier);
        BackupKeyResponseMessageFuture result = new BackupKeyResponseMessageFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyBundle> restoreKeyAsync(String vault, byte[] keyBundleBackup) {
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = createRestoreKeyRequest(keyBundleBackup);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = getKeysOperations().restoreAsync(vault, keyOpRequest);
        KeyBundleFuture result = new KeyBundleFuture(rawResult);
        return result;
    }

    @Override
    public Future<Secret> getSecretAsync(String vault, String secretName, String secretVersion) {
        String secretIdentifier = createSecretIdentifier(vault, secretName, secretVersion);
        return getSecretAsync(secretIdentifier);
    }

    @Override
    public Future<Secret> getSecretAsync(String secretIdentifier) {
        Future<SecretResponseMessageWithRawJsonContent> rawResult = getSecretsOperations().getAsync(secretIdentifier);
        SecretFuture result = new SecretFuture(rawResult);
        return result;
    }

    @Override
    public Future<Secret> setSecretAsync(String vault, String secretName, String value, String contentType, SecretAttributes secretAttributes, Map<String, String> tags) {
        String secretIdentifier = createSecretIdentifier(vault, secretName);
        SecretRequestMessageWithRawJsonContent secretOpRequest = createSetSecretRequest(value, contentType, secretAttributes, tags);
        Future<SecretResponseMessageWithRawJsonContent> rawResult = getSecretsOperations().setAsync(secretIdentifier, secretOpRequest);
        SecretFuture result = new SecretFuture(rawResult);
        return result;
    }

    @Override
    public Future<Secret> updateSecretAsync(String vault, String secretName, String contentType, SecretAttributes secretAttributes, Map<String, String> tags) {
        String secretIdentifier = createSecretIdentifier(vault, secretName);
        return updateSecretAsync(secretIdentifier, contentType, secretAttributes, tags);
    }

    @Override
    public Future<Secret> updateSecretAsync(String secretIdentifier, String contentType, SecretAttributes secretAttributes, Map<String, String> tags) {
        SecretRequestMessageWithRawJsonContent secretOpRequest = createUpdateSecretRequest(contentType, secretAttributes, tags);
        Future<SecretResponseMessageWithRawJsonContent> rawResult = getSecretsOperations().updateAsync(secretIdentifier, secretOpRequest);
        SecretFuture result = new SecretFuture(rawResult);
        return result;
    }

    @Override
    public Future<Secret> deleteSecretAsync(String vault, String secretName) {
        String secretIdentifier = createSecretIdentifier(vault, secretName);
        Future<SecretResponseMessageWithRawJsonContent> rawResult = getSecretsOperations().deleteAsync(secretIdentifier);
        SecretFuture result = new SecretFuture(rawResult);
        return result;
    }

    @Override
    public Future<ListSecretsResponseMessage> getSecretsAsync(String vault, Integer maxresults) {
        Future<SecretResponseMessageWithRawJsonContent> rawResult = getSecretsOperations().listAsync(vault, maxresults);
        ListSecretsFuture result = new ListSecretsFuture(rawResult);
        return result;
    }

    @Override
    public Future<ListSecretsResponseMessage> getSecretsNextAsync(String nextLink) {
        Future<SecretResponseMessageWithRawJsonContent> rawResult = getSecretsOperations().listNextAsync(nextLink);
        ListSecretsFuture result = new ListSecretsFuture(rawResult);
        return result;
    }

    @Override
    public Future<ListSecretsResponseMessage> getSecretVersionsAsync(String vault, String secretName, Integer maxresults) {
        Future<SecretResponseMessageWithRawJsonContent> rawResult = getSecretsOperations().listVersionsAsync(vault, secretName, maxresults);
        ListSecretsFuture result = new ListSecretsFuture(rawResult);
        return result;
    }

    @Override
    public Future<ListSecretsResponseMessage> getSecretVersionsNextAsync(String nextLink) {
        Future<SecretResponseMessageWithRawJsonContent> rawResult = getSecretsOperations().listVersionsNextAsync(nextLink);
        ListSecretsFuture result = new ListSecretsFuture(rawResult);
        return result;
    }

    private KeyOperations getKeysOperations() {
        return internalClient.getKeysOperations();
    }

    private SecretOperations getSecretsOperations() {
        return internalClient.getSecretsOperations();
    }

    private static String createKeyIdentifier(String vault, String keyName) {
        return new KeyIdentifier(vault, keyName).getIdentifier();
    }

    private static String createKeyIdentifier(String vault, String keyName, String keyVersion) {
        return new KeyIdentifier(vault, keyName, keyVersion).getIdentifier();
    }

    private static String createSecretIdentifier(String vault, String secretName) {
        return new SecretIdentifier(vault, secretName).getIdentifier();
    }

    private static String createSecretIdentifier(String vault, String secretName, String secretVersion) {
        return new SecretIdentifier(vault, secretName, secretVersion).getIdentifier();
    }

    private static KeyOpRequestMessageWithRawJsonContent createKeyOpRequest(String algorithm, byte[] data) {
        KeyOperationRequest request = new KeyOperationRequest();
        request.setAlg(algorithm);
        request.setValue(data);
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = JsonSupport.serializeKeyOpRequest(request);
        return keyOpRequest;
    }

    private static KeyOpRequestMessageWithRawJsonContent createVerifyOpRequest(String algorithm, byte[] digest, byte[] signature) {
        VerifyRequestMessage request = new VerifyRequestMessage();
        request.setAlg(algorithm);
        request.setDigest(digest);
        request.setValue(signature);
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = JsonSupport.serializeKeyOpRequest(request);
        return keyOpRequest;
    }

    private static KeyOpRequestMessageWithRawJsonContent createCreateKeyRequest(String keyType, Integer keySize, String[] keyOps, KeyAttributes keyAttributes, Map<String, String> tags) {
        CreateKeyRequestMessage request = new CreateKeyRequestMessage();
        request.setKty(keyType);
        request.setKeySize(keySize);
        request.setKeyOps(keyOps);
        request.setAttributes(keyAttributes);
        request.setTags(tags);
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = JsonSupport.serializeKeyOpRequest(request);
        return keyOpRequest;
    }

    private static KeyOpRequestMessageWithRawJsonContent createUpdateKeyRequest(String[] keyOps, KeyAttributes attributes, Map<String, String> tags) {
        UpdateKeyRequestMessage request = new UpdateKeyRequestMessage();
        request.setKeyOps(keyOps);
        request.setAttributes(attributes);
        request.setTags(tags);
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = JsonSupport.serializeKeyOpRequest(request);
        return keyOpRequest;
    }

    private static KeyOpRequestMessageWithRawJsonContent createImportKeyRequest(KeyBundle keyBundle, Boolean importToHardware) {
        ImportKeyRequestMessage request = new ImportKeyRequestMessage();
        request.setKey(keyBundle.getKey());
        request.setAttributes(keyBundle.getAttributes());
        request.setTags(keyBundle.getTags());
        request.setHsm(importToHardware);
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = JsonSupport.serializeKeyOpRequest(request);
        return keyOpRequest;
    }

    private static KeyOpRequestMessageWithRawJsonContent createRestoreKeyRequest(byte[] keyBundleBackup) {
        RestoreKeyRequestMessage request = new RestoreKeyRequestMessage();
        request.setValue(keyBundleBackup);
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = JsonSupport.serializeKeyOpRequest(request);
        return keyOpRequest;
    }

    private static SecretRequestMessageWithRawJsonContent createSetSecretRequest(String value, String contentType, SecretAttributes secretAttributes, Map<String, String> tags) {
        Secret request = new Secret();
        request.setValue(value);
        request.setContentType(contentType);
        request.setAttributes(secretAttributes);
        request.setTags(tags);
        SecretRequestMessageWithRawJsonContent secretOpRequest = JsonSupport.serializeSecretOpRequest(request);
        return secretOpRequest;
    }

    private static SecretRequestMessageWithRawJsonContent createUpdateSecretRequest(String contentType, SecretAttributes secretAttributes, Map<String, String> tags) {
        Secret request = new Secret();
        request.setContentType(contentType);
        request.setAttributes(secretAttributes);
        request.setTags(tags);
        SecretRequestMessageWithRawJsonContent secretOpRequest = JsonSupport.serializeSecretOpRequest(request);
        return secretOpRequest;
    }

}
