/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.cryptography;

import java.util.Arrays;

public final class ByteExtensions {
    public static byte[] or(byte[] self, byte[] other) {
        return ByteExtensions.or(self, other, 0);
    }

    public static byte[] or(byte[] self, byte[] other, int offset) {
        if (self == null) {
            throw new IllegalArgumentException("self");
        }
        if (other == null) {
            throw new IllegalArgumentException("other");
        }
        if (self.length > other.length - offset) {
            throw new IllegalArgumentException("self and other lengths do not match");
        }
        byte[] result = new byte[self.length];
        for (int i = 0; i < self.length; ++i) {
            result[i] = (byte)(self[i] | other[offset + i]);
        }
        return result;
    }

    public static byte[] xor(byte[] self, byte[] other) {
        return ByteExtensions.xor(self, other, 0);
    }

    static byte[] xor(byte[] self, byte[] other, int offset) {
        if (self == null) {
            throw new IllegalArgumentException("self");
        }
        if (other == null) {
            throw new IllegalArgumentException("other");
        }
        if (self.length > other.length - offset) {
            throw new IllegalArgumentException("self and other lengths do not match");
        }
        byte[] result = new byte[self.length];
        for (int i = 0; i < self.length; ++i) {
            result[i] = (byte)(self[i] ^ other[offset + i]);
        }
        return result;
    }

    public static void zero(byte[] self) {
        if (self != null) {
            Arrays.fill(self, (byte)0);
        }
    }

    public static boolean sequenceEqualConstantTime(byte[] self, byte[] other) {
        if (self == null) {
            throw new IllegalArgumentException("self");
        }
        if (other == null) {
            throw new IllegalArgumentException("other");
        }
        long difference = (long)self.length & 0xFFFFFFFFL ^ (long)other.length & 0xFFFFFFFFL;
        for (int i = 0; i < self.length && i < other.length; ++i) {
            difference |= (long)(self[i] ^ other[i]) & 0xFFFFFFFFL;
        }
        return difference == 0L;
    }

    public static byte[] clone(byte[] source) {
        if (source == null) {
            return null;
        }
        byte[] copy = new byte[source.length];
        System.arraycopy(source, 0, copy, 0, source.length);
        return copy;
    }
}

