/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.auth.AzureTokenWrapper;
import com.microsoft.azure.common.Utils;
import com.microsoft.azure.common.applicationinsights.ApplicationInsightsManager;
import com.microsoft.azure.common.appservice.DeployTargetType;
import com.microsoft.azure.common.appservice.DeploymentType;
import com.microsoft.azure.common.appservice.OperatingSystemEnum;
import com.microsoft.azure.common.deploytarget.DeployTarget;
import com.microsoft.azure.common.docker.IDockerCredentialProvider;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.function.configurations.RuntimeConfiguration;
import com.microsoft.azure.common.function.handlers.artifact.DockerArtifactHandler;
import com.microsoft.azure.common.function.handlers.artifact.MSDeployArtifactHandlerImpl;
import com.microsoft.azure.common.function.handlers.artifact.RunFromBlobArtifactHandlerImpl;
import com.microsoft.azure.common.function.handlers.artifact.RunFromZipArtifactHandlerImpl;
import com.microsoft.azure.common.function.handlers.runtime.DockerFunctionRuntimeHandler;
import com.microsoft.azure.common.function.handlers.runtime.FunctionRuntimeHandler;
import com.microsoft.azure.common.function.handlers.runtime.LinuxFunctionRuntimeHandler;
import com.microsoft.azure.common.function.handlers.runtime.WindowsFunctionRuntimeHandler;
import com.microsoft.azure.common.handlers.ArtifactHandler;
import com.microsoft.azure.common.handlers.artifact.FTPArtifactHandlerImpl;
import com.microsoft.azure.common.handlers.artifact.ZIPArtifactHandlerImpl;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.common.utils.AppServiceUtils;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ApplicationInsightsComponent;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.maven.MavenDockerCredentialProvider;
import com.microsoft.azure.maven.ProjectUtils;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractFunctionMojo {
    private static final String DEPLOY_START = "Trying to deploy the function app...";
    private static final String DEPLOY_FINISH = "Successfully deployed the function app at https://%s.azurewebsites.net.";
    private static final String FUNCTION_APP_CREATE_START = "The specified function app does not exist. Creating a new function app...";
    private static final String FUNCTION_APP_CREATED = "Successfully created the function app: %s.";
    private static final String FUNCTION_APP_UPDATE = "Updating the specified function app...";
    private static final String FUNCTION_APP_UPDATE_DONE = "Successfully updated the function app: %s.";
    private static final String DEPLOYMENT_TYPE_KEY = "deploymentType";
    private static final String UNKNOWN_DEPLOYMENT_TYPE = "The value of <deploymentType> is unknown, supported values are: ftp, zip, msdeploy, run_from_blob and run_from_zip.";
    private static final String APPINSIGHTS_INSTRUMENTATION_KEY = "APPINSIGHTS_INSTRUMENTATIONKEY";
    private static final String APPLICATION_INSIGHTS_NOT_SUPPORTED = "Application Insights features are not supported with current authentication, skip related steps.";
    private static final String APPLICATION_INSIGHTS_CONFIGURATION_CONFLICT = "Contradictory configurations for application insights, specify 'appInsightsKey' or 'appInsightsInstance' if you want to enable it, and specify 'disableAppInsights=true' if you want to disable it.";
    private static final String FAILED_TO_GET_APPLICATION_INSIGHTS = "The application insights %s cannot be found, will create it in resource group %s.";
    private static final String SKIP_CREATING_APPLICATION_INSIGHTS = "Skip creating application insights";
    private static final String APPLICATION_INSIGHTS_CREATE_START = "Creating application insights...";
    private static final String APPLICATION_INSIGHTS_CREATED = "Successfully created the application insights %s for this Function App. You can visit https://portal.azure.com/#resource%s/overview to view your Application Insights component.";
    private static final String APPLICATION_INSIGHTS_CREATE_FAILED = "Unable to create the Application Insights for the Function App due to error %s. Please use the Azure Portal to manually create and configure the Application Insights if needed.";
    private static final String INSTRUMENTATION_KEY_IS_NOT_VALID = "Instrumentation key is not valid, please update the application insights configuration";
    private static final String FAILED_TO_GET_FUNCTION_APP_PRICING_TIER = "Failed to get function app pricing tier";

    protected void doExecute() throws AzureExecutionException {
        try {
            this.createOrUpdateFunctionApp();
            FunctionApp app = this.getFunctionApp();
            if (app == null) {
                throw new AzureExecutionException(String.format("Failed to get the function app with name: %s", this.getAppName()));
            }
            DeployTarget deployTarget = new DeployTarget((WebAppBase)app, DeployTargetType.FUNCTION);
            Log.info((String)DEPLOY_START);
            this.getArtifactHandler().publish(deployTarget);
            Log.info((String)String.format(DEPLOY_FINISH, this.getAppName()));
        }
        catch (AzureAuthFailureException e) {
            throw new AzureExecutionException("Cannot auth to azure", (Throwable)e);
        }
    }

    protected void createOrUpdateFunctionApp() throws AzureAuthFailureException, AzureExecutionException {
        FunctionApp app = this.getFunctionApp();
        if (app == null) {
            this.createFunctionApp();
        } else {
            this.updateFunctionApp(app);
        }
    }

    protected void createFunctionApp() throws AzureAuthFailureException, AzureExecutionException {
        Log.info((String)FUNCTION_APP_CREATE_START);
        this.validateApplicationInsightsConfiguration();
        Map appSettings = this.getAppSettingsWithDefaultValue();
        this.bindApplicationInsights(appSettings, true);
        FunctionRuntimeHandler runtimeHandler = this.getFunctionRuntimeHandler();
        FunctionApp.DefinitionStages.WithCreate withCreate = runtimeHandler.defineAppWithRuntime();
        withCreate.withAppSettings(appSettings).create();
        Log.info((String)String.format(FUNCTION_APP_CREATED, this.getAppName()));
    }

    protected void updateFunctionApp(FunctionApp app) throws AzureAuthFailureException, AzureExecutionException {
        Log.info((String)FUNCTION_APP_UPDATE);
        FunctionRuntimeHandler runtimeHandler = this.getFunctionRuntimeHandler();
        runtimeHandler.updateAppServicePlan((WebAppBase)app);
        FunctionApp.Update update = runtimeHandler.updateAppRuntime(app);
        this.validateApplicationInsightsConfiguration();
        Map appSettings = this.getAppSettingsWithDefaultValue();
        if (this.isDisableAppInsights()) {
            update.withoutAppSetting(APPINSIGHTS_INSTRUMENTATION_KEY);
        } else {
            this.bindApplicationInsights(appSettings, false);
        }
        this.configureAppSettings(arg_0 -> ((FunctionApp.Update)update).withAppSettings(arg_0), appSettings);
        update.apply();
        Log.info((String)String.format(FUNCTION_APP_UPDATE_DONE, this.getAppName()));
    }

    protected void configureAppSettings(Consumer<Map> withAppSettings, Map appSettings) {
        if (appSettings != null && !appSettings.isEmpty()) {
            withAppSettings.accept(appSettings);
        }
    }

    private void bindApplicationInsights(Map appSettings, boolean isCreation) throws AzureExecutionException, AzureAuthFailureException {
        if (appSettings.containsKey(APPINSIGHTS_INSTRUMENTATION_KEY)) {
            return;
        }
        String instrumentationKey = null;
        if (StringUtils.isNotEmpty((CharSequence)this.getAppInsightsKey())) {
            instrumentationKey = this.getAppInsightsKey();
            if (!Utils.isGUID((String)instrumentationKey)) {
                throw new AzureExecutionException(INSTRUMENTATION_KEY_IS_NOT_VALID);
            }
        } else {
            ApplicationInsightsComponent applicationInsightsComponent = this.getOrCreateApplicationInsights(isCreation);
            String string = instrumentationKey = applicationInsightsComponent == null ? null : applicationInsightsComponent.instrumentationKey();
        }
        if (StringUtils.isNotEmpty((CharSequence)instrumentationKey)) {
            appSettings.put(APPINSIGHTS_INSTRUMENTATION_KEY, instrumentationKey);
        }
    }

    private void validateApplicationInsightsConfiguration() throws AzureExecutionException {
        if (this.isDisableAppInsights() && (StringUtils.isNotEmpty((CharSequence)this.getAppInsightsKey()) || StringUtils.isNotEmpty((CharSequence)this.getAppInsightsInstance()))) {
            throw new AzureExecutionException(APPLICATION_INSIGHTS_CONFIGURATION_CONFLICT);
        }
    }

    private ApplicationInsightsComponent getOrCreateApplicationInsights(boolean enableCreation) throws AzureAuthFailureException {
        AzureTokenWrapper credentials = this.getAzureTokenWrapper();
        if (credentials == null) {
            Log.warn((String)APPLICATION_INSIGHTS_NOT_SUPPORTED);
            return null;
        }
        String subscriptionId = this.getAzureClient().subscriptionId();
        ApplicationInsightsManager applicationInsightsManager = new ApplicationInsightsManager((AzureTokenCredentials)credentials, subscriptionId, this.getUserAgent());
        return StringUtils.isNotEmpty((CharSequence)this.getAppInsightsInstance()) ? this.getApplicationInsights(applicationInsightsManager, this.getAppInsightsInstance()) : (enableCreation ? this.createApplicationInsights(applicationInsightsManager, this.getAppName()) : null);
    }

    private ApplicationInsightsComponent getApplicationInsights(ApplicationInsightsManager applicationInsightsManager, String appInsightsInstance) {
        ApplicationInsightsComponent resource = applicationInsightsManager.getApplicationInsightsInstance(this.getResourceGroup(), appInsightsInstance);
        if (resource == null) {
            Log.warn((String)String.format(FAILED_TO_GET_APPLICATION_INSIGHTS, appInsightsInstance, this.getResourceGroup()));
            return this.createApplicationInsights(applicationInsightsManager, appInsightsInstance);
        }
        return resource;
    }

    private ApplicationInsightsComponent createApplicationInsights(ApplicationInsightsManager applicationInsightsManager, String name) {
        if (this.isDisableAppInsights()) {
            Log.info((String)SKIP_CREATING_APPLICATION_INSIGHTS);
            return null;
        }
        try {
            Log.info((String)APPLICATION_INSIGHTS_CREATE_START);
            ApplicationInsightsComponent resource = applicationInsightsManager.createApplicationInsights(this.getResourceGroup(), name, this.getRegion());
            Log.info((String)String.format(APPLICATION_INSIGHTS_CREATED, resource.name(), resource.id()));
            return resource;
        }
        catch (Exception e) {
            Log.warn((String)String.format(APPLICATION_INSIGHTS_CREATE_FAILED, e.getMessage()));
            return null;
        }
    }

    protected FunctionRuntimeHandler getFunctionRuntimeHandler() throws AzureAuthFailureException, AzureExecutionException {
        WindowsFunctionRuntimeHandler.Builder builder;
        OperatingSystemEnum os = this.getOsEnum();
        switch (os) {
            case Windows: {
                builder = new WindowsFunctionRuntimeHandler.Builder();
                break;
            }
            case Linux: {
                builder = new LinuxFunctionRuntimeHandler.Builder();
                break;
            }
            case Docker: {
                RuntimeConfiguration runtime = this.getRuntime();
                builder = (FunctionRuntimeHandler.Builder)((DockerFunctionRuntimeHandler.Builder)((DockerFunctionRuntimeHandler.Builder)new DockerFunctionRuntimeHandler.Builder().image(runtime.getImage())).dockerCredentialProvider((IDockerCredentialProvider)MavenDockerCredentialProvider.fromMavenSettings((Settings)this.getSettings(), (String)runtime.getServerId()))).registryUrl(runtime.getRegistryUrl());
                break;
            }
            default: {
                throw new AzureExecutionException(String.format("Unsupported runtime %s", os));
            }
        }
        return ((FunctionRuntimeHandler.Builder)((FunctionRuntimeHandler.Builder)((FunctionRuntimeHandler.Builder)((FunctionRuntimeHandler.Builder)((FunctionRuntimeHandler.Builder)((FunctionRuntimeHandler.Builder)((FunctionRuntimeHandler.Builder)builder.appName(this.getAppName())).resourceGroup(this.getResourceGroup())).runtime(this.getRuntime()).region(Region.fromName((String)this.region))).pricingTier(this.getPricingTier())).servicePlanName(this.getAppServicePlanName())).servicePlanResourceGroup(this.getAppServicePlanResourceGroup())).functionExtensionVersion(this.getFunctionExtensionVersion()).azure(this.getAzureClient())).build();
    }

    protected OperatingSystemEnum getOsEnum() throws AzureExecutionException {
        String os = this.runtime == null ? null : this.runtime.getOs();
        return StringUtils.isEmpty((CharSequence)os) ? RuntimeConfiguration.DEFAULT_OS : Utils.parseOperationSystem((String)os);
    }

    protected ArtifactHandler getArtifactHandler() throws AzureExecutionException {
        FTPArtifactHandlerImpl.Builder builder;
        DeploymentType deploymentType = this.getDeploymentType();
        this.getTelemetryProxy().addDefaultProperty(DEPLOYMENT_TYPE_KEY, deploymentType.toString());
        switch (deploymentType) {
            case MSDEPLOY: {
                builder = new MSDeployArtifactHandlerImpl.Builder().functionAppName(this.getAppName());
                break;
            }
            case FTP: {
                builder = new FTPArtifactHandlerImpl.Builder();
                break;
            }
            case ZIP: {
                builder = new ZIPArtifactHandlerImpl.Builder();
                break;
            }
            case RUN_FROM_BLOB: {
                builder = new RunFromBlobArtifactHandlerImpl.Builder();
                break;
            }
            case DOCKER: {
                builder = new DockerArtifactHandler.Builder();
                break;
            }
            case EMPTY: 
            case RUN_FROM_ZIP: {
                builder = new RunFromZipArtifactHandlerImpl.Builder();
                break;
            }
            default: {
                throw new AzureExecutionException(UNKNOWN_DEPLOYMENT_TYPE);
            }
        }
        return builder.project(ProjectUtils.convertCommonProject((MavenProject)this.getProject())).stagingDirectoryPath(this.getDeploymentStagingDirectoryPath()).buildDirectoryAbsolutePath(this.getBuildDirectoryAbsolutePath()).build();
    }

    public DeploymentType getDeploymentType() throws AzureExecutionException {
        DeploymentType deploymentType = super.getDeploymentType();
        return deploymentType == DeploymentType.EMPTY ? this.getDeploymentTypeByRuntime() : deploymentType;
    }

    public DeploymentType getDeploymentTypeByRuntime() throws AzureExecutionException {
        OperatingSystemEnum operatingSystemEnum = this.getOsEnum();
        switch (operatingSystemEnum) {
            case Docker: {
                return DeploymentType.DOCKER;
            }
            case Linux: {
                return this.isDedicatedPricingTier() ? DeploymentType.RUN_FROM_ZIP : DeploymentType.RUN_FROM_BLOB;
            }
        }
        return DeploymentType.RUN_FROM_ZIP;
    }

    protected boolean isDedicatedPricingTier() throws AzureExecutionException {
        try {
            FunctionApp functionApp = this.getFunctionApp();
            AppServicePlan appServicePlan = AppServiceUtils.getAppServicePlanByAppService((WebAppBase)functionApp);
            PricingTier functionPricingTier = appServicePlan.pricingTier();
            return PricingTier.getAll().stream().anyMatch(pricingTier -> pricingTier.equals((Object)functionPricingTier));
        }
        catch (AzureAuthFailureException e) {
            throw new AzureExecutionException(FAILED_TO_GET_FUNCTION_APP_PRICING_TIER, (Throwable)e);
        }
    }
}

