/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function.handlers;

import com.microsoft.azure.management.appservice.AppSetting;
import com.microsoft.azure.maven.artifacthandler.ArtifactHandlerBase;
import com.microsoft.azure.maven.deploytarget.DeployTarget;
import com.microsoft.azure.maven.function.AzureStorageHelper;
import com.microsoft.azure.storage.CloudStorageAccount;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import org.codehaus.plexus.util.StringUtils;
import org.zeroturnaround.zip.ZipUtil;

public class MSDeployArtifactHandlerImpl
extends ArtifactHandlerBase {
    public static final String DEPLOYMENT_PACKAGE_CONTAINER = "java-functions-deployment-packages";
    public static final String ZIP_EXT = ".zip";
    public static final String CREATE_ZIP_START = "Step 1 of 4: Creating ZIP file...";
    public static final String CREATE_ZIP_DONE = "Successfully saved ZIP file at ";
    public static final String STAGE_DIR_NOT_FOUND = "Azure Functions stage directory not found. Please run 'mvn package azure-functions:package' first.";
    public static final String LOCAL_SETTINGS_FILE = "local.settings.json";
    public static final String REMOVE_LOCAL_SETTINGS = "Remove local.settings.json from ZIP package.";
    public static final String INTERNAL_STORAGE_KEY = "AzureWebJobsStorage";
    public static final String INTERNAL_STORAGE_NOT_FOUND = "Application setting 'AzureWebJobsStorage' not found.";
    public static final String INTERNAL_STORAGE_CONNECTION_STRING = "Azure Function App's Storage Connection String: ";
    public static final String UPLOAD_PACKAGE_START = "Step 2 of 4: Uploading ZIP file to Azure Storage...";
    public static final String UPLOAD_PACKAGE_DONE = "Successfully uploaded ZIP file to ";
    public static final String DEPLOY_PACKAGE_START = "Step 3 of 4: Deploying Azure Function App with package...";
    public static final String DEPLOY_PACKAGE_DONE = "Successfully deployed Azure Function App.";
    public static final String DELETE_PACKAGE_START = "Step 4 of 4: Deleting deployment package from Azure Storage...";
    public static final String DELETE_PACKAGE_DONE = "Successfully deleted deployment package ";
    public static final String DELETE_PACKAGE_FAIL = "Failed to delete deployment package ";
    protected final String functionAppName;

    private MSDeployArtifactHandlerImpl(@Nonnull Builder builder) {
        super((ArtifactHandlerBase.Builder)builder);
        this.functionAppName = builder.functionAppName;
    }

    public void publish(DeployTarget target) throws Exception {
        File zipPackage = this.createZipPackage();
        CloudStorageAccount storageAccount = this.getCloudStorageAccount(target);
        String blobName = this.getBlobName();
        String packageUri = this.uploadPackageToAzureStorage(zipPackage, storageAccount, blobName);
        this.deployWithPackageUri(target, packageUri, () -> this.deletePackageFromAzureStorage(storageAccount, blobName));
    }

    protected void logInfo(String message) {
        if (this.log != null) {
            this.log.info((CharSequence)message);
        }
    }

    protected void logDebug(String message) {
        if (this.log != null) {
            this.log.debug((CharSequence)message);
        }
    }

    protected void logError(String message) {
        if (this.log != null) {
            this.log.error((CharSequence)message);
        }
    }

    protected File createZipPackage() throws Exception {
        this.logInfo("");
        this.logInfo(CREATE_ZIP_START);
        File stageDirectory = new File(this.stagingDirectoryPath);
        File zipPackage = new File(this.stagingDirectoryPath.concat(ZIP_EXT));
        if (!stageDirectory.exists()) {
            this.logError(STAGE_DIR_NOT_FOUND);
            throw new Exception(STAGE_DIR_NOT_FOUND);
        }
        ZipUtil.pack((File)stageDirectory, (File)zipPackage);
        this.logDebug(REMOVE_LOCAL_SETTINGS);
        ZipUtil.removeEntry((File)zipPackage, (String)LOCAL_SETTINGS_FILE);
        this.logInfo(CREATE_ZIP_DONE + this.stagingDirectoryPath.concat(ZIP_EXT));
        return zipPackage;
    }

    protected CloudStorageAccount getCloudStorageAccount(DeployTarget target) throws Exception {
        String value;
        AppSetting setting;
        Map settingsMap = target.getAppSettings();
        if (settingsMap != null && (setting = (AppSetting)settingsMap.get(INTERNAL_STORAGE_KEY)) != null && StringUtils.isNotEmpty((String)(value = setting.value()))) {
            this.logDebug(INTERNAL_STORAGE_CONNECTION_STRING + value);
            return CloudStorageAccount.parse((String)value);
        }
        this.logError(INTERNAL_STORAGE_NOT_FOUND);
        throw new Exception(INTERNAL_STORAGE_NOT_FOUND);
    }

    protected String getBlobName() {
        return this.functionAppName.concat(new SimpleDateFormat(".yyyyMMddHHmmssSSS").format(new Date())).concat(ZIP_EXT);
    }

    protected String uploadPackageToAzureStorage(File zipPackage, CloudStorageAccount storageAccount, String blobName) throws Exception {
        this.logInfo(UPLOAD_PACKAGE_START);
        String packageUri = AzureStorageHelper.uploadFileAsBlob(zipPackage, storageAccount, DEPLOYMENT_PACKAGE_CONTAINER, blobName);
        this.logInfo(UPLOAD_PACKAGE_DONE + packageUri);
        return packageUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployWithPackageUri(DeployTarget target, String packageUri, Runnable onDeployFinish) {
        try {
            this.logInfo(DEPLOY_PACKAGE_START);
            target.msDeploy(packageUri, false);
            this.logInfo(DEPLOY_PACKAGE_DONE);
        }
        finally {
            onDeployFinish.run();
        }
    }

    protected void deletePackageFromAzureStorage(CloudStorageAccount storageAccount, String blobName) {
        try {
            this.logInfo(DELETE_PACKAGE_START);
            AzureStorageHelper.deleteBlob(storageAccount, DEPLOYMENT_PACKAGE_CONTAINER, blobName);
            this.logInfo(DELETE_PACKAGE_DONE + blobName);
        }
        catch (Exception e) {
            this.logError(DELETE_PACKAGE_FAIL + blobName);
        }
    }

    public static class Builder
    extends ArtifactHandlerBase.Builder<Builder> {
        private String functionAppName;

        protected Builder self() {
            return this;
        }

        public MSDeployArtifactHandlerImpl build() {
            return new MSDeployArtifactHandlerImpl(this);
        }

        public Builder functionAppName(String value) {
            this.functionAppName = value;
            return this.self();
        }
    }
}

