/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.microsoft.azure.maven.Utils;
import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import com.microsoft.azure.maven.function.bindings.BindingEnum;
import com.microsoft.azure.maven.function.configurations.FunctionConfiguration;
import com.microsoft.azure.maven.function.handlers.AnnotationHandler;
import com.microsoft.azure.maven.function.handlers.AnnotationHandlerImpl;
import com.microsoft.azure.maven.function.handlers.CommandHandler;
import com.microsoft.azure.maven.function.handlers.CommandHandlerImpl;
import com.microsoft.azure.maven.function.handlers.FunctionCoreToolsHandler;
import com.microsoft.azure.maven.function.handlers.FunctionCoreToolsHandlerImpl;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class PackageMojo
extends AbstractFunctionMojo {
    public static final String SEARCH_FUNCTIONS = "Step 1 of 7: Searching for Azure Functions entry points";
    public static final String FOUND_FUNCTIONS = " Azure Functions entry point(s) found.";
    public static final String NO_FUNCTIONS = "Azure Functions entry point not found, plugin will exit.";
    public static final String GENERATE_CONFIG = "Step 2 of 7: Generating Azure Functions configurations";
    public static final String GENERATE_SKIP = "No Azure Functions found. Skip configuration generation.";
    public static final String GENERATE_DONE = "Generation done.";
    public static final String VALIDATE_CONFIG = "Step 3 of 7: Validating generated configurations";
    public static final String VALIDATE_SKIP = "No configurations found. Skip validation.";
    public static final String VALIDATE_DONE = "Validation done.";
    public static final String SAVE_HOST_JSON = "Step 4 of 7: Saving empty host.json";
    public static final String SAVE_FUNCTION_JSONS = "Step 5 of 7: Saving configurations to function.json";
    public static final String SAVE_SKIP = "No configurations found. Skip save.";
    public static final String SAVE_FUNCTION_JSON = "Starting processing function: ";
    public static final String SAVE_SUCCESS = "Successfully saved to ";
    public static final String COPY_JARS = "Step 6 of 7: Copying JARs to staging directory";
    public static final String COPY_SUCCESS = "Copied successfully.";
    public static final String INSTALL_EXTENSIONS = "Step 7 of 7: Installing function extensions if needed";
    public static final String SKIP_INSTALL_EXTENSIONS = "Skip install Function extension for HTTP Trigger Functions";
    public static final String INSTALL_EXTENSIONS_FINISH = "Function extension installation done.";
    public static final String BUILD_SUCCESS = "Successfully built Azure Functions.";
    public static final String FUNCTION_JSON = "function.json";
    public static final String HOST_JSON = "host.json";
    private static final BindingEnum[] FUNCTION_WITHOUT_FUNCTION_EXTENSION = new BindingEnum[]{BindingEnum.HttpOutput, BindingEnum.HttpTrigger};

    protected void doExecute() throws Exception {
        AnnotationHandler annotationHandler = this.getAnnotationHandler();
        Set<Method> methods = this.findAnnotatedMethods(annotationHandler);
        if (methods.size() == 0) {
            this.info(NO_FUNCTIONS);
            return;
        }
        Map<String, FunctionConfiguration> configMap = this.getFunctionConfigurations(annotationHandler, methods);
        this.validateFunctionConfigurations(configMap);
        ObjectWriter objectWriter = this.getObjectWriter();
        this.writeEmptyHostJsonFile(objectWriter);
        this.writeFunctionJsonFiles(objectWriter, configMap);
        this.copyJarsToStageDirectory();
        CommandHandlerImpl commandHandler = new CommandHandlerImpl(this.getLog());
        FunctionCoreToolsHandler functionCoreToolsHandler = this.getFunctionCoreToolsHandler(commandHandler);
        Set<BindingEnum> bindingClasses = this.getFunctionBindingEnums(configMap);
        this.installExtension(functionCoreToolsHandler, bindingClasses);
        this.info(BUILD_SUCCESS);
    }

    protected AnnotationHandler getAnnotationHandler() {
        return new AnnotationHandlerImpl(this.getLog());
    }

    protected Set<Method> findAnnotatedMethods(AnnotationHandler handler) throws Exception {
        Set<Method> functions;
        this.info("");
        this.info(SEARCH_FUNCTIONS);
        try {
            this.debug("ClassPath to resolve: " + this.getTargetClassUrl());
            List<URL> dependencyWithTargetClass = this.getDependencyArtifactUrls();
            dependencyWithTargetClass.add(this.getTargetClassUrl());
            functions = handler.findFunctions(dependencyWithTargetClass);
        }
        catch (NoClassDefFoundError e) {
            this.debug("ClassPath to resolve: " + this.getArtifactUrl());
            functions = handler.findFunctions(Arrays.asList(this.getArtifactUrl()));
        }
        this.info(functions.size() + FOUND_FUNCTIONS);
        return functions;
    }

    protected URL getArtifactUrl() throws Exception {
        return this.getProject().getArtifact().getFile().toURI().toURL();
    }

    protected URL getTargetClassUrl() throws Exception {
        return this.outputDirectory.toURI().toURL();
    }

    protected List<URL> getDependencyArtifactUrls() {
        ArrayList<URL> urlList = new ArrayList<URL>();
        ArrayList compileClasspathElements = new ArrayList();
        try {
            compileClasspathElements.addAll(this.getProject().getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            this.debug("Failed to resolve dependencies for compile scope, exception: " + e.getMessage());
        }
        for (String element : compileClasspathElements) {
            File f = new File(element);
            try {
                urlList.add(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.debug("Failed to get URL for file: " + f.toString());
            }
        }
        return urlList;
    }

    protected Map<String, FunctionConfiguration> getFunctionConfigurations(AnnotationHandler handler, Set<Method> methods) throws Exception {
        this.info("");
        this.info(GENERATE_CONFIG);
        Map<String, FunctionConfiguration> configMap = handler.generateConfigurations(methods);
        if (configMap.size() == 0) {
            this.info(GENERATE_SKIP);
        } else {
            String scriptFilePath = this.getScriptFilePath();
            configMap.values().forEach(config -> config.setScriptFile(scriptFilePath));
            this.info(GENERATE_DONE);
        }
        return configMap;
    }

    protected String getScriptFilePath() {
        return ".." + File.separator + this.getFinalName() + ".jar";
    }

    protected void validateFunctionConfigurations(Map<String, FunctionConfiguration> configMap) {
        this.info("");
        this.info(VALIDATE_CONFIG);
        if (configMap.size() == 0) {
            this.info(VALIDATE_SKIP);
        } else {
            configMap.values().forEach(config -> config.validate());
            this.info(VALIDATE_DONE);
        }
    }

    protected void writeFunctionJsonFiles(ObjectWriter objectWriter, Map<String, FunctionConfiguration> configMap) throws IOException {
        this.info("");
        this.info(SAVE_FUNCTION_JSONS);
        if (configMap.size() == 0) {
            this.info(SAVE_SKIP);
        } else {
            for (Map.Entry<String, FunctionConfiguration> config : configMap.entrySet()) {
                this.writeFunctionJsonFile(objectWriter, config.getKey(), config.getValue());
            }
        }
    }

    protected void writeFunctionJsonFile(ObjectWriter objectWriter, String functionName, FunctionConfiguration config) throws IOException {
        this.info(SAVE_FUNCTION_JSON + functionName);
        File functionJsonFile = Paths.get(this.getDeploymentStagingDirectoryPath(), functionName, FUNCTION_JSON).toFile();
        this.writeObjectToFile(objectWriter, config, functionJsonFile);
        this.info(SAVE_SUCCESS + functionJsonFile.getAbsolutePath());
    }

    protected void writeEmptyHostJsonFile(ObjectWriter objectWriter) throws IOException {
        this.info("");
        this.info(SAVE_HOST_JSON);
        File hostJsonFile = Paths.get(this.getDeploymentStagingDirectoryPath(), HOST_JSON).toFile();
        this.writeObjectToFile(objectWriter, new Object(), hostJsonFile);
        this.info(SAVE_SUCCESS + hostJsonFile.getAbsolutePath());
    }

    protected void writeObjectToFile(ObjectWriter objectWriter, Object object, File targetFile) throws IOException {
        targetFile.getParentFile().mkdirs();
        targetFile.createNewFile();
        objectWriter.writeValue(targetFile, object);
    }

    protected ObjectWriter getObjectWriter() {
        return new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).writerWithDefaultPrettyPrinter();
    }

    protected void copyJarsToStageDirectory() throws IOException {
        String stagingDirectory = this.getDeploymentStagingDirectoryPath();
        this.info("");
        this.info(COPY_JARS + stagingDirectory);
        Utils.copyResources((MavenProject)this.getProject(), (MavenSession)this.getSession(), (MavenResourcesFiltering)this.getMavenResourcesFiltering(), this.getResources(), (String)stagingDirectory);
        this.info(COPY_SUCCESS);
    }

    public List<Resource> getResources() {
        Resource resource = new Resource();
        resource.setDirectory(this.getBuildDirectoryAbsolutePath());
        resource.setTargetPath("/");
        resource.setFiltering(false);
        resource.setIncludes(Arrays.asList("*.jar"));
        return Arrays.asList(resource);
    }

    protected FunctionCoreToolsHandler getFunctionCoreToolsHandler(CommandHandler commandHandler) {
        return new FunctionCoreToolsHandlerImpl(this, commandHandler);
    }

    protected void installExtension(FunctionCoreToolsHandler handler, Set<BindingEnum> bindingEnums) throws Exception {
        if (!this.isInstallingExtensionNeeded(bindingEnums)) {
            this.info(SKIP_INSTALL_EXTENSIONS);
            return;
        }
        this.info(INSTALL_EXTENSIONS);
        handler.installExtension();
        this.info(INSTALL_EXTENSIONS_FINISH);
    }

    protected Set<BindingEnum> getFunctionBindingEnums(Map<String, FunctionConfiguration> configMap) {
        HashSet<BindingEnum> result = new HashSet<BindingEnum>();
        configMap.values().forEach(configuration -> configuration.getBindings().forEach(binding -> result.add(binding.getBindingEnum())));
        return result;
    }

    protected boolean isInstallingExtensionNeeded(Set<BindingEnum> bindingTypes) {
        return bindingTypes.stream().anyMatch(binding -> !Arrays.asList(FUNCTION_WITHOUT_FUNCTION_EXTENSION).contains(binding));
    }
}

