/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.maven.appservice.DeployTargetType;
import com.microsoft.azure.maven.artifacthandler.ArtifactHandler;
import com.microsoft.azure.maven.artifacthandler.FTPArtifactHandlerImpl;
import com.microsoft.azure.maven.artifacthandler.ZIPArtifactHandlerImpl;
import com.microsoft.azure.maven.deploytarget.DeployTarget;
import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import com.microsoft.azure.maven.function.handlers.MSDeployArtifactHandlerImpl;
import com.microsoft.azure.maven.utils.AppServiceUtils;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractFunctionMojo {
    public static final JavaVersion DEFAULT_JAVA_VERSION = JavaVersion.JAVA_8_NEWEST;
    public static final String VALID_JAVA_VERSION_PATTERN = "^1\\.8.*";
    public static final String DEPLOY_START = "Trying to deploy the function app...";
    public static final String DEPLOY_FINISH = "Successfully deployed the function app at https://%s.azurewebsites.net";
    public static final String FUNCTION_APP_CREATE_START = "The specified function app does not exist. Creating a new function app...";
    public static final String FUNCTION_APP_CREATED = "Successfully created the function app: %s";
    public static final String FUNCTION_APP_UPDATE = "Updating the specified function app...";
    public static final String FUNCTION_APP_UPDATE_DONE = "Successfully updated the function app.";
    public static final String DEPLOYMENT_TYPE_KEY = "deploymentType";
    public static final String HOST_JAVA_VERSION = "Java version of function host : %s";
    public static final String HOST_JAVA_VERSION_OFF = "Java version of function host is not initiated, set it to Java 8";
    public static final String HOST_JAVA_VERSION_INCORRECT = "Java version of function host %s does not meet the requirement of Azure Functions, set it to Java 8";

    protected void doExecute() throws Exception {
        this.createOrUpdateFunctionApp();
        FunctionApp app = this.getFunctionApp();
        if (app == null) {
            throw new MojoExecutionException(String.format("Failed to get the function app with name: %s", this.getAppName()));
        }
        DeployTarget deployTarget = new DeployTarget((WebAppBase)app, DeployTargetType.FUNCTION);
        this.info(DEPLOY_START);
        this.getArtifactHandler().publish(deployTarget);
        this.info(String.format(DEPLOY_FINISH, this.getAppName()));
    }

    protected void createOrUpdateFunctionApp() throws Exception {
        FunctionApp app = this.getFunctionApp();
        if (app == null) {
            this.createFunctionApp();
        } else {
            this.updateFunctionApp(app);
        }
    }

    protected void createFunctionApp() throws Exception {
        FunctionApp.DefinitionStages.WithCreate withCreate;
        this.info(FUNCTION_APP_CREATE_START);
        AppServicePlan plan = AppServiceUtils.getAppServicePlan((String)this.getAppServicePlanName(), (Azure)this.getAzureClient(), (String)this.getResourceGroup(), (String)this.getAppServicePlanResourceGroup());
        FunctionApp.DefinitionStages.Blank functionApp = (FunctionApp.DefinitionStages.Blank)this.getAzureClient().appServices().functionApps().define(this.appName);
        String resGrp = this.getResourceGroup();
        if (plan == null) {
            FunctionApp.DefinitionStages.NewAppServicePlanWithGroup newAppServicePlanWithGroup = (FunctionApp.DefinitionStages.NewAppServicePlanWithGroup)functionApp.withRegion(this.region);
            withCreate = this.configureResourceGroup(newAppServicePlanWithGroup, resGrp);
            this.configurePricingTier(withCreate, this.getPricingTier());
        } else {
            FunctionApp.DefinitionStages.ExistingAppServicePlanWithGroup planWithGroup = functionApp.withExistingAppServicePlan(plan);
            withCreate = this.isResourceGroupExist(resGrp) ? (FunctionApp.DefinitionStages.WithCreate)planWithGroup.withExistingResourceGroup(resGrp) : (FunctionApp.DefinitionStages.WithCreate)planWithGroup.withNewResourceGroup(resGrp);
        }
        this.configureAppSettings(arg_0 -> ((FunctionApp.DefinitionStages.WithCreate)withCreate).withAppSettings(arg_0), this.getAppSettings());
        withCreate.withJavaVersion(DEFAULT_JAVA_VERSION).withWebContainer(null).create();
        this.info(String.format(FUNCTION_APP_CREATED, this.getAppName()));
    }

    protected void updateFunctionApp(FunctionApp app) {
        this.info(FUNCTION_APP_UPDATE);
        ((SiteInner)app.inner()).withTags(null);
        FunctionApp.Update update = (FunctionApp.Update)app.update();
        this.checkHostJavaVersion(app, update);
        this.configureAppSettings(arg_0 -> ((FunctionApp.Update)update).withAppSettings(arg_0), this.getAppSettings());
        update.apply();
        this.info(FUNCTION_APP_UPDATE_DONE + this.getAppName());
    }

    protected void checkHostJavaVersion(FunctionApp app, FunctionApp.Update update) {
        JavaVersion serverJavaVersion = app.javaVersion();
        if (serverJavaVersion.toString().matches(VALID_JAVA_VERSION_PATTERN)) {
            this.info(String.format(HOST_JAVA_VERSION, serverJavaVersion));
        } else if (serverJavaVersion.equals((Object)JavaVersion.OFF)) {
            this.info(HOST_JAVA_VERSION_OFF);
            update.withJavaVersion(DEFAULT_JAVA_VERSION);
        } else {
            this.warning(HOST_JAVA_VERSION_INCORRECT);
            update.withJavaVersion(DEFAULT_JAVA_VERSION);
        }
    }

    protected FunctionApp.DefinitionStages.WithCreate configureResourceGroup(FunctionApp.DefinitionStages.NewAppServicePlanWithGroup newAppServicePlanWithGroup, String resourceGroup) throws Exception {
        return this.isResourceGroupExist(resourceGroup) ? newAppServicePlanWithGroup.withExistingResourceGroup(resourceGroup) : newAppServicePlanWithGroup.withNewResourceGroup(resourceGroup);
    }

    protected boolean isResourceGroupExist(String resourceGroup) throws Exception {
        return this.getAzureClient().resourceGroups().contain(resourceGroup);
    }

    protected void configurePricingTier(FunctionApp.DefinitionStages.WithCreate withCreate, PricingTier pricingTier) {
        if (pricingTier != null) {
            withCreate.withNewAppServicePlan(pricingTier).withWebAppAlwaysOn(true);
        } else {
            withCreate.withNewConsumptionPlan();
        }
    }

    protected void configureAppSettings(Consumer<Map> withAppSettings, Map appSettings) {
        if (appSettings != null && !appSettings.isEmpty()) {
            withAppSettings.accept(appSettings);
        }
    }

    protected ArtifactHandler getArtifactHandler() throws MojoExecutionException {
        Object builder;
        switch (this.getDeploymentType()) {
            case MSDEPLOY: {
                builder = new MSDeployArtifactHandlerImpl.Builder().functionAppName(this.getAppName());
                break;
            }
            case FTP: {
                builder = new FTPArtifactHandlerImpl.Builder();
                break;
            }
            case EMPTY: 
            case ZIP: {
                builder = new ZIPArtifactHandlerImpl.Builder();
                break;
            }
            default: {
                throw new MojoExecutionException("The value of <deploymentType> is unknown, supported values are: ftp, zip and msdeploy.");
            }
        }
        return builder.project(this.getProject()).session(this.getSession()).filtering(this.getMavenResourcesFiltering()).resources(this.getResources()).stagingDirectoryPath(this.getDeploymentStagingDirectoryPath()).buildDirectoryAbsolutePath(this.getBuildDirectoryAbsolutePath()).log(this.getLog()).build();
    }

    public Map<String, String> getTelemetryProperties() {
        Map map = super.getTelemetryProperties();
        try {
            map.put(DEPLOYMENT_TYPE_KEY, this.getDeploymentType().toString());
        }
        catch (MojoExecutionException e) {
            map.put(DEPLOYMENT_TYPE_KEY, "Unknown deployment type.");
        }
        return map;
    }
}

