/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.maven.AbstractAppServiceMojo;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.maven.utils.AppServiceUtils;
import java.io.File;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractFunctionMojo
extends AbstractAppServiceMojo {
    private static final String JDK_VERSION_ERROR = "Azure Functions only support JDK 8, which is lower than local JDK version %s";
    private static final String FUNCTIONS_WORKER_RUNTIME_NAME = "FUNCTIONS_WORKER_RUNTIME";
    private static final String FUNCTIONS_WORKER_RUNTIME_VALUE = "java";
    private static final String SET_FUNCTIONS_WORKER_RUNTIME = "Set function worker runtime to java";
    private static final String CHANGE_FUNCTIONS_WORKER_RUNTIME = "Function worker runtime doesn't meet the requirement, change it from %s to java";
    @Parameter(property="functions.pricingTier")
    protected String pricingTier;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true, required=true)
    protected String finalName;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true, required=true)
    protected File outputDirectory;
    @Parameter(property="functions.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="functions.region", defaultValue="westeurope")
    protected String region;

    public Map getAppSettings() {
        Map result = super.getAppSettings();
        String workerRuntime = (String)result.get(FUNCTIONS_WORKER_RUNTIME_NAME);
        if (StringUtils.isEmpty((CharSequence)workerRuntime)) {
            this.info(SET_FUNCTIONS_WORKER_RUNTIME);
        } else if (!FUNCTIONS_WORKER_RUNTIME_VALUE.equals(workerRuntime)) {
            this.warning(String.format(CHANGE_FUNCTIONS_WORKER_RUNTIME, workerRuntime));
        }
        result.put(FUNCTIONS_WORKER_RUNTIME_NAME, FUNCTIONS_WORKER_RUNTIME_VALUE);
        return result;
    }

    public PricingTier getPricingTier() throws MojoExecutionException {
        return StringUtils.isEmpty((CharSequence)this.pricingTier) ? null : AppServiceUtils.getPricingTierFromString((String)this.pricingTier);
    }

    public String getRegion() {
        return this.region;
    }

    protected boolean isSkipMojo() {
        return this.skip;
    }

    public String getFinalName() {
        return this.finalName;
    }

    @Nullable
    public FunctionApp getFunctionApp() throws AzureAuthFailureException {
        try {
            return (FunctionApp)this.getAzureClient().appServices().functionApps().getByResourceGroup(this.getResourceGroup(), this.getAppName());
        }
        catch (AzureAuthFailureException authEx) {
            throw authEx;
        }
        catch (Exception ex) {
            this.getLog().debug((Throwable)ex);
            return null;
        }
    }

    public void execute() throws MojoExecutionException {
        this.checkJavaVersion();
        super.execute();
    }

    public void checkJavaVersion() throws MojoExecutionException {
        String javaVersion = System.getProperty("java.version");
        if (!javaVersion.startsWith("1.8")) {
            super.warning(String.format(JDK_VERSION_ERROR, javaVersion));
        }
    }
}

